/*
 * Decompiled with CFR 0.152.
 */
package de.uib.configed.gui;

import de.uib.configed.Globals;
import java.awt.BorderLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class IconAsButton
extends JPanel
implements MouseListener {
    protected String imageURLActive;
    protected String imageURLAttention;
    protected String imageURLInactive;
    protected String imageURLOver;
    protected String imageURLDisabled;
    protected ImageIcon iconActive;
    protected ImageIcon iconInactive;
    protected ImageIcon iconOver;
    protected ImageIcon iconDisabled;
    protected String tooltipActive;
    protected String tooltipInactive;
    protected JLabel label;
    protected boolean activated;
    protected boolean enabled;
    protected boolean getAttention;
    protected boolean mouseOver;
    protected ArrayList<ActionListener> actionListeners;
    public String description;

    public IconAsButton(String string, String string2, String string3, String string4, String string5, String string6) {
        this.setOpaque(false);
        this.setDisplay(string, string2, string3, string4, string5, string6);
        this.label = new JLabel(this.iconInactive, 0);
        this.label.setToolTipText(string);
        this.activated = false;
        this.enabled = true;
        this.mouseOver = false;
        this.actionListeners = new ArrayList();
        this.setLayout(new BorderLayout());
        this.label.addMouseListener(this);
        this.add(this.label);
    }

    public IconAsButton(String string, String string2, String string3, String string4, String string5) {
        this(string, string2, string3, string4, null, string5);
    }

    public void setDisplay(String string, String string2, String string3, String string4, String string5) {
        this.setDisplay(string, string2, string3, string4, null, string5);
    }

    public void setDisplay(String string, String string2, String string3, String string4, String string5, String string6) {
        this.description = string;
        this.tooltipActive = string;
        this.tooltipInactive = string;
        this.imageURLActive = string4;
        this.imageURLAttention = string5;
        if (this.imageURLAttention == null || this.imageURLAttention.equals("")) {
            this.imageURLAttention = this.imageURLActive;
        }
        this.imageURLInactive = string2;
        this.imageURLOver = string3;
        this.imageURLDisabled = string6;
        this.iconInactive = Globals.createImageIcon(this.imageURLInactive, this.description);
        if (this.imageURLActive != null) {
            this.iconActive = Globals.createImageIcon(this.imageURLActive, this.description);
        }
        if (this.imageURLOver != null) {
            this.iconOver = Globals.createImageIcon(this.imageURLOver, this.description);
        }
        if (this.imageURLDisabled != null) {
            this.iconDisabled = Globals.createImageIcon(this.imageURLDisabled, this.description);
        }
        if (this.label != null) {
            this.label.setToolTipText(string);
        }
    }

    @Override
    public void setToolTipText(String string) {
        this.description = string;
        this.label.setToolTipText(string);
        this.tooltipActive = string;
        this.tooltipInactive = string;
    }

    public void setToolTips(String string, String string2) {
        this.tooltipActive = string;
        this.tooltipInactive = string2;
    }

    @Override
    public void setEnabled(boolean bl) {
        this.enabled = bl;
        super.setEnabled(this.enabled);
        this.setIcon();
        if (this.enabled) {
            this.label.setEnabled(true);
        }
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    public void setAttention(boolean bl) {
        this.getAttention = bl;
    }

    private void setIcon() {
        if (!this.enabled) {
            if (this.iconDisabled != null) {
                this.label.setIcon(this.iconDisabled);
            } else {
                this.label.setEnabled(false);
            }
        } else if (this.mouseOver) {
            if (this.iconOver != null) {
                this.label.setIcon(this.iconOver);
            } else if (!this.activated && this.iconActive != null) {
                this.label.setIcon(this.iconActive);
            } else {
                this.label.setIcon(this.iconInactive);
            }
        } else if (this.activated && this.iconActive != null) {
            this.label.setIcon(this.iconActive);
        } else {
            this.label.setIcon(this.iconInactive);
        }
        this.repaint();
    }

    public void setActivated(boolean bl) {
        this.activated = bl;
        this.mouseOver = false;
        this.setIcon();
        if (this.tooltipActive != null && this.tooltipInactive != null) {
            if (bl) {
                this.label.setToolTipText(this.tooltipActive);
            } else {
                this.label.setToolTipText(this.tooltipInactive);
            }
        }
    }

    public boolean isActivated() {
        return this.activated;
    }

    public ArrayList getActionListeners() {
        return this.actionListeners;
    }

    public void addActionListener(ActionListener actionListener) {
        boolean bl = true;
        for (int i = 0; i < this.actionListeners.size(); ++i) {
            if (this.actionListeners.get(i) != actionListener) continue;
            bl = false;
            break;
        }
        if (bl) {
            this.actionListeners.add(actionListener);
        }
    }

    public void fireActionPerformed(ActionEvent actionEvent) {
        for (int i = 0; i < this.actionListeners.size(); ++i) {
            this.actionListeners.get(i).actionPerformed(actionEvent);
        }
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        int n = mouseEvent.getButton();
        Object object = mouseEvent.getSource();
        if (this.isEnabled()) {
            ActionEvent actionEvent = new ActionEvent(this, 1, this.description);
            this.fireActionPerformed(actionEvent);
        }
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
        if (this.enabled && !this.mouseOver) {
            this.mouseOver = true;
            this.setIcon();
        }
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
        if (this.enabled && this.mouseOver) {
            this.mouseOver = false;
            this.setIcon();
        }
    }
}

