/*
 * Decompiled with CFR 0.152.
 */
package de.uib.opsicommand;

import de.uib.utilities.logging.logging;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONObject;

public class JSONObjectX
extends JSONObject {
    private JSONObject master;
    private Map<String, Object> map;
    private List<Object> list;
    private String value = "";
    private boolean beingMap = false;
    private boolean beingList = false;
    private boolean beingString = false;
    private boolean hasElements = false;

    public JSONObjectX(JSONObject jSONObject) {
        this.master = jSONObject;
        this.produceList();
        this.produceMap();
    }

    public Map<String, Object> getMap() {
        return this.map;
    }

    public boolean isEmpty() {
        return !this.hasElements;
    }

    public boolean isMap() {
        return this.beingMap;
    }

    public boolean isList() {
        return this.beingList;
    }

    public boolean isString() {
        return this.beingString;
    }

    private void produceMap() {
        this.beingMap = true;
        this.beingList = true;
        this.hasElements = true;
        this.map = new HashMap<String, Object>();
        try {
            Iterator iterator = this.master.keys();
            if (!iterator.hasNext()) {
                this.hasElements = false;
            }
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                if (this.master.get(string) != null) {
                    this.beingList = false;
                }
                if (this.master.get(string) == null) {
                    this.beingMap = false;
                }
                if (this.master.isNull(string)) continue;
                Object object = this.master.get(string);
                if (object instanceof Boolean || object instanceof String) {
                    this.map.put(string, object);
                    continue;
                }
                if (object instanceof JSONArray) {
                    this.map.put(string, ((JSONArray)object).toList());
                    continue;
                }
                if (!(object instanceof JSONObject)) continue;
                this.map.put(string, object);
            }
        }
        catch (Exception exception) {
            logging.error(this, "json transform exception: " + exception);
        }
    }

    private void produceList() {
        if (this.master.names() != null) {
            this.list = this.master.names().toList();
        }
    }

    public List getList() {
        return this.list;
    }

    public void produceString() {
        if (this.list.size() == 0) {
            this.value = "";
            this.beingString = true;
        } else if (this.list.size() == 1 && !this.beingMap) {
            this.value = this.list.get(1).toString();
            this.beingString = true;
        } else {
            this.value = this.master.toString();
            this.beingString = false;
        }
    }

    public String getString() {
        return this.value;
    }
}

