/*
 * Decompiled with CFR 0.152.
 */
package de.uib.configed.tree;

import de.uib.configed.ConfigedMain;
import de.uib.configed.Globals;
import de.uib.configed.tree.IconNode;
import de.uib.configed.tree.IconNodeRenderer;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import javax.swing.JTree;
import javax.swing.border.EmptyBorder;

public class IconNodeRendererClientTree
extends IconNodeRenderer {
    protected ConfigedMain main;
    public static int labelWidth = 200;
    public static int labelHeight = 20;

    public IconNodeRendererClientTree(ConfigedMain configedMain) {
        this.main = configedMain;
        this.setOpaque(true);
        this.setForeground(Globals.lightBlack);
        this.setTextSelectionColor(Globals.lightBlack);
        this.setBackground(Color.white);
        this.setBorder(new EmptyBorder(new Insets(0, 0, 0, 0)));
        this.setPreferredSize(new Dimension(labelWidth, labelHeight));
    }

    @Override
    public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
        if (object instanceof IconNode) {
            String string = jTree.convertValueToText(object, bl, bl2, bl3, n, bl4);
            this.setText(string);
            this.setToolTipText(((IconNode)object).getToolTipText());
            IconNode iconNode = (IconNode)object;
            boolean bl5 = jTree.isEnabled();
            this.setEnabled(bl5);
            iconNode.setEnabled(bl5);
            if (!iconNode.getAllowsChildren()) {
                if (this.main.getActiveTreeNodes().containsKey(string)) {
                    this.setFont(Globals.defaultFontStandardBold);
                    this.setIcon(iconNode.getLeafIcon());
                } else {
                    this.setFont(Globals.defaultFont);
                    this.setIcon(iconNode.getNonSelectedLeafIcon());
                }
            } else {
                this.setIcon(iconNode.getClosedIcon());
                if (this.main.getActiveParents().contains(string)) {
                    this.setIcon(iconNode.getEmphasizedIcon());
                }
                if (this.main.getActiveTreeNodes().containsKey(string)) {
                    this.setFont(Globals.defaultFontStandardBold);
                } else {
                    this.setFont(Globals.defaultFont);
                }
            }
            this.setComponentOrientation(jTree.getComponentOrientation());
            return this;
        }
        return super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
    }
}

