/*
 * Decompiled with CFR 0.152.
 */
package de.uib.configed.gui;

import de.uib.configed.Globals;
import de.uib.configed.configed;
import de.uib.configed.gui.GeneralFrame;
import de.uib.utilities.logging.logging;
import de.uib.utilities.swing.PopupMenuTrait;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.TreeMap;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultHighlighter;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Highlighter;
import javax.swing.text.JTextComponent;
import javax.swing.text.LayeredHighlighter;
import javax.swing.text.Position;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;
import javax.swing.text.View;

public class LogPane
extends JPanel
implements KeyListener,
ActionListener {
    protected JTextPane jTextPane;
    protected JScrollPane scrollpane;
    protected JPanel commandpane;
    protected JLabel labelSearch;
    protected JTextField fieldSearch;
    protected final int fieldH = 28;
    protected JButton buttonSearch;
    protected JCheckBox jCheckBoxCaseSensitive;
    protected JLabel labelLevel;
    protected AdaptingSlider sliderLevel;
    protected final int sliderH = 35;
    protected final int sliderW = 180;
    protected ChangeListener sliderListener;
    protected JLabel labelDisplayRestriction;
    protected JComboBox comboType;
    protected DefaultComboBoxModel comboModelTypes;
    protected final String defaultType = "(all)";
    protected JPanel jTextPanel;
    protected WordSearcher searcher;
    protected Highlighter highlighter;
    protected final StyleContext styleContext;
    protected final Style[] logLevelStyles;
    public Integer[] levels = new Integer[]{1, 2, 3, 4, 5, 6, 7, 8, 9};
    public List<Integer> levelList = Arrays.asList(this.levels);
    protected Integer maxLevel = this.levels[this.levels.length - 1];
    protected Integer minLevel;
    protected Integer maxExistingLevel = this.minLevel = this.levels[0];
    protected Integer showLevel = this.minLevel;
    protected boolean showTypeRestricted = false;
    protected List<String> typesList;
    protected int[] lineTypes;
    TreeMap<Integer, Integer> docLinestartPosition2lineCount;
    TreeMap<Integer, Integer> lineCount2docLinestartPosition;
    int selTypeIndex = -1;
    protected String title = "";
    private boolean changing = false;
    final Font monospacedFont = new Font("Monospaced", 0, 11);
    protected PopupMenuTrait popupMenu;
    protected ImmutableDefaultStyledDocument document;
    protected String[] lines;
    protected int[] lineLevels;
    protected Style[] lineStyles;

    protected void reload() {
        logging.debug(this, "reload action");
    }

    protected void floatExternal() {
        if (this.document == null) {
            return;
        }
        LogPane logPane = new LogPane("", false);
        GeneralFrame generalFrame = new GeneralFrame(null, this.title, false);
        generalFrame.addPanel(logPane);
        generalFrame.setup();
        generalFrame.setSize(this.getSize());
        generalFrame.centerOn(Globals.mainFrame);
        logPane.setLevelWithoutAction(this.showLevel);
        logPane.setParsedText(this.lines, this.lineLevels, this.lineStyles, this.lineTypes, this.typesList, this.showTypeRestricted, this.selTypeIndex, this.maxExistingLevel);
        logPane.getTextComponent().setCaretPosition(this.jTextPane.getCaretPosition());
        logPane.adaptSlider();
        generalFrame.setVisible(true);
    }

    JTextComponent getTextComponent() {
        return this.jTextPane;
    }

    public void setTitle(String string) {
        this.title = string;
    }

    public LogPane(String string) {
        this(string, true);
    }

    public LogPane(String string, boolean bl) {
        super(new BorderLayout());
        this.jTextPanel = new JPanel(new BorderLayout());
        this.scrollpane = new JScrollPane();
        this.jTextPane = new JTextPane();
        this.jTextPane.setCaretColor(Color.RED);
        this.jTextPane.getCaret().setBlinkRate(0);
        class LogStyleContext
        extends StyleContext {
            LogStyleContext() {
            }

            @Override
            public Font getFont(AttributeSet attributeSet) {
                return LogPane.this.monospacedFont;
            }
        }
        this.styleContext = new LogStyleContext();
        this.logLevelStyles = new Style[10];
        this.logLevelStyles[1] = this.styleContext.addStyle("loglevel essential", null);
        StyleConstants.setForeground(this.logLevelStyles[1], Globals.logColorEssential);
        this.logLevelStyles[2] = this.styleContext.addStyle("loglevel critical", null);
        StyleConstants.setForeground(this.logLevelStyles[2], Globals.logColorCritical);
        this.logLevelStyles[3] = this.styleContext.addStyle("loglevel error", null);
        StyleConstants.setForeground(this.logLevelStyles[3], Globals.logColorError);
        this.logLevelStyles[4] = this.styleContext.addStyle("loglevel warning", null);
        StyleConstants.setForeground(this.logLevelStyles[4], Globals.logColorWarning);
        this.logLevelStyles[5] = this.styleContext.addStyle("loglevel notice", null);
        StyleConstants.setForeground(this.logLevelStyles[5], Globals.logColorNotice);
        this.logLevelStyles[6] = this.styleContext.addStyle("loglevel info", null);
        StyleConstants.setForeground(this.logLevelStyles[6], Globals.logColorInfo);
        this.logLevelStyles[7] = this.styleContext.addStyle("loglevel debug", null);
        StyleConstants.setForeground(this.logLevelStyles[7], Globals.logColorDebug);
        this.logLevelStyles[8] = this.styleContext.addStyle("loglevel debug2", null);
        StyleConstants.setForeground(this.logLevelStyles[8], Globals.logColorDebug2);
        this.logLevelStyles[9] = this.styleContext.addStyle("loglevel confidential", null);
        StyleConstants.setForeground(this.logLevelStyles[9], Globals.logColorConfidential);
        this.searcher = new WordSearcher(this.jTextPane);
        this.highlighter = new UnderlineHighlighter(null);
        this.jTextPane.setHighlighter(this.highlighter);
        if (string != null) {
            this.jTextPane.setText(string);
        }
        this.jTextPane.setOpaque(true);
        this.jTextPane.setBackground(Globals.backgroundWhite);
        this.jTextPane.setEditable(true);
        this.jTextPane.setFont(Globals.defaultFont);
        this.jTextPane.addKeyListener(this);
        this.jTextPanel.add((Component)this.jTextPane, "Center");
        this.scrollpane.setVerticalScrollBarPolicy(22);
        this.scrollpane.getVerticalScrollBar().setUnitIncrement(20);
        this.scrollpane.getViewport().add(this.jTextPanel);
        this.add((Component)this.scrollpane, "Center");
        this.labelSearch = new JLabel(configed.getResourceValue("TextPane.jLabel_search"));
        this.labelSearch.setFont(Globals.defaultFont);
        this.fieldSearch = new JTextField("");
        this.fieldSearch.addActionListener(this);
        this.fieldSearch.setPreferredSize(new Dimension(140, 28));
        this.fieldSearch.setBackground(Globals.backgroundWhite);
        this.fieldSearch.addKeyListener(this);
        this.buttonSearch = new JButton(configed.getResourceValue("TextPane.jButton_search"));
        this.buttonSearch.setFont(Globals.defaultFont);
        this.buttonSearch.addActionListener(this);
        this.buttonSearch.addKeyListener(this);
        this.jCheckBoxCaseSensitive = new JCheckBox(configed.getResourceValue("TextPane.jCheckBoxCaseSensitive"));
        this.jCheckBoxCaseSensitive.setToolTipText(configed.getResourceValue("TextPane.jCheckBoxCaseSensitive.toolTip"));
        this.jCheckBoxCaseSensitive.setSelected(false);
        this.jCheckBoxCaseSensitive.addActionListener(this);
        this.labelLevel = new JLabel(configed.getResourceValue("TextPane.jLabel_level"));
        this.labelLevel.setFont(Globals.defaultFont);
        this.sliderLevel = new AdaptingSlider(1, 9, (int)this.showLevel);
        this.sliderListener = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                logging.debug(this, "change event from sliderLevel, " + LogPane.this.sliderLevel.getValue());
                if (LogPane.this.sliderLevel.getValueIsAdjusting()) {
                    return;
                }
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        logging.debug(this, "activateShowLevel call");
                        Cursor cursor = LogPane.this.sliderLevel.getCursor();
                        LogPane.this.sliderLevel.setCursor(new Cursor(3));
                        try {
                            LogPane.this.activateShowLevel();
                        }
                        catch (Exception exception) {
                            logging.debug(this, "Exception in activateShowLevel " + exception);
                        }
                        LogPane.this.sliderLevel.setCursor(cursor);
                    }
                });
            }
        };
        this.sliderLevel.addChangeListener(this.sliderListener);
        this.sliderLevel.addMouseWheelListener(new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
                logging.debug(this, "MouseWheelEvent " + mouseWheelEvent);
                int n = LogPane.this.levelList.indexOf(LogPane.this.sliderLevel.getValue()) - mouseWheelEvent.getWheelRotation();
                logging.debug(this, "MouseWheelEvent newIndex " + n);
                if (n > LogPane.this.levels.length - 1) {
                    n = LogPane.this.levels.length - 1;
                } else if (n < 0) {
                    n = 0;
                }
                logging.debug(this, "MouseWheelEvent newIndex " + n);
                LogPane.this.sliderLevel.setValue(LogPane.this.levelList.get(n));
            }
        });
        this.labelDisplayRestriction = new JLabel(configed.getResourceValue("TextPane.EventType"));
        this.labelDisplayRestriction.setFont(Globals.defaultFont);
        this.comboModelTypes = new DefaultComboBoxModel();
        this.comboType = new JComboBox(this.comboModelTypes);
        this.comboType.setFont(Globals.defaultFont);
        this.comboType.setEnabled(false);
        this.comboType.setEditable(false);
        this.comboType.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n = LogPane.this.selTypeIndex;
                Object object = LogPane.this.comboType.getSelectedItem();
                if (object == null || object.equals("(all)")) {
                    LogPane.this.showTypeRestricted = false;
                    LogPane.this.selTypeIndex = -1;
                } else {
                    LogPane.this.showTypeRestricted = true;
                    LogPane.this.selTypeIndex = LogPane.this.typesList.indexOf(object);
                }
                if (LogPane.this.selTypeIndex != n) {
                    LogPane.this.buildDocument();
                }
            }
        });
        this.commandpane = new JPanel();
        GroupLayout groupLayout = new GroupLayout(this.commandpane);
        this.commandpane.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGap(10, 10, 10).addComponent(this.labelSearch, -2, -2, -2).addGap(10, 10, 10).addComponent(this.fieldSearch, 140, 140, Short.MAX_VALUE).addGap(10, 10, 10).addComponent(this.buttonSearch, 70, 70, 70).addGap(10, 10, 10).addComponent(this.jCheckBoxCaseSensitive, 140, 140, 140).addGap(10, 10, 10).addGap(10, 10, 10).addComponent(this.labelDisplayRestriction, -2, -2, -2).addGap(10, 10, 10).addComponent(this.comboType, 140, 140, Short.MAX_VALUE).addGap(10, 10, 10).addGap(10, 10, 10).addComponent(this.labelLevel, -2, -2, -2).addGap(10, 10, 10).addComponent(this.sliderLevel, 180, 180, 180).addGap(10, 10, 10)));
        groupLayout.setVerticalGroup(groupLayout.createSequentialGroup().addGap(5, 5, 5).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.labelSearch, -2, -2, -2).addComponent(this.fieldSearch, 28, 28, 28).addComponent(this.buttonSearch, 24, 24, 24).addComponent(this.jCheckBoxCaseSensitive, 24, 24, 24).addComponent(this.labelDisplayRestriction, 28, 28, 28).addComponent(this.comboType, 24, 24, 24).addComponent(this.labelLevel, 28, 28, 28).addComponent(this.sliderLevel, 35, 35, 35)).addGap(5, 5, 5));
        this.add((Component)this.commandpane, "South");
        if (bl) {
            this.popupMenu = new PopupMenuTrait(new Integer[]{4, 6}){

                @Override
                public void action(int n) {
                    switch (n) {
                        case 4: {
                            LogPane.this.reload();
                            break;
                        }
                        case 6: {
                            LogPane.this.floatExternal();
                        }
                    }
                }
            };
            this.popupMenu.addPopupListenersTo(new JComponent[]{this.jTextPane});
        }
    }

    private void emptyDocument() {
        ImmutableDefaultStyledDocument immutableDefaultStyledDocument = new ImmutableDefaultStyledDocument();
        try {
            immutableDefaultStyledDocument.insertStringTruely(0, "building document", this.lineStyles[0]);
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        this.jTextPane.setDocument(immutableDefaultStyledDocument);
    }

    public void buildDocument() {
        logging.debug(this, "building document");
        Cursor cursor = this.jTextPane.getCursor();
        this.jTextPane.setCursor(new Cursor(3));
        this.document = new ImmutableDefaultStyledDocument(this.styleContext);
        int n = this.levelList.indexOf(this.sliderLevel.getValue()) + 1;
        this.docLinestartPosition2lineCount = new TreeMap();
        this.lineCount2docLinestartPosition = new TreeMap();
        try {
            for (int i = 0; i < this.lines.length; ++i) {
                boolean bl = false;
                if (this.lineLevels[i] <= n) {
                    bl = true;
                }
                if (bl && this.showTypeRestricted && this.lineTypes[i] != this.selTypeIndex) {
                    bl = false;
                }
                if (!bl) continue;
                this.docLinestartPosition2lineCount.put(this.document.getLength(), i);
                this.lineCount2docLinestartPosition.put(i, this.document.getLength());
                String string = "(" + i + ")";
                this.document.insertStringTruely(this.document.getLength(), String.format("%-10s", string) + this.lines[i] + '\n', this.lineStyles[i]);
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        this.jTextPane.setDocument(this.document);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                LogPane.this.jTextPane.setCursor(new Cursor(0));
            }
        });
    }

    private void setLevelWithoutAction(Object object) {
        logging.debug(this, "setLevel " + object);
        Integer n = this.sliderLevel.getValue();
        if (n != object && this.sliderListener != null) {
            this.sliderLevel.removeChangeListener(this.sliderListener);
            this.sliderLevel.setValue((Integer)object);
            this.sliderLevel.addChangeListener(this.sliderListener);
        }
    }

    private void activateShowLevel() {
        Integer n = this.sliderLevel.getValue();
        if (n > this.maxExistingLevel) {
            n = this.maxExistingLevel;
            this.sliderLevel.setValue(n);
            return;
        }
        logging.debug(this, "activateShowLevel " + n);
        Integer n2 = this.showLevel;
        this.showLevel = n;
        logging.debug(this, "activateShowLevel level, oldLevel, maxExistingLevel " + n + " , " + n2 + ", " + this.maxExistingLevel);
        if (n2 != n && (n < this.maxExistingLevel || n2 < this.maxExistingLevel)) {
            int n3 = this.jTextPane.getCaretPosition();
            int n4 = 0;
            int n5 = 0;
            int n6 = 0;
            Iterator<Integer> iterator = this.docLinestartPosition2lineCount.keySet().iterator();
            while (n4 < n3 && iterator.hasNext()) {
                n6 = n3 - n4;
                n5 = n4;
                n4 = iterator.next();
            }
            int n7 = 0;
            if (this.docLinestartPosition2lineCount.get(n5) != null) {
                n7 = this.docLinestartPosition2lineCount.get(n5);
            }
            this.buildDocument();
            if (this.lineCount2docLinestartPosition.containsKey(n7)) {
                n4 = this.lineCount2docLinestartPosition.get(n7) + n6;
            } else {
                Iterator<Integer> iterator2 = this.lineCount2docLinestartPosition.keySet().iterator();
                int n8 = 0;
                if (iterator2.hasNext()) {
                    n8 = iterator2.next();
                }
                while (iterator2.hasNext() && n8 < n7) {
                    n8 = iterator2.next();
                }
                n4 = this.lineCount2docLinestartPosition.get(n8) + n6;
            }
            this.jTextPane.setCaretPosition(n4);
            this.jTextPane.getCaret().setVisible(true);
        }
    }

    protected Style getStyleByLevelNo(int n) {
        Style style = null;
        style = n < this.logLevelStyles.length ? this.logLevelStyles[n] : this.logLevelStyles[this.logLevelStyles.length - 1];
        return style;
    }

    protected void parse() {
        char c = '0';
        int n = 0;
        this.maxExistingLevel = 0;
        this.lineLevels = new int[this.lines.length];
        this.lineStyles = new Style[this.lines.length];
        this.lineTypes = new int[this.lines.length];
        this.typesList = new ArrayList<String>();
        StringBlock stringBlock = new StringBlock();
        StringBlock stringBlock2 = new StringBlock();
        Style style = this.getStyleByLevelNo(0);
        int n2 = this.lines.length;
        for (int i = 0; i < n2; ++i) {
            if (this.lines[i].length() >= 3 && this.lines[i].charAt(0) == '[' && this.lines[i].charAt(2) == ']') {
                c = this.lines[i].charAt(1);
            }
            if (Character.isDigit(c)) {
                n = new Integer("" + c);
                if (n > this.maxExistingLevel) {
                    this.maxExistingLevel = n;
                }
                this.lineLevels[i] = n;
                style = this.getStyleByLevelNo(n);
            }
            this.lineStyles[i] = style;
            String string = "";
            int n3 = 0;
            int n4 = 0;
            stringBlock.setString(this.lines[i]);
            stringBlock2.setString(this.lines[i]);
            stringBlock.forward(n4, '[', ']');
            int n5 = 0;
            if (stringBlock.hasFound()) {
                ++n5;
                n4 = stringBlock.getIEnd() + 1;
                stringBlock2.forward(n4, '(', ')');
                if (stringBlock2.hasFound()) {
                    n4 = stringBlock2.getIEnd() + 1;
                }
                stringBlock.forward(n4, '[', ']');
            }
            if (stringBlock.hasFound()) {
                ++n5;
                n4 = stringBlock.getIEnd() + 1;
                stringBlock.forward(n4, '[', ']');
            }
            if (stringBlock.hasFound()) {
                ++n5;
                string = stringBlock.getContent();
                n3 = this.typesList.indexOf(string);
                if (n3 == -1) {
                    n3 = this.typesList.size();
                    this.typesList.add(string);
                }
            }
            this.lineTypes[i] = n3;
        }
        this.adaptComboType();
    }

    private void adaptComboType() {
        this.comboType.setEnabled(false);
        this.comboModelTypes.removeAllElements();
        if (this.typesList.size() > 0) {
            this.comboModelTypes.addElement("(all)");
            for (String string : this.typesList) {
                this.comboModelTypes.addElement(string);
            }
            this.comboType.setEnabled(true);
            this.comboType.setMaximumRowCount(this.typesList.size() + 1);
        }
    }

    public void adaptSlider() {
        this.sliderLevel.produceLabels(this.maxExistingLevel);
    }

    public void setText(String string) {
        if (string == null) {
            logging.info(this, "Setting text");
        }
        this.lines = string.split("\n");
        this.parse();
        if (this.lines.length > 1) {
            this.showLevel = this.maxExistingLevel;
            this.adaptSlider();
        } else {
            this.showLevel = 1;
            this.sliderLevel.produceLabels(0);
        }
        this.sliderLevel.setValue(this.showLevel);
        this.buildDocument();
        this.jTextPane.setCaretPosition(0);
        this.jTextPane.getCaret().setVisible(true);
    }

    private void setParsedText(String[] stringArray, int[] nArray, Style[] styleArray, int[] nArray2, List list, boolean bl, int n, int n2) {
        logging.debug(this, "setParsedText");
        this.lines = stringArray;
        this.lineLevels = nArray;
        this.maxExistingLevel = n2;
        this.lineStyles = styleArray;
        this.lineTypes = nArray2;
        this.typesList = list;
        this.adaptComboType();
        this.showTypeRestricted = bl;
        this.selTypeIndex = n;
        this.buildDocument();
    }

    public void editSearchString() {
        this.fieldSearch.requestFocus();
    }

    public void search() {
        logging.debug(this, "Searching string in log");
        this.jTextPane.requestFocus();
        int n = this.searcher.search(this.fieldSearch.getText());
        if (n != -1) {
            try {
                this.jTextPane.scrollRectToVisible(this.jTextPane.modelToView(n + this.fieldSearch.getText().length()));
                this.jTextPane.setCaretPosition(n);
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        logging.debug(this, "KeyEvent " + keyEvent);
        if (keyEvent.getSource() == this.buttonSearch) {
            if (keyEvent.getKeyCode() == 10) {
                this.search();
            }
        } else if (!(keyEvent.getSource() != this.fieldSearch && keyEvent.getSource() != this.jTextPane || keyEvent.getKeyCode() != 114 && keyEvent.getKeyCode() != 10 || this.fieldSearch.getText().equals(""))) {
            this.search();
        }
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
        if (keyEvent.getSource() == this.jTextPane) {
            if (keyEvent.getKeyChar() == '/' || keyEvent.getKeyChar() == '\u0006') {
                this.editSearchString();
            }
            if (keyEvent.getKeyChar() == 'n' || keyEvent.getKeyChar() == '\f' || keyEvent.getKeyCode() == 114) {
                this.search();
            }
            keyEvent.consume();
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.buttonSearch) {
            this.search();
        } else if (actionEvent.getSource() == this.jCheckBoxCaseSensitive) {
            if (this.jCheckBoxCaseSensitive.isSelected()) {
                this.searcher.setCaseSensitivity(true);
            } else {
                this.searcher.setCaseSensitivity(false);
            }
        }
    }

    public class UnderlineHighlighter
    extends DefaultHighlighter {
        protected final Highlighter.HighlightPainter sharedPainter;
        protected Highlighter.HighlightPainter painter;

        public UnderlineHighlighter(Color color) {
            this.sharedPainter = new UnderlineHighlightPainter(null);
            this.painter = color == null ? this.sharedPainter : new UnderlineHighlightPainter(color);
        }

        public Object addHighlight(int n, int n2) throws BadLocationException {
            return this.addHighlight(n, n2, this.painter);
        }

        @Override
        public void setDrawsLayeredHighlights(boolean bl) {
            if (!bl) {
                throw new IllegalArgumentException("UnderlineHighlighter only draws layered highlights");
            }
            super.setDrawsLayeredHighlights(true);
        }
    }

    public class UnderlineHighlightPainter
    extends LayeredHighlighter.LayerPainter {
        protected Color color;

        public UnderlineHighlightPainter(Color color) {
            this.color = color;
        }

        @Override
        public void paint(Graphics graphics, int n, int n2, Shape shape, JTextComponent jTextComponent) {
        }

        @Override
        public Shape paintLayer(Graphics graphics, int n, int n2, Shape shape, JTextComponent jTextComponent, View view) {
            Object object;
            graphics.setColor(this.color == null ? jTextComponent.getSelectionColor() : this.color);
            Rectangle rectangle = null;
            if (n == view.getStartOffset() && n2 == view.getEndOffset()) {
                rectangle = shape instanceof Rectangle ? (Rectangle)shape : shape.getBounds();
            } else {
                try {
                    object = view.modelToView(n, Position.Bias.Forward, n2, Position.Bias.Backward, shape);
                    rectangle = object instanceof Rectangle ? (Rectangle)object : object.getBounds();
                }
                catch (BadLocationException badLocationException) {
                    return null;
                }
            }
            object = jTextComponent.getFontMetrics(jTextComponent.getFont());
            int n3 = rectangle.y + rectangle.height - ((FontMetrics)object).getDescent() + 1;
            graphics.drawLine(rectangle.x, n3, rectangle.x + rectangle.width, n3);
            graphics.drawLine(rectangle.x, n3 + 1, rectangle.x + rectangle.width, n3 + 1);
            return rectangle;
        }
    }

    public class WordSearcher {
        protected JTextComponent comp;
        protected Highlighter.HighlightPainter painter;
        protected int lastReturnedOffset;
        protected boolean cS = false;

        public WordSearcher(JTextComponent jTextComponent) {
            this.comp = jTextComponent;
            this.painter = new UnderlineHighlightPainter(Color.red);
            this.lastReturnedOffset = -1;
        }

        public void setCaseSensitivity(boolean bl) {
            this.cS = bl;
        }

        public int search(String string) {
            Object object;
            int n = -1;
            int n2 = this.lastReturnedOffset;
            Highlighter highlighter = this.comp.getHighlighter();
            Highlighter.Highlight[] highlightArray = highlighter.getHighlights();
            for (int i = 0; i < highlightArray.length; ++i) {
                object = highlightArray[i];
                if (!(object.getPainter() instanceof UnderlineHighlightPainter)) continue;
                highlighter.removeHighlight(object);
            }
            if (string == null || string.equals("")) {
                return -1;
            }
            String string2 = null;
            try {
                object = this.comp.getDocument();
                string2 = this.cS ? object.getText(0, object.getLength()) : object.getText(0, object.getLength()).toLowerCase();
            }
            catch (BadLocationException badLocationException) {
                return -1;
            }
            if (!this.cS) {
                string = string.toLowerCase();
            }
            int n3 = 0;
            int n4 = string.length();
            while ((n3 = string2.indexOf(string, n3)) != -1) {
                int n5 = n3 + n4;
                try {
                    highlighter.addHighlight(n3, n5, this.painter);
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
                if (n == -1) {
                    n = n3;
                }
                if (n2 == this.lastReturnedOffset && n3 > this.lastReturnedOffset) {
                    n2 = n3;
                }
                n3 = n5;
            }
            if (n2 == this.lastReturnedOffset) {
                n2 = n;
            }
            this.lastReturnedOffset = n2;
            return n2;
        }
    }

    private class StringBlock {
        String s;
        int iStart;
        int iEnd;
        private int contentStart;
        private int contentEnd;
        boolean finish;
        boolean found;
        char startC;
        char endC;

        private StringBlock() {
        }

        void setString(String string) {
            this.s = string;
        }

        String getContent() {
            return this.s.substring(this.contentStart, this.contentEnd).trim();
        }

        boolean hasFound() {
            return this.found;
        }

        int getIEnd() {
            return this.iEnd;
        }

        private int findContentEnd() {
            int n = -1;
            int n2 = 0;
            for (int i = this.contentStart; n == -1 && i < this.s.length(); ++i) {
                char c = this.s.charAt(i);
                if (c == this.startC) {
                    ++n2;
                    continue;
                }
                if (c != this.endC) continue;
                if (n2 > 0) {
                    --n2;
                    continue;
                }
                n = i;
            }
            return n;
        }

        void forward(int n, char c, char c2) {
            this.iStart = n;
            this.iEnd = n;
            this.finish = false;
            this.found = false;
            this.startC = c;
            this.endC = c2;
            this.contentStart = this.s.indexOf(c, n);
            if (this.contentStart < 0) {
                return;
            }
            if (this.s.substring(n, this.contentStart).trim().length() > 0) {
                return;
            }
            ++this.contentStart;
            this.contentEnd = this.findContentEnd();
            if (this.contentEnd <= -1) {
                return;
            }
            this.found = true;
            this.iEnd = this.contentEnd;
            ++this.iEnd;
        }
    }

    protected class ImmutableDefaultStyledDocument
    extends DefaultStyledDocument {
        ImmutableDefaultStyledDocument() {
        }

        ImmutableDefaultStyledDocument(StyleContext styleContext) {
            super(styleContext);
        }

        public void insertStringTruely(int n, String string, AttributeSet attributeSet) throws BadLocationException {
            super.insertString(n, string, attributeSet);
        }

        @Override
        public void insertString(int n, String string, AttributeSet attributeSet) throws BadLocationException {
        }

        @Override
        public void replace(int n, int n2, String string, AttributeSet attributeSet) throws BadLocationException {
        }

        @Override
        public void remove(int n, int n2) throws BadLocationException {
        }
    }

    protected class AdaptingSlider
    extends JSlider {
        LinkedHashMap<Integer, JLabel> levelMap;
        Hashtable<Integer, JLabel> levelDict;
        int min;
        int max;
        int value;

        public AdaptingSlider(int n, int n2, int n3) {
            super(n, n2, n3);
            this.min = n;
            this.max = n2;
            this.value = n3;
            this.setFont(Globals.defaultFont);
            this.produceLabels(n2);
            this.setPaintLabels(true);
            this.setSnapToTicks(true);
        }

        public void produceLabels(int n) {
            int n2;
            this.levelMap = new LinkedHashMap();
            for (n2 = this.min; n2 <= n; ++n2) {
                this.levelMap.put(n2, new JLabel("" + n2));
            }
            for (n2 = n + 1; n2 <= this.max; ++n2) {
                this.levelMap.put(n2, new JLabel(" . "));
            }
            this.levelDict = new Hashtable<Integer, JLabel>(this.levelMap);
            try {
                this.setLabelTable(this.levelDict);
            }
            catch (Exception exception) {
                logging.info(this, "setLabelTable levelDict " + this.levelDict + " ex " + exception);
            }
        }
    }
}

