/*
 * Decompiled with CFR 0.152.
 */
package de.uib.configed.gui;

import de.uib.configed.ConfigedMain;
import de.uib.configed.Globals;
import de.uib.configed.clientselection.SelectData;
import de.uib.configed.clientselection.SelectElement;
import de.uib.configed.clientselection.SelectGroupOperation;
import de.uib.configed.clientselection.SelectOperation;
import de.uib.configed.clientselection.SelectionManager;
import de.uib.configed.clientselection.elements.DescriptionElement;
import de.uib.configed.clientselection.elements.GroupElement;
import de.uib.configed.clientselection.elements.IPElement;
import de.uib.configed.clientselection.elements.NameElement;
import de.uib.configed.clientselection.elements.SoftwareActionProgressElement;
import de.uib.configed.clientselection.elements.SoftwareActionResultElement;
import de.uib.configed.clientselection.elements.SoftwareInstallationStatusElement;
import de.uib.configed.clientselection.elements.SoftwareLastActionElement;
import de.uib.configed.clientselection.elements.SoftwareModificationTimeElement;
import de.uib.configed.clientselection.elements.SoftwarePackageVersionElement;
import de.uib.configed.clientselection.elements.SoftwareRequestElement;
import de.uib.configed.clientselection.elements.SoftwareVersionElement;
import de.uib.configed.clientselection.elements.SwAuditArchitectureElement;
import de.uib.configed.clientselection.elements.SwAuditLanguageElement;
import de.uib.configed.clientselection.elements.SwAuditNameElement;
import de.uib.configed.clientselection.elements.SwAuditSoftwareIdElement;
import de.uib.configed.clientselection.elements.SwAuditVersionElement;
import de.uib.configed.clientselection.operations.HardwareOperation;
import de.uib.configed.clientselection.operations.HostOperation;
import de.uib.configed.clientselection.operations.SoftwareOperation;
import de.uib.configed.clientselection.operations.SwAuditOperation;
import de.uib.configed.configed;
import de.uib.configed.gui.AndOrSelectButtonByIcon;
import de.uib.configed.gui.FGeneralDialog;
import de.uib.configed.gui.IconAsButton;
import de.uib.configed.gui.SavedSearchesDialog;
import de.uib.configed.type.SavedSearch;
import de.uib.utilities.logging.logging;
import de.uib.utilities.observer.swing.ValueChangeListener;
import de.uib.utilities.selectionpanel.JTableSelectionPanel;
import de.uib.utilities.swing.TextInputField;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Stack;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeListener;

public class ClientSelectionDialog
extends FGeneralDialog {
    private static ClientSelectionDialog instance = null;
    private GroupLayout layout;
    private GroupLayout.SequentialGroup vGroup;
    private GroupLayout.ParallelGroup hGroupParenthesisClose;
    private GroupLayout.ParallelGroup hGroupParenthesisOpen;
    private GroupLayout.ParallelGroup hGroupRemoveBtn;
    private GroupLayout.ParallelGroup hGroupNegate;
    private GroupLayout.ParallelGroup hGroupConnections;
    private GroupLayout.ParallelGroup hGroupElements;
    private GroupLayout.ParallelGroup hGroupOperations;
    private GroupLayout.ParallelGroup hGroupData;
    private JPanel contentPane;
    private JComboBox newElementBox;
    private JComboBox loadSearchBox;
    private IconAsButton buttonReload;
    private JTextField saveNameField;
    private JTextField saveDescriptionField;
    private JButton saveButton;
    private LinkedList<SelectElement> elements;
    private LinkedList<ComplexGroup> complexElements;
    private SelectionManager manager;
    private JTableSelectionPanel selectionPanel;
    private SavedSearchesDialog savedSearchesDialog;
    private final Color selectedColor = Color.red;
    private final Color deselectedColor = Color.gray;
    private ConfigedMain main;

    public ClientSelectionDialog(ConfigedMain configedMain, JTableSelectionPanel jTableSelectionPanel, SavedSearchesDialog savedSearchesDialog) {
        super(null, configed.getResourceValue("ClientSelectionDialog.title") + " (" + "opsi config editor" + ")", false, new String[]{configed.getResourceValue("ClientSelectionDialog.buttonSet"), configed.getResourceValue("ClientSelectionDialog.buttonReset"), configed.getResourceValue("ClientSelectionDialog.buttonClose")}, 750, 620);
        this.main = configedMain;
        this.selectionPanel = jTableSelectionPanel;
        this.savedSearchesDialog = savedSearchesDialog;
        this.setDefaultCloseOperation(1);
        this.manager = new SelectionManager("OpsiData");
        this.elements = new LinkedList();
        this.complexElements = new LinkedList();
        this.init();
        this.pack();
    }

    public void setReloadRequested() {
        this.manager.getBackend().setReloadRequested();
    }

    public void refreshGroups() {
        for (ComplexGroup complexGroup : this.complexElements) {
            if (complexGroup.type != GroupType.HostGroup) continue;
            for (SimpleGroup simpleGroup : complexGroup.groupList) {
                if (!(simpleGroup.element instanceof GroupElement)) continue;
                JComboBox jComboBox = (JComboBox)simpleGroup.dataComponent;
                jComboBox.removeAllItems();
                for (String string : simpleGroup.element.getEnumData()) {
                    jComboBox.addItem(string);
                }
            }
        }
    }

    public void loadSearch(String string) {
        try {
            this.manager.loadSearch(string);
            this.loadFromManager();
            SavedSearch savedSearch = (SavedSearch)this.manager.getSavedSearches().get(string);
            this.saveNameField.setText(savedSearch.name);
            this.saveDescriptionField.setText(savedSearch.description);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            logging.error("Could not load search!");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doAction1() {
        logging.info(this, "doAction1");
        List<Object> list = new ArrayList();
        this.collectData();
        this.main.setVisualViewIndex(0);
        if (this.manager != null) {
            list = this.manager.selectClients();
        }
        if (list == null) {
            return;
        }
        logging.debug(this, list.toString());
        this.selectionPanel.setSelectedValues(list);
    }

    @Override
    protected void doAction2() {
        this.reset();
    }

    @Override
    protected void initComponents() {
        this.additionalPane = new JPanel();
        GroupLayout groupLayout = new GroupLayout(this.additionalPane);
        this.additionalPane.setLayout(groupLayout);
        this.saveNameField = new JTextField();
        this.saveDescriptionField = new JTextField();
        JLabel jLabel = new JLabel(configed.getResourceValue("ClientSelectionDialog.inquiryName"));
        jLabel.setFont(Globals.defaultFont);
        JLabel jLabel2 = new JLabel(configed.getResourceValue("ClientSelectionDialog.inquiryDescription"));
        jLabel2.setFont(Globals.defaultFont);
        this.saveButton = new JButton(configed.getResourceValue("ClientSelectionDialog.inquirySave"));
        this.saveButton.setSize(new Dimension(140, 22));
        this.saveButton.setFont(Globals.defaultFont);
        this.saveButton.addActionListener(new SaveButtonListener());
        this.buttonReload = new IconAsButton(configed.getResourceValue("ClientSelectionDialog.buttonReload"), "images/reload16.png", "images/reload16.png", "images/reload16.png", "images/reload16.png");
        this.buttonReload.setBackground(de.uib.utilities.Globals.backgroundLightGrey);
        this.buttonReload.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                logging.info(this, "actionPerformed");
                ClientSelectionDialog.this.setReloadRequested();
            }
        });
        GroupLayout.SequentialGroup sequentialGroup = groupLayout.createSequentialGroup();
        sequentialGroup.addGap(10);
        sequentialGroup.addComponent(jLabel, -2, -2, -2);
        sequentialGroup.addGap(5);
        sequentialGroup.addComponent(this.saveNameField, 40, 100, 200);
        sequentialGroup.addGap(10);
        sequentialGroup.addComponent(jLabel2, -2, -2, -2);
        sequentialGroup.addGap(5);
        sequentialGroup.addComponent(this.saveDescriptionField, 40, 200, Short.MAX_VALUE);
        sequentialGroup.addGap(10);
        sequentialGroup.addComponent(this.saveButton, 140, 140, 140);
        sequentialGroup.addGap(10);
        sequentialGroup.addComponent(this.buttonReload, 30, 30, 30);
        sequentialGroup.addGap(5);
        groupLayout.setHorizontalGroup(sequentialGroup);
        GroupLayout.ParallelGroup parallelGroup = groupLayout.createParallelGroup(GroupLayout.Alignment.CENTER);
        parallelGroup.addComponent(jLabel, 28, 28, 28);
        parallelGroup.addComponent(this.saveNameField, 28, 28, 28);
        parallelGroup.addComponent(jLabel2, 28, 28, 28);
        parallelGroup.addComponent(this.saveDescriptionField, 28, 28, 28);
        parallelGroup.addComponent(this.saveButton, 28, 28, 28);
        parallelGroup.addComponent(this.buttonReload, 28, 28, 28);
        groupLayout.setVerticalGroup(parallelGroup);
        this.additionalPane.setVisible(true);
    }

    private void init() {
        this.contentPane = new JPanel();
        this.contentPane.setBackground(Globals.backLightBlue);
        this.layout = new GroupLayout(this.contentPane);
        this.contentPane.setLayout(this.layout);
        this.layout.setAutoCreateContainerGaps(true);
        this.layout.setHonorsVisibility(false);
        GroupLayout.SequentialGroup sequentialGroup = this.layout.createSequentialGroup();
        GroupLayout.ParallelGroup parallelGroup = this.layout.createParallelGroup();
        this.vGroup = this.layout.createSequentialGroup();
        GroupLayout.ParallelGroup parallelGroup2 = this.layout.createParallelGroup();
        this.vGroup.addGroup(parallelGroup2);
        sequentialGroup.addGroup(this.vGroup);
        this.layout.setVerticalGroup(sequentialGroup);
        this.hGroupParenthesisClose = this.layout.createParallelGroup();
        this.hGroupParenthesisOpen = this.layout.createParallelGroup();
        this.hGroupRemoveBtn = this.layout.createParallelGroup();
        this.hGroupNegate = this.layout.createParallelGroup();
        this.hGroupConnections = this.layout.createParallelGroup();
        this.hGroupElements = this.layout.createParallelGroup();
        this.hGroupOperations = this.layout.createParallelGroup();
        this.hGroupData = this.layout.createParallelGroup();
        parallelGroup.addGroup(this.layout.createSequentialGroup().addGroup(this.hGroupParenthesisOpen).addGap(3).addGroup(this.hGroupNegate).addGap(5).addGroup(this.hGroupElements).addGap(5).addGroup(this.hGroupOperations).addGap(5).addGroup(this.hGroupData).addGap(3).addGroup(this.hGroupParenthesisClose).addGap(5).addGroup(this.hGroupConnections).addGap(5).addGroup(this.hGroupRemoveBtn));
        this.layout.setHorizontalGroup(parallelGroup);
        Font font = Globals.defaultFontStandardBold;
        JLabel jLabel = new JLabel(configed.getResourceValue("ClientSelectionDialog.negateColumn"));
        jLabel.setFont(font);
        JLabel jLabel2 = new JLabel(configed.getResourceValue("ClientSelectionDialog.nameColumn"));
        jLabel2.setFont(font);
        JLabel jLabel3 = new JLabel(configed.getResourceValue("ClientSelectionDialog.dataColumn"));
        jLabel3.setFont(font);
        JLabel jLabel4 = new JLabel(configed.getResourceValue("ClientSelectionDialog.connectionColumn"));
        jLabel4.setFont(font);
        parallelGroup2.addComponent(jLabel);
        parallelGroup2.addComponent(jLabel2);
        parallelGroup2.addComponent(jLabel3);
        parallelGroup2.addComponent(jLabel4);
        this.hGroupNegate.addComponent(jLabel, GroupLayout.Alignment.CENTER);
        this.hGroupElements.addComponent(jLabel2, GroupLayout.Alignment.CENTER);
        this.hGroupData.addComponent(jLabel3, GroupLayout.Alignment.CENTER);
        this.hGroupConnections.addComponent(jLabel4, GroupLayout.Alignment.CENTER);
        this.newElementBox = new JComboBox<String>(new String[]{configed.getResourceValue("ClientSelectionDialog.newElementsBox")});
        this.newElementBox.setFont(Globals.defaultFont);
        this.newElementBox.addItem(configed.getResourceValue("ClientSelectionDialog.hostName"));
        this.newElementBox.addItem(configed.getResourceValue("ClientSelectionDialog.softwareName"));
        this.newElementBox.addItem(configed.getResourceValue("ClientSelectionDialog.swauditName"));
        LinkedList<String> linkedList = new LinkedList<String>(this.manager.getLocalizedHardwareList().keySet());
        Collections.sort(linkedList);
        for (String string : linkedList) {
            this.newElementBox.addItem(string);
        }
        this.newElementBox.setMaximumSize(new Dimension(this.newElementBox.getPreferredSize().width, this.newElementBox.getPreferredSize().height));
        this.newElementBox.addActionListener(new AddElementListener());
        sequentialGroup.addComponent(this.newElementBox);
        parallelGroup.addComponent(this.newElementBox);
        this.contentPane.add(this.newElementBox);
        this.complexElements.add(this.createHostGroup());
        this.complexElements.add(this.createSoftwareGroup());
        this.complexElements.getLast().connectionType.setVisible(false);
        this.scrollpane.getViewport().add(this.contentPane);
    }

    private SimpleGroup createSimpleGroup(SelectElement selectElement) {
        SimpleGroup simpleGroup = new SimpleGroup();
        simpleGroup.element = selectElement;
        SelectOperation[] selectOperationArray = selectElement.supportedOperations().toArray(new SelectOperation[0]);
        if (selectOperationArray.length == 0) {
            logging.warning("Elements without any operations are not supported");
            return null;
        }
        simpleGroup.negateButton = new IconAsButton("", "images/boolean_not_disabled.png", "images/boolean_not_over.png", "images/boolean_not.png", null);
        simpleGroup.negateButton.setActivated(false);
        simpleGroup.negateButton.setMaximumSize(new Dimension(simpleGroup.negateButton.getMaximumSize().width, simpleGroup.negateButton.getPreferredSize().height));
        simpleGroup.negateButton.addActionListener(new NotButtonListener());
        simpleGroup.connectionType = new AndOrSelectButtonByIcon();
        simpleGroup.connectionType.addActionListener(new AndOrButtonListener());
        simpleGroup.connectionType.setMaximumSize(new Dimension(simpleGroup.connectionType.getMaximumSize().width, simpleGroup.connectionType.getPreferredSize().height));
        simpleGroup.elementLabel = new JLabel(selectElement.getLocalizedPath());
        simpleGroup.elementLabel.setMaximumSize(new Dimension(simpleGroup.elementLabel.getMaximumSize().width, simpleGroup.connectionType.getPreferredSize().height));
        if (selectOperationArray.length > 1) {
            JComboBox<String> jComboBox = new JComboBox<String>();
            for (SelectOperation selectOperation : selectOperationArray) {
                jComboBox.addItem(selectOperation.getOperationString());
            }
            simpleGroup.operationComponent = jComboBox;
        } else {
            simpleGroup.operationComponent = new JLabel(selectOperationArray[0].getOperationString(), 0);
        }
        simpleGroup.operationComponent.setMaximumSize(new Dimension(simpleGroup.operationComponent.getMaximumSize().width, simpleGroup.operationComponent.getPreferredSize().height));
        simpleGroup.dataComponent = new JLabel();
        simpleGroup.dataComponent.setMaximumSize(new Dimension(simpleGroup.dataComponent.getMaximumSize().width, simpleGroup.dataComponent.getPreferredSize().height));
        simpleGroup.openParenthesis = new IconAsButton("", "images/parenthesis_open_disabled.png", "images/parenthesis_open_over.png", "images/parenthesis_open.png", null);
        simpleGroup.openParenthesis.setActivated(true);
        simpleGroup.openParenthesis.setVisible(false);
        simpleGroup.closeParenthesis = new IconAsButton("", "images/parenthesis_close_disabled.png", "images/parenthesis_close_over.png", "images/parenthesis_close.png", null);
        simpleGroup.closeParenthesis.setActivated(true);
        simpleGroup.closeParenthesis.setVisible(false);
        simpleGroup.vRow = this.layout.createParallelGroup();
        simpleGroup.vRow.addComponent(simpleGroup.negateButton, GroupLayout.Alignment.CENTER);
        simpleGroup.vRow.addComponent(simpleGroup.connectionType, GroupLayout.Alignment.CENTER);
        simpleGroup.vRow.addComponent(simpleGroup.elementLabel, GroupLayout.Alignment.CENTER);
        simpleGroup.vRow.addComponent(simpleGroup.operationComponent, GroupLayout.Alignment.CENTER);
        simpleGroup.vRow.addComponent(simpleGroup.dataComponent, GroupLayout.Alignment.CENTER);
        simpleGroup.vRow.addComponent(simpleGroup.openParenthesis, GroupLayout.Alignment.CENTER, 20, 20, 20);
        simpleGroup.vRow.addComponent(simpleGroup.closeParenthesis, GroupLayout.Alignment.CENTER, 20, 20, 20);
        this.vGroup.addGroup(simpleGroup.vRow);
        this.hGroupNegate.addComponent(simpleGroup.negateButton, 10, 40, 50);
        this.hGroupConnections.addComponent(simpleGroup.connectionType, 100, 100, 100);
        this.hGroupElements.addComponent(simpleGroup.elementLabel);
        this.hGroupOperations.addComponent(simpleGroup.operationComponent, 65, 70, 70);
        this.hGroupData.addComponent(simpleGroup.dataComponent, 100, 100, Short.MAX_VALUE);
        this.hGroupParenthesisOpen.addComponent(simpleGroup.openParenthesis, 20, 20, 20);
        this.hGroupParenthesisClose.addComponent(simpleGroup.closeParenthesis, 20, 20, 20);
        this.contentPane.add(simpleGroup.negateButton);
        this.contentPane.add(simpleGroup.connectionType);
        this.contentPane.add(simpleGroup.elementLabel);
        this.contentPane.add(simpleGroup.operationComponent);
        this.contentPane.add(simpleGroup.dataComponent);
        this.contentPane.add(simpleGroup.openParenthesis);
        this.contentPane.add(simpleGroup.closeParenthesis);
        if (selectOperationArray.length > 1) {
            ((JComboBox)simpleGroup.operationComponent).addActionListener(new SelectOperationListener());
            this.addDataComponent(simpleGroup, ((JComboBox)simpleGroup.operationComponent).getSelectedIndex());
        } else if (selectOperationArray.length == 1) {
            this.addDataComponent(simpleGroup, 0);
        }
        return simpleGroup;
    }

    private ComplexGroup createHostGroup() {
        ComplexGroup complexGroup = this.createComplexGroup();
        complexGroup.type = GroupType.HostGroup;
        complexGroup.topLabel.setText(configed.getResourceValue("ClientSelectionDialog.hostGroup") + ":");
        complexGroup.topLabel.setIcon(Globals.createImageIcon("images/client_small.png", configed.getResourceValue("ClientSelectionDialog.client")));
        complexGroup.topLabel.setFont(Globals.defaultFontStandardBold);
        complexGroup.groupList.add(this.createSimpleGroup(new GroupElement(this.manager.getBackend().getGroups().toArray(new String[0]))));
        complexGroup.groupList.add(this.createSimpleGroup(new NameElement()));
        complexGroup.groupList.add(this.createSimpleGroup(new IPElement()));
        complexGroup.groupList.add(this.createSimpleGroup(new DescriptionElement()));
        complexGroup.groupList.getLast().connectionType.setVisible(false);
        this.createComplexBottom(complexGroup);
        return complexGroup;
    }

    private ComplexGroup createSoftwareGroup() {
        ComplexGroup complexGroup = this.createComplexGroup();
        complexGroup.type = GroupType.SoftwareGroup;
        complexGroup.topLabel.setText(configed.getResourceValue("ClientSelectionDialog.softwareGroup") + ":");
        complexGroup.topLabel.setIcon(Globals.createImageIcon("images/package.png", configed.getResourceValue("ClientSelectionDialog.softwareGroup")));
        complexGroup.topLabel.setFont(Globals.defaultFontStandardBold);
        complexGroup.groupList.add(this.createSimpleGroup(this.manager.getNewSoftwareNameElement()));
        complexGroup.groupList.add(this.createSimpleGroup(new SoftwareInstallationStatusElement()));
        complexGroup.groupList.add(this.createSimpleGroup(new SoftwareActionResultElement()));
        complexGroup.groupList.add(this.createSimpleGroup(new SoftwareRequestElement()));
        complexGroup.groupList.add(this.createSimpleGroup(new SoftwareActionProgressElement()));
        complexGroup.groupList.add(this.createSimpleGroup(new SoftwareLastActionElement()));
        complexGroup.groupList.add(this.createSimpleGroup(new SoftwareVersionElement()));
        complexGroup.groupList.add(this.createSimpleGroup(new SoftwarePackageVersionElement()));
        complexGroup.groupList.add(this.createSimpleGroup(new SoftwareModificationTimeElement()));
        complexGroup.groupList.getLast().connectionType.setVisible(false);
        this.createComplexBottom(complexGroup);
        return complexGroup;
    }

    private ComplexGroup createHardwareGroup(String string) {
        ComplexGroup complexGroup = this.createComplexGroup();
        complexGroup.type = GroupType.HardwareGroup;
        complexGroup.topLabel.setText(string);
        complexGroup.topLabel.setIcon(Globals.createImageIcon("images/hwaudit.png", configed.getResourceValue("ClientSelectionDialog.hardwareName")));
        complexGroup.topLabel.setFont(Globals.defaultFontStandardBold);
        List<SelectElement> list = this.manager.getLocalizedHardwareList().get(string);
        for (SelectElement selectElement : list) {
            complexGroup.groupList.add(this.createSimpleGroup(selectElement));
        }
        complexGroup.groupList.getLast().connectionType.setVisible(false);
        this.createComplexBottom(complexGroup);
        return complexGroup;
    }

    private ComplexGroup createSwAuditGroup() {
        ComplexGroup complexGroup = this.createComplexGroup();
        complexGroup.type = GroupType.SwAuditGroup;
        complexGroup.topLabel.setText(configed.getResourceValue("ClientSelectionDialog.swAuditGroup") + ":");
        complexGroup.topLabel.setIcon(Globals.createImageIcon("images/swaudit.png", configed.getResourceValue("ClientSelectionDialog.swauditName")));
        complexGroup.topLabel.setFont(Globals.defaultFontStandardBold);
        complexGroup.groupList.add(this.createSimpleGroup(new SwAuditNameElement()));
        complexGroup.groupList.add(this.createSimpleGroup(new SwAuditVersionElement()));
        complexGroup.groupList.add(this.createSimpleGroup(new SwAuditArchitectureElement()));
        complexGroup.groupList.add(this.createSimpleGroup(new SwAuditLanguageElement()));
        complexGroup.groupList.add(this.createSimpleGroup(new SwAuditSoftwareIdElement()));
        complexGroup.groupList.getLast().connectionType.setVisible(false);
        this.createComplexBottom(complexGroup);
        return complexGroup;
    }

    private ComplexGroup createComplexGroup() {
        ComplexGroup complexGroup = new ComplexGroup();
        complexGroup.removeButton = new IconAsButton("", "images/user-trash.png", "images/user-trash_over.png", "images/user-trash.png", "images/user-trash_disabled.png");
        complexGroup.removeButton.setMaximumSize(new Dimension(complexGroup.removeButton.getPreferredSize().width, complexGroup.removeButton.getPreferredSize().height));
        complexGroup.removeButton.addActionListener(new RemoveButtonListener());
        complexGroup.negateButton = new IconAsButton("", "images/boolean_not_disabled.png", "images/boolean_not_over.png", "images/boolean_not.png", null);
        complexGroup.negateButton.setActivated(false);
        complexGroup.negateButton.setMaximumSize(new Dimension(complexGroup.negateButton.getMaximumSize().width, complexGroup.negateButton.getPreferredSize().height));
        complexGroup.negateButton.addActionListener(new NotButtonListener());
        complexGroup.topLabel = new JLabel();
        complexGroup.topLabel.setMaximumSize(new Dimension(complexGroup.topLabel.getMaximumSize().width, complexGroup.removeButton.getPreferredSize().height));
        complexGroup.topLabel.setFont(Globals.defaultFontStandardBold);
        complexGroup.openParenthesis = new IconAsButton("", "images/parenthesis_open_disabled.png", "images/parenthesis_open_over.png", "images/parenthesis_open.png", null);
        complexGroup.openParenthesis.setActivated(false);
        complexGroup.openParenthesis.addActionListener(new ParenthesisListener());
        GroupLayout.ParallelGroup parallelGroup = this.layout.createParallelGroup();
        parallelGroup.addComponent(complexGroup.topLabel, GroupLayout.Alignment.CENTER, 20, 20, 20);
        parallelGroup.addComponent(complexGroup.removeButton, GroupLayout.Alignment.CENTER);
        parallelGroup.addComponent(complexGroup.negateButton, GroupLayout.Alignment.CENTER);
        parallelGroup.addComponent(complexGroup.openParenthesis, GroupLayout.Alignment.CENTER, 20, 20, 20);
        this.vGroup.addGroup(parallelGroup);
        this.hGroupNegate.addComponent(complexGroup.negateButton, 10, 40, 50);
        this.hGroupRemoveBtn.addComponent(complexGroup.removeButton);
        this.hGroupElements.addComponent(complexGroup.topLabel);
        this.hGroupParenthesisOpen.addComponent(complexGroup.openParenthesis, 20, 20, 20);
        this.contentPane.add(complexGroup.topLabel);
        complexGroup.groupList = new LinkedList();
        return complexGroup;
    }

    private void createComplexBottom(ComplexGroup complexGroup) {
        complexGroup.closeParenthesis = new IconAsButton("", "images/parenthesis_close_disabled.png", "images/parenthesis_close_over.png", "images/parenthesis_close.png", null);
        complexGroup.closeParenthesis.setActivated(false);
        complexGroup.closeParenthesis.addActionListener(new ParenthesisListener());
        complexGroup.connectionType = new AndOrSelectButtonByIcon();
        complexGroup.connectionType.addActionListener(new AndOrButtonListener());
        complexGroup.connectionType.setMaximumSize(new Dimension(complexGroup.connectionType.getMaximumSize().width, complexGroup.connectionType.getPreferredSize().height));
        GroupLayout.ParallelGroup parallelGroup = this.layout.createParallelGroup();
        parallelGroup.addComponent(complexGroup.connectionType, GroupLayout.Alignment.CENTER);
        parallelGroup.addComponent(complexGroup.closeParenthesis, GroupLayout.Alignment.CENTER, 20, 20, 20);
        this.vGroup.addGroup(parallelGroup);
        this.hGroupConnections.addComponent(complexGroup.connectionType, 100, 100, 100);
        this.hGroupParenthesisClose.addComponent(complexGroup.closeParenthesis, 20, 20, 20);
        this.contentPane.add(complexGroup.connectionType);
    }

    private SelectOperation getOperation(SimpleGroup simpleGroup) {
        int n = simpleGroup.operationComponent instanceof JComboBox ? ((JComboBox)simpleGroup.operationComponent).getSelectedIndex() : 0;
        SelectOperation selectOperation = simpleGroup.element.supportedOperations().get(n);
        Object object = null;
        String string = null;
        SelectData.DataType dataType = selectOperation.getDataType();
        switch (dataType) {
            case DoubleType: 
            case TextType: {
                string = ((TextInputField)simpleGroup.dataComponent).getText();
                if (string.isEmpty()) {
                    return null;
                }
                object = string;
                break;
            }
            case DateType: {
                string = ((TextInputField)simpleGroup.dataComponent).getText();
                if (string.isEmpty()) {
                    return null;
                }
                object = string;
                break;
            }
            case IntegerType: {
                Integer n2 = (Integer)((JSpinner)simpleGroup.dataComponent).getValue();
                if (n2 == 0) {
                    return null;
                }
                object = n2;
                break;
            }
            case BigIntegerType: {
                Long l = ((SpinnerWithExt)simpleGroup.dataComponent).getValue();
                if (l == 0L) {
                    return null;
                }
                object = l;
                break;
            }
            case EnumType: {
                String string2 = ((TextInputField)simpleGroup.dataComponent).getText();
                if (string2.isEmpty()) {
                    return null;
                }
                object = string2;
                break;
            }
        }
        selectOperation.setSelectData(new SelectData(object, dataType));
        return selectOperation;
    }

    private SelectionManager.OperationWithStatus getInformation(SimpleGroup simpleGroup) {
        SelectionManager.OperationWithStatus operationWithStatus = new SelectionManager.OperationWithStatus();
        operationWithStatus.operation = null;
        operationWithStatus.parenthesisOpen = simpleGroup.openParenthesis.isVisible();
        operationWithStatus.parenthesisClose = simpleGroup.closeParenthesis.isVisible();
        boolean bl = simpleGroup.connectionType.isAndSelected();
        logging.debug(this, simpleGroup.element.getPath() + ": AND selected: " + bl);
        boolean bl2 = simpleGroup.negateButton.isActivated();
        operationWithStatus.status = this.getStatus(bl, bl2);
        return operationWithStatus;
    }

    private SelectionManager.OperationWithStatus getInformation(ComplexGroup complexGroup) {
        SelectionManager.OperationWithStatus operationWithStatus = new SelectionManager.OperationWithStatus();
        operationWithStatus.operation = null;
        operationWithStatus.parenthesisOpen = complexGroup.openParenthesis.isActivated();
        operationWithStatus.parenthesisClose = complexGroup.closeParenthesis.isActivated();
        boolean bl = complexGroup.connectionType.isAndSelected();
        boolean bl2 = complexGroup.negateButton.isActivated();
        operationWithStatus.status = this.getStatus(bl, bl2);
        return operationWithStatus;
    }

    private SelectionManager.ConnectionStatus getStatus(boolean bl, boolean bl2) {
        SelectionManager.ConnectionStatus connectionStatus = bl ? (bl2 ? SelectionManager.ConnectionStatus.AndNot : SelectionManager.ConnectionStatus.And) : (bl2 ? SelectionManager.ConnectionStatus.OrNot : SelectionManager.ConnectionStatus.Or);
        return connectionStatus;
    }

    private void removeGroup(SimpleGroup simpleGroup) {
        this.contentPane.remove(simpleGroup.negateButton);
        this.contentPane.remove(simpleGroup.connectionType);
        this.contentPane.remove(simpleGroup.elementLabel);
        this.contentPane.remove(simpleGroup.operationComponent);
        if (simpleGroup.dataComponent != null) {
            this.contentPane.remove(simpleGroup.dataComponent);
        }
        this.contentPane.remove(simpleGroup.openParenthesis);
        this.contentPane.remove(simpleGroup.closeParenthesis);
        this.contentPane.revalidate();
        this.contentPane.repaint();
    }

    private void showParenthesesForGroup(LinkedList<SimpleGroup> linkedList) {
        boolean bl = false;
        for (SimpleGroup simpleGroup : linkedList) {
            simpleGroup.openParenthesis.setVisible(false);
            simpleGroup.closeParenthesis.setVisible(false);
            if (this.getOperation(simpleGroup) == null) continue;
            if (simpleGroup.connectionType.isAndSelected() && bl) {
                bl = false;
                simpleGroup.closeParenthesis.setVisible(true);
            }
            if (!simpleGroup.connectionType.isOrSelected() || bl) continue;
            bl = true;
            simpleGroup.openParenthesis.setVisible(true);
        }
        if (bl) {
            SimpleGroup simpleGroup = linkedList.getLast();
            simpleGroup.closeParenthesis.setVisible(true);
        }
    }

    private void buildParentheses() {
        logging.debug("BUILDPARENTHESES");
        for (ComplexGroup complexGroup : this.complexElements) {
            this.showParenthesesForGroup(complexGroup.groupList);
        }
    }

    private void repairParentheses() {
        Stack<ComplexGroup> stack = new Stack<ComplexGroup>();
        for (ComplexGroup complexGroup : this.complexElements) {
            if (complexGroup.openParenthesis.isActivated() && complexGroup.closeParenthesis.isActivated()) {
                complexGroup.openParenthesis.setActivated(false);
                complexGroup.closeParenthesis.setActivated(false);
                continue;
            }
            if (complexGroup.openParenthesis.isActivated()) {
                stack.push(complexGroup);
                continue;
            }
            if (!complexGroup.closeParenthesis.isActivated()) continue;
            if (!stack.isEmpty()) {
                stack.pop();
                continue;
            }
            complexGroup.closeParenthesis.setActivated(false);
        }
        for (ComplexGroup complexGroup : stack) {
            complexGroup.openParenthesis.setActivated(false);
        }
    }

    private void addDataComponent(SimpleGroup simpleGroup, int n) {
        if (n == -1) {
            return;
        }
        switch (simpleGroup.element.supportedOperations().get(n).getDataType()) {
            case TextType: {
                TextInputField textInputField = new TextInputField("", simpleGroup.element.getEnumData());
                textInputField.setEditable(true);
                textInputField.setSize(new Dimension(140, 28));
                textInputField.setToolTipText(configed.getResourceValue("ClientSelectionDialog.textInputToolTip"));
                textInputField.addValueChangeListener(new ValueChangeListener(){

                    @Override
                    protected void actOnChange() {
                        ClientSelectionDialog.this.buildParentheses();
                    }
                });
                simpleGroup.dataComponent = textInputField;
                break;
            }
            case DoubleType: {
                TextInputField textInputField = new TextInputField("");
                textInputField.setSize(new Dimension(140, 28));
                textInputField.setToolTipText(configed.getResourceValue("ClientSelectionDialog.textInputToolTip"));
                textInputField.addValueChangeListener(new ValueChangeListener(){

                    @Override
                    protected void actOnChange() {
                        ClientSelectionDialog.this.buildParentheses();
                    }
                });
                simpleGroup.dataComponent = textInputField;
                break;
            }
            case EnumType: {
                TextInputField textInputField = new TextInputField("", simpleGroup.element.getEnumData());
                textInputField.setEditable(true);
                textInputField.setToolTipText(configed.getResourceValue("ClientSelectionDialog.textInputToolTip"));
                textInputField.addValueChangeListener(new ValueChangeListener(){

                    @Override
                    protected void actOnChange() {
                        ClientSelectionDialog.this.buildParentheses();
                    }
                });
                simpleGroup.dataComponent = textInputField;
                break;
            }
            case DateType: {
                TextInputField textInputField = new TextInputField(null);
                textInputField.setSize(new Dimension(140, 28));
                textInputField.setToolTipText("yyyy-mm-dd");
                textInputField.addValueChangeListener(new ValueChangeListener(){

                    @Override
                    protected void actOnChange() {
                        ClientSelectionDialog.this.buildParentheses();
                    }
                });
                simpleGroup.dataComponent = textInputField;
                break;
            }
            case IntegerType: {
                JSpinner jSpinner = new JSpinner();
                jSpinner.addChangeListener(new ValueChangeListener(){

                    @Override
                    protected void actOnChange() {
                        ClientSelectionDialog.this.buildParentheses();
                    }
                });
                simpleGroup.dataComponent = jSpinner;
                break;
            }
            case BigIntegerType: {
                SpinnerWithExt spinnerWithExt = new SpinnerWithExt();
                spinnerWithExt.addChangeListener(new ValueChangeListener(){

                    @Override
                    protected void actOnChange() {
                        ClientSelectionDialog.this.buildParentheses();
                    }
                });
                simpleGroup.dataComponent = spinnerWithExt;
                break;
            }
            case NoneType: {
                return;
            }
        }
        simpleGroup.dataComponent.setMaximumSize(new Dimension(simpleGroup.dataComponent.getMaximumSize().width, simpleGroup.dataComponent.getMinimumSize().height));
        int n2 = 28;
        simpleGroup.vRow.addComponent(simpleGroup.dataComponent, GroupLayout.Alignment.CENTER, n2, n2, n2);
        this.hGroupData.addComponent(simpleGroup.dataComponent, 100, 100, Short.MAX_VALUE);
    }

    private void collectData() {
        logging.info(this, "collectData  complexElements " + this.complexElements);
        this.manager.clearOperations();
        logging.info(this, "collectData  complexElements " + this.complexElements);
        this.repairParentheses();
        for (ComplexGroup complexGroup : this.complexElements) {
            SelectionManager.OperationWithStatus operationWithStatus = this.getInformation(complexGroup);
            LinkedList<SelectionManager.OperationWithStatus> linkedList = new LinkedList<SelectionManager.OperationWithStatus>();
            for (SimpleGroup simpleGroup : complexGroup.groupList) {
                SelectOperation selectOperation = this.getOperation(simpleGroup);
                if (selectOperation == null) continue;
                SelectionManager.OperationWithStatus operationWithStatus2 = this.getInformation(simpleGroup);
                operationWithStatus2.operation = selectOperation;
                linkedList.add(operationWithStatus2);
            }
            if (linkedList.isEmpty()) continue;
            switch (complexGroup.type) {
                case SoftwareGroup: {
                    this.manager.addGroupOperation("Software", operationWithStatus, linkedList);
                    break;
                }
                case SwAuditGroup: {
                    this.manager.addGroupOperation("SwAudit", operationWithStatus, linkedList);
                    break;
                }
                case HardwareGroup: {
                    this.manager.addGroupOperation("Hardware", operationWithStatus, linkedList);
                    break;
                }
                case HostGroup: {
                    this.manager.addGroupOperation("Host", operationWithStatus, linkedList);
                }
            }
        }
    }

    private void reset() {
        logging.debug(this, "RESET");
        for (ComplexGroup complexGroup : this.complexElements) {
            this.contentPane.remove(complexGroup.topLabel);
            this.contentPane.remove(complexGroup.removeButton);
            this.contentPane.remove(complexGroup.connectionType);
            this.contentPane.remove(complexGroup.negateButton);
            this.contentPane.remove(complexGroup.openParenthesis);
            this.contentPane.remove(complexGroup.closeParenthesis);
            for (SimpleGroup simpleGroup : complexGroup.groupList) {
                this.removeGroup(simpleGroup);
            }
        }
        this.saveNameField.setText("");
        this.saveDescriptionField.setText("");
        this.complexElements.clear();
        this.complexElements.add(this.createHostGroup());
        this.complexElements.add(this.createSoftwareGroup());
        this.buildParentheses();
        this.contentPane.revalidate();
        this.contentPane.repaint();
    }

    private void loadFromManager() {
        for (ComplexGroup complexGroup : this.complexElements) {
            this.contentPane.remove(complexGroup.topLabel);
            this.contentPane.remove(complexGroup.removeButton);
            this.contentPane.remove(complexGroup.connectionType);
            this.contentPane.remove(complexGroup.negateButton);
            this.contentPane.remove(complexGroup.openParenthesis);
            this.contentPane.remove(complexGroup.closeParenthesis);
            for (SimpleGroup object : complexGroup.groupList) {
                this.removeGroup(object);
            }
        }
        this.complexElements.clear();
        List<SelectionManager.OperationWithStatus> list = this.manager.operationsAsList(null);
        logging.debug(this, "load: size: " + list.size());
        for (int i = 0; i < list.size(); ++i) {
            ComplexGroup complexGroup;
            SelectionManager.OperationWithStatus operationWithStatus = (SelectionManager.OperationWithStatus)list.get(i);
            SelectOperation selectOperation = operationWithStatus.operation;
            if (selectOperation == null) {
                this.reset();
                return;
            }
            if (selectOperation instanceof HostOperation) {
                complexGroup = this.createHostGroup();
            } else if (selectOperation instanceof SoftwareOperation) {
                complexGroup = this.createSoftwareGroup();
            } else if (selectOperation instanceof SwAuditOperation) {
                complexGroup = this.createSwAuditGroup();
            } else if (selectOperation instanceof HardwareOperation) {
                complexGroup = this.createHardwareGroup(this.getNonGroupOperation((HardwareOperation)selectOperation).getElement().getLocalizedPathArray()[0]);
            } else {
                logging.error("Not a group operation: " + selectOperation.getClassName());
                this.reset();
                return;
            }
            this.complexElements.add(complexGroup);
            this.setConnectionTypes(complexGroup.connectionType, complexGroup.negateButton, operationWithStatus.status);
            List<SelectionManager.OperationWithStatus> list2 = this.manager.operationsAsList(((SelectGroupOperation)selectOperation).getChildOperations().get(0));
            logging.debug(this, "subload: " + list2.size());
            this.setGroupValues(complexGroup, list2);
        }
        if (!this.complexElements.isEmpty()) {
            this.complexElements.getLast().connectionType.setVisible(false);
        }
        this.buildParentheses();
        this.contentPane.revalidate();
        this.contentPane.repaint();
    }

    private SelectOperation getNonGroupOperation(SelectGroupOperation selectGroupOperation) {
        SelectOperation selectOperation = selectGroupOperation.getChildOperations().get(0);
        while (selectOperation instanceof SelectGroupOperation) {
            selectOperation = ((SelectGroupOperation)selectOperation).getChildOperations().get(0);
        }
        return selectOperation;
    }

    private void setGroupValues(ComplexGroup complexGroup, List<SelectionManager.OperationWithStatus> list) {
        block0: for (int i = 0; i < list.size(); ++i) {
            for (SimpleGroup simpleGroup : complexGroup.groupList) {
                SelectionManager.OperationWithStatus operationWithStatus = list.get(i);
                SelectOperation selectOperation = operationWithStatus.operation;
                if (!selectOperation.getElement().getPath().equals(simpleGroup.element.getPath())) continue;
                if (selectOperation.getElement().supportedOperations().size() > 1) {
                    ((JComboBox)simpleGroup.operationComponent).setSelectedItem(selectOperation.getOperationString());
                }
                this.setComponentData(simpleGroup.dataComponent, selectOperation.getSelectData());
                this.setConnectionTypes(simpleGroup.connectionType, simpleGroup.negateButton, operationWithStatus.status);
                logging.debug(this, "simple, open, closed: " + simpleGroup.element.getClassName() + operationWithStatus.parenthesisOpen + operationWithStatus.parenthesisClose);
                continue block0;
            }
        }
    }

    private void setComponentData(JComponent jComponent, SelectData selectData) {
        if (selectData == null || selectData.getData() == null) {
            return;
        }
        if (jComponent instanceof TextInputField) {
            ((TextInputField)jComponent).setText(selectData.getData().toString());
        } else if (jComponent instanceof SpinnerWithExt && selectData.getType() == SelectData.DataType.BigIntegerType) {
            ((SpinnerWithExt)jComponent).setValue((Long)selectData.getData());
        } else if (jComponent instanceof JSpinner && selectData.getType() == SelectData.DataType.IntegerType) {
            ((JSpinner)jComponent).setValue((Integer)selectData.getData());
        }
    }

    private void setConnectionTypes(AndOrSelectButtonByIcon andOrSelectButtonByIcon, IconAsButton iconAsButton, SelectionManager.ConnectionStatus connectionStatus) {
        switch (connectionStatus) {
            case And: {
                andOrSelectButtonByIcon.selectAnd();
                break;
            }
            case Or: {
                andOrSelectButtonByIcon.selectOr();
                break;
            }
            case AndNot: {
                andOrSelectButtonByIcon.selectAnd();
                iconAsButton.setActivated(true);
                break;
            }
            case OrNot: {
                andOrSelectButtonByIcon.selectOr();
                iconAsButton.setActivated(true);
            }
        }
    }

    private void resetGroup(SimpleGroup simpleGroup) {
        if (simpleGroup.dataComponent instanceof TextInputField) {
            ((TextInputField)simpleGroup.dataComponent).setText("");
        } else if (simpleGroup.dataComponent instanceof JComboBox) {
            ((JComboBox)simpleGroup.dataComponent).setSelectedItem("");
        } else if (simpleGroup.dataComponent instanceof JSpinner) {
            ((JSpinner)simpleGroup.dataComponent).setValue(0);
        } else if (simpleGroup.dataComponent instanceof SpinnerWithExt) {
            ((SpinnerWithExt)simpleGroup.dataComponent).setValue(0L);
        } else {
            logging.warning(this, "Unknown data component: " + simpleGroup.dataComponent);
        }
    }

    private class SavedBoxListener
    implements ActionListener {
        private SavedBoxListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
        }
    }

    private class SaveButtonListener
    implements ActionListener {
        private SaveButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            String string = ClientSelectionDialog.this.saveNameField.getText();
            if (string.isEmpty()) {
                JOptionPane.showMessageDialog(ClientSelectionDialog.this.saveButton, configed.getResourceValue("ClientSelectionDialog.emptyName"), configed.getResourceValue("ClientSelectionDialog.emptyNameTitle") + " (" + "opsi config editor" + ")", 0);
                ClientSelectionDialog.this.toFront();
                return;
            }
            if (!string.matches("[\\p{javaLowerCase}\\d_-]*")) {
                JOptionPane.showMessageDialog(ClientSelectionDialog.this.saveButton, "wrong name", "error", 0);
                ClientSelectionDialog.this.toFront();
                return;
            }
            ClientSelectionDialog.this.collectData();
            ClientSelectionDialog.this.manager.saveSearch(string, ClientSelectionDialog.this.saveDescriptionField.getText());
            ClientSelectionDialog.this.savedSearchesDialog.reloadAction();
        }
    }

    private class SpinnerWithExt
    extends JPanel {
        private JSpinner spinner = new JSpinner(new SpinnerNumberModel(new Long(0L), Long.valueOf(Long.MIN_VALUE), Long.valueOf(Long.MAX_VALUE), new Long(1L)));
        private JComboBox box;

        public SpinnerWithExt() {
            this.spinner.setMinimumSize(new Dimension(0, 0));
            this.box = new JComboBox<String>(new String[]{"", "k", "M", "G", "T"});
            this.box.setMinimumSize(new Dimension(50, 0));
            GroupLayout groupLayout = new GroupLayout(this);
            groupLayout.setVerticalGroup(groupLayout.createParallelGroup().addComponent(this.spinner).addComponent(this.box));
            groupLayout.setHorizontalGroup(groupLayout.createSequentialGroup().addComponent(this.spinner).addComponent(this.box));
            this.setLayout(groupLayout);
            this.add(this.spinner);
            this.add(this.box);
        }

        public long getValue() {
            long l = (Long)this.spinner.getValue();
            for (int i = 0; i < this.box.getSelectedIndex(); ++i) {
                l *= 1024L;
            }
            return l;
        }

        public void setValue(long l) {
            this.spinner.setValue(l);
            this.box.setSelectedIndex(0);
        }

        public void addChangeListener(ChangeListener changeListener) {
            this.spinner.addChangeListener(changeListener);
        }
    }

    private class AndOrButtonListener
    implements ActionListener {
        private AndOrButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ClientSelectionDialog.this.buildParentheses();
        }
    }

    private class ParenthesisListener
    implements ActionListener {
        private ParenthesisListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            IconAsButton iconAsButton;
            if (!(actionEvent.getSource() instanceof IconAsButton)) {
                return;
            }
            iconAsButton.setActivated(!(iconAsButton = (IconAsButton)actionEvent.getSource()).isActivated());
        }
    }

    private class NotButtonListener
    implements ActionListener {
        private NotButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            IconAsButton iconAsButton;
            if (!(actionEvent.getSource() instanceof IconAsButton)) {
                return;
            }
            iconAsButton.setActivated(!(iconAsButton = (IconAsButton)actionEvent.getSource()).isActivated());
            logging.debug(this, "Negate button is activated: " + iconAsButton.isActivated());
        }
    }

    private class SelectOperationListener
    implements ActionListener {
        private SelectOperationListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JComponent jComponent = null;
            SimpleGroup simpleGroup = null;
            for (ComplexGroup complexGroup : ClientSelectionDialog.this.complexElements) {
                for (SimpleGroup simpleGroup2 : complexGroup.groupList) {
                    if (simpleGroup2.operationComponent != actionEvent.getSource()) continue;
                    jComponent = simpleGroup2.operationComponent;
                    simpleGroup = simpleGroup2;
                    break;
                }
                if (jComponent == null) continue;
                break;
            }
            if (jComponent == null) {
                return;
            }
            if (simpleGroup.dataComponent != null) {
                ClientSelectionDialog.this.contentPane.remove(simpleGroup.dataComponent);
                simpleGroup.dataComponent = null;
            }
            int n = 0;
            if (jComponent instanceof JComboBox) {
                n = ((JComboBox)jComponent).getSelectedIndex();
            } else if (jComponent instanceof JLabel) {
                n = 0;
            }
            ClientSelectionDialog.this.addDataComponent(simpleGroup, n);
            ClientSelectionDialog.this.buildParentheses();
            ClientSelectionDialog.this.contentPane.revalidate();
            ClientSelectionDialog.this.contentPane.repaint();
        }
    }

    private class LoadSearchListener
    implements ActionListener {
        private LoadSearchListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (ClientSelectionDialog.this.loadSearchBox.getSelectedIndex() == 0) {
                return;
            }
            ClientSelectionDialog.this.loadSearch(ClientSelectionDialog.this.loadSearchBox.getSelectedItem().toString());
            ClientSelectionDialog.this.loadSearchBox.setSelectedIndex(0);
        }
    }

    private class AddElementListener
    implements ActionListener {
        private AddElementListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            int n;
            if (ClientSelectionDialog.this.complexElements.size() != 0) {
                ((ComplexGroup)((ClientSelectionDialog)ClientSelectionDialog.this).complexElements.getLast()).connectionType.setVisible(true);
            }
            if ((n = ClientSelectionDialog.this.newElementBox.getSelectedIndex()) == 0) {
                return;
            }
            if (n == 1) {
                ClientSelectionDialog.this.complexElements.add(ClientSelectionDialog.this.createHostGroup());
            } else if (n == 2) {
                ClientSelectionDialog.this.complexElements.add(ClientSelectionDialog.this.createSoftwareGroup());
            } else if (n == 3) {
                ClientSelectionDialog.this.complexElements.add(ClientSelectionDialog.this.createSwAuditGroup());
            } else {
                ClientSelectionDialog.this.complexElements.add(ClientSelectionDialog.this.createHardwareGroup(ClientSelectionDialog.this.newElementBox.getSelectedItem().toString()));
            }
            ClientSelectionDialog.this.contentPane.revalidate();
            ClientSelectionDialog.this.contentPane.repaint();
            ClientSelectionDialog.this.newElementBox.setSelectedIndex(0);
            ((ComplexGroup)((ClientSelectionDialog)ClientSelectionDialog.this).complexElements.getLast()).connectionType.setVisible(false);
        }
    }

    private class RemoveButtonListener
    implements ActionListener {
        private RemoveButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Iterator iterator = ClientSelectionDialog.this.complexElements.iterator();
            while (iterator.hasNext()) {
                ComplexGroup complexGroup = (ComplexGroup)iterator.next();
                if (complexGroup.removeButton != actionEvent.getSource()) continue;
                ClientSelectionDialog.this.contentPane.remove(complexGroup.topLabel);
                ClientSelectionDialog.this.contentPane.remove(complexGroup.removeButton);
                ClientSelectionDialog.this.contentPane.remove(complexGroup.connectionType);
                ClientSelectionDialog.this.contentPane.remove(complexGroup.negateButton);
                ClientSelectionDialog.this.contentPane.remove(complexGroup.openParenthesis);
                ClientSelectionDialog.this.contentPane.remove(complexGroup.closeParenthesis);
                for (SimpleGroup simpleGroup : complexGroup.groupList) {
                    ClientSelectionDialog.this.removeGroup(simpleGroup);
                }
                ClientSelectionDialog.this.contentPane.revalidate();
                ClientSelectionDialog.this.contentPane.repaint();
                iterator.remove();
                ClientSelectionDialog.this.buildParentheses();
                break;
            }
            if (ClientSelectionDialog.this.complexElements.size() != 0) {
                ((ComplexGroup)((ClientSelectionDialog)ClientSelectionDialog.this).complexElements.getLast()).connectionType.setVisible(false);
            }
        }
    }

    private class ComplexGroup {
        public GroupType type;
        public IconAsButton removeButton;
        public IconAsButton negateButton;
        public JLabel topLabel = null;
        public AndOrSelectButtonByIcon connectionType;
        public LinkedList<SimpleGroup> groupList;
        public IconAsButton openParenthesis;
        public IconAsButton closeParenthesis;

        private ComplexGroup() {
        }

        public String toString() {
            return "ComplexGroup type " + (Object)((Object)this.type);
        }
    }

    private static enum GroupType {
        HostGroup,
        SoftwareGroup,
        SwAuditGroup,
        HardwareGroup;

    }

    private class SimpleGroup {
        public SelectElement element;
        public IconAsButton removeButton = null;
        public IconAsButton negateButton;
        public AndOrSelectButtonByIcon connectionType;
        public JLabel elementLabel;
        public JComponent operationComponent;
        public JComponent dataComponent;
        public GroupLayout.ParallelGroup vRow;
        public IconAsButton openParenthesis;
        public IconAsButton closeParenthesis;

        private SimpleGroup() {
        }
    }
}

