Name: nodebrain
Version: 0.10.0
Release: 1%{?dist}
Summary: A rule engine for state and event monitoring
License: MIT

# Group will be dropped when no distribution complains
%if 0%{?rhel} || 0%{?centos} 
Group: Development/Languages
%else
# Drop group for fedora now, keep for others
%if 0%{?fedora} == 0
Group: Development/Languages/Other
%endif
%endif

Source: http://downloads.sourceforge.net/nodebrain/nodebrain-0.10.0.tar.gz
URL: http://nodebrain.org/
BuildRoot: %{_tmppath}/%{name}-%{version}-%{release}-root-%(%{__id_u} -n)

%if 0%{?rhel} || 0%{?centos} < 6
BuildRequires: pcre-devel openssl-devel gettext pkgconfig
%else
BuildRequires: pkgconfig(libedit) pkgconfig(libpcre) pkgconfig(openssl) gettext pkgconfig
%endif
Requires(post): /sbin/install-info
Requires(preun): /sbin/install-info

%prep
%setup -q 

%build
%configure 
make %{?_smp_mflags}

%check
make check

%install
make DESTDIR=%{buildroot} \
    docdir=%{buildroot}%{_docdir}/%{name} \
    pkgconfigdir=%{_libdir}/pkgconfig \
    install
find %{buildroot}/%{_libdir}/nb-0 -type f -name "*.la" -exec rm -f {} ';'
rm -f %{buildroot}/%{_infodir}/dir

%post
ldconfig
if [ -f %{_infodir}/nodebrain.info.gz ]; then # for --excludedocs
   /sbin/install-info %{_infodir}/nodebrain.info.gz %{_infodir}/dir ||:
fi

%preun
if [ $1 = 0 ]; then
    if [ -f %{_infodir}/nodebrain.info.gz ]; then # for --excludedocs
        /sbin/install-info --delete %{_infodir}/nodebrain.info.gz %{_infodir}/dir ||:
    fi
fi

%postun -p /sbin/ldconfig

%clean
rm -rf $RPM_BUILD_ROOT

%description
NodeBrain is a rule engine for construction of state and event monitoring
applications. It interacts with other monitoring components to perform
simple element state monitoring or complex event correlation based on user
specified rules. It is extended through the development of plug-in modules
using the C API, and servant programs that may be written in any language
to interact with the rule engine via standard input, output, and error. The
The package includes a small set of plug-in modules to provide capabilities
typically required for monitoring applications.

%files
%if 0%{?suse_version} && 0%{?suse_version} < 1200
%defattr(-,root,root,-)
%endif
%if 0%{?fedora} >= 19 || 0%{?rhel} >= 7 || 0%{?centos} >= 7
%license COPYING
%doc AUTHORS ChangeLog NEWS README THANKS
%else
%doc AUTHORS ChangeLog COPYING NEWS README THANKS
%endif
%dir %{_libdir}/nb-0
%{_bindir}/nb
%{_bindir}/nbkit
%{_libdir}/*.so.*
%{_libdir}/nb-0/*.so
%exclude %{_libdir}/*.so
%exclude %{_libdir}/*.a
%exclude %{_libdir}/*.la
%exclude %{_libdir}/nb-0/*.a
%{_mandir}/man1/*.1*
%{_mandir}/man3/*.3*
%{_mandir}/man5/*.5*
%{_mandir}/man7/*.7*
%{_infodir}/*.info*

#-- nodebrain-devel rpm --------------------------------------------------

%package devel
%if 0%{?rhel} || 0%{?centos} 
Group:          Development/Libraries
%else
%if 0%{?fedora} == 0
Group:          Development/Libraries/Other
%endif
%endif
Summary:        Development package for nodebrain
Requires:       pkgconfig
Requires:       nodebrain = %{version}-%{release}
Requires:       pcre-devel
Requires:       libopenssl-devel
Requires:       glibc-devel

%description devel
This package contains development files for nodebrain.

%files devel
%if 0%{?suse_version} && 0%{?suse_version} < 1200
%defattr(-,root,root,-)
%endif
%if 0%{?fedora} >= 19 || 0%{?rhel} >= 7  || 0%{?centos} >= 7
%license COPYING
%doc API
%else
%doc API COPYING
%endif
%dir %{_includedir}/nb
%{_includedir}/nb/*
%{_libdir}/*.la
%{_libdir}/*.so
%exclude %{_libdir}/*.so.*
%exclude %{_libdir}/nb-0
%{_libdir}/pkgconfig/*.pc


#-- nodebrain-static rpm --------------------------------------------------

%package static
%if 0%{?rhel} || 0%{?centos} 
Group:          Development/Libraries
%else
%if 0%{?fedora} == 0
Group:          Development/Libraries/Other
%endif
%endif
Summary:        Static libraries for nodebrain
Requires:       nodebrain-devel = %{version}-%{release}

%description static
This package contains static libraries for nodebrain.

%files static
%if 0%{?suse_version} && 0%{?suse_version} < 1200
%defattr(-,root,root,-)
%endif
%if 0%{?fedora} >= 19 || 0%{?rhel} >= 7  || 0%{?centos} >= 7
%license COPYING
%doc API
%else
%doc API COPYING
%endif
%{_libdir}/*.a
%exclude %{_libdir}/*.la
%exclude %{_libdir}/nb-0


#-------------------------------------------------------------------------

%changelog
* Thu Sep 24 2015 Ed Trettevik <eat@nodebrain.org> - 0.9.04-1
- release reset

* Sun Dec 21 2014 Ed Trettevik <eat@nodebrain.org> - 0.9.03-3
- included patch for newer version gcc compiler warnings
- also patched nb.pc.in to reference libedit instead of edit

* Wed Dec 17 2014 Ed Trettevik <eat@nodebrain.org> - 0.9.03-2
- Moved COPYING from doc to license for ready targets
- Included COPYING in devel and static packages
- Dropped Group tag on fedora
- Dropped defattr except on suse < 12

* Sat Dec 13 2014 Ed Trettevik <eat@nodebrain.org> - 0.9.03-1
- Changed description and summary
- Changed library versioning to the libtool scheme
- Dropped mandriva conditionals
- Eliminating the versioned bindir/nb-0.9.03 and bindir/nb symbolic
- Removed minor and patch version number from module path libdir/nb-x

* Wed Jul 9 2014 Ed Trettevik <eat@nodebrain.org> - 0.9.02-1
- Update for 0.9.02

* Tue Jul 8 2014 Ed Trettevik <eat@nodebrain.org> - 0.8.17-1
- License change and switch from readline to libedit

* Mon Feb 17 2014 Ed Trettevik <eat@nodebrain.org> - 0.8.16-1
- Configuration options

* Sat Apr 27 2013 Ed Trettevik <eat@nodebrain.org> - 0.8.15-2
- Changed to please rpmlint

* Sun Mar 10 2013 Ed Trettevik <eat@nodebrain.org> - 0.8.15-1
- Switch location of modules to {_libdir}/nb-{version}

* Sun Jan 20 2013 Ed Trettevik <eat@nodebrain.org> - 0.8.13-1
- Updated for 0.8.13

* Fri Feb 26 2010 John Ellson <ellson@research.att.com> - 0.8.3-1
- First rpm packaging.
