#
# File:   modules.nb-
#
# Title:  Module Declaration Test Script   
#
# Test:
#
#   1) Verify that a module can be declared using an aliase
#      for both module and skill names. 
# 
#   2) Invoke the skill methods to make sure the linkage
#      is working.
#
# Note:
#
#   We are using the tree skill module because it is simple.
#   Specific tests are devoted to other modules.  Here we
#   are just testing to make sure modules can be loaded and
#   linked to a node.
#============================================================
# History:
#
# Date        Change
# ----------  -----------------------------------------------
# 2007/07/23  Ed Trettevik - introduced in 0.6.8
#============================================================

# Declare a tree skill in a variety of ways

declare tree module {"."};
declare treeSkill skill tree;
declare treeAlias module {"."}tree;
declare treeAliasSkill skill treeAlias.tree;
 
# Declare tables using one of each declaration

define tab1 node tree;
define tab2 node treeSkill;
define tab3 node treeAlias.tree;
define tab4 node treeAliasSkill;

# Test assertion method linkage

tab1. assert (1),(2),(3,4),("something");
tab2. assert (1),(2),(3,4),("something");
tab3. assert (1),(2),(3,4),("something");
tab4. assert (1),(2),(3,4),("something");

# Test command method linkage

tab1:flatten
tab2:flatten
tab3:flatten
tab4:flatten

# Define some rules to test evaluation

define r1 on(a and tab1(b));
define r2 on(a and tab2(b));
define r3 on(a and tab3(b));
define r4 on(a and tab4(b));

# Test evaluate method linkage

assert a,b;
