/*
* Copyright (C) 2014 Ed Trettevik <eat@nodebrain.org>
*
* NodeBrain is free software; you can modify and/or redistribute it under the
* terms of either the MIT License (Expat) or the following NodeBrain License.
*
* Permission to use and redistribute with or without fee, in source and binary
* forms, with or without modification, is granted free of charge to any person
* obtaining a copy of this software and included documentation, provided that
* the above copyright notice, this permission notice, and the following
* disclaimer are retained with source files and reproduced in documention
* included with source and binary distributions. 
*
* Unless required by applicable law or agreed to in writing, this software is
* distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
* KIND, either express or implied.
*
*=============================================================================
* Program:  NodeBrain
*
* File:     nbtrack.h 
* 
* Title:    Simulation Track Header
*
* Function:
*
*   This header defines routines that manage NB_Track objects.  An NB_Track
*   object is an extension of NB_Object.  
*
* See nbtrack.c for more information.
*=============================================================================
* Change History:
*
*    Date    Name/Change
* ---------- -----------------------------------------------------------------
* 2014-12-16 Ed Trettevik - introduced in 0.9.04
*=============================================================================
*/
#ifndef _NB_TRACK_H_
#define _NB_TRACK_H_

#if defined(NB_INTERNAL)

#include <nb/nbstem.h>

void nbTrackInit(NB_Stem *stem);


#endif // NB_INTERNAL

//******************************************************
// External API

#if defined(WIN32)
__declspec(dllexport)
#endif
extern int nbTrackPlay(nbCELL context,char *filename);

#endif
