/*
 * Decompiled with CFR 0.152.
 */
package abbot.tester;

import abbot.i18n.Strings;
import abbot.tester.ActionFailedException;
import abbot.tester.ContainerTester;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Window;
import javax.accessibility.AccessibleContext;

public class WindowTester
extends ContainerTester {
    public String deriveTag(Component comp) {
        if (this.isCustom(comp.getClass())) {
            return null;
        }
        String tag = null;
        AccessibleContext context = ((Window)comp).getAccessibleContext();
        tag = this.deriveAccessibleTag(context);
        if (tag == null || "".equals(tag)) {
            Dimension size = comp.getSize();
            tag = String.valueOf(size.width) + "x" + String.valueOf(size.height);
        }
        return tag;
    }

    public void actionClose(Component c) {
        this.close((Window)c);
        this.waitForIdle();
    }

    public void actionMove(Component w, int screenx, int screeny) {
        if (!this.userMovable(w)) {
            throw new ActionFailedException(Strings.get("tester.Window.no_move"));
        }
        this.move((Window)w, screenx, screeny);
        this.waitForIdle();
    }

    public void actionMoveBy(Component w, int dx, int dy) {
        if (!this.userMovable(w)) {
            throw new ActionFailedException(Strings.get("tester.Window.no_move"));
        }
        this.moveBy((Window)w, dx, dy);
        this.waitForIdle();
    }

    public void actionResize(Component w, int width, int height) {
        if (!this.userResizable(w)) {
            throw new ActionFailedException(Strings.get("tester.Window.no_resize"));
        }
        this.resize((Window)w, width, height);
        this.waitForIdle();
    }

    public void actionResizeBy(Component w, int dx, int dy) {
        if (!this.userResizable(w)) {
            throw new ActionFailedException(Strings.get("tester.Window.no_resize"));
        }
        this.resizeBy((Window)w, dx, dy);
        this.waitForIdle();
    }

    public void actionActivate(Window w) {
        this.activate(w);
        this.waitForIdle();
    }
}

