/*
 * Decompiled with CFR 0.152.
 */
package abbot.tester;

import abbot.Log;
import abbot.i18n.Strings;
import abbot.script.parsers.TreePathParser;
import abbot.tester.ComponentLocation;
import abbot.tester.JTreeTester;
import abbot.tester.LocationUnavailableException;
import abbot.util.ExtendedComparator;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Arrays;
import javax.swing.JTree;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class JTreeLocation
extends ComponentLocation {
    private int row = -1;
    private TreePath treePath;
    private boolean inExpansion;

    public JTreeLocation() {
    }

    public JTreeLocation(int row) {
        this(row, false);
    }

    public JTreeLocation(int row, boolean inExpansion) {
        if (row < 0) {
            String msg = Strings.get("tester.JTree.row_not_visible", new Object[]{new Integer(row)});
            throw new LocationUnavailableException(msg);
        }
        this.row = row;
        this.inExpansion = inExpansion;
    }

    public JTreeLocation(TreePath treePath) {
        this(treePath, false);
    }

    public JTreeLocation(TreePath treePath, boolean inExpansion) {
        this.treePath = treePath;
        this.inExpansion = inExpansion;
    }

    public JTreeLocation(Point p) {
        super(p);
    }

    public void setInExpansion(boolean in) {
        this.inExpansion = in;
    }

    public boolean isInExpansion() {
        return this.inExpansion;
    }

    protected Point rowToPoint(JTree tree, int row) {
        TreePath path = tree.getPathForRow(row);
        if (path == null) {
            String msg = Strings.get("tester.JTree.row_not_visible", new Object[]{new Integer(row)});
            throw new LocationUnavailableException(msg);
        }
        return this.pathToPoint(tree, path);
    }

    protected Point pathToPoint(JTree tree, TreePath path) {
        Rectangle rect = tree.getPathBounds(path = JTreeLocation.findMatchingPath(tree, path));
        if (rect == null) {
            String msg = Strings.get("tester.JTree.path_not_visible", new Object[]{path});
            throw new LocationUnavailableException(msg);
        }
        if (this.inExpansion) {
            return new Point(rect.x - rect.height / 2, rect.y + rect.height / 2);
        }
        return new Point(rect.x + rect.width / 2, rect.y + rect.height / 2);
    }

    TreePath getPath(JTree tree) {
        if (this.treePath != null) {
            try {
                return JTreeLocation.findMatchingPath(tree, this.treePath);
            }
            catch (LocationUnavailableException e) {
                return this.treePath;
            }
        }
        if (this.row != -1) {
            return tree.getPathForRow(this.row);
        }
        Point where = super.getPoint(tree);
        return tree.getPathForLocation(where.x, where.y);
    }

    int getRow(JTree tree) {
        if (this.treePath != null) {
            return tree.getRowForPath(this.getPath(tree));
        }
        if (this.row != -1) {
            return this.row;
        }
        Point where = super.getPoint(tree);
        return tree.getRowForLocation(where.x, where.y);
    }

    public Point getPoint(Component c) {
        JTree tree = (JTree)c;
        if (this.treePath != null) {
            return this.pathToPoint(tree, this.treePath);
        }
        if (this.row != -1) {
            return this.rowToPoint(tree, this.row);
        }
        return super.getPoint(c);
    }

    public Rectangle getBounds(Component c) {
        JTree tree = (JTree)c;
        int row = this.getRow(tree);
        if (row == -1) {
            Point where = this.getPoint(c);
            return new Rectangle(where.x, where.y, 1, 1);
        }
        Rectangle rect = tree.getRowBounds(row);
        if (rect == null) {
            String msg = Strings.get("tester.JTree.row_not_visible", new Object[]{new Integer(row)});
            throw new LocationUnavailableException(msg);
        }
        if (this.inExpansion) {
            rect.x -= rect.height;
            rect.width = rect.height;
        }
        return rect;
    }

    public boolean equals(Object o) {
        if (o instanceof JTreeLocation) {
            JTreeLocation loc = (JTreeLocation)o;
            if (loc.inExpansion != this.inExpansion) {
                return false;
            }
            if (this.treePath != null) {
                if (this.treePath.getPathCount() != loc.treePath.getPathCount()) {
                    return false;
                }
                for (int i = 0; i < this.treePath.getPathCount(); ++i) {
                    if (!(this.treePath.getPathComponent(i) == null ? loc.treePath.getPathComponent(i) != null : !this.treePath.getPathComponent(i).equals(loc.treePath.getPathComponent(i)))) continue;
                    return false;
                }
                return true;
            }
            if (this.row != -1) {
                return this.row == loc.row;
            }
        }
        return super.equals(o);
    }

    public String toString() {
        String s;
        String string = s = this.inExpansion ? "+" : "";
        if (this.treePath != null) {
            return s + this.encodeValue(this.treePath.toString());
        }
        if (this.row != -1) {
            return s + this.encodeIndex(this.row);
        }
        return super.toString();
    }

    public ComponentLocation parse(String encoded) {
        if ((encoded = encoded.trim()).startsWith("+")) {
            this.inExpansion = true;
            encoded = encoded.substring(1);
        }
        if (this.isValue(encoded)) {
            String path = this.parseValue(encoded);
            this.treePath = (TreePath)new TreePathParser().parse(path);
            return this;
        }
        if (this.isIndex(encoded)) {
            this.row = this.parseIndex(encoded);
            return this;
        }
        return super.parse(encoded);
    }

    protected String badFormat(String encoded) {
        return Strings.get("location.tree.bad_format", new Object[]{encoded});
    }

    private static boolean matchesLastComponent(JTree tree, Object pattern, TreePath path) {
        String patternString;
        if (pattern == null) {
            return true;
        }
        if (pattern.equals(path.getLastPathComponent())) {
            return true;
        }
        String objString = JTreeTester.valueToString(tree, path);
        if (pattern instanceof String) {
            patternString = (String)pattern;
        } else if (path.getParentPath() != null) {
            TreePath parent = path.getParentPath();
            patternString = JTreeTester.valueToString(tree, parent.pathByAddingChild(pattern));
        } else {
            patternString = pattern.toString();
        }
        return ExtendedComparator.stringsMatch(patternString, objString);
    }

    public static TreePath findMatchingPath(JTree tree, TreePath path) {
        TreePath realPath;
        Log.debug("Find path matching " + path);
        Object[] input = path.getPath();
        TreeModel model = tree.getModel();
        Object root = model.getRoot();
        if (!tree.isRootVisible() && !JTreeLocation.matchesLastComponent(tree, input[0], new TreePath(root))) {
            Object[] tmp = new Object[input.length + 1];
            System.arraycopy(input, 0, tmp, 1, input.length);
            tmp[0] = null;
            input = tmp;
        }
        if ((realPath = JTreeLocation.findMatchingPath(tree, new TreePath(root), input)) != null) {
            return realPath;
        }
        String msg = Strings.get("tester.JTree.path_not_found", new Object[]{path});
        throw new LocationUnavailableException(msg);
    }

    private static TreePath findMatchingPath(JTree tree, TreePath realPath, Object[] input) {
        Log.debug("Comparing " + realPath + " with " + input[0] + " from " + Arrays.asList(input));
        TreeModel model = tree.getModel();
        if (!JTreeLocation.matchesLastComponent(tree, input[0], realPath)) {
            Log.debug("no root match");
        } else {
            Log.debug("node matched: " + realPath.getLastPathComponent());
            if (input.length == 1) {
                return realPath;
            }
            Object[] subs = new Object[input.length - 1];
            System.arraycopy(input, 1, subs, 0, subs.length);
            Object obj = realPath.getLastPathComponent();
            int count = model.getChildCount(obj);
            Log.debug("Obj " + obj + " (" + obj.getClass() + ") has " + count);
            for (int i = 0; i < count; ++i) {
                Object child = model.getChild(obj, i);
                Log.debug("checking child " + i + " (" + child + ")");
                TreePath newPath = JTreeLocation.findMatchingPath(tree, realPath.pathByAddingChild(child), subs);
                if (newPath == null) continue;
                return newPath;
            }
            Log.debug("No child path matched");
        }
        return null;
    }
}

