/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grid.drmaa;

import com.sun.grid.drmaa.SessionImpl;
import java.text.ParseException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.ggf.drmaa.DrmaaException;
import org.ggf.drmaa.FileTransferMode;
import org.ggf.drmaa.InternalException;
import org.ggf.drmaa.InvalidAttributeValueException;
import org.ggf.drmaa.JobTemplate;
import org.ggf.drmaa.PartialTimestamp;
import org.ggf.drmaa.PartialTimestampFormat;

public class JobTemplateImpl
extends JobTemplate {
    private static final String REMOTE_COMMAND = "drmaa_remote_command";
    private static final String INPUT_PARAMETERS = "drmaa_v_argv";
    private static final String JOB_SUBMISSION_STATE = "drmaa_js_state";
    private static final String JOB_ENVIRONMENT = "drmaa_v_env";
    private static final String WORKING_DIRECTORY = "drmaa_wd";
    private static final String JOB_CATEGORY = "drmaa_job_category";
    private static final String NATIVE_SPECIFICATION = "drmaa_native_specification";
    private static final String EMAIL_ADDRESS = "drmaa_v_email";
    private static final String BLOCK_EMAIL = "drmaa_block_email";
    private static final String START_TIME = "drmaa_start_time";
    private static final String JOB_NAME = "drmaa_job_name";
    private static final String INPUT_PATH = "drmaa_input_path";
    private static final String OUTPUT_PATH = "drmaa_output_path";
    private static final String ERROR_PATH = "drmaa_error_path";
    private static final String JOIN_FILES = "drmaa_join_files";
    private static final String TRANSFER_FILES = "drmaa_transfer_files";
    private static final String HOLD_STRING = "drmaa_hold";
    private static final String ACTIVE_STRING = "drmaa_active";
    private static final String BLOCK_EMAIL_TRUE_STRING = "1";
    private static final String BLOCK_EMAIL_FALSE_STRING = "0";
    private static final String JOIN_FILES_TRUE_STRING = "y";
    private static final String JOIN_FILES_FALSE_STRING = "n";
    private static PartialTimestampFormat ptf = new PartialTimestampFormat();
    private SessionImpl session = null;
    private int id = -1;

    JobTemplateImpl(SessionImpl session, int id) {
        this.session = session;
        this.id = id;
    }

    int getId() {
        return this.id;
    }

    public void setRemoteCommand(String remoteCommand) throws DrmaaException {
        this.setAttribute(REMOTE_COMMAND, remoteCommand);
    }

    public String getRemoteCommand() {
        String[] command = this.getAttribute(REMOTE_COMMAND);
        if (command != null) {
            return command[0];
        }
        return null;
    }

    public void setArgs(String[] args) throws DrmaaException {
        this.setAttribute(INPUT_PARAMETERS, Arrays.asList(args));
    }

    public String[] getArgs() {
        String[] result = this.getAttribute(INPUT_PARAMETERS);
        return result;
    }

    public void setJobSubmissionState(int state) throws DrmaaException {
        String stateString = null;
        if (state == 0) {
            stateString = HOLD_STRING;
        } else if (state == 1) {
            stateString = ACTIVE_STRING;
        } else {
            throw new InvalidAttributeValueException("jobSubmissionState attribute is invalid");
        }
        this.setAttribute(JOB_SUBMISSION_STATE, stateString);
    }

    public int getJobSubmissionState() {
        String[] stateString;
        block5: {
            block4: {
                stateString = this.getAttribute(JOB_SUBMISSION_STATE);
                if (stateString == null) break block4;
                if (!stateString[0].equals(ACTIVE_STRING)) break block5;
            }
            return 1;
        }
        if (stateString[0].equals(HOLD_STRING)) {
            return 0;
        }
        throw new InternalException("jobSubmissionState property is unparsable");
    }

    public void setJobEnvironment(Properties env) throws DrmaaException {
        String[] envStrings = new String[env.size()];
        Iterator<Object> i = env.keySet().iterator();
        int count = 0;
        String key = null;
        StringBuffer nameValue = null;
        while (i.hasNext()) {
            key = (String)i.next();
            nameValue = new StringBuffer(key);
            nameValue.append('=');
            nameValue.append(env.getProperty(key));
            envStrings[count] = nameValue.toString();
            ++count;
        }
        this.setAttribute(JOB_ENVIRONMENT, Arrays.asList(envStrings));
    }

    public Properties getJobEnvironment() {
        String[] props = this.getAttribute(JOB_ENVIRONMENT);
        Properties env = null;
        if (props != null) {
            env = new Properties();
            for (int count = 0; count < props.length; ++count) {
                int index = props[count].indexOf(61);
                String name = props[count].substring(0, index);
                String value = props[count].substring(index + 1);
                env.setProperty(name, value);
            }
        }
        return env;
    }

    public void setWorkingDirectory(String wd) throws DrmaaException {
        this.setAttribute(WORKING_DIRECTORY, wd);
    }

    public String getWorkingDirectory() {
        String[] wd = this.getAttribute(WORKING_DIRECTORY);
        if (wd != null) {
            return wd[0];
        }
        return null;
    }

    public void setJobCategory(String category) throws DrmaaException {
        this.setAttribute(JOB_CATEGORY, category);
    }

    public String getJobCategory() {
        String[] category = this.getAttribute(JOB_CATEGORY);
        if (category != null) {
            return category[0];
        }
        return null;
    }

    public void setNativeSpecification(String spec) throws DrmaaException {
        this.setAttribute(NATIVE_SPECIFICATION, spec);
    }

    public String getNativeSpecification() {
        String[] spec = this.getAttribute(NATIVE_SPECIFICATION);
        if (spec != null) {
            return spec[0];
        }
        return null;
    }

    public void setEmail(String[] email) throws DrmaaException {
        this.setAttribute(EMAIL_ADDRESS, Arrays.asList(email));
    }

    public String[] getEmail() {
        String[] emails = this.getAttribute(EMAIL_ADDRESS);
        return emails;
    }

    public void setBlockEmail(boolean blockEmail) throws DrmaaException {
        if (blockEmail) {
            this.setAttribute(BLOCK_EMAIL, BLOCK_EMAIL_TRUE_STRING);
        } else {
            this.setAttribute(BLOCK_EMAIL, BLOCK_EMAIL_FALSE_STRING);
        }
    }

    public boolean getBlockEmail() {
        String[] block = this.getAttribute(BLOCK_EMAIL);
        if (block != null) {
            return block[0].equals(BLOCK_EMAIL_TRUE_STRING);
        }
        return false;
    }

    public void setStartTime(PartialTimestamp startTime) throws DrmaaException {
        this.setAttribute(START_TIME, ptf.format(startTime));
    }

    public PartialTimestamp getStartTime() {
        String[] time = this.getAttribute(START_TIME);
        if (time != null) {
            try {
                return ptf.parse(time[0]);
            }
            catch (ParseException e) {
                throw new InternalException("startTime property is unparsable");
            }
        }
        return null;
    }

    public void setJobName(String name) throws DrmaaException {
        this.setAttribute(JOB_NAME, name);
    }

    public String getJobName() {
        String[] name = this.getAttribute(JOB_NAME);
        if (name != null) {
            return name[0];
        }
        return null;
    }

    public void setInputPath(String inputPath) throws DrmaaException {
        this.setAttribute(INPUT_PATH, inputPath);
    }

    public String getInputPath() {
        String[] path = this.getAttribute(INPUT_PATH);
        if (path != null) {
            return path[0];
        }
        return null;
    }

    public void setOutputPath(String outputPath) throws DrmaaException {
        this.setAttribute(OUTPUT_PATH, outputPath);
    }

    public String getOutputPath() {
        String[] path = this.getAttribute(OUTPUT_PATH);
        if (path != null) {
            return path[0];
        }
        return null;
    }

    public void setErrorPath(String errorPath) throws DrmaaException {
        this.setAttribute(ERROR_PATH, errorPath);
    }

    public String getErrorPath() {
        String[] path = this.getAttribute(ERROR_PATH);
        if (path != null) {
            return path[0];
        }
        return null;
    }

    public void setJoinFiles(boolean join) throws DrmaaException {
        if (join) {
            this.setAttribute(JOIN_FILES, JOIN_FILES_TRUE_STRING);
        } else {
            this.setAttribute(JOIN_FILES, JOIN_FILES_FALSE_STRING);
        }
    }

    public boolean getJoinFiles() {
        String[] join = this.getAttribute(JOIN_FILES);
        if (join != null) {
            return join[0].equalsIgnoreCase(JOIN_FILES_TRUE_STRING);
        }
        return false;
    }

    public void setTransferFiles(FileTransferMode mode) throws DrmaaException {
        StringBuffer buf = new StringBuffer();
        if (mode.getInputStream()) {
            buf.append('i');
        }
        if (mode.getOutputStream()) {
            buf.append('o');
        }
        if (mode.getErrorStream()) {
            buf.append('e');
        }
        this.setAttribute(TRANSFER_FILES, buf.toString());
    }

    public FileTransferMode getTransferFiles() {
        String[] mode = this.getAttribute(TRANSFER_FILES);
        if (mode != null) {
            return new FileTransferMode(mode[0].indexOf(105) != -1, mode[0].indexOf(111) != -1, mode[0].indexOf(101) != -1);
        }
        return null;
    }

    private String[] getAttribute(String name) {
        String[] values = this.session.nativeGetAttribute(this.id, name);
        return values;
    }

    private void setAttribute(String name, List value) throws DrmaaException {
        this.session.nativeSetAttributeValues(this.id, name, value.toArray(new String[value.size()]));
    }

    private void setAttribute(String name, String value) throws DrmaaException {
        this.session.nativeSetAttributeValue(this.id, name, value);
    }

    public List getAttributeNames() {
        return Arrays.asList(this.session.nativeGetAttributeNames(this.id));
    }

    public boolean equals(Object obj) {
        if (obj instanceof JobTemplateImpl) {
            return this.getId() == ((JobTemplateImpl)obj).getId();
        }
        return false;
    }

    public int hashCode() {
        return this.getId();
    }
}

