/*
 * Decompiled with CFR 0.152.
 */
package ucar.grib.grib2;

import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.grib.GribGridRecord;
import ucar.grib.grib1.Grib1Tables;
import ucar.grib.grib2.Grib2DataRepresentationSection;
import ucar.grib.grib2.Grib2DataSection;
import ucar.grib.grib2.Grib2IdentificationSection;
import ucar.grib.grib2.Grib2Pds;
import ucar.grib.grib2.Grib2Record;
import ucar.grib.grib2.Grib2Tables;
import ucar.grib.grib2.ParameterTable;
import ucar.grid.GridDefRecord;
import ucar.grid.GridParameter;
import ucar.grid.GridRecord;
import ucar.grid.GridTableLookup;

public final class Grib2GridTableLookup
implements GridTableLookup {
    private static Logger logger = LoggerFactory.getLogger(Grib2GridTableLookup.class);
    private final Grib2Pds firstPDSV;
    private final Grib2IdentificationSection firstID;
    private final Grib2DataRepresentationSection firstDRS;

    public Grib2GridTableLookup(Grib2Record firstRecord) {
        this.firstPDSV = firstRecord.getPDS().getPdsVars();
        this.firstID = firstRecord.getId();
        this.firstDRS = firstRecord.getDRS();
    }

    public final String getGridName(GridDefRecord gds) {
        return Grib2Tables.codeTable3_1(gds.getParamInt("grid_type"));
    }

    public final String getShapeName(GridDefRecord gds) {
        return Grib2Tables.codeTable3_2(gds.getParamInt("grid_shape_code"));
    }

    public final String getDisciplineName(GridRecord gr) {
        GribGridRecord ggr = (GribGridRecord)gr;
        return ParameterTable.getDisciplineName(ggr.getDiscipline());
    }

    public final String getCategoryName(GridRecord gr) {
        GribGridRecord ggr = (GribGridRecord)gr;
        Grib2Pds pds = (Grib2Pds)ggr.getPds();
        return ParameterTable.getCategoryName(ggr.getDiscipline(), pds.getParameterCategory());
    }

    public GridParameter getParameter(GridRecord gr) {
        GribGridRecord ggr = (GribGridRecord)gr;
        Grib2Pds pds = (Grib2Pds)ggr.getPds();
        if (this.firstID.getCenter_id() == 7 || ggr.getParameterNumber() < 192 && pds.getParameterCategory() < 192 && ggr.getDiscipline() < 192) {
            return ParameterTable.getParameter(ggr.getDiscipline(), pds.getParameterCategory(), ggr.getParameterNumber());
        }
        return ParameterTable.getParameter(ggr.getDiscipline(), pds.getParameterCategory(), ggr.getParameterNumber(), this.firstID.getCenter_id());
    }

    public int[] getParameterId(GridRecord gr) {
        GribGridRecord ggr = (GribGridRecord)gr;
        Grib2Pds pds = (Grib2Pds)ggr.getPds();
        int[] result = new int[]{2, ggr.getDiscipline(), pds.getParameterCategory(), ggr.getParameterNumber()};
        return result;
    }

    public final String getProductDefinitionName(GridRecord gr) {
        GribGridRecord ggr = (GribGridRecord)gr;
        Grib2Pds pds = (Grib2Pds)ggr.getPds();
        return Grib2Tables.codeTable4_0(pds.getProductDefinitionTemplate());
    }

    public final int getProductDefinition(GridRecord gr) {
        GribGridRecord ggr = (GribGridRecord)gr;
        Grib2Pds pds = (Grib2Pds)ggr.getPds();
        return pds.getProductDefinitionTemplate();
    }

    public final String getSource() {
        return "Type: " + this.firstID.getProductTypeName() + " Status: " + this.firstID.getProductStatusName();
    }

    public final String getGenProcessTypeName(GridRecord gr) {
        return Grib2Tables.codeTable4_3(this.getGenProcessType(gr));
    }

    public final int getGenProcessType(GridRecord gr) {
        GribGridRecord ggr = (GribGridRecord)gr;
        Grib2Pds pds = (Grib2Pds)ggr.getPds();
        return pds.getGenProcessType();
    }

    public final String getLevelName(GridRecord gr) {
        GribGridRecord ggr = (GribGridRecord)gr;
        return Grib2Tables.getTypeSurfaceNameShort(ggr.getLevelType1());
    }

    public final String getLevelDescription(GridRecord gr) {
        GribGridRecord ggr = (GribGridRecord)gr;
        return Grib2Tables.codeTable4_5(ggr.getLevelType1());
    }

    public final String getLevelUnit(GridRecord gr) {
        GribGridRecord ggr = (GribGridRecord)gr;
        return Grib2Tables.getTypeSurfaceUnit(ggr.getLevelType1());
    }

    public final Date getFirstBaseTime() {
        return this.firstID.getBaseTime();
    }

    public final String getTimeRangeUnitName(int tunit) {
        return Grib2Tables.getUdunitTimeUnitFromTable4_4(tunit);
    }

    public final String getFirstCenterName() {
        return Grib1Tables.getCenter_idName(this.firstID.getCenter_id()) + " (" + Integer.toString(this.firstID.getCenter_id()) + ")";
    }

    public final String getFirstSubcenterName() {
        String subcenter = Grib1Tables.getSubCenter_idName(this.firstID.getCenter_id(), this.firstID.getSubcenter_id());
        if (subcenter == null) {
            return null;
        }
        return subcenter + " (" + Integer.toString(this.firstID.getSubcenter_id()) + ")";
    }

    public String getInstitution() {
        String subcenter = this.getFirstSubcenterName();
        if (subcenter == null) {
            return "Center " + this.getFirstCenterName();
        }
        return "Center " + this.getFirstCenterName() + " Subcenter " + subcenter;
    }

    public final String getFirstProductStatusName() {
        return this.firstID.getProductStatusName();
    }

    public final String getComment() {
        return null;
    }

    public final String getFirstProductTypeName() {
        return this.firstID.getProductTypeName();
    }

    public final String getTitle() {
        String productType;
        StringBuilder title = new StringBuilder(Grib1Tables.getCenter_idName(this.firstID.getCenter_id()));
        String model = Grib1Tables.getModelName(this.firstID.getCenter_id(), this.firstPDSV.getGenProcessId());
        if (model != null) {
            title.append(" ");
            title.append(model);
        }
        if ((productType = this.firstID.getProductTypeName()) != null) {
            title.append(" ");
            title.append(productType);
        }
        return title.toString();
    }

    public final String getModel() {
        return Grib1Tables.getModelName(this.firstID.getCenter_id(), this.firstPDSV.getGenProcessId());
    }

    public final String getFirstSignificanceOfRTName() {
        return this.firstID.getSignificanceOfRTName();
    }

    public final boolean isLatLon(GridDefRecord gds) {
        int grid_type = gds.getParamInt("grid_type");
        return grid_type == 0 || grid_type >= 40 && grid_type < 44;
    }

    public final int getProjectionType(GridDefRecord gds) {
        return Grib2Tables.getProjectionType(gds.getParamInt("grid_type"));
    }

    public final boolean isVerticalCoordinate(GridRecord gr) {
        GribGridRecord ggr = (GribGridRecord)gr;
        if (ggr.getLevelType1() == 104 || ggr.getLevelType1() == 105) {
            return true;
        }
        String units = this.getLevelUnit(gr);
        if (units == null || units.length() == 0) {
            return false;
        }
        return ggr.getLevelType1() != 0;
    }

    public final boolean isPositiveUp(GridRecord gr) {
        GribGridRecord ggr = (GribGridRecord)gr;
        return ggr.getLevelType1() != 20 && ggr.getLevelType1() != 100 && ggr.getLevelType1() != 106 && ggr.getLevelType1() != 160;
    }

    public final float getFirstMissingValue() {
        if (Grib2DataSection.isStaticMissingValueInUse()) {
            return Float.NaN;
        }
        if (this.firstDRS.getMissingValueManagement() == 0) {
            return Float.NaN;
        }
        if (this.firstDRS.getMissingValueManagement() == 1) {
            return this.firstDRS.getPrimaryMissingValue();
        }
        if (this.firstDRS.getMissingValueManagement() == 2) {
            return this.firstDRS.getSecondaryMissingValue();
        }
        return -9999.0f;
    }

    public final boolean isLayer(GridRecord gr) {
        return gr.getLevelType2() != 255 && gr.getLevelType2() != 0;
    }

    public final String getGridType() {
        return "GRIB-2";
    }
}

