/*
 * Decompiled with CFR 0.152.
 */
package opendap.dap;

import java.io.BufferedWriter;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.Enumeration;
import opendap.dap.Attribute;
import opendap.dap.AttributeExistsException;
import opendap.dap.AttributeTable;
import opendap.dap.BadSemanticsException;
import opendap.dap.BaseTypePrimitiveVector;
import opendap.dap.DASException;
import opendap.dap.PrimitiveVector;
import opendap.dap.XMLparser.DDSXMLParser;
import opendap.util.EscapeStrings;

public abstract class BaseType
implements Cloneable,
Serializable {
    static final long serialVersionUID = 1L;
    private String _name;
    private String _nameEncoded;
    private BaseType _myParent;
    private Attribute _attr;
    private AttributeTable _attrTbl;

    public BaseType() {
        this(null);
    }

    public BaseType(String n) {
        this(n, true);
    }

    public BaseType(String n, boolean decodeName) {
        this._name = decodeName ? EscapeStrings.www2id(n) : n;
        this._nameEncoded = EscapeStrings.www2id(this._name);
        this._myParent = null;
        this._attrTbl = new AttributeTable(this._name);
        this._attr = new Attribute(this._name, this._attrTbl);
    }

    public Object clone() {
        try {
            BaseType bt = (BaseType)super.clone();
            bt._name = this._name;
            bt._attrTbl = (AttributeTable)this._attrTbl.clone();
            bt._attr = new Attribute(this.getName(), bt._attrTbl);
            return bt;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    public final String getClearName() {
        return this._name;
    }

    public final String getName() {
        return this._nameEncoded;
    }

    public final void setName(String n) {
        this.setClearName(EscapeStrings.www2id(n));
    }

    public final void setClearName(String n) {
        this._name = n;
        this._attr.setClearName(n);
        this._attrTbl.setClearName(n);
        this._nameEncoded = EscapeStrings.id2www(n);
    }

    public abstract String getTypeName();

    public int elementCount(boolean leaves) {
        return 1;
    }

    public final int elementCount() {
        return this.elementCount(false);
    }

    public void printDecl(PrintWriter os, String space, boolean print_semi, boolean constrained) {
        os.print(space + this.getTypeName() + " " + this.getName());
        if (print_semi) {
            os.println(";");
        }
    }

    public void printDecl(PrintWriter os, String space, boolean print_semi) {
        this.printDecl(os, space, print_semi, false);
    }

    public final void printDecl(PrintWriter os, String space) {
        this.printDecl(os, space, true, false);
    }

    public final void printDecl(PrintWriter os) {
        this.printDecl(os, "    ", true, false);
    }

    public final void printDecl(OutputStream os, String space, boolean print_semi, boolean constrained) {
        PrintWriter pw = new PrintWriter(new BufferedWriter(new OutputStreamWriter(os)));
        this.printDecl(pw, space, print_semi, constrained);
        pw.flush();
    }

    public final void printDecl(OutputStream os, String space, boolean print_semi) {
        this.printDecl(os, space, print_semi, false);
    }

    public final void printDecl(OutputStream os, String space) {
        PrintWriter pw = new PrintWriter(new BufferedWriter(new OutputStreamWriter(os)));
        this.printDecl(pw, space);
        pw.flush();
    }

    public final void printDecl(OutputStream os) {
        PrintWriter pw = new PrintWriter(new BufferedWriter(new OutputStreamWriter(os)));
        this.printDecl(pw);
        pw.flush();
    }

    public abstract void printVal(PrintWriter var1, String var2, boolean var3);

    public final void printVal(PrintWriter os, String space) {
        this.printVal(os, space, true);
    }

    public final void printVal(OutputStream os, String space, boolean print_decl_p) {
        PrintWriter pw = new PrintWriter(new BufferedWriter(new OutputStreamWriter(os)));
        this.printVal(pw, space, print_decl_p);
        pw.flush();
    }

    public final void printVal(OutputStream os, String space) {
        PrintWriter pw = new PrintWriter(new BufferedWriter(new OutputStreamWriter(os)));
        this.printVal(pw, space);
        pw.flush();
    }

    public void checkSemantics(boolean all) throws BadSemanticsException {
        if (this._name == null) {
            throw new BadSemanticsException("BaseType.checkSemantics(): Every variable must have a name");
        }
    }

    public final void checkSemantics() throws BadSemanticsException {
        this.checkSemantics(false);
    }

    public PrimitiveVector newPrimitiveVector() {
        return new BaseTypePrimitiveVector(this);
    }

    public void setParent(BaseType bt) {
        this._myParent = bt;
    }

    public BaseType getParent() {
        return this._myParent;
    }

    public String getLongName() {
        boolean done = false;
        String longName = this._name;
        for (BaseType parent = this._myParent; parent != null; parent = parent.getParent()) {
            longName = parent.getName() + "." + longName;
        }
        return longName;
    }

    public boolean hasAttributes() {
        Enumeration e = this._attrTbl.getNames();
        return e.hasMoreElements();
    }

    public Attribute getAttribute() {
        return this._attr;
    }

    public AttributeTable getAttributeTable() {
        return this._attrTbl;
    }

    public void addAttributeAlias(String alias, String attributeName) throws DASException {
        this._attrTbl.addAlias(alias, attributeName);
    }

    public void appendAttribute(String name, int type, String value, boolean check) throws DASException {
        this._attrTbl.appendAttribute(name, type, value, check);
    }

    public void appendAttribute(String name, int type, String value) throws DASException {
        this._attrTbl.appendAttribute(name, type, value);
    }

    public void addAttributeContainer(AttributeTable at) throws AttributeExistsException {
        this._attrTbl.addContainer(at.getName(), at);
    }

    public AttributeTable appendAttributeContainer(String name) {
        return this._attrTbl.appendContainer(name);
    }

    public void delAttribute(String name) {
        this._attrTbl.delAttribute(name);
    }

    public void delAttribute(String name, int i) throws DASException {
        this._attrTbl.delAttribute(name, i);
    }

    public Attribute getAttribute(String name) {
        return this._attrTbl.getAttribute(name);
    }

    public Enumeration getAttributeNames() {
        return this._attrTbl.getNames();
    }

    public void printAttributes(OutputStream os) {
        this._attrTbl.print(os);
    }

    public void printAttributes(OutputStream os, String pad) {
        this._attrTbl.print(os, pad);
    }

    public void printAttributes(PrintWriter pw) {
        this._attrTbl.print(pw);
    }

    public void printAttributes(PrintWriter pw, String pad) {
        this._attrTbl.print(pw, pad);
    }

    public void printXML(OutputStream os) {
        this.printXML(os, "");
    }

    public void printXML(OutputStream os, String pad) {
        PrintWriter pw = new PrintWriter(new BufferedWriter(new OutputStreamWriter(os)));
        this.printXML(pw, pad, false);
        pw.flush();
    }

    public void printXML(PrintWriter pw) {
        this.printXML(pw, "");
    }

    public void printXML(PrintWriter pw, String pad) {
        this.printXML(pw, pad, false);
    }

    public void printXML(PrintWriter pw, String pad, boolean constrained) {
        Enumeration e;
        pw.print(pad + "<" + this.getTypeName());
        if (this._name != null) {
            pw.print(" name=\"" + DDSXMLParser.normalizeToXML(this._name) + "\"");
        }
        if ((e = this.getAttributeNames()).hasMoreElements()) {
            pw.println(">");
            while (e.hasMoreElements()) {
                String aName = (String)e.nextElement();
                Attribute a = this.getAttribute(aName);
                if (a == null) continue;
                a.printXML(pw, pad + "\t", constrained);
            }
            pw.println(pad + "</" + this.getTypeName() + ">");
        } else {
            pw.println("/>");
        }
    }
}

