/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.record.compiler;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.hadoop.record.compiler.CodeBuffer;
import org.apache.hadoop.record.compiler.JBuffer;
import org.apache.hadoop.record.compiler.JCompType;
import org.apache.hadoop.record.compiler.JField;
import org.apache.hadoop.record.compiler.JType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JRecord
extends JCompType {
    private String signature;

    public JRecord(String name, ArrayList<JField<JType>> flist) {
        this.setJavaType(new JavaRecord(name, flist));
        this.setCppType(new CppRecord(name, flist));
        this.setCType(new CRecord());
        int idx = name.lastIndexOf(46);
        String recName = name.substring(idx + 1);
        StringBuffer sb = new StringBuffer();
        sb.append("L").append(recName).append("(");
        Iterator<JField<JType>> i = flist.iterator();
        while (i.hasNext()) {
            String s = i.next().getType().getSignature();
            sb.append(s);
        }
        sb.append(")");
        this.signature = sb.toString();
    }

    @Override
    String getSignature() {
        return this.signature;
    }

    void genCppCode(FileWriter hh, FileWriter cc, ArrayList<String> options) throws IOException {
        ((CppRecord)this.getCppType()).genCode(hh, cc, options);
    }

    void genJavaCode(String destDir, ArrayList<String> options) throws IOException {
        ((JavaRecord)this.getJavaType()).genCode(destDir, options);
    }

    class CRecord
    extends JCompType.CCompType {
        CRecord() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class CppRecord
    extends JCompType.CppCompType {
        private String fullName;
        private String name;
        private String module;
        private ArrayList<JField<JType.CppType>> fields;

        CppRecord(String name, ArrayList<JField<JType>> flist) {
            super(name.replaceAll("\\.", "::"));
            this.fields = new ArrayList();
            this.fullName = name.replaceAll("\\.", "::");
            int idx = name.lastIndexOf(46);
            this.name = name.substring(idx + 1);
            this.module = name.substring(0, idx).replaceAll("\\.", "::");
            for (JField<JType> f : flist) {
                this.fields.add(new JField<JType.CppType>(f.getName(), f.getType().getCppType()));
            }
        }

        String genDecl(String fname) {
            return "  " + this.name + " " + fname + ";\n";
        }

        void genCode(FileWriter hh, FileWriter cc, ArrayList<String> options) throws IOException {
            JType.CppType type;
            String name;
            JType.CppType type2;
            String name2;
            CodeBuffer hb = new CodeBuffer();
            String[] ns = this.module.split("::");
            for (int i = 0; i < ns.length; ++i) {
                hb.append("namespace " + ns[i] + " {\n");
            }
            hb.append("class " + this.name + " : public ::hadoop::Record {\n");
            hb.append("private:\n");
            for (JField<JType.CppType> jf : this.fields) {
                name2 = jf.getName();
                type2 = jf.getType();
                type2.genDecl(hb, name2);
            }
            hb.append("public:\n");
            hb.append("virtual void serialize(::hadoop::OArchive& a_, const char* tag) const;\n");
            hb.append("virtual void deserialize(::hadoop::IArchive& a_, const char* tag);\n");
            hb.append("virtual const ::std::string& type() const;\n");
            hb.append("virtual const ::std::string& signature() const;\n");
            hb.append("virtual bool operator<(const " + this.name + "& peer_) const;\n");
            hb.append("virtual bool operator==(const " + this.name + "& peer_) const;\n");
            hb.append("virtual ~" + this.name + "() {};\n");
            for (JField<JType.CppType> jf : this.fields) {
                name2 = jf.getName();
                type2 = jf.getType();
                type2.genGetSet(hb, name2);
            }
            hb.append("}; // end record " + this.name + "\n");
            for (int i = ns.length - 1; i >= 0; --i) {
                hb.append("} // end namespace " + ns[i] + "\n");
            }
            hh.write(hb.toString());
            CodeBuffer cb = new CodeBuffer();
            cb.append("void " + this.fullName + "::serialize(::hadoop::OArchive& a_, const char* tag) const {\n");
            cb.append("a_.startRecord(*this,tag);\n");
            for (JField<JType.CppType> jf : this.fields) {
                name = jf.getName();
                type = jf.getType();
                if (type instanceof JBuffer.CppBuffer) {
                    cb.append("a_.serialize(" + name + "," + name + ".length(),\"" + name + "\");\n");
                    continue;
                }
                cb.append("a_.serialize(" + name + ",\"" + name + "\");\n");
            }
            cb.append("a_.endRecord(*this,tag);\n");
            cb.append("return;\n");
            cb.append("}\n");
            cb.append("void " + this.fullName + "::deserialize(::hadoop::IArchive& a_, const char* tag) {\n");
            cb.append("a_.startRecord(*this,tag);\n");
            for (JField<JType.CppType> jf : this.fields) {
                name = jf.getName();
                type = jf.getType();
                if (type instanceof JBuffer.CppBuffer) {
                    cb.append("{\nsize_t len=0; a_.deserialize(" + name + ",len,\"" + name + "\");\n}\n");
                    continue;
                }
                cb.append("a_.deserialize(" + name + ",\"" + name + "\");\n");
            }
            cb.append("a_.endRecord(*this,tag);\n");
            cb.append("return;\n");
            cb.append("}\n");
            cb.append("bool " + this.fullName + "::operator< (const " + this.fullName + "& peer_) const {\n");
            cb.append("return (1\n");
            for (JField<JType.CppType> jf : this.fields) {
                name = jf.getName();
                cb.append("&& (" + name + " < peer_." + name + ")\n");
            }
            cb.append(");\n");
            cb.append("}\n");
            cb.append("bool " + this.fullName + "::operator== (const " + this.fullName + "& peer_) const {\n");
            cb.append("return (1\n");
            for (JField<JType.CppType> jf : this.fields) {
                name = jf.getName();
                cb.append("&& (" + name + " == peer_." + name + ")\n");
            }
            cb.append(");\n");
            cb.append("}\n");
            cb.append("const ::std::string&" + this.fullName + "::type() const {\n");
            cb.append("static const ::std::string type_(\"" + this.name + "\");\n");
            cb.append("return type_;\n");
            cb.append("}\n");
            cb.append("const ::std::string&" + this.fullName + "::signature() const {\n");
            cb.append("static const ::std::string sig_(\"" + JRecord.this.getSignature() + "\");\n");
            cb.append("return sig_;\n");
            cb.append("}\n");
            cc.write(cb.toString());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class JavaRecord
    extends JCompType.JavaCompType {
        private String fullName;
        private String name;
        private String module;
        private ArrayList<JField<JType.JavaType>> fields;

        JavaRecord(String name, ArrayList<JField<JType>> flist) {
            super(name, "Record", name);
            this.fields = new ArrayList();
            this.fullName = name;
            int idx = name.lastIndexOf(46);
            this.name = name.substring(idx + 1);
            this.module = name.substring(0, idx);
            for (JField<JType> f : flist) {
                this.fields.add(new JField<JType.JavaType>(f.getName(), f.getType().getJavaType()));
            }
        }

        @Override
        void genReadMethod(CodeBuffer cb, String fname, String tag, boolean decl) {
            if (decl) {
                cb.append(this.fullName + " " + fname + ";\n");
            }
            cb.append(fname + "= new " + this.fullName + "();\n");
            cb.append(fname + ".deserialize(a,\"" + tag + "\");\n");
        }

        @Override
        void genWriteMethod(CodeBuffer cb, String fname, String tag) {
            cb.append(fname + ".serialize(a,\"" + tag + "\");\n");
        }

        @Override
        void genSlurpBytes(CodeBuffer cb, String b, String s, String l) {
            cb.append("{\n");
            cb.append("int r = " + this.fullName + ".Comparator.slurpRaw(" + b + "," + s + "," + l + ");\n");
            cb.append(s + "+=r; " + l + "-=r;\n");
            cb.append("}\n");
        }

        @Override
        void genCompareBytes(CodeBuffer cb) {
            cb.append("{\n");
            cb.append("int r1 = " + this.fullName + ".Comparator.compareRaw(b1,s1,l1,b2,s2,l2);\n");
            cb.append("if (r1 <= 0) { return r1; }\n");
            cb.append("s1+=r1; s2+=r1; l1-=r1; l2-=r1;\n");
            cb.append("}\n");
        }

        void genCode(String destDir, ArrayList<String> options) throws IOException {
            JType.JavaType type;
            String name;
            String pkg = this.module;
            String pkgpath = pkg.replaceAll("\\.", "/");
            File pkgdir = new File(destDir, pkgpath);
            if (!pkgdir.exists()) {
                boolean ret = pkgdir.mkdirs();
                if (!ret) {
                    throw new IOException("Cannnot create directory: " + pkgpath);
                }
            } else if (!pkgdir.isDirectory()) {
                throw new IOException(pkgpath + " is not a directory.");
            }
            File jfile = new File(pkgdir, this.name + ".java");
            FileWriter jj = new FileWriter(jfile);
            CodeBuffer cb = new CodeBuffer();
            cb.append("// File generated by hadoop record compiler. Do not edit.\n");
            cb.append("package " + this.module + ";\n\n");
            cb.append("public class " + this.name + " extends org.apache.hadoop.record.Record {\n");
            for (JField<JType.JavaType> jf : this.fields) {
                String name2 = jf.getName();
                JType.JavaType type2 = jf.getType();
                type2.genDecl(cb, name2);
            }
            cb.append("public " + this.name + "() { }\n");
            cb.append("public " + this.name + "(\n");
            int fIdx = 0;
            Iterator<JField<JType.JavaType>> i = this.fields.iterator();
            while (i.hasNext()) {
                JField<JType.JavaType> jf = i.next();
                name = jf.getName();
                type = jf.getType();
                type.genConstructorParam(cb, name);
                cb.append(!i.hasNext() ? "" : ",\n");
                ++fIdx;
            }
            cb.append(") {\n");
            fIdx = 0;
            for (JField<JType.JavaType> jf : this.fields) {
                name = jf.getName();
                type = jf.getType();
                type.genConstructorSet(cb, name);
                ++fIdx;
            }
            cb.append("}\n");
            for (JField<JType.JavaType> jf : this.fields) {
                name = jf.getName();
                type = jf.getType();
                type.genGetSet(cb, name);
            }
            cb.append("public void serialize(final org.apache.hadoop.record.RecordOutput a, final String tag)\nthrows java.io.IOException {\n");
            cb.append("a.startRecord(this,tag);\n");
            for (JField<JType.JavaType> jf : this.fields) {
                name = jf.getName();
                type = jf.getType();
                type.genWriteMethod(cb, name, name);
            }
            cb.append("a.endRecord(this,tag);\n");
            cb.append("}\n");
            cb.append("public void deserialize(final org.apache.hadoop.record.RecordInput a, final String tag)\nthrows java.io.IOException {\n");
            cb.append("a.startRecord(tag);\n");
            for (JField<JType.JavaType> jf : this.fields) {
                name = jf.getName();
                type = jf.getType();
                type.genReadMethod(cb, name, name, false);
            }
            cb.append("a.endRecord(tag);\n");
            cb.append("}\n");
            cb.append("public int compareTo (final Object peer_) throws ClassCastException {\n");
            cb.append("if (!(peer_ instanceof " + this.name + ")) {\n");
            cb.append("throw new ClassCastException(\"Comparing different types of records.\");\n");
            cb.append("}\n");
            cb.append(this.name + " peer = (" + this.name + ") peer_;\n");
            cb.append("int ret = 0;\n");
            for (JField<JType.JavaType> jf : this.fields) {
                name = jf.getName();
                type = jf.getType();
                type.genCompareTo(cb, name, "peer." + name);
                cb.append("if (ret != 0) return ret;\n");
            }
            cb.append("return ret;\n");
            cb.append("}\n");
            cb.append("public boolean equals(final Object peer_) {\n");
            cb.append("if (!(peer_ instanceof " + this.name + ")) {\n");
            cb.append("return false;\n");
            cb.append("}\n");
            cb.append("if (peer_ == this) {\n");
            cb.append("return true;\n");
            cb.append("}\n");
            cb.append(this.name + " peer = (" + this.name + ") peer_;\n");
            cb.append("boolean ret = false;\n");
            for (JField<JType.JavaType> jf : this.fields) {
                name = jf.getName();
                type = jf.getType();
                type.genEquals(cb, name, "peer." + name);
                cb.append("if (!ret) return ret;\n");
            }
            cb.append("return ret;\n");
            cb.append("}\n");
            cb.append("public Object clone() throws CloneNotSupportedException {\n");
            cb.append(this.name + " other = new " + this.name + "();\n");
            for (JField<JType.JavaType> jf : this.fields) {
                name = jf.getName();
                type = jf.getType();
                type.genClone(cb, name);
            }
            cb.append("return other;\n");
            cb.append("}\n");
            cb.append("public int hashCode() {\n");
            cb.append("int result = 17;\n");
            cb.append("int ret;\n");
            for (JField<JType.JavaType> jf : this.fields) {
                name = jf.getName();
                type = jf.getType();
                type.genHashCode(cb, name);
                cb.append("result = 37*result + ret;\n");
            }
            cb.append("return result;\n");
            cb.append("}\n");
            cb.append("public static String signature() {\n");
            cb.append("return \"" + JRecord.this.getSignature() + "\";\n");
            cb.append("}\n");
            cb.append("public static class Comparator extends org.apache.hadoop.record.RecordComparator {\n");
            cb.append("public Comparator() {\n");
            cb.append("super(" + this.name + ".class);\n");
            cb.append("}\n");
            cb.append("static public int slurpRaw(byte[] b, int s, int l) {\n");
            cb.append("try {\n");
            cb.append("int os = s;\n");
            for (JField<JType.JavaType> jf : this.fields) {
                name = jf.getName();
                type = jf.getType();
                type.genSlurpBytes(cb, "b", "s", "l");
            }
            cb.append("return (os - s);\n");
            cb.append("} catch(java.io.IOException e) {\n");
            cb.append("throw new RuntimeException(e);\n");
            cb.append("}\n");
            cb.append("}\n");
            cb.append("static public int compareRaw(byte[] b1, int s1, int l1,\n");
            cb.append("                             byte[] b2, int s2, int l2) {\n");
            cb.append("try {\n");
            cb.append("int os1 = s1;\n");
            for (JField<JType.JavaType> jf : this.fields) {
                name = jf.getName();
                type = jf.getType();
                type.genCompareBytes(cb);
            }
            cb.append("return (os1 - s1);\n");
            cb.append("} catch(java.io.IOException e) {\n");
            cb.append("throw new RuntimeException(e);\n");
            cb.append("}\n");
            cb.append("}\n");
            cb.append("public int compare(byte[] b1, int s1, int l1,\n");
            cb.append("                   byte[] b2, int s2, int l2) {\n");
            cb.append("int ret = compareRaw(b1,s1,l1,b2,s2,l2);\n");
            cb.append("return (ret == -1)? -1 : ((ret==0)? 1 : 0);");
            cb.append("}\n");
            cb.append("}\n\n");
            cb.append("static {\n");
            cb.append("org.apache.hadoop.record.RecordComparator.define(" + this.name + ".class, new Comparator());\n");
            cb.append("}\n");
            cb.append("}\n");
            jj.write(cb.toString());
            jj.close();
        }
    }
}

