/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.net;

import org.apache.hadoop.net.Node;

public class NodeBase
implements Node {
    public static final char PATH_SEPARATOR = '/';
    public static String PATH_SEPARATOR_STR = "/";
    public static final String ROOT = "";
    protected String name;
    protected String location;
    protected int level;
    protected Node parent;

    public NodeBase() {
    }

    public NodeBase(String path) {
        path = NodeBase.normalize(path);
        int index = path.lastIndexOf(47);
        if (index == -1) {
            this.set(ROOT, path);
        } else {
            this.set(path.substring(index + 1), path.substring(0, index));
        }
    }

    public NodeBase(String name, String location) {
        this.set(name, NodeBase.normalize(location));
    }

    public NodeBase(String name, String location, Node parent, int level) {
        this.set(name, NodeBase.normalize(location));
        this.parent = parent;
        this.level = level;
    }

    private void set(String name, String location) {
        if (name != null && name.contains(PATH_SEPARATOR_STR)) {
            throw new IllegalArgumentException("Network location name contains /: " + name);
        }
        this.name = name == null ? ROOT : name;
        this.location = location;
    }

    public String getName() {
        return this.name;
    }

    public String getNetworkLocation() {
        return this.location;
    }

    public String getPath() {
        return this.location + PATH_SEPARATOR_STR + this.name;
    }

    public String toString() {
        return this.getPath();
    }

    public static String normalize(String path) {
        if (path == null || path.length() == 0) {
            return ROOT;
        }
        if (path.charAt(0) != '/') {
            throw new IllegalArgumentException("Network Location path does not start with " + PATH_SEPARATOR_STR + ": " + path);
        }
        int len = path.length();
        if (path.charAt(len - 1) == '/') {
            return path.substring(0, len - 1);
        }
        return path;
    }

    public Node getParent() {
        return this.parent;
    }

    public int getLevel() {
        return this.level;
    }
}

