/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.net;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Random;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.dfs.DatanodeDescriptor;
import org.apache.hadoop.net.Node;
import org.apache.hadoop.net.NodeBase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NetworkTopology {
    public static final String DEFAULT_RACK = "/default-rack";
    public static final Log LOG = LogFactory.getLog((String)"org.apache.hadoop.net.NetworkTopology");
    InnerNode clusterMap = new InnerNode("");
    private int numOfRacks = 0;
    private static final Random r = new Random();
    private DatanodeDescriptor distFrom = null;
    private final Comparator<DatanodeDescriptor> nodeDistanceComparator = new Comparator<DatanodeDescriptor>(){

        @Override
        public int compare(DatanodeDescriptor n1, DatanodeDescriptor n2) {
            return NetworkTopology.this.getDistance(NetworkTopology.this.distFrom, n1) - NetworkTopology.this.getDistance(NetworkTopology.this.distFrom, n2);
        }
    };

    public synchronized void add(DatanodeDescriptor node) {
        if (node == null) {
            return;
        }
        LOG.info((Object)("Adding a new node: " + node.getPath()));
        Node rack = this.getNode(node.getNetworkLocation());
        if (rack != null && !(rack instanceof InnerNode)) {
            throw new IllegalArgumentException("Unexpected data node " + node.toString() + " at an illegal network location");
        }
        if (this.clusterMap.add(node) && rack == null) {
            ++this.numOfRacks;
        }
        LOG.debug((Object)("NetworkTopology became:\n" + this.toString()));
    }

    public synchronized void remove(DatanodeDescriptor node) {
        InnerNode rack;
        if (node == null) {
            return;
        }
        LOG.info((Object)("Removing a node: " + node.getPath()));
        if (this.clusterMap.remove(node) && (rack = (InnerNode)this.getNode(node.getNetworkLocation())) == null) {
            --this.numOfRacks;
        }
        LOG.debug((Object)("NetworkTopology became:\n" + this.toString()));
    }

    public synchronized boolean contains(DatanodeDescriptor node) {
        if (node == null) {
            return false;
        }
        Node parent = node.getParent();
        for (int level = node.getLevel(); parent != null && level > 0; parent = parent.getParent(), --level) {
            if (parent != this.clusterMap) continue;
            return true;
        }
        return false;
    }

    public synchronized Node getNode(String loc) {
        if (!"".equals(loc = NodeBase.normalize(loc))) {
            loc = loc.substring(1);
        }
        return this.clusterMap.getLoc(loc);
    }

    public synchronized int getNumOfRacks() {
        return this.numOfRacks;
    }

    public synchronized int getNumOfLeaves() {
        return this.clusterMap.getNumOfLeaves();
    }

    public int getDistance(DatanodeDescriptor node1, DatanodeDescriptor node2) {
        if (node1 == node2) {
            return 0;
        }
        Node n1 = node1;
        Node n2 = node2;
        int level1 = node1.getLevel();
        int level2 = node2.getLevel();
        int dis = 0;
        while (n1 != null && level1 > level2) {
            n1 = n1.getParent();
            --level1;
            ++dis;
        }
        while (n2 != null && level2 > level1) {
            n2 = n2.getParent();
            --level2;
            ++dis;
        }
        while (n1 != null && n2 != null && n1.getParent() != n2.getParent()) {
            n1 = n1.getParent();
            n2 = n2.getParent();
            dis += 2;
        }
        if (n1 == null) {
            LOG.warn((Object)("The cluster does not contain data node: " + node1.getPath()));
            return Integer.MAX_VALUE;
        }
        if (n2 == null) {
            LOG.warn((Object)("The cluster does not contain data node: " + node2.getPath()));
            return Integer.MAX_VALUE;
        }
        return dis + 2;
    }

    public boolean isOnSameRack(DatanodeDescriptor node1, DatanodeDescriptor node2) {
        if (node1 == null || node2 == null) {
            return false;
        }
        if (node1 == node2 || node1.equals(node2)) {
            return true;
        }
        return node1.getParent() == node2.getParent();
    }

    public DatanodeDescriptor chooseRandom(String scope) {
        if (scope.startsWith("~")) {
            return this.chooseRandom("", scope.substring(1));
        }
        return this.chooseRandom(scope, null);
    }

    private DatanodeDescriptor chooseRandom(String scope, String excludedScope) {
        Node node;
        if (excludedScope != null) {
            if (scope.startsWith(excludedScope)) {
                return null;
            }
            if (!excludedScope.startsWith(scope)) {
                excludedScope = null;
            }
        }
        if ((node = this.getNode(scope)) instanceof DatanodeDescriptor) {
            return (DatanodeDescriptor)node;
        }
        InnerNode innerNode = (InnerNode)node;
        int numOfDatanodes = innerNode.getNumOfLeaves();
        if (excludedScope == null) {
            node = null;
        } else {
            node = this.getNode(excludedScope);
            numOfDatanodes = node instanceof DatanodeDescriptor ? --numOfDatanodes : (numOfDatanodes -= ((InnerNode)node).getNumOfLeaves());
        }
        int leaveIndex = r.nextInt(numOfDatanodes);
        return innerNode.getLeaf(leaveIndex, node);
    }

    public int countNumOfAvailableNodes(String scope, List<DatanodeDescriptor> excludedNodes) {
        boolean isExcluded = false;
        if (scope.startsWith("~")) {
            isExcluded = true;
            scope = scope.substring(1);
        }
        scope = NodeBase.normalize(scope);
        int count = 0;
        for (DatanodeDescriptor node : excludedNodes) {
            if (!(node.getPath() + NodeBase.PATH_SEPARATOR_STR).startsWith(scope + NodeBase.PATH_SEPARATOR_STR)) continue;
            ++count;
        }
        Node n = this.getNode(scope);
        int scopeNodeCount = 1;
        if (n instanceof InnerNode) {
            scopeNodeCount = ((InnerNode)n).getNumOfLeaves();
        }
        if (isExcluded) {
            return this.clusterMap.getNumOfLeaves() - scopeNodeCount - excludedNodes.size() + count;
        }
        return scopeNodeCount - count;
    }

    public String toString() {
        StringBuffer tree = new StringBuffer();
        tree.append("Number of racks: ");
        tree.append(this.numOfRacks);
        tree.append("\n");
        int numOfLeaves = this.getNumOfLeaves();
        tree.append("Expected number of leaves:");
        tree.append(numOfLeaves);
        tree.append("\n");
        for (int i = 0; i < numOfLeaves; ++i) {
            tree.append(this.clusterMap.getLeaf(i, null).getPath());
            tree.append("\n");
        }
        return tree.toString();
    }

    public synchronized void sortByDistance(DatanodeDescriptor reader, DatanodeDescriptor[] nodes) {
        if (reader != null && this.contains(reader)) {
            this.distFrom = reader;
            Arrays.sort(nodes, this.nodeDistanceComparator);
            this.distFrom = null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class InnerNode
    extends NodeBase {
        private ArrayList<Node> children;
        private int numOfLeaves;

        InnerNode(String path) {
            super(path);
            this.children = new ArrayList();
        }

        InnerNode(String name, String location) {
            super(name, location);
            this.children = new ArrayList();
        }

        InnerNode(String name, String location, InnerNode parent, int level) {
            super(name, location, parent, level);
            this.children = new ArrayList();
        }

        Collection<Node> getChildren() {
            return this.children;
        }

        int getNumOfChildren() {
            return this.children.size();
        }

        boolean isRack() {
            if (this.children.isEmpty()) {
                return true;
            }
            Node firstChild = this.children.get(0);
            return !(firstChild instanceof InnerNode);
        }

        boolean isAncestor(Node n) {
            return this.getPath().equals(NodeBase.PATH_SEPARATOR_STR) || (n.getNetworkLocation() + NodeBase.PATH_SEPARATOR_STR).startsWith(this.getPath() + NodeBase.PATH_SEPARATOR_STR);
        }

        boolean isParent(Node n) {
            return n.getNetworkLocation().equals(this.getPath());
        }

        private String getNextAncestorName(Node n) {
            int index;
            if (!this.isAncestor(n)) {
                throw new IllegalArgumentException(this + "is not an ancestor of " + n);
            }
            String name = n.getNetworkLocation().substring(this.getPath().length());
            if (name.charAt(0) == '/') {
                name = name.substring(1);
            }
            if ((index = name.indexOf(47)) != -1) {
                name = name.substring(0, index);
            }
            return name;
        }

        boolean add(DatanodeDescriptor n) {
            if (!this.isAncestor(n)) {
                throw new IllegalArgumentException(n.getName() + ", which is located at " + n.getNetworkLocation() + ", is not a decendent of " + this.getPath());
            }
            if (this.isParent(n)) {
                n.setParent(this);
                n.setLevel(this.level + 1);
                for (int i = 0; i < this.children.size(); ++i) {
                    if (!this.children.get(i).getName().equals(n.getName())) continue;
                    this.children.set(i, n);
                    return false;
                }
                this.children.add(n);
                ++this.numOfLeaves;
                return true;
            }
            String parentName = this.getNextAncestorName(n);
            InnerNode parentNode = null;
            for (int i = 0; i < this.children.size(); ++i) {
                if (!this.children.get(i).getName().equals(parentName)) continue;
                parentNode = (InnerNode)this.children.get(i);
                break;
            }
            if (parentNode == null) {
                parentNode = new InnerNode(parentName, this.getPath(), this, this.getLevel() + 1);
                this.children.add(parentNode);
            }
            if (parentNode.add(n)) {
                ++this.numOfLeaves;
                return true;
            }
            return false;
        }

        boolean remove(DatanodeDescriptor n) {
            int i;
            String parent = n.getNetworkLocation();
            String currentPath = this.getPath();
            if (!this.isAncestor(n)) {
                throw new IllegalArgumentException(n.getName() + ", which is located at " + parent + ", is not a decendent of " + currentPath);
            }
            if (this.isParent(n)) {
                for (int i2 = 0; i2 < this.children.size(); ++i2) {
                    if (!this.children.get(i2).getName().equals(n.getName())) continue;
                    this.children.remove(i2);
                    --this.numOfLeaves;
                    n.setParent(null);
                    return true;
                }
                return false;
            }
            String parentName = this.getNextAncestorName(n);
            InnerNode parentNode = null;
            for (i = 0; i < this.children.size(); ++i) {
                if (!this.children.get(i).getName().equals(parentName)) continue;
                parentNode = (InnerNode)this.children.get(i);
                break;
            }
            if (parentNode == null) {
                return false;
            }
            boolean isRemoved = parentNode.remove(n);
            if (isRemoved) {
                if (parentNode.getNumOfChildren() == 0) {
                    this.children.remove(i);
                }
                --this.numOfLeaves;
            }
            return isRemoved;
        }

        Node getLoc(String loc) {
            if (loc == null || loc.length() == 0) {
                return this;
            }
            String[] path = loc.split(PATH_SEPARATOR_STR, 2);
            Node childnode = null;
            for (int i = 0; i < this.children.size(); ++i) {
                if (!this.children.get(i).getName().equals(path[0])) continue;
                childnode = this.children.get(i);
            }
            if (childnode == null) {
                return null;
            }
            if (path.length == 1) {
                return childnode;
            }
            if (childnode instanceof InnerNode) {
                return ((InnerNode)childnode).getLoc(path[1]);
            }
            return null;
        }

        private DatanodeDescriptor getLeaf(int leaveIndex, Node excludedNode) {
            int count = 0;
            int numOfExcludedLeaves = 1;
            if (excludedNode instanceof InnerNode) {
                numOfExcludedLeaves = ((InnerNode)excludedNode).getNumOfLeaves();
            }
            if (this.isRack()) {
                if (leaveIndex < 0 || leaveIndex >= this.getNumOfChildren()) {
                    return null;
                }
                DatanodeDescriptor child = (DatanodeDescriptor)this.children.get(leaveIndex);
                if (excludedNode == null || excludedNode != child) {
                    return child;
                }
                if (leaveIndex + 1 >= this.getNumOfChildren()) {
                    return null;
                }
                return (DatanodeDescriptor)this.children.get(leaveIndex + 1);
            }
            for (int i = 0; i < this.children.size(); ++i) {
                InnerNode child = (InnerNode)this.children.get(i);
                if (excludedNode == null || excludedNode != child) {
                    int numOfLeaves = child.getNumOfLeaves();
                    if (excludedNode != null && child.isAncestor(excludedNode)) {
                        numOfLeaves -= numOfExcludedLeaves;
                    }
                    if (count + numOfLeaves > leaveIndex) {
                        return child.getLeaf(leaveIndex - count, excludedNode);
                    }
                    count += numOfLeaves;
                    continue;
                }
                excludedNode = null;
            }
            return null;
        }

        int getNumOfLeaves() {
            return this.numOfLeaves;
        }
    }
}

