/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.servlet.jsp.JspFactory;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.SkipPageException;
import org.apache.hadoop.mapred.JobInProgress;
import org.apache.hadoop.mapred.JobTracker;
import org.apache.hadoop.mapred.TaskStatus;
import org.apache.hadoop.mapred.TaskTrackerStatus;
import org.apache.hadoop.util.StringUtils;
import org.apache.jasper.runtime.HttpJspBase;
import org.apache.jasper.runtime.JspSourceDependent;

public final class taskdetails_jsp
extends HttpJspBase
implements JspSourceDependent {
    static SimpleDateFormat dateFormat = new SimpleDateFormat("d-MMM-yyyy HH:mm:ss");
    private static Vector _jspx_dependants;

    public List getDependants() {
        return _jspx_dependants;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void _jspService(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        JspFactory _jspxFactory = null;
        PageContext pageContext = null;
        HttpSession session = null;
        ServletContext application = null;
        ServletConfig config = null;
        JspWriter out = null;
        taskdetails_jsp page = this;
        JspWriter _jspx_out = null;
        PageContext _jspx_page_context = null;
        try {
            _jspxFactory = JspFactory.getDefaultFactory();
            response.setContentType("text/html; charset=UTF-8");
            _jspx_page_context = pageContext = _jspxFactory.getPageContext((Servlet)this, (ServletRequest)request, (ServletResponse)response, null, true, 8192, true);
            application = pageContext.getServletContext();
            config = pageContext.getServletConfig();
            session = pageContext.getSession();
            _jspx_out = out = pageContext.getOut();
            out.write(10);
            out.write(10);
            String jobid = request.getParameter("jobid");
            JobTracker tracker = JobTracker.getTracker();
            JobInProgress job = tracker.getJob(jobid);
            String tipid = request.getParameter("tipid");
            TaskStatus[] ts = job != null ? tracker.getTaskStatuses(jobid, tipid) : null;
            out.write("\n\n<html>\n<title>Hadoop Task Details</title>\n<body>\n<h1>Job ");
            out.print(jobid);
            out.write("</h1>\n\n<hr>\n\n<h2>All Task Attempts</h2>\n<center>\n");
            if (ts == null || ts.length == 0) {
                out.write("\n\t\t<h3>No Task Attempts found</h3>\n");
            } else {
                out.write("\n<table border=2 cellpadding=\"5\" cellspacing=\"2\">\n<tr><td align=\"center\">Task Attempts</td><td>Machine</td><td>Status</td><td>Progress</td><td>Start Time</td> \n  ");
                if (!ts[0].getIsMap()) {
                    out.write("\n<td>Shuffle Finished</td><td>Sort Finished</td>\n  ");
                }
                out.write("\n<td>Finish Time</td><td>Errors</td><td>Task Logs</td><td>Counters</td></tr>\n  ");
                for (int i = 0; i < ts.length; ++i) {
                    TaskStatus status = ts[i];
                    String taskTrackerName = status.getTaskTracker();
                    TaskTrackerStatus taskTracker = tracker.getTaskTracker(taskTrackerName);
                    out.print("<tr><td>" + status.getTaskId() + "</td>");
                    String taskAttemptTracker = null;
                    if (taskTracker == null) {
                        out.print("<td>" + taskTrackerName + "</td>");
                    } else {
                        taskAttemptTracker = "http://" + taskTracker.getHost() + ":" + taskTracker.getHttpPort();
                        out.print("<td><a href=\"" + taskAttemptTracker + "\">" + taskTracker.getHost() + "</a></td>");
                    }
                    out.print("<td>" + (Object)((Object)status.getRunState()) + "</td>");
                    out.print("<td>" + StringUtils.formatPercent(status.getProgress(), 2) + "</td>");
                    out.print("<td>" + StringUtils.getFormattedTimeWithDiff(dateFormat, status.getStartTime(), 0L) + "</td>");
                    if (!ts[i].getIsMap()) {
                        out.print("<td>" + StringUtils.getFormattedTimeWithDiff(dateFormat, status.getShuffleFinishTime(), status.getStartTime()) + "</td>");
                        out.println("<td>" + StringUtils.getFormattedTimeWithDiff(dateFormat, status.getSortFinishTime(), status.getShuffleFinishTime()) + "</td>");
                    }
                    out.println("<td>" + StringUtils.getFormattedTimeWithDiff(dateFormat, status.getFinishTime(), status.getStartTime()) + "</td>");
                    out.print("<td><pre>");
                    List<String> failures = tracker.getTaskDiagnostics(jobid, tipid, status.getTaskId());
                    if (failures == null) {
                        out.print("&nbsp;");
                    } else {
                        Iterator<String> itr = failures.iterator();
                        while (itr.hasNext()) {
                            out.print(itr.next());
                            if (!itr.hasNext()) continue;
                            out.print("\n-------\n");
                        }
                    }
                    out.print("</pre></td>");
                    out.print("<td>");
                    if (taskAttemptTracker == null) {
                        out.print("n/a");
                    } else {
                        String taskLogUrl = taskAttemptTracker + "/tasklog.jsp?taskid=" + status.getTaskId();
                        String tailFourKBUrl = taskLogUrl + "&tail=true&tailsize=4096";
                        String tailEightKBUrl = taskLogUrl + "&tail=true&tailsize=8192";
                        String entireLogUrl = taskLogUrl + "&all=true";
                        out.print("<a href=\"" + tailFourKBUrl + "\">Last 4KB</a><br/>");
                        out.print("<a href=\"" + tailEightKBUrl + "\">Last 8KB</a><br/>");
                        out.print("<a href=\"" + entireLogUrl + "\">All</a><br/>");
                    }
                    out.println("</td><td><a href=\"/taskstats.jsp?jobid=" + jobid + "&tipid=" + tipid + "&taskid=" + status.getTaskId() + "\">" + status.getCounters().size() + "</a></td></tr>");
                }
            }
            out.write("\n</table>\n</center>\n\n<hr>\n<a href=\"/jobdetails.jsp?jobid=");
            out.print(jobid);
            out.write("\">Go back to the job</a><br>\n<a href=\"/jobtracker.jsp\">Go back to JobTracker</a><br>\n<a href=\"http://lucene.apache.org/hadoop\">Hadoop</a>, 2006.<br>\n</body>\n</html>\n");
            if (_jspxFactory == null) return;
        }
        catch (Throwable t) {
            try {
                if (t instanceof SkipPageException) return;
                out = _jspx_out;
                if (out != null && out.getBufferSize() != 0) {
                    out.clearBuffer();
                }
                if (_jspx_page_context == null) return;
                _jspx_page_context.handlePageException(t);
                return;
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                if (_jspxFactory != null) {
                    _jspxFactory.releasePageContext(_jspx_page_context);
                }
            }
        }
        _jspxFactory.releasePageContext(_jspx_page_context);
        return;
    }
}

