/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred.lib.aggregate;

import java.util.ArrayList;
import java.util.Map;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.lib.aggregate.DoubleValueSum;
import org.apache.hadoop.mapred.lib.aggregate.LongValueMax;
import org.apache.hadoop.mapred.lib.aggregate.LongValueMin;
import org.apache.hadoop.mapred.lib.aggregate.LongValueSum;
import org.apache.hadoop.mapred.lib.aggregate.StringValueMax;
import org.apache.hadoop.mapred.lib.aggregate.StringValueMin;
import org.apache.hadoop.mapred.lib.aggregate.UniqValueCount;
import org.apache.hadoop.mapred.lib.aggregate.ValueAggregator;
import org.apache.hadoop.mapred.lib.aggregate.ValueAggregatorDescriptor;
import org.apache.hadoop.mapred.lib.aggregate.ValueHistogram;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ValueAggregatorBaseDescriptor
implements ValueAggregatorDescriptor {
    public static final String UNIQ_VALUE_COUNT = "UniqValueCount";
    public static final String LONG_VALUE_SUM = "LongValueSum";
    public static final String DOUBLE_VALUE_SUM = "DoubleValueSum";
    public static final String VALUE_HISTOGRAM = "ValueHistogram";
    public static final String LONG_VALUE_MAX = "LongValueMax";
    public static final String LONG_VALUE_MIN = "LongValueMin";
    public static final String STRING_VALUE_MAX = "StringValueMax";
    public static final String STRING_VALUE_MIN = "StringValueMin";
    public String inputFile = null;

    public static Map.Entry generateEntry(String type, String id, Object val) {
        Text key = new Text(type + ":" + id);
        return new MyEntry(key, val);
    }

    public static ValueAggregator generateValueAggregator(String type) {
        ValueAggregator retv = null;
        if (type.compareToIgnoreCase(LONG_VALUE_SUM) == 0) {
            retv = new LongValueSum();
        }
        if (type.compareToIgnoreCase(LONG_VALUE_MAX) == 0) {
            retv = new LongValueMax();
        } else if (type.compareToIgnoreCase(LONG_VALUE_MIN) == 0) {
            retv = new LongValueMin();
        } else if (type.compareToIgnoreCase(STRING_VALUE_MAX) == 0) {
            retv = new StringValueMax();
        } else if (type.compareToIgnoreCase(STRING_VALUE_MIN) == 0) {
            retv = new StringValueMin();
        } else if (type.compareToIgnoreCase(DOUBLE_VALUE_SUM) == 0) {
            retv = new DoubleValueSum();
        } else if (type.compareToIgnoreCase(UNIQ_VALUE_COUNT) == 0) {
            retv = new UniqValueCount();
        } else if (type.compareToIgnoreCase(VALUE_HISTOGRAM) == 0) {
            retv = new ValueHistogram();
        }
        return retv;
    }

    @Override
    public ArrayList<Map.Entry> generateKeyValPairs(Object key, Object val) {
        ArrayList<Map.Entry> retv = new ArrayList<Map.Entry>();
        String countType = LONG_VALUE_SUM;
        String id = "record_count";
        Map.Entry e = ValueAggregatorBaseDescriptor.generateEntry(countType, id, ONE);
        if (e != null) {
            retv.add(e);
        }
        if (this.inputFile != null && (e = ValueAggregatorBaseDescriptor.generateEntry(countType, this.inputFile, ONE)) != null) {
            retv.add(e);
        }
        return retv;
    }

    @Override
    public void configure(JobConf job) {
        this.inputFile = job.get("map.input.file");
    }

    private static class MyEntry
    implements Map.Entry {
        Object key;
        Object val;

        public Object getKey() {
            return this.key;
        }

        public Object getValue() {
            return this.val;
        }

        public Object setValue(Object val) {
            this.val = val;
            return val;
        }

        public MyEntry(Object key, Object val) {
            this.key = key;
            this.val = val;
        }
    }
}

