/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.IOException;
import java.text.DecimalFormat;
import java.util.Date;
import java.util.List;
import java.util.Vector;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.servlet.jsp.JspFactory;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.SkipPageException;
import org.apache.hadoop.mapred.Counters;
import org.apache.hadoop.mapred.JobInProgress;
import org.apache.hadoop.mapred.JobProfile;
import org.apache.hadoop.mapred.JobStatus;
import org.apache.hadoop.mapred.JobTracker;
import org.apache.hadoop.mapred.TaskInProgress;
import org.apache.hadoop.util.StringUtils;
import org.apache.jasper.runtime.HttpJspBase;
import org.apache.jasper.runtime.JspSourceDependent;

public final class jobdetails_jsp
extends HttpJspBase
implements JspSourceDependent {
    JobTracker tracker = JobTracker.getTracker();
    String trackerName = StringUtils.simpleHostname(this.tracker.getJobTrackerMachine());
    private static Vector _jspx_dependants;

    private void printTaskSummary(JspWriter out, String jobId, String kind, double completePercent, TaskInProgress[] tasks) throws IOException {
        int totalTasks = tasks.length;
        int runningTasks = 0;
        int finishedTasks = 0;
        int killedTasks = 0;
        int failedTaskAttempts = 0;
        int killedTaskAttempts = 0;
        for (int i = 0; i < totalTasks; ++i) {
            TaskInProgress task = tasks[i];
            if (task.isComplete()) {
                ++finishedTasks;
            } else if (task.isRunning()) {
                ++runningTasks;
            } else if (task.wasKilled()) {
                ++killedTasks;
            }
            failedTaskAttempts += task.numTaskFailures();
            killedTaskAttempts += task.numKilledTasks();
        }
        out.print("<tr><th><a href=\"/jobtasks.jsp?jobid=" + jobId + "&type=" + kind + "&pagenum=1\">" + kind + "</a></th><td align=\"right\">" + StringUtils.formatPercent(completePercent, 2) + "</td><td align=\"right\">" + totalTasks + "</td><td align=\"right\">" + (totalTasks - runningTasks - finishedTasks - killedTasks) + "</td><td align=\"right\">" + runningTasks + "</td><td align=\"right\">" + finishedTasks + "</td><td align=\"right\">" + killedTasks + "</td><td align=\"right\">" + (failedTaskAttempts > 0 ? new String("<a href=\"/jobfailures.jsp?jobid=" + jobId + "&kind=" + kind + "&cause=failed\">" + failedTaskAttempts + "</a>") : "0") + " / " + (killedTaskAttempts > 0 ? new String("<a href=\"/jobfailures.jsp?jobid=" + jobId + "&kind=" + kind + "&cause=killed\">" + killedTaskAttempts + "</a>") : "0") + "</td></tr>\n");
    }

    public List getDependants() {
        return _jspx_dependants;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void _jspService(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        JobInProgress job;
        String jobId;
        PageContext _jspx_page_context;
        JspWriter _jspx_out;
        JspWriter out;
        JspFactory _jspxFactory;
        block23: {
            _jspxFactory = null;
            PageContext pageContext = null;
            HttpSession session = null;
            ServletContext application = null;
            ServletConfig config = null;
            out = null;
            jobdetails_jsp page = this;
            _jspx_out = null;
            _jspx_page_context = null;
            _jspxFactory = JspFactory.getDefaultFactory();
            response.setContentType("text/html; charset=UTF-8");
            _jspx_page_context = pageContext = _jspxFactory.getPageContext((Servlet)this, (ServletRequest)request, (ServletResponse)response, null, true, 8192, true);
            application = pageContext.getServletContext();
            config = pageContext.getServletConfig();
            session = pageContext.getSession();
            _jspx_out = out = pageContext.getOut();
            out.write(10);
            out.write(10);
            out.write("       \n");
            jobId = request.getParameter("jobid");
            String refreshParam = request.getParameter("refresh");
            int refresh = 60;
            if (refreshParam != null) {
                try {
                    refresh = Integer.parseInt(refreshParam);
                }
                catch (NumberFormatException ignored) {
                    // empty catch block
                }
            }
            out.write("\n\n<html>\n<head>\n  ");
            if (refresh != 0) {
                out.write("\n      <meta http-equiv=\"refresh\" content=\"");
                out.print(refresh);
                out.write("\">\n      ");
            }
            out.write("\n<title>Hadoop ");
            out.print(jobId);
            out.write(" on ");
            out.print(this.trackerName);
            out.write("</title>\n</head>\n<body>\n<h1>Hadoop ");
            out.print(jobId);
            out.write(" on <a href=\"/jobtracker.jsp\">");
            out.print(this.trackerName);
            out.write("</a></h1>\n\n");
            job = this.tracker.getJob(jobId);
            if (job != null) break block23;
            out.print("<b>Job " + jobId + " not found.</b><br>\n");
            if (_jspxFactory == null) return;
            _jspxFactory.releasePageContext(_jspx_page_context);
            return;
        }
        try {
            JobProfile profile = job.getProfile();
            JobStatus status = job.getStatus();
            int runState = status.getRunState();
            int flakyTaskTrackers = job.getNoOfBlackListedTrackers();
            out.print("<b>User:</b> " + profile.getUser() + "<br>\n");
            out.print("<b>Job Name:</b> " + profile.getJobName() + "<br>\n");
            if (runState == 1) {
                out.print("<b>Job File:</b> <a href=\"/jobconf.jsp?jobid=" + jobId + "\">" + profile.getJobFile() + "</a><br>\n");
            } else {
                out.print("<b>Job File:</b> " + profile.getJobFile() + "<br>\n");
            }
            out.print("<b>Started at:</b> " + new Date(job.getStartTime()) + "<br>\n");
            if (runState == 1) {
                out.print("<b>Status:</b> Running<br>\n");
            } else {
                if (runState == 2) {
                    out.print("<b>Status:</b> Succeeded<br>\n");
                } else if (runState == 3) {
                    out.print("<b>Status:</b> Failed<br>\n");
                }
                out.print("<b>Finished at:</b> " + new Date(job.getFinishTime()) + "<br>\n");
            }
            if (flakyTaskTrackers > 0) {
                out.print("<b>Black-listed TaskTrackers:</b> <a href=\"/jobblacklistedtrackers.jsp?jobid=" + jobId + "\">" + flakyTaskTrackers + "</a><br>\n");
            }
            out.print("<hr>\n");
            out.print("<table border=2 cellpadding=\"5\" cellspacing=\"2\">");
            out.print("<tr><th>Kind</th><th>% Complete</th><th>Num Tasks</th><th>Pending</th><th>Running</th><th>Complete</th><th>Killed</th><th><a href=\"/jobfailures.jsp?jobid=" + jobId + "\">Failed/Killed<br>Task Attempts</a></th></tr>\n");
            this.printTaskSummary(out, jobId, "map", status.mapProgress(), job.getMapTasks());
            this.printTaskSummary(out, jobId, "reduce", status.reduceProgress(), job.getReduceTasks());
            out.print("</table>\n");
            out.write("\n    <p/>\n    <table border=2 cellpadding=\"5\" cellspacing=\"2\">\n    <tr>\n      <th><br/></th>\n      <th>Counter</th>\n      <th>Map</th>\n      <th>Reduce</th>\n      <th>Total</th>\n    </tr>\n    ");
            Counters mapCounters = job.getMapCounters();
            Counters reduceCounters = job.getReduceCounters();
            Counters totalCounters = job.getCounters();
            for (String groupName : totalCounters.getGroupNames()) {
                Counters.Group totalGroup = totalCounters.getGroup(groupName);
                Counters.Group mapGroup = mapCounters.getGroup(groupName);
                Counters.Group reduceGroup = reduceCounters.getGroup(groupName);
                DecimalFormat decimal = new DecimalFormat();
                boolean isFirst = true;
                for (String counter : totalGroup.getCounterNames()) {
                    String mapValue = decimal.format((Object)mapGroup.getCounter(counter));
                    String reduceValue = decimal.format((Object)reduceGroup.getCounter(counter));
                    String totalValue = decimal.format((Object)totalGroup.getCounter(counter));
                    out.write("\n        <tr>\n          ");
                    if (isFirst) {
                        isFirst = false;
                        out.write("\n            <td rowspan=\"");
                        out.print(totalGroup.size());
                        out.write(34);
                        out.write(62);
                        out.print(totalGroup.getDisplayName());
                        out.write("</td>\n            ");
                    }
                    out.write("\n          <td>");
                    out.print(totalGroup.getDisplayName(counter));
                    out.write("</td>\n          <td align=\"right\">");
                    out.print(mapValue);
                    out.write("</td>\n          <td align=\"right\">");
                    out.print(reduceValue);
                    out.write("</td>\n          <td align=\"right\">");
                    out.print(totalValue);
                    out.write("</td>\n        </tr>\n        ");
                }
            }
            out.write("\n    </table>\n\n<hr>\n<a href=\"/jobtracker.jsp\">Go back to JobTracker</a><br>\n<a href=\"http://lucene.apache.org/hadoop\">Hadoop</a>, 2006.<br>\n</body>\n</html>\n");
            if (_jspxFactory == null) return;
        }
        catch (Throwable t) {
            try {
                if (t instanceof SkipPageException) return;
                out = _jspx_out;
                if (out != null && out.getBufferSize() != 0) {
                    out.clearBuffer();
                }
                if (_jspx_page_context == null) return;
                _jspx_page_context.handlePageException(t);
                return;
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                if (_jspxFactory != null) {
                    _jspxFactory.releasePageContext(_jspx_page_context);
                }
            }
        }
        _jspxFactory.releasePageContext(_jspx_page_context);
        return;
    }
}

