/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.BindException;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.regex.Pattern;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.fs.DF;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FSError;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalDirAllocator;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.ipc.RemoteException;
import org.apache.hadoop.ipc.Server;
import org.apache.hadoop.mapred.Counters;
import org.apache.hadoop.mapred.DisallowedTaskTrackerException;
import org.apache.hadoop.mapred.HeartbeatResponse;
import org.apache.hadoop.mapred.InterTrackerProtocol;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.JobTracker;
import org.apache.hadoop.mapred.KillJobAction;
import org.apache.hadoop.mapred.KillTaskAction;
import org.apache.hadoop.mapred.LaunchTaskAction;
import org.apache.hadoop.mapred.MRConstants;
import org.apache.hadoop.mapred.MapOutputFile;
import org.apache.hadoop.mapred.ReduceTask;
import org.apache.hadoop.mapred.StatusHttpServer;
import org.apache.hadoop.mapred.Task;
import org.apache.hadoop.mapred.TaskCompletionEvent;
import org.apache.hadoop.mapred.TaskRunner;
import org.apache.hadoop.mapred.TaskStatus;
import org.apache.hadoop.mapred.TaskTrackerAction;
import org.apache.hadoop.mapred.TaskTrackerStatus;
import org.apache.hadoop.mapred.TaskUmbilicalProtocol;
import org.apache.hadoop.metrics.MetricsContext;
import org.apache.hadoop.metrics.MetricsException;
import org.apache.hadoop.metrics.MetricsRecord;
import org.apache.hadoop.metrics.MetricsUtil;
import org.apache.hadoop.net.DNS;
import org.apache.hadoop.util.DiskChecker;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.hadoop.util.RunJar;
import org.apache.hadoop.util.StringUtils;
import org.apache.log4j.LogManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaskTracker
implements MRConstants,
TaskUmbilicalProtocol,
Runnable {
    static final long WAIT_FOR_DONE = 3000L;
    private int httpPort;
    public static final Log LOG = LogFactory.getLog((String)"org.apache.hadoop.mapred.TaskTracker");
    private boolean running = true;
    private LocalDirAllocator localDirAllocator;
    String taskTrackerName;
    String localHostname;
    InetSocketAddress jobTrackAddr;
    String taskReportBindAddress;
    int taskReportPort;
    Server taskReportServer = null;
    InterTrackerProtocol jobClient;
    short heartbeatResponseId = (short)-1;
    TaskTrackerStatus status = null;
    StatusHttpServer server = null;
    boolean shuttingDown = false;
    Map<String, TaskInProgress> tasks = new HashMap<String, TaskInProgress>();
    Map<String, TaskInProgress> runningTasks = null;
    Map<String, RunningJob> runningJobs = null;
    int mapTotal = 0;
    int reduceTotal = 0;
    boolean justStarted = true;
    Map<String, DF> localDirsDf = new HashMap<String, DF>();
    long minSpaceStart = 0L;
    boolean acceptNewTasks = true;
    long minSpaceKill = 0L;
    static Random r = new Random();
    FileSystem fs = null;
    private static final String SUBDIR = "taskTracker";
    private static final String CACHEDIR = "archive";
    private static final String JOBCACHE = "jobcache";
    private JobConf fConf;
    private MapOutputFile mapOutputFile;
    private int maxCurrentTasks;
    private int failures;
    private int[] finishedCount = new int[1];
    private MapEventsFetcherThread mapEventsFetcher;
    private static final long MIN_POLL_INTERVAL = 5000L;
    private int probe_sample_size = 50;
    private TaskTrackerMetrics myMetrics = null;
    private BlockingQueue<TaskTrackerAction> tasksToCleanup = new LinkedBlockingQueue<TaskTrackerAction>();
    private Thread taskCleanupThread = new Thread(new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (true) {
                try {
                    while (true) {
                        TaskTrackerAction action;
                        if ((action = (TaskTrackerAction)TaskTracker.this.tasksToCleanup.take()) instanceof KillJobAction) {
                            TaskTracker.this.purgeJob((KillJobAction)action);
                            continue;
                        }
                        if (action instanceof KillTaskAction) {
                            TaskInProgress tip;
                            KillTaskAction killAction = (KillTaskAction)action;
                            TaskTracker taskTracker = TaskTracker.this;
                            synchronized (taskTracker) {
                                tip = TaskTracker.this.tasks.get(killAction.getTaskId());
                            }
                            LOG.info((Object)("Received KillTaskAction for task: " + killAction.getTaskId()));
                            TaskTracker.this.purgeTask(tip);
                            continue;
                        }
                        LOG.error((Object)("Non-delete action given to cleanup thread: " + action));
                    }
                }
                catch (Throwable except) {
                    LOG.warn((Object)StringUtils.stringifyException(except));
                    continue;
                }
                break;
            }
        }
    }, "taskCleanup");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RunningJob addTaskToJob(String jobId, Path localJobFile, TaskInProgress tip) {
        Map<String, RunningJob> map = this.runningJobs;
        synchronized (map) {
            RunningJob rJob = null;
            if (!this.runningJobs.containsKey(jobId)) {
                rJob = new RunningJob(jobId, localJobFile);
                rJob.localized = false;
                rJob.tasks = new HashSet<TaskInProgress>();
                rJob.jobFile = localJobFile;
                this.runningJobs.put(jobId, rJob);
            } else {
                rJob = this.runningJobs.get(jobId);
            }
            RunningJob runningJob = rJob;
            synchronized (runningJob) {
                rJob.tasks.add(tip);
            }
            this.runningJobs.notify();
            return rJob;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeTaskFromJob(String jobId, TaskInProgress tip) {
        Map<String, RunningJob> map = this.runningJobs;
        synchronized (map) {
            RunningJob rjob = this.runningJobs.get(jobId);
            if (rjob == null) {
                LOG.warn((Object)("Unknown job " + jobId + " being deleted."));
            } else {
                RunningJob runningJob = rjob;
                synchronized (runningJob) {
                    rjob.tasks.remove(tip);
                    if (rjob.tasks.isEmpty()) {
                        this.runningJobs.remove(jobId);
                    }
                }
            }
        }
    }

    static String getCacheSubdir() {
        return "taskTracker/archive";
    }

    static String getJobCacheSubdir() {
        return "taskTracker/jobcache";
    }

    @Override
    public long getProtocolVersion(String protocol, long clientVersion) throws IOException {
        if (protocol.equals(TaskUmbilicalProtocol.class.getName())) {
            return 2L;
        }
        throw new IOException("Unknown protocol for task tracker: " + protocol);
    }

    synchronized void initialize() throws IOException {
        this.localHostname = DNS.getDefaultHost(this.fConf.get("mapred.tasktracker.dns.interface", "default"), this.fConf.get("mapred.tasktracker.dns.nameserver", "default"));
        TaskTracker.checkLocalDirs(this.fConf.getLocalDirs());
        this.fConf.deleteLocalFiles(SUBDIR);
        this.tasks.clear();
        this.runningTasks = new TreeMap<String, TaskInProgress>();
        this.runningJobs = new TreeMap<String, RunningJob>();
        this.mapTotal = 0;
        this.reduceTotal = 0;
        this.acceptNewTasks = true;
        this.status = null;
        this.minSpaceStart = this.fConf.getLong("mapred.local.dir.minspacestart", 0L);
        this.minSpaceKill = this.fConf.getLong("mapred.local.dir.minspacekill", 0L);
        int numCopiers = this.fConf.getInt("mapred.reduce.parallel.copies", 5);
        this.probe_sample_size = Math.max(numCopiers * 5, 50);
        this.myMetrics = new TaskTrackerMetrics();
        this.taskReportPort = this.fConf.getInt("mapred.task.tracker.report.port", 50050);
        this.taskReportBindAddress = this.fConf.get("mapred.task.tracker.report.bindAddress", "0.0.0.0");
        while (true) {
            try {
                this.taskReportServer = RPC.getServer(this, this.taskReportBindAddress, this.taskReportPort, this.maxCurrentTasks, false, this.fConf);
                this.taskReportServer.start();
            }
            catch (BindException e) {
                LOG.info((Object)("Could not open report server at " + this.taskReportPort + ", trying new port"));
                ++this.taskReportPort;
                continue;
            }
            break;
        }
        this.taskReportPort = this.taskReportServer.getListenerAddress().getPort();
        this.fConf.setInt("mapred.task.tracker.report.port", this.taskReportPort);
        LOG.info((Object)("TaskTracker up at: " + this.taskReportPort));
        this.taskTrackerName = "tracker_" + this.localHostname + ":" + this.taskReportPort;
        LOG.info((Object)("Starting tracker " + this.taskTrackerName));
        this.mapOutputFile.cleanupStorage();
        this.justStarted = true;
        this.jobClient = (InterTrackerProtocol)RPC.waitForProxy(InterTrackerProtocol.class, 5L, this.jobTrackAddr, this.fConf);
        this.running = true;
        this.mapEventsFetcher = new MapEventsFetcherThread();
        this.mapEventsFetcher.setDaemon(true);
        this.mapEventsFetcher.setName("Map-events fetcher for all reduce tasks on " + this.taskTrackerName);
        this.mapEventsFetcher.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void localizeJob(TaskInProgress tip) throws IOException {
        RunningJob rjob;
        Path localJarFile = null;
        Task t = tip.getTask();
        String jobId = t.getJobId();
        Path localJobFile = new Path(this.fConf.getLocalPath(TaskTracker.getJobCacheSubdir()), jobId + "/" + "job.xml");
        RunningJob runningJob = rjob = this.addTaskToJob(jobId, localJobFile, tip);
        synchronized (runningJob) {
            if (!rjob.localized) {
                Path jobDir;
                localJarFile = new Path(this.fConf.getLocalPath(TaskTracker.getJobCacheSubdir()), jobId + "/" + "job.jar");
                String jobFile = t.getJobFile();
                LocalFileSystem localFs = FileSystem.getLocal(this.fConf);
                if (((FileSystem)localFs).exists(jobDir = localJobFile.getParent())) {
                    ((FileSystem)localFs).delete(jobDir);
                    boolean b = ((FileSystem)localFs).mkdirs(jobDir);
                    if (!b) {
                        throw new IOException("Not able to create job directory " + jobDir.toString());
                    }
                }
                this.fs.copyToLocalFile(new Path(jobFile), localJobFile);
                JobConf localJobConf = new JobConf(localJobFile);
                String jarFile = localJobConf.getJar();
                if (jarFile != null) {
                    this.fs.copyToLocalFile(new Path(jarFile), localJarFile);
                    localJobConf.setJar(localJarFile.toString());
                    FSDataOutputStream out = localFs.create(localJobFile);
                    try {
                        localJobConf.write(out);
                    }
                    finally {
                        ((OutputStream)out).close();
                    }
                    File workDir = new File(new File(localJobFile.toString()).getParent(), "work");
                    if (!workDir.mkdirs() && !workDir.isDirectory()) {
                        throw new IOException("Mkdirs failed to create " + workDir.toString());
                    }
                    RunJar.unJar(new File(localJarFile.toString()), workDir);
                }
                rjob.keepJobFiles = localJobConf.getKeepTaskFilesPattern() != null || localJobConf.getKeepFailedTaskFiles();
                rjob.localized = true;
            }
        }
        this.launchTaskForJob(tip, new JobConf(rjob.jobFile));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void launchTaskForJob(TaskInProgress tip, JobConf jobConf) throws IOException {
        TaskInProgress taskInProgress = tip;
        synchronized (taskInProgress) {
            try {
                tip.setJobConf(jobConf);
                tip.launchTask();
            }
            catch (Throwable ie) {
                tip.runstate = TaskStatus.State.FAILED;
                try {
                    tip.cleanup();
                }
                catch (Throwable ie2) {
                    // empty catch block
                }
                String error = StringUtils.stringifyException(ie);
                tip.reportDiagnosticInfo(error);
                LOG.info((Object)error);
            }
        }
    }

    public synchronized void shutdown() throws IOException {
        this.shuttingDown = true;
        this.close();
        if (this.server != null) {
            try {
                LOG.info((Object)"Shutting down StatusHttpServer");
                this.server.stop();
            }
            catch (InterruptedException ex) {
                ex.printStackTrace();
            }
        }
    }

    public synchronized void close() throws IOException {
        TreeMap<String, TaskInProgress> tasksToClose = new TreeMap<String, TaskInProgress>();
        tasksToClose.putAll(this.tasks);
        for (TaskInProgress tip : tasksToClose.values()) {
            tip.jobHasFinished();
        }
        new Thread("RPC shutdown"){

            public void run() {
                if (TaskTracker.this.taskReportServer != null) {
                    TaskTracker.this.taskReportServer.stop();
                    TaskTracker.this.taskReportServer = null;
                }
            }
        }.start();
        this.running = false;
        this.mapOutputFile.cleanupStorage();
        this.mapEventsFetcher.interrupt();
    }

    public TaskTracker(JobConf conf) throws IOException {
        this.taskCleanupThread.setDaemon(true);
        this.taskCleanupThread.start();
        this.maxCurrentTasks = conf.getInt("mapred.tasktracker.tasks.maximum", 2);
        this.fConf = conf;
        this.jobTrackAddr = JobTracker.getAddress(conf);
        this.mapOutputFile = new MapOutputFile();
        this.mapOutputFile.setConf(conf);
        int httpPort = conf.getInt("tasktracker.http.port", 50060);
        String httpBindAddress = conf.get("tasktracker.http.bindAddress", "0.0.0.0");
        this.server = new StatusHttpServer("task", httpBindAddress, httpPort, true);
        int workerThreads = conf.getInt("tasktracker.http.threads", 40);
        this.server.setThreads(1, workerThreads);
        LocalFileSystem local = FileSystem.getLocal(conf);
        this.localDirAllocator = new LocalDirAllocator("mapred.local.dir");
        this.server.setAttribute("task.tracker", this);
        this.server.setAttribute("local.file.system", local);
        this.server.setAttribute("conf", conf);
        this.server.setAttribute("log", LOG);
        this.server.setAttribute("localDirAllocator", this.localDirAllocator);
        this.server.addServlet("mapOutput", "/mapOutput", MapOutputServlet.class);
        this.server.start();
        this.httpPort = this.server.getPort();
        this.initialize();
    }

    public InterTrackerProtocol getJobClient() {
        return this.jobClient;
    }

    public FileSystem getFileSystem() {
        return this.fs;
    }

    private List<TaskCompletionEvent> queryJobTracker(IntWritable fromEventId, String jobId, InterTrackerProtocol jobClient) throws IOException {
        TaskCompletionEvent[] t = jobClient.getTaskCompletionEvents(jobId, fromEventId.get(), this.probe_sample_size);
        ArrayList<TaskCompletionEvent> recentMapEvents = new ArrayList<TaskCompletionEvent>();
        for (int i = 0; i < t.length; ++i) {
            if (!t[i].isMap) continue;
            recentMapEvents.add(t[i]);
        }
        fromEventId.set(fromEventId.get() + t.length);
        return recentMapEvents;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    State offerService() throws Exception {
        long lastHeartbeat = 0L;
        this.fs = FileSystem.getNamed(this.jobClient.getFilesystemName(), this.fConf);
        while (this.running) {
            String msg;
            if (this.shuttingDown) return State.NORMAL;
            try {
                long now = System.currentTimeMillis();
                long waitTime = 10000L - (now - lastHeartbeat);
                if (waitTime > 0L) {
                    int[] nArray = this.finishedCount;
                    // MONITORENTER : this.finishedCount
                    if (this.finishedCount[0] == 0) {
                        this.finishedCount.wait(waitTime);
                    }
                    this.finishedCount[0] = 0;
                    // MONITOREXIT : nArray
                }
                HeartbeatResponse heartbeatResponse = this.transmitHeartBeat();
                TaskTrackerAction[] actions = heartbeatResponse.getActions();
                LOG.debug((Object)("Got heartbeatResponse from JobTracker with responseId: " + heartbeatResponse.getResponseId() + " and " + (actions != null ? actions.length : 0) + " actions"));
                if (this.reinitTaskTracker(actions)) {
                    return State.STALE;
                }
                lastHeartbeat = now;
                this.justStarted = false;
                if (actions != null) {
                    for (TaskTrackerAction action : actions) {
                        if (action instanceof LaunchTaskAction) {
                            this.startNewTask((LaunchTaskAction)action);
                            continue;
                        }
                        this.tasksToCleanup.put(action);
                    }
                }
                this.markUnresponsiveTasks();
                this.killOverflowingTasks();
                if (this.acceptNewTasks || !this.isIdle()) continue;
                this.acceptNewTasks = true;
            }
            catch (InterruptedException ie) {
                LOG.info((Object)"Interrupted. Closing down.");
                return State.INTERRUPTED;
            }
            catch (DiskChecker.DiskErrorException de) {
                msg = "Exiting task tracker for disk error:\n" + StringUtils.stringifyException(de);
                LOG.error((Object)msg);
                this.jobClient.reportTaskTrackerError(this.taskTrackerName, "DiskErrorException", msg);
                return State.STALE;
            }
            catch (RemoteException re) {
                String reClass = re.getClassName();
                if (!DisallowedTaskTrackerException.class.getName().equals(reClass)) continue;
                LOG.info((Object)"Tasktracker disallowed by JobTracker.");
                return State.DENIED;
            }
            catch (Exception except) {
                msg = "Caught exception: " + StringUtils.stringifyException(except);
                LOG.error((Object)msg);
            }
        }
        return State.NORMAL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HeartbeatResponse transmitHeartBeat() throws IOException {
        boolean askForNewTask;
        Object taskReports;
        if (this.status == null) {
            TaskTracker taskTracker = this;
            synchronized (taskTracker) {
                taskReports = new ArrayList(this.runningTasks.size());
                for (TaskInProgress tip : this.runningTasks.values()) {
                    taskReports.add(tip.createStatus());
                }
                this.status = new TaskTrackerStatus(this.taskTrackerName, this.localHostname, this.httpPort, (List<TaskStatus>)taskReports, this.failures);
            }
        } else {
            LOG.info((Object)("Resending 'status' to '" + this.jobTrackAddr.getHostName() + "' with reponseId '" + this.heartbeatResponseId));
        }
        taskReports = this;
        synchronized (taskReports) {
            askForNewTask = (this.mapTotal < this.maxCurrentTasks || this.reduceTotal < this.maxCurrentTasks) && this.acceptNewTasks;
        }
        if (askForNewTask) {
            TaskTracker.checkLocalDirs(this.fConf.getLocalDirs());
            askForNewTask = this.enoughFreeSpace(this.minSpaceStart);
        }
        HeartbeatResponse heartbeatResponse = this.jobClient.heartbeat(this.status, this.justStarted, askForNewTask, this.heartbeatResponseId);
        this.heartbeatResponseId = heartbeatResponse.getResponseId();
        TaskTracker taskTracker = this;
        synchronized (taskTracker) {
            for (TaskStatus taskStatus : this.status.getTaskReports()) {
                if (taskStatus.getRunState() == TaskStatus.State.RUNNING) continue;
                if (taskStatus.getIsMap()) {
                    --this.mapTotal;
                } else {
                    --this.reduceTotal;
                }
                try {
                    this.myMetrics.completeTask();
                    this.myMetrics.update();
                }
                catch (MetricsException me) {
                    LOG.warn((Object)("Caught: " + StringUtils.stringifyException(me)));
                }
                this.runningTasks.remove(taskStatus.getTaskId());
            }
        }
        this.status = null;
        return heartbeatResponse;
    }

    private boolean reinitTaskTracker(TaskTrackerAction[] actions) {
        if (actions != null) {
            for (TaskTrackerAction action : actions) {
                if (action.getActionId() != TaskTrackerAction.ActionType.REINIT_TRACKER) continue;
                LOG.info((Object)"Recieved RenitTrackerAction from JobTracker");
                return true;
            }
        }
        return false;
    }

    private synchronized void markUnresponsiveTasks() throws IOException {
        long now = System.currentTimeMillis();
        for (TaskInProgress tip : this.runningTasks.values()) {
            long timeSinceLastReport;
            long jobTaskTimeout;
            if (tip.getRunState() != TaskStatus.State.RUNNING || (jobTaskTimeout = tip.getTaskTimeout()) == 0L || (timeSinceLastReport = now - tip.getLastProgressReport()) <= jobTaskTimeout || tip.wasKilled) continue;
            String msg = "Task failed to report status for " + timeSinceLastReport / 1000L + " seconds. Killing.";
            LOG.info((Object)(tip.getTask().getTaskId() + ": " + msg));
            ReflectionUtils.logThreadInfo(LOG, "lost task", 30L);
            tip.reportDiagnosticInfo(msg);
            this.purgeTask(tip);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void purgeJob(KillJobAction action) throws IOException {
        String jobId = action.getJobId();
        LOG.info((Object)("Received 'KillJobAction' for job: " + jobId));
        RunningJob rjob = null;
        Map<String, RunningJob> map = this.runningJobs;
        synchronized (map) {
            rjob = this.runningJobs.get(jobId);
        }
        if (rjob == null) {
            LOG.warn((Object)("Unknown job " + jobId + " being deleted."));
        } else {
            map = rjob;
            synchronized (map) {
                for (TaskInProgress tip : rjob.tasks) {
                    tip.jobHasFinished();
                }
                if (!rjob.keepJobFiles) {
                    this.fConf.deleteLocalFiles("taskTracker/jobcache/" + rjob.getJobId());
                }
                rjob.tasks.clear();
            }
        }
        map = this.runningJobs;
        synchronized (map) {
            this.runningJobs.remove(jobId);
        }
    }

    private void purgeTask(TaskInProgress tip) throws IOException {
        if (tip != null) {
            LOG.info((Object)("About to purge task: " + tip.getTask().getTaskId()));
            this.removeTaskFromJob(tip.getTask().getJobId(), tip);
            tip.jobHasFinished();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void killOverflowingTasks() throws IOException {
        if (!this.enoughFreeSpace(this.minSpaceKill)) {
            this.acceptNewTasks = false;
            TaskTracker taskTracker = this;
            synchronized (taskTracker) {
                TaskInProgress killMe = this.findTaskToKill();
                if (killMe != null) {
                    String msg = "Tasktracker running out of space. Killing task.";
                    LOG.info((Object)(killMe.getTask().getTaskId() + ": " + msg));
                    killMe.reportDiagnosticInfo(msg);
                    this.purgeTask(killMe);
                }
            }
        }
    }

    private TaskInProgress findTaskToKill() {
        TaskInProgress killMe = null;
        for (TaskInProgress tip : this.runningTasks.values()) {
            if (tip.getRunState() != TaskStatus.State.RUNNING || tip.wasKilled) continue;
            if (killMe == null) {
                killMe = tip;
                continue;
            }
            if (!tip.getTask().isMapTask()) {
                if (!killMe.getTask().isMapTask() && !(tip.getTask().getProgress().get() < killMe.getTask().getProgress().get())) continue;
                killMe = tip;
                continue;
            }
            if (!killMe.getTask().isMapTask() || !(tip.getTask().getProgress().get() < killMe.getTask().getProgress().get())) continue;
            killMe = tip;
        }
        return killMe;
    }

    private boolean enoughFreeSpace(long minSpace) throws IOException {
        if (minSpace == 0L) {
            return true;
        }
        String[] localDirs = this.fConf.getLocalDirs();
        for (int i = 0; i < localDirs.length; ++i) {
            DF df = null;
            if (this.localDirsDf.containsKey(localDirs[i])) {
                df = this.localDirsDf.get(localDirs[i]);
            } else {
                df = new DF(new File(localDirs[i]), this.fConf);
                this.localDirsDf.put(localDirs[i], df);
            }
            if (df.getAvailable() >= minSpace) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startNewTask(LaunchTaskAction action) {
        block9: {
            Task t = action.getTask();
            LOG.info((Object)("LaunchTaskAction: " + t.getTaskId()));
            TaskInProgress tip = new TaskInProgress(t, this.fConf);
            TaskTracker taskTracker = this;
            synchronized (taskTracker) {
                this.tasks.put(t.getTaskId(), tip);
                this.runningTasks.put(t.getTaskId(), tip);
                boolean isMap = t.isMapTask();
                if (isMap) {
                    ++this.mapTotal;
                } else {
                    ++this.reduceTotal;
                }
                this.myMetrics.update();
            }
            try {
                this.localizeJob(tip);
            }
            catch (Throwable e) {
                String msg = "Error initializing " + tip.getTask().getTaskId() + ":\n" + StringUtils.stringifyException(e);
                LOG.warn((Object)msg);
                tip.reportDiagnosticInfo(msg);
                try {
                    tip.killAndCleanup(true);
                }
                catch (IOException ie2) {
                    LOG.info((Object)("Error cleaning up " + tip.getTask().getTaskId() + ":\n" + StringUtils.stringifyException(ie2)));
                }
                if (!(e instanceof Error)) break block9;
                throw (Error)e;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        try {
            boolean denied = false;
            while (true) {
                if (!this.running || this.shuttingDown || denied) {
                    if (!denied) return;
                    this.shutdown();
                    return;
                }
                boolean staleState = false;
                try {
                    while (this.running && !staleState && !this.shuttingDown && !denied) {
                        try {
                            State osState = this.offerService();
                            if (osState == State.STALE) {
                                staleState = true;
                                continue;
                            }
                            if (osState != State.DENIED) continue;
                            denied = true;
                        }
                        catch (Exception ex) {
                            if (this.shuttingDown) continue;
                            LOG.info((Object)("Lost connection to JobTracker [" + this.jobTrackAddr + "].  Retrying..."), (Throwable)ex);
                            try {
                                Thread.sleep(5000L);
                            }
                            catch (InterruptedException ie) {}
                        }
                    }
                }
                finally {
                    this.close();
                }
                if (this.shuttingDown) {
                    return;
                }
                LOG.warn((Object)"Reinitializing local state");
                this.initialize();
            }
        }
        catch (IOException iex) {
            LOG.error((Object)("Got fatal exception while reinitializing TaskTracker: " + StringUtils.stringifyException(iex)));
            return;
        }
    }

    @Override
    public synchronized Task getTask(String taskid) throws IOException {
        TaskInProgress tip = this.tasks.get(taskid);
        if (tip != null) {
            return tip.getTask();
        }
        return null;
    }

    @Override
    public synchronized void progress(String taskid, float progress, String state, TaskStatus.Phase phase, Counters counters) throws IOException {
        TaskInProgress tip = this.tasks.get(taskid);
        if (tip != null) {
            tip.reportProgress(progress, state, phase, counters);
        } else {
            LOG.warn((Object)("Progress from unknown child task: " + taskid + ". Ignored."));
        }
    }

    @Override
    public synchronized void reportDiagnosticInfo(String taskid, String info) throws IOException {
        TaskInProgress tip = this.tasks.get(taskid);
        if (tip != null) {
            tip.reportDiagnosticInfo(info);
        } else {
            LOG.warn((Object)("Error from unknown child task: " + taskid + ". Ignored."));
        }
    }

    @Override
    public synchronized boolean ping(String taskid) throws IOException {
        return this.tasks.get(taskid) != null;
    }

    @Override
    public synchronized void done(String taskid) throws IOException {
        TaskInProgress tip = this.tasks.get(taskid);
        if (tip != null) {
            tip.reportDone();
        } else {
            LOG.warn((Object)("Unknown child task done: " + taskid + ". Ignored."));
        }
    }

    @Override
    public synchronized void fsError(String taskId, String message) throws IOException {
        LOG.fatal((Object)("Task: " + taskId + " - Killed due to FSError: " + message));
        TaskInProgress tip = this.runningTasks.get(taskId);
        tip.reportDiagnosticInfo("FSError: " + message);
        this.purgeTask(tip);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TaskCompletionEvent[] getMapCompletionEvents(String jobId, int fromEventId, int maxLocs) throws IOException {
        TaskCompletionEvent[] mapEvents = TaskCompletionEvent.EMPTY_ARRAY;
        Map<String, RunningJob> map = this.runningJobs;
        synchronized (map) {
            RunningJob rjob = this.runningJobs.get(jobId);
            if (rjob != null) {
                RunningJob runningJob = rjob;
                synchronized (runningJob) {
                    FetchStatus f = rjob.getFetchStatus();
                    if (f != null) {
                        mapEvents = f.getMapEvents(fromEventId, maxLocs);
                    }
                }
            }
        }
        return mapEvents;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void reportTaskFinished(String taskid) {
        TaskInProgress tip;
        Object object = this;
        synchronized (object) {
            tip = this.tasks.get(taskid);
        }
        if (tip != null) {
            tip.taskFinished();
            object = this.finishedCount;
            synchronized (this.finishedCount) {
                this.finishedCount[0] = this.finishedCount[0] + 1;
                this.finishedCount.notify();
                // ** MonitorExit[var3_2] (shouldn't be in output)
            }
        } else {
            LOG.warn((Object)("Unknown child task finshed: " + taskid + ". Ignored."));
        }
    }

    public synchronized void mapOutputLost(String taskid, String errorMsg) throws IOException {
        TaskInProgress tip = this.tasks.get(taskid);
        if (tip != null) {
            tip.mapOutputLost(errorMsg);
        } else {
            LOG.warn((Object)("Unknown child with bad map output: " + taskid + ". Ignored."));
        }
    }

    String getName() {
        return this.taskTrackerName;
    }

    synchronized List<TaskStatus> getRunningTaskStatuses() {
        ArrayList<TaskStatus> result = new ArrayList<TaskStatus>(this.runningTasks.size());
        for (TaskInProgress tip : this.runningTasks.values()) {
            result.add(tip.createStatus());
        }
        return result;
    }

    synchronized List<TaskStatus> getNonRunningTasks() {
        ArrayList<TaskStatus> result = new ArrayList<TaskStatus>(this.tasks.size());
        for (Map.Entry<String, TaskInProgress> task : this.tasks.entrySet()) {
            if (this.runningTasks.containsKey(task.getKey())) continue;
            result.add(task.getValue().createStatus());
        }
        return result;
    }

    JobConf getJobConf() {
        return this.fConf;
    }

    private static void checkLocalDirs(String[] localDirs) throws DiskChecker.DiskErrorException {
        boolean writable = false;
        if (localDirs != null) {
            for (int i = 0; i < localDirs.length; ++i) {
                try {
                    DiskChecker.checkDir(new File(localDirs[i]));
                    writable = true;
                    continue;
                }
                catch (DiskChecker.DiskErrorException e) {
                    LOG.warn((Object)("Task Tracker local " + e.getMessage()));
                }
            }
        }
        if (!writable) {
            throw new DiskChecker.DiskErrorException("all local directories are not writable");
        }
    }

    public synchronized boolean isIdle() {
        return this.tasks.isEmpty() && this.tasksToCleanup.isEmpty();
    }

    public static void main(String[] argv) throws Exception {
        if (argv.length != 0) {
            System.out.println("usage: TaskTracker");
            System.exit(-1);
        }
        try {
            JobConf conf = new JobConf();
            ReflectionUtils.setContentionTracing(conf.getBoolean("tasktracker.contention.tracking", false));
            new TaskTracker(conf).run();
        }
        catch (Throwable e) {
            LOG.error((Object)("Can not start task tracker because " + StringUtils.stringifyException(e)));
            System.exit(-1);
        }
    }

    public static class MapOutputServlet
    extends HttpServlet {
        private final int MAX_BYTES_TO_READ = 65536;

        public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
            String mapId = request.getParameter("map");
            String reduceId = request.getParameter("reduce");
            if (mapId == null || reduceId == null) {
                throw new IOException("map and reduce parameters are required");
            }
            ServletContext context = this.getServletContext();
            int reduce = Integer.parseInt(reduceId);
            byte[] buffer = new byte[65536];
            ServletOutputStream outStream = response.getOutputStream();
            JobConf conf = (JobConf)context.getAttribute("conf");
            LocalDirAllocator lDirAlloc = (LocalDirAllocator)context.getAttribute("localDirAllocator");
            FileSystem fileSys = (FileSystem)context.getAttribute("local.file.system");
            Path indexFileName = lDirAlloc.getLocalPathToRead(mapId + "/file.out.index", conf);
            FSDataInputStream indexIn = null;
            Path mapOutputFileName = lDirAlloc.getLocalPathToRead(mapId + "/file.out", conf);
            FilterInputStream mapOutputIn = null;
            boolean isInputException = true;
            try {
                indexIn = fileSys.open(indexFileName);
                indexIn.seek(reduce * 16);
                long startOffset = indexIn.readLong();
                long partLength = indexIn.readLong();
                indexIn.close();
                indexIn = null;
                response.setHeader("Map-Output-Length", Long.toString(partLength));
                response.setBufferSize(65536);
                mapOutputIn = fileSys.open(mapOutputFileName);
                ((FSDataInputStream)mapOutputIn).seek(startOffset);
                long totalRead = 0L;
                int len = ((DataInputStream)mapOutputIn).read(buffer, 0, partLength < 65536L ? (int)partLength : 65536);
                while (len > 0) {
                    try {
                        outStream.write(buffer, 0, len);
                        outStream.flush();
                    }
                    catch (IOException ie) {
                        isInputException = false;
                        throw ie;
                    }
                    if ((totalRead += (long)len) == partLength) {
                        break;
                    }
                    len = ((DataInputStream)mapOutputIn).read(buffer, 0, partLength - totalRead < 65536L ? (int)(partLength - totalRead) : 65536);
                }
            }
            catch (IOException ie) {
                TaskTracker tracker = (TaskTracker)context.getAttribute("task.tracker");
                Log log = (Log)context.getAttribute("log");
                String errorMsg = "getMapOutput(" + mapId + "," + reduceId + ") failed :\n" + StringUtils.stringifyException(ie);
                log.warn((Object)errorMsg);
                if (isInputException) {
                    tracker.mapOutputLost(mapId, errorMsg);
                }
                response.sendError(410, errorMsg);
                throw ie;
            }
            finally {
                if (indexIn != null) {
                    indexIn.close();
                }
                if (mapOutputIn != null) {
                    mapOutputIn.close();
                }
            }
            outStream.close();
        }
    }

    public static class Child {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static void main(String[] args) throws Throwable {
            LOG.debug((Object)"Child starting");
            JobConf defaultConf = new JobConf();
            int port = Integer.parseInt(args[0]);
            String taskid = args[1];
            TaskUmbilicalProtocol umbilical = (TaskUmbilicalProtocol)RPC.getProxy(TaskUmbilicalProtocol.class, 2L, new InetSocketAddress(port), defaultConf);
            Task task = umbilical.getTask(taskid);
            JobConf job = new JobConf(task.getJobFile());
            task.setConf(job);
            defaultConf.addFinalResource(new Path(task.getJobFile()));
            Child.startPinging(umbilical, taskid);
            try {
                FileSystem.get(job).setWorkingDirectory(job.getWorkingDirectory());
                task.run(job, umbilical);
            }
            catch (FSError e) {
                LOG.fatal((Object)"FSError from child", (Throwable)e);
                umbilical.fsError(taskid, e.getMessage());
            }
            catch (Throwable throwable) {
                LOG.warn((Object)"Error running child", throwable);
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                throwable.printStackTrace(new PrintStream(baos));
                umbilical.reportDiagnosticInfo(taskid, baos.toString());
            }
            finally {
                MetricsContext metricsContext = MetricsUtil.getContext("mapred");
                metricsContext.close();
                LogManager.shutdown();
            }
        }

        private static void startPinging(final TaskUmbilicalProtocol umbilical, final String taskid) {
            Thread thread = new Thread(new Runnable(){

                public void run() {
                    int MAX_RETRIES = 3;
                    int remainingRetries = 3;
                    while (true) {
                        block6: {
                            try {
                                if (!umbilical.ping(taskid)) {
                                    LOG.warn((Object)("Parent died.  Exiting " + taskid));
                                    System.exit(66);
                                }
                                remainingRetries = 3;
                            }
                            catch (Throwable t) {
                                String msg = StringUtils.stringifyException(t);
                                LOG.info((Object)("Ping exception: " + msg));
                                if (--remainingRetries != 0) break block6;
                                ReflectionUtils.logThreadInfo(LOG, "ping exception", 0L);
                                LOG.warn((Object)("Last retry, killing " + taskid));
                                System.exit(65);
                            }
                        }
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (InterruptedException interruptedException) {
                        }
                    }
                }
            }, "Pinger for " + taskid);
            thread.setDaemon(true);
            thread.start();
        }
    }

    static class RunningJob {
        private String jobid;
        private Path jobFile;
        Set<TaskInProgress> tasks;
        boolean localized;
        boolean keepJobFiles;
        FetchStatus f;

        RunningJob(String jobid, Path jobFile) {
            this.jobid = jobid;
            this.localized = false;
            this.tasks = new HashSet<TaskInProgress>();
            this.jobFile = jobFile;
            this.keepJobFiles = false;
        }

        Path getJobFile() {
            return this.jobFile;
        }

        String getJobId() {
            return this.jobid;
        }

        void setFetchStatus(FetchStatus f) {
            this.f = f;
        }

        FetchStatus getFetchStatus() {
            return this.f;
        }
    }

    class TaskInProgress {
        Task task;
        float progress;
        volatile TaskStatus.State runstate;
        long lastProgressReport;
        StringBuffer diagnosticInfo = new StringBuffer();
        private TaskRunner runner;
        volatile boolean done = false;
        boolean wasKilled = false;
        private JobConf defaultJobConf;
        private JobConf localJobConf;
        private boolean keepFailedTaskFiles;
        private boolean alwaysKeepTaskFiles;
        private TaskStatus taskStatus;
        private boolean keepJobFiles;
        private long taskTimeout;

        public TaskInProgress(Task task, JobConf conf) {
            this.task = task;
            this.progress = 0.0f;
            this.runstate = TaskStatus.State.UNASSIGNED;
            this.lastProgressReport = System.currentTimeMillis();
            this.defaultJobConf = conf;
            this.localJobConf = null;
            this.taskStatus = new TaskStatus(task.getTaskId(), task.isMapTask(), this.progress, this.runstate, this.diagnosticInfo.toString(), "initializing", TaskTracker.this.getName(), task.isMapTask() ? TaskStatus.Phase.MAP : TaskStatus.Phase.SHUFFLE, task.getCounters());
            this.keepJobFiles = false;
            this.taskTimeout = 600000L;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void localizeTask(Task task) throws IOException {
            Path localTaskDir = new Path(this.defaultJobConf.getLocalPath(TaskTracker.getJobCacheSubdir()), task.getJobId() + "/" + task.getTaskId());
            LocalFileSystem localFs = FileSystem.getLocal(TaskTracker.this.fConf);
            if (!((FileSystem)localFs).mkdirs(localTaskDir)) {
                throw new IOException("Mkdirs failed to create " + localTaskDir.toString());
            }
            Path localTaskFile = new Path(localTaskDir, "job.xml");
            task.setJobFile(localTaskFile.toString());
            this.localJobConf.set("mapred.local.dir", TaskTracker.this.fConf.get("mapred.local.dir"));
            this.localJobConf.set("mapred.task.id", task.getTaskId());
            this.keepFailedTaskFiles = this.localJobConf.getKeepFailedTaskFiles();
            task.localizeConfiguration(this.localJobConf);
            FSDataOutputStream out = localFs.create(localTaskFile);
            try {
                this.localJobConf.write(out);
            }
            finally {
                ((OutputStream)out).close();
            }
            task.setConf(this.localJobConf);
            String keepPattern = this.localJobConf.getKeepTaskFilesPattern();
            if (keepPattern != null) {
                this.keepJobFiles = true;
                this.alwaysKeepTaskFiles = Pattern.matches(keepPattern, task.getTaskId());
            } else {
                this.alwaysKeepTaskFiles = false;
            }
        }

        public Task getTask() {
            return this.task;
        }

        public void setJobConf(JobConf lconf) {
            this.localJobConf = lconf;
            this.keepFailedTaskFiles = this.localJobConf.getKeepFailedTaskFiles();
            this.taskTimeout = this.localJobConf.getLong("mapred.task.timeout", 600000L);
        }

        public JobConf getJobConf() {
            return this.localJobConf;
        }

        public synchronized TaskStatus createStatus() {
            this.taskStatus.setProgress(this.progress);
            this.taskStatus.setRunState(this.runstate);
            this.taskStatus.setDiagnosticInfo(this.diagnosticInfo.toString());
            if (this.diagnosticInfo.length() > 0) {
                this.diagnosticInfo = new StringBuffer();
            }
            return this.taskStatus;
        }

        public synchronized void launchTask() throws IOException {
            this.localizeTask(this.task);
            this.runstate = TaskStatus.State.RUNNING;
            this.runner = this.task.createRunner(TaskTracker.this);
            this.runner.start();
            this.taskStatus.setStartTime(System.currentTimeMillis());
        }

        public synchronized void reportProgress(float p, String state, TaskStatus.Phase newPhase, Counters counters) {
            if (this.done) {
                return;
            }
            LOG.info((Object)(this.task.getTaskId() + " " + p + "% " + state));
            this.progress = p;
            this.runstate = TaskStatus.State.RUNNING;
            this.lastProgressReport = System.currentTimeMillis();
            TaskStatus.Phase oldPhase = this.taskStatus.getPhase();
            if (oldPhase != newPhase) {
                if (newPhase == TaskStatus.Phase.SORT) {
                    this.taskStatus.setShuffleFinishTime(System.currentTimeMillis());
                } else if (newPhase == TaskStatus.Phase.REDUCE) {
                    this.taskStatus.setSortFinishTime(System.currentTimeMillis());
                }
                this.taskStatus.setPhase(newPhase);
            }
            this.taskStatus.setStateString(state);
            this.taskStatus.setCounters(counters);
        }

        public long getLastProgressReport() {
            return this.lastProgressReport;
        }

        public TaskStatus.State getRunState() {
            return this.runstate;
        }

        public long getTaskTimeout() {
            return this.taskTimeout;
        }

        public synchronized void reportDiagnosticInfo(String info) {
            this.diagnosticInfo.append(info);
        }

        public synchronized void reportDone() {
            LOG.info((Object)("Task " + this.task.getTaskId() + " is done."));
            this.progress = 1.0f;
            this.taskStatus.setFinishTime(System.currentTimeMillis());
            this.done = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void taskFinished() {
            long start = System.currentTimeMillis();
            while (!this.done && System.currentTimeMillis() - start < 3000L) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException ie) {}
            }
            boolean needCleanup = false;
            TaskInProgress taskInProgress = this;
            synchronized (taskInProgress) {
                if (this.done) {
                    this.runstate = TaskStatus.State.SUCCEEDED;
                } else {
                    if (!this.wasKilled) {
                        TaskTracker.this.failures += 1;
                        this.runstate = TaskStatus.State.FAILED;
                    } else {
                        this.runstate = TaskStatus.State.KILLED;
                    }
                    this.progress = 0.0f;
                }
                this.taskStatus.setFinishTime(System.currentTimeMillis());
                needCleanup = this.runstate == TaskStatus.State.FAILED | this.runstate == TaskStatus.State.KILLED;
            }
            if (needCleanup) {
                try {
                    this.cleanup();
                }
                catch (IOException ie) {
                    // empty catch block
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void jobHasFinished() throws IOException {
            boolean killTask = false;
            TaskInProgress taskInProgress = this;
            synchronized (taskInProgress) {
                boolean bl = killTask = this.getRunState() == TaskStatus.State.RUNNING;
                if (killTask) {
                    this.killAndCleanup(false);
                }
            }
            if (!killTask) {
                this.cleanup();
            }
            if (this.keepJobFiles) {
                return;
            }
            taskInProgress = this;
            synchronized (taskInProgress) {
                try {
                    String systemDir = this.task.getConf().get("mapred.system.dir");
                    Path taskTempDir = new Path(systemDir + "/" + this.task.getJobId() + "/" + this.task.getTipId() + "/" + this.task.getTaskId());
                    if (TaskTracker.this.fs.exists(taskTempDir)) {
                        TaskTracker.this.fs.delete(taskTempDir);
                    }
                }
                catch (IOException e) {
                    LOG.warn((Object)"Error in deleting reduce temporary output", (Throwable)e);
                }
            }
        }

        public synchronized void killAndCleanup(boolean wasFailure) throws IOException {
            if (this.runstate == TaskStatus.State.RUNNING) {
                this.wasKilled = true;
                if (wasFailure) {
                    TaskTracker.this.failures += 1;
                }
                this.runner.kill();
                this.runstate = TaskStatus.State.KILLED;
            } else if (this.runstate == TaskStatus.State.UNASSIGNED) {
                if (wasFailure) {
                    TaskTracker.this.failures += 1;
                    this.runstate = TaskStatus.State.FAILED;
                } else {
                    this.runstate = TaskStatus.State.KILLED;
                }
            }
        }

        private synchronized void mapOutputLost(String failure) throws IOException {
            if (this.runstate == TaskStatus.State.SUCCEEDED) {
                LOG.info((Object)("Reporting output lost:" + this.task.getTaskId()));
                this.runstate = TaskStatus.State.FAILED;
                this.progress = 0.0f;
                this.reportDiagnosticInfo("Map output lost, rescheduling: " + failure);
                TaskTracker.this.runningTasks.put(this.task.getTaskId(), this);
                ++TaskTracker.this.mapTotal;
                TaskTracker.this.myMetrics.update();
            } else {
                LOG.warn((Object)("Output already reported lost:" + this.task.getTaskId()));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void cleanup() throws IOException {
            String taskId = this.task.getTaskId();
            LOG.debug((Object)("Cleaning up " + taskId));
            Object object = TaskTracker.this;
            synchronized (object) {
                TaskTracker.this.tasks.remove(taskId);
                if (this.alwaysKeepTaskFiles || this.runstate == TaskStatus.State.FAILED && this.keepFailedTaskFiles) {
                    return;
                }
            }
            object = this;
            synchronized (object) {
                try {
                    if (this.runner != null) {
                        this.runner.close();
                    }
                    this.defaultJobConf.deleteLocalFiles("taskTracker/jobcache/" + this.task.getJobId() + "/" + taskId);
                }
                catch (Throwable ie) {
                    LOG.info((Object)("Error cleaning up task runner: " + StringUtils.stringifyException(ie)));
                }
            }
        }

        public boolean equals(Object obj) {
            return obj instanceof TaskInProgress && this.task.getTaskId().equals(((TaskInProgress)obj).getTask().getTaskId());
        }

        public int hashCode() {
            return this.task.getTaskId().hashCode();
        }
    }

    private class FetchStatus {
        private IntWritable fromEventId = new IntWritable(0);
        private List<TaskCompletionEvent> allMapEvents;
        private int[] indexToEventsCache;
        private String jobId;

        public FetchStatus(String jobId, int numMaps) {
            this.jobId = jobId;
            this.allMapEvents = new ArrayList<TaskCompletionEvent>(numMaps);
            this.indexToEventsCache = new int[numMaps];
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public TaskCompletionEvent[] getMapEvents(int fromId, int max) {
            TaskCompletionEvent[] mapEvents = TaskCompletionEvent.EMPTY_ARRAY;
            List<TaskCompletionEvent> list = this.allMapEvents;
            synchronized (list) {
                if (this.allMapEvents.size() > fromId) {
                    int actualMax = Math.min(max, this.allMapEvents.size() - fromId);
                    List<TaskCompletionEvent> eventSublist = this.allMapEvents.subList(fromId, actualMax + fromId);
                    mapEvents = eventSublist.toArray(mapEvents);
                }
            }
            return mapEvents;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void fetchMapCompletionEvents() throws IOException {
            List recentMapEvents = TaskTracker.this.queryJobTracker(this.fromEventId, this.jobId, TaskTracker.this.jobClient);
            List<TaskCompletionEvent> list = this.allMapEvents;
            synchronized (list) {
                for (TaskCompletionEvent t : recentMapEvents) {
                    int idx;
                    TaskCompletionEvent.Status status = t.getTaskStatus();
                    this.allMapEvents.add(t);
                    if (status == TaskCompletionEvent.Status.SUCCEEDED) {
                        this.indexToEventsCache[t.idWithinJob()] = this.allMapEvents.size();
                        continue;
                    }
                    if (status != TaskCompletionEvent.Status.FAILED && status != TaskCompletionEvent.Status.OBSOLETE || (idx = this.indexToEventsCache[t.idWithinJob()]) <= 0) continue;
                    TaskCompletionEvent obsoleteEvent = this.allMapEvents.get(idx - 1);
                    obsoleteEvent.setTaskStatus(TaskCompletionEvent.Status.OBSOLETE);
                    this.indexToEventsCache[t.idWithinJob()] = 0;
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MapEventsFetcherThread
    extends Thread {
        private MapEventsFetcherThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private List<FetchStatus> reducesInShuffle() {
            ArrayList<FetchStatus> fList = new ArrayList<FetchStatus>();
            for (Map.Entry<String, RunningJob> item : TaskTracker.this.runningJobs.entrySet()) {
                RunningJob rjob = item.getValue();
                String jobId = item.getKey();
                RunningJob runningJob = rjob;
                synchronized (runningJob) {
                    FetchStatus f = rjob.getFetchStatus();
                    for (TaskInProgress tip : rjob.tasks) {
                        Task task = tip.getTask();
                        if (task.isMapTask() || ((ReduceTask)task).getPhase() != TaskStatus.Phase.SHUFFLE) continue;
                        if (rjob.getFetchStatus() == null) {
                            f = new FetchStatus(jobId, ((ReduceTask)task).getNumMaps());
                            rjob.setFetchStatus(f);
                        }
                        f = rjob.getFetchStatus();
                        fList.add(f);
                        break;
                    }
                }
            }
            return fList;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            LOG.info((Object)("Starting thread: " + this.getName()));
            while (true) {
                try {
                    block12: while (true) {
                        List<FetchStatus> fList = null;
                        Map<String, RunningJob> map = TaskTracker.this.runningJobs;
                        synchronized (map) {
                            while ((fList = this.reducesInShuffle()).size() == 0) {
                                try {
                                    TaskTracker.this.runningJobs.wait();
                                }
                                catch (InterruptedException e) {
                                    LOG.info((Object)("Shutting down: " + this.getName()));
                                    return;
                                }
                            }
                        }
                        Iterator<FetchStatus> i$ = fList.iterator();
                        while (true) {
                            if (!i$.hasNext()) continue block12;
                            FetchStatus f = i$.next();
                            try {
                                f.fetchMapCompletionEvents();
                                try {
                                    Thread.sleep(5000L);
                                    continue;
                                }
                                catch (InterruptedException ie) {
                                    LOG.info((Object)("Shutting down: " + this.getName()));
                                    return;
                                }
                            }
                            catch (Exception e) {
                                LOG.warn((Object)("Ignoring exception that fetch for map completion events threw for " + f.jobId + " threw: " + StringUtils.stringifyException(e)));
                                continue;
                            }
                            break;
                        }
                        break;
                    }
                }
                catch (Exception e) {
                    LOG.info((Object)("Ignoring exception " + e.getMessage()));
                    continue;
                }
                break;
            }
        }
    }

    private class TaskTrackerMetrics {
        private MetricsRecord metricsRecord = null;

        TaskTrackerMetrics() {
            MetricsContext context = MetricsUtil.getContext("mapred");
            this.metricsRecord = MetricsUtil.createRecord(context, "tasktracker");
        }

        synchronized void completeTask() {
            if (this.metricsRecord != null) {
                this.metricsRecord.incrMetric("tasks_completed", 1);
            }
        }

        synchronized void update() {
            if (this.metricsRecord != null) {
                this.metricsRecord.setMetric("maps_running", TaskTracker.this.mapTotal);
                this.metricsRecord.setMetric("reduces_running", TaskTracker.this.reduceTotal);
                this.metricsRecord.update();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum State {
        NORMAL,
        STALE,
        INTERRUPTED,
        DENIED;

    }
}

