/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.net.URI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.LocalDirAllocator;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.UTF8;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapred.Counters;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.MapOutputFile;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapred.TaskRunner;
import org.apache.hadoop.mapred.TaskStatus;
import org.apache.hadoop.mapred.TaskTracker;
import org.apache.hadoop.mapred.TaskUmbilicalProtocol;
import org.apache.hadoop.util.Progress;
import org.apache.hadoop.util.StringUtils;

abstract class Task
implements Writable,
Configurable {
    private static final Log LOG = LogFactory.getLog((String)"org.apache.hadoop.mapred.TaskRunner");
    private String jobFile;
    private String taskId;
    private String jobId;
    private String tipId;
    private int partition;
    private TaskStatus.Phase phase;
    private Path taskOutputPath;
    protected JobConf conf;
    protected MapOutputFile mapOutputFile = new MapOutputFile();
    protected LocalDirAllocator lDirAlloc;
    public static final int PROGRESS_INTERVAL = 1000;
    private transient Progress taskProgress = new Progress();
    private transient long nextProgressTime = System.currentTimeMillis() + 1000L;
    private transient Counters counters = new Counters();

    public Task() {
    }

    public Task(String jobId, String jobFile, String tipId, String taskId, int partition) {
        this.jobFile = jobFile;
        this.taskId = taskId;
        this.jobId = jobId;
        this.tipId = tipId;
        this.partition = partition;
    }

    public void setJobFile(String jobFile) {
        this.jobFile = jobFile;
    }

    public String getJobFile() {
        return this.jobFile;
    }

    public String getTaskId() {
        return this.taskId;
    }

    public String getTipId() {
        return this.tipId;
    }

    public Counters getCounters() {
        return this.counters;
    }

    public String getJobId() {
        return this.jobId;
    }

    public int getPartition() {
        return this.partition;
    }

    public TaskStatus.Phase getPhase() {
        return this.phase;
    }

    protected void setPhase(TaskStatus.Phase p) {
        this.phase = p;
    }

    public void write(DataOutput out) throws IOException {
        UTF8.writeString(out, this.jobFile);
        UTF8.writeString(out, this.tipId);
        UTF8.writeString(out, this.taskId);
        UTF8.writeString(out, this.jobId);
        out.writeInt(this.partition);
        if (this.taskOutputPath != null) {
            Text.writeString(out, this.taskOutputPath.toString());
        } else {
            Text.writeString(out, new String(""));
        }
    }

    public void readFields(DataInput in) throws IOException {
        this.jobFile = UTF8.readString(in);
        this.tipId = UTF8.readString(in);
        this.taskId = UTF8.readString(in);
        this.jobId = UTF8.readString(in);
        this.partition = in.readInt();
        String outPath = Text.readString(in);
        this.taskOutputPath = outPath.length() != 0 ? new Path(outPath) : null;
    }

    public String toString() {
        return this.taskId;
    }

    private Path getTaskOutputPath(JobConf conf) {
        return new Path(conf.getOutputPath(), new String("_" + this.taskId));
    }

    public void localizeConfiguration(JobConf conf) throws IOException {
        conf.set("mapred.tip.id", this.tipId);
        conf.set("mapred.task.id", this.taskId);
        conf.setBoolean("mapred.task.is.map", this.isMapTask());
        conf.setInt("mapred.task.partition", this.partition);
        conf.set("mapred.job.id", this.jobId);
        if (conf.getOutputPath() != null) {
            this.taskOutputPath = this.getTaskOutputPath(conf);
            conf.setOutputPath(this.taskOutputPath);
        }
    }

    public abstract void run(JobConf var1, TaskUmbilicalProtocol var2) throws IOException;

    public abstract TaskRunner createRunner(TaskTracker var1) throws IOException;

    public abstract boolean isMapTask();

    public Progress getProgress() {
        return this.taskProgress;
    }

    InputSplit getInputSplit() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Input only available on map");
    }

    protected Reporter getReporter(final TaskUmbilicalProtocol umbilical) throws IOException {
        return new Reporter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void setStatus(String status) throws IOException {
                1 var2_2 = this;
                synchronized (var2_2) {
                    Task.this.taskProgress.setStatus(status);
                    this.progress();
                }
            }

            public void progress() throws IOException {
                Task.this.reportProgress(umbilical);
            }

            public void incrCounter(Enum key, long amount) {
                Counters counters = Task.this.getCounters();
                if (counters != null) {
                    counters.incrCounter(key, amount);
                }
            }

            public InputSplit getInputSplit() throws UnsupportedOperationException {
                return Task.this.getInputSplit();
            }
        };
    }

    public void setProgress(float progress) {
        this.taskProgress.set(progress);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reportProgress(TaskUmbilicalProtocol umbilical) {
        long now = System.currentTimeMillis();
        Task task = this;
        synchronized (task) {
            if (now > this.nextProgressTime) {
                this.nextProgressTime = now + 1000L;
                float progress = this.taskProgress.get();
                String status = this.taskProgress.toString();
                try {
                    umbilical.progress(this.getTaskId(), progress, status, this.phase, this.counters);
                }
                catch (InterruptedException ie) {
                    Thread.currentThread().interrupt();
                }
                catch (IOException ie) {
                    LOG.warn((Object)StringUtils.stringifyException(ie));
                }
            }
        }
    }

    public void done(TaskUmbilicalProtocol umbilical) throws IOException {
        int retries = 10;
        boolean needProgress = true;
        while (true) {
            try {
                if (needProgress) {
                    try {
                        umbilical.progress(this.getTaskId(), this.taskProgress.get(), this.taskProgress.toString(), this.phase, this.counters);
                        needProgress = false;
                    }
                    catch (InterruptedException ie) {
                        Thread.currentThread().interrupt();
                    }
                }
                umbilical.done(this.getTaskId());
                return;
            }
            catch (IOException ie) {
                LOG.warn((Object)("Failure signalling completion: " + StringUtils.stringifyException(ie)));
                if (--retries != 0) continue;
                throw ie;
            }
            break;
        }
    }

    public void setConf(Configuration conf) {
        if (conf instanceof JobConf) {
            this.conf = (JobConf)conf;
            if (this.taskId != null && this.taskOutputPath == null && this.conf.getOutputPath() != null) {
                this.taskOutputPath = this.getTaskOutputPath(this.conf);
            }
        } else {
            this.conf = new JobConf(conf);
        }
        this.mapOutputFile.setConf(this.conf);
        this.lDirAlloc = new LocalDirAllocator("mapred.local.dir");
    }

    public Configuration getConf() {
        return this.conf;
    }

    void saveTaskOutput() throws IOException {
        FileSystem fs = FileSystem.get(this.conf);
        if (this.taskOutputPath != null && fs.exists(this.taskOutputPath)) {
            Path jobOutputPath = this.taskOutputPath.getParent();
            this.moveTaskOutputs(fs, jobOutputPath, this.taskOutputPath);
            if (!fs.delete(this.taskOutputPath)) {
                LOG.info((Object)("Failed to delete the temporary output directory of task: " + this.getTaskId() + " - " + this.taskOutputPath));
            }
            LOG.info((Object)("Saved output of task '" + this.getTaskId() + "' to " + jobOutputPath));
        }
    }

    private Path getFinalPath(Path jobOutputDir, Path taskOutput) {
        URI relativePath = this.taskOutputPath.toUri().relativize(taskOutput.toUri());
        return new Path(jobOutputDir, relativePath.toString());
    }

    private void moveTaskOutputs(FileSystem fs, Path jobOutputDir, Path taskOutput) throws IOException {
        Path[] paths;
        if (fs.isFile(taskOutput)) {
            Path finalOutputPath = this.getFinalPath(jobOutputDir, taskOutput);
            fs.mkdirs(finalOutputPath.getParent());
            if (!fs.rename(taskOutput, finalOutputPath)) {
                throw new IOException("Failed to save output of task: " + this.getTaskId());
            }
            LOG.debug((Object)("Moved " + taskOutput + " to " + finalOutputPath));
        } else if (fs.isDirectory(taskOutput) && (paths = fs.listPaths(taskOutput)) != null) {
            for (Path path : paths) {
                this.moveTaskOutputs(fs, jobOutputDir, path);
            }
        }
    }

    void discardTaskOutput() throws IOException {
        FileSystem fs = FileSystem.get(this.conf);
        if (this.taskOutputPath != null && fs.exists(this.taskOutputPath)) {
            FileUtil.fullyDelete(fs, this.taskOutputPath);
            LOG.info((Object)("Discarded output of task '" + this.getTaskId() + "' - " + this.taskOutputPath));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum Counter {
        MAP_INPUT_RECORDS,
        MAP_OUTPUT_RECORDS,
        MAP_INPUT_BYTES,
        MAP_OUTPUT_BYTES,
        COMBINE_INPUT_RECORDS,
        COMBINE_OUTPUT_RECORDS,
        REDUCE_INPUT_GROUPS,
        REDUCE_INPUT_RECORDS,
        REDUCE_OUTPUT_RECORDS;

    }
}

