/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FilterFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.util.Progressable;

public class PhasedFileSystem
extends FilterFileSystem {
    private Map<Path, FileInfo> finalNameToFileInfo = new HashMap<Path, FileInfo>();
    private String jobid;
    private String tipid;
    private String taskid;
    private Path tempDir;

    public PhasedFileSystem(FileSystem fs, String jobid, String tipid, String taskid) {
        super(fs);
        this.jobid = jobid;
        this.tipid = tipid;
        this.taskid = taskid;
        this.tempDir = new Path(fs.getConf().get("mapred.system.dir"));
        this.setConf(fs.getConf());
    }

    public PhasedFileSystem(FileSystem fs, JobConf conf) {
        super(fs);
        this.jobid = conf.get("mapred.job.id");
        this.tipid = conf.get("mapred.tip.id");
        this.taskid = conf.get("mapred.task.id");
        this.tempDir = new Path(fs.getConf().get("mapred.system.dir"));
        this.setConf(fs.getConf());
    }

    private Path setupFile(Path finalFile, boolean overwrite) throws IOException {
        if (this.finalNameToFileInfo.containsKey(finalFile)) {
            if (!overwrite) {
                throw new IOException("Error, file already exists : " + finalFile.toString());
            }
            FileInfo fInfo = this.finalNameToFileInfo.get(finalFile);
            try {
                fInfo.getOpenFileStream().close();
            }
            catch (IOException ioe) {
                // empty catch block
            }
            if (this.fs.exists(fInfo.getTempPath())) {
                this.fs.delete(fInfo.getTempPath());
            }
            this.finalNameToFileInfo.remove(finalFile);
        }
        String uniqueFile = this.jobid + "/" + this.tipid + "/" + this.taskid + "/" + finalFile.getName();
        Path tempPath = new Path(this.tempDir, new Path(uniqueFile));
        FileInfo fInfo = new FileInfo(tempPath, finalFile, overwrite);
        this.finalNameToFileInfo.put(finalFile, fInfo);
        return tempPath;
    }

    public FSDataOutputStream create(Path f, boolean overwrite, int bufferSize, short replication, long blockSize, Progressable progress) throws IOException {
        if (this.fs.exists(f) && !overwrite) {
            throw new IOException("Error creating file - already exists : " + f);
        }
        FSDataOutputStream stream = this.fs.create(this.setupFile(f, overwrite), overwrite, bufferSize, replication, blockSize, progress);
        this.finalNameToFileInfo.get(f).setOpenFileStream(stream);
        return stream;
    }

    public void commit(Path fPath) throws IOException {
        this.commit(fPath, true);
    }

    private void commit(Path fPath, boolean removeFromMap) throws IOException {
        FileInfo fInfo = this.finalNameToFileInfo.get(fPath);
        if (null == fInfo) {
            throw new IOException("Error committing file! File was not created with PhasedFileSystem : " + fPath);
        }
        try {
            fInfo.getOpenFileStream().close();
        }
        catch (IOException ioe) {
            LOG.debug((Object)("Ignoring exception : " + ioe.getMessage()));
        }
        Path tempPath = fInfo.getTempPath();
        if (!tempPath.toString().endsWith(".crc")) {
            if (!this.fs.exists(fPath) || fInfo.isOverwrite()) {
                if (!this.fs.exists(fPath.getParent())) {
                    this.fs.mkdirs(fPath.getParent());
                }
                if (this.fs.exists(fPath) && fInfo.isOverwrite()) {
                    this.fs.delete(fPath);
                }
                try {
                    if (!this.fs.rename(fInfo.getTempPath(), fPath)) {
                        this.fs.delete(fInfo.getTempPath());
                    }
                }
                catch (IOException ioe) {
                    LOG.error((Object)("PhasedFileSystem failed to commit file : " + fPath + " error : " + ioe.getMessage()));
                    this.fs.delete(fInfo.getTempPath());
                }
            } else {
                this.fs.delete(fInfo.getTempPath());
            }
            if (removeFromMap) {
                this.finalNameToFileInfo.remove(fPath);
            }
        }
    }

    public void commit() throws IOException {
        for (Path fPath : this.finalNameToFileInfo.keySet()) {
            this.commit(fPath, false);
        }
        this.finalNameToFileInfo.clear();
    }

    public void abort(Path p) throws IOException {
        this.abort(p, true);
    }

    private void abort(Path p, boolean removeFromMap) throws IOException {
        FileInfo fInfo = this.finalNameToFileInfo.get(p);
        if (null != fInfo) {
            try {
                fInfo.getOpenFileStream().close();
            }
            catch (IOException ioe) {
                // empty catch block
            }
            this.fs.delete(fInfo.getTempPath());
            if (removeFromMap) {
                this.finalNameToFileInfo.remove(p);
            }
        }
    }

    public void abort() throws IOException {
        for (Path fPath : this.finalNameToFileInfo.keySet()) {
            this.abort(fPath, false);
        }
        this.finalNameToFileInfo.clear();
    }

    public boolean setReplication(Path src, short replication) throws IOException {
        throw new UnsupportedOperationException("Operation not supported");
    }

    public boolean rename(Path src, Path dst) throws IOException {
        throw new UnsupportedOperationException("Operation not supported");
    }

    public boolean delete(Path f) throws IOException {
        throw new UnsupportedOperationException("Operation not supported");
    }

    @Deprecated
    public void lock(Path f, boolean shared) throws IOException {
        throw new UnsupportedOperationException("Operation not supported");
    }

    @Deprecated
    public void release(Path f) throws IOException {
        throw new UnsupportedOperationException("Operation not supported");
    }

    public void copyFromLocalFile(boolean delSrc, Path src, Path dst) throws IOException {
        throw new UnsupportedOperationException("Operation not supported");
    }

    public void copyToLocalFile(boolean delSrc, Path src, Path dst) throws IOException {
        throw new UnsupportedOperationException("Operation not supported");
    }

    public Path startLocalOutput(Path fsOutputFile, Path tmpLocalFile) throws IOException {
        throw new UnsupportedOperationException("Operation not supported");
    }

    public void completeLocalOutput(Path fsOutputFile, Path tmpLocalFile) throws IOException {
        throw new UnsupportedOperationException("Operation not supported");
    }

    public String[][] getFileCacheHints(Path f, long start, long len) throws IOException {
        throw new UnsupportedOperationException("Operation not supported");
    }

    public String getName() {
        throw new UnsupportedOperationException("Operation not supported");
    }

    private class FileInfo {
        private Path tempPath;
        private Path finalPath;
        private OutputStream openFileStream;
        private boolean overwrite;

        FileInfo(Path tempPath, Path finalPath, boolean overwrite) {
            this.tempPath = tempPath;
            this.finalPath = finalPath;
            this.overwrite = overwrite;
        }

        public OutputStream getOpenFileStream() {
            return this.openFileStream;
        }

        public void setOpenFileStream(OutputStream openFileStream) {
            this.openFileStream = openFileStream;
        }

        public Path getFinalPath() {
            return this.finalPath;
        }

        public void setFinalPath(Path finalPath) {
            this.finalPath = finalPath;
        }

        public boolean isOverwrite() {
            return this.overwrite;
        }

        public void setOverwrite(boolean overwrite) {
            this.overwrite = overwrite;
        }

        public Path getTempPath() {
            return this.tempPath;
        }

        public void setTempPath(Path tempPath) {
            this.tempPath = tempPath;
        }
    }
}

