/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.IOException;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.mapred.FileAlreadyExistsException;
import org.apache.hadoop.mapred.InvalidJobConfException;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.OutputFormat;
import org.apache.hadoop.mapred.RecordWriter;
import org.apache.hadoop.util.Progressable;

public abstract class OutputFormatBase
implements OutputFormat {
    public static void setCompressOutput(JobConf conf, boolean val) {
        conf.setBoolean("mapred.output.compress", val);
    }

    public static boolean getCompressOutput(JobConf conf) {
        return conf.getBoolean("mapred.output.compress", false);
    }

    public static void setOutputCompressorClass(JobConf conf, Class codecClass) {
        OutputFormatBase.setCompressOutput(conf, true);
        conf.setClass("mapred.output.compression.codec", codecClass, CompressionCodec.class);
    }

    public static Class getOutputCompressorClass(JobConf conf, Class defaultValue) {
        String name = conf.get("mapred.output.compression.codec");
        if (name == null) {
            return defaultValue;
        }
        try {
            return conf.getClassByName(name);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("Compression codec " + name + " was not found.", e);
        }
    }

    public abstract RecordWriter getRecordWriter(FileSystem var1, JobConf var2, String var3, Progressable var4) throws IOException;

    public void checkOutputSpecs(FileSystem ignored, JobConf job) throws FileAlreadyExistsException, InvalidJobConfException, IOException {
        Path outDir = job.getOutputPath();
        if (outDir == null && job.getNumReduceTasks() != 0) {
            throw new InvalidJobConfException("Output directory not set in JobConf.");
        }
        if (outDir != null && outDir.getFileSystem(job).exists(outDir)) {
            throw new FileAlreadyExistsException("Output directory " + outDir + " already exists");
        }
    }
}

