/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.LocalDirAllocator;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.JobConf;

class MapOutputFile {
    private JobConf conf;
    private LocalDirAllocator lDirAlloc = new LocalDirAllocator("mapred.local.dir");

    MapOutputFile() {
    }

    public Path getOutputFile(String mapTaskId) throws IOException {
        return this.lDirAlloc.getLocalPathToRead(mapTaskId + "/file.out", this.conf);
    }

    public Path getOutputFileForWrite(String mapTaskId, long size) throws IOException {
        return this.lDirAlloc.getLocalPathForWrite(mapTaskId + "/file.out", size, this.conf);
    }

    public Path getOutputIndexFile(String mapTaskId) throws IOException {
        return this.lDirAlloc.getLocalPathToRead(mapTaskId + "/file.out.index", this.conf);
    }

    public Path getOutputIndexFileForWrite(String mapTaskId, long size) throws IOException {
        return this.lDirAlloc.getLocalPathForWrite(mapTaskId + "/file.out.index", size, this.conf);
    }

    public Path getSpillFile(String mapTaskId, int spillNumber) throws IOException {
        return this.lDirAlloc.getLocalPathToRead(mapTaskId + "/spill" + spillNumber + ".out", this.conf);
    }

    public Path getSpillFileForWrite(String mapTaskId, int spillNumber, long size) throws IOException {
        return this.lDirAlloc.getLocalPathForWrite(mapTaskId + "/spill" + spillNumber + ".out", size, this.conf);
    }

    public Path getSpillIndexFile(String mapTaskId, int spillNumber) throws IOException {
        return this.lDirAlloc.getLocalPathToRead(mapTaskId + "/spill" + spillNumber + ".out.index", this.conf);
    }

    public Path getSpillIndexFileForWrite(String mapTaskId, int spillNumber, long size) throws IOException {
        return this.lDirAlloc.getLocalPathForWrite(mapTaskId + "/spill" + spillNumber + ".out.index", size, this.conf);
    }

    public Path getInputFile(int mapId, String reduceTaskId) throws IOException {
        return this.lDirAlloc.getLocalPathToRead(reduceTaskId + "/map_" + mapId + ".out", this.conf);
    }

    public Path getInputFileForWrite(int mapId, String reduceTaskId, long size) throws IOException {
        return this.lDirAlloc.getLocalPathForWrite(reduceTaskId + "/map_" + mapId + ".out", size, this.conf);
    }

    public void removeAll(String taskId) throws IOException {
        this.conf.deleteLocalFiles(taskId);
    }

    public void cleanupStorage() throws IOException {
        this.conf.deleteLocalFiles();
    }

    public void setConf(Configuration conf) {
        this.conf = conf instanceof JobConf ? (JobConf)conf : new JobConf(conf);
    }
}

