/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ipc;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;

class SocketChannelOutputStream
extends OutputStream {
    ByteBuffer buffer;
    ByteBuffer flush;
    SocketChannel channel;
    Selector selector;

    public SocketChannelOutputStream(SocketChannel channel) {
        this.channel = channel;
        this.buffer = ByteBuffer.allocate(8);
    }

    public void write(int b) throws IOException {
        this.buffer.clear();
        this.buffer.put((byte)b);
        this.buffer.flip();
        this.flush = this.buffer;
        this.flushBuffer();
    }

    public void close() throws IOException {
        this.channel.close();
    }

    public void flush() throws IOException {
    }

    public void write(byte[] buf, int offset, int length) throws IOException {
        this.flush = ByteBuffer.wrap(buf, offset, length);
        this.flushBuffer();
    }

    public void write(byte[] buf) throws IOException {
        this.flush = ByteBuffer.wrap(buf);
        this.flushBuffer();
    }

    private void flushBuffer() throws IOException {
        while (this.flush.hasRemaining()) {
            int len = this.channel.write(this.flush);
            if (len < 0) {
                throw new IOException("EOF");
            }
            if (len != 0) continue;
            Thread.yield();
            len = this.channel.write(this.flush);
            if (len < 0) {
                throw new IOException("EOF");
            }
            if (len != 0) continue;
            if (this.selector == null) {
                this.selector = Selector.open();
                this.channel.register(this.selector, 4);
            }
            this.selector.select();
        }
        this.flush = null;
    }

    public void destroy() {
        if (this.selector != null) {
            try {
                this.selector.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.selector = null;
            this.buffer = null;
            this.flush = null;
            this.channel = null;
        }
    }
}

