/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.io.compress.zlib;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.io.compress.Compressor;
import org.apache.hadoop.io.compress.Decompressor;
import org.apache.hadoop.io.compress.zlib.BuiltInZlibDeflater;
import org.apache.hadoop.io.compress.zlib.BuiltInZlibInflater;
import org.apache.hadoop.io.compress.zlib.ZlibCompressor;
import org.apache.hadoop.io.compress.zlib.ZlibDecompressor;
import org.apache.hadoop.util.NativeCodeLoader;

public class ZlibFactory {
    private static final Log LOG = LogFactory.getLog((String)"org.apache.hadoop.io.compress.zlib.ZlibFactory");
    private static boolean nativeZlibLoaded = false;

    public static boolean isNativeZlibLoaded() {
        return nativeZlibLoaded;
    }

    public static Compressor getZlibCompressor() {
        return nativeZlibLoaded ? new ZlibCompressor() : new BuiltInZlibDeflater();
    }

    public static Decompressor getZlibDecompressor() {
        return nativeZlibLoaded ? new ZlibDecompressor() : new BuiltInZlibInflater();
    }

    static {
        if (NativeCodeLoader.isNativeCodeLoaded()) {
            boolean bl = nativeZlibLoaded = ZlibCompressor.isNativeZlibLoaded() && ZlibDecompressor.isNativeZlibLoaded();
            if (nativeZlibLoaded) {
                LOG.info((Object)"Successfully loaded & initialized native-zlib library");
            } else {
                LOG.warn((Object)"Failed to load/initialize native-zlib library");
            }
        }
    }
}

