/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.io.compress;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.hadoop.io.compress.CompressionInputStream;
import org.apache.hadoop.io.compress.CompressionOutputStream;
import org.apache.hadoop.io.compress.CompressorStream;
import org.apache.hadoop.io.compress.DecompressorStream;
import org.apache.hadoop.io.compress.DefaultCodec;
import org.apache.hadoop.io.compress.zlib.ZlibCompressor;
import org.apache.hadoop.io.compress.zlib.ZlibDecompressor;
import org.apache.hadoop.io.compress.zlib.ZlibFactory;

public class GzipCodec
extends DefaultCodec {
    public CompressionOutputStream createOutputStream(OutputStream out) throws IOException {
        CompressorStream compOutStream = null;
        if (ZlibFactory.isNativeZlibLoaded()) {
            ZlibCompressor compressor = new ZlibCompressor(ZlibCompressor.CompressionLevel.DEFAULT_COMPRESSION, ZlibCompressor.CompressionStrategy.DEFAULT_STRATEGY, ZlibCompressor.CompressionHeader.GZIP_FORMAT, 65536);
            compOutStream = new CompressorStream(out, compressor, this.conf.getInt("io.file.buffer.size", 4096));
        } else {
            compOutStream = new GzipOutputStream(out);
        }
        return compOutStream;
    }

    public CompressionInputStream createInputStream(InputStream in) throws IOException {
        DecompressorStream compInStream = null;
        if (ZlibFactory.isNativeZlibLoaded()) {
            ZlibDecompressor decompressor = new ZlibDecompressor(ZlibDecompressor.CompressionHeader.AUTODETECT_GZIP_ZLIB, 65536);
            compInStream = new DecompressorStream(in, decompressor, this.conf.getInt("io.file.buffer.size", 4096));
        } else {
            compInStream = new GzipInputStream(in);
        }
        return compInStream;
    }

    public String getDefaultExtension() {
        return ".gz";
    }

    protected static class GzipInputStream
    extends DecompressorStream {
        public GzipInputStream(InputStream in) throws IOException {
            super(new ResetableGZIPInputStream(in));
        }

        protected GzipInputStream(DecompressorStream in) {
            super(in);
        }

        public int available() throws IOException {
            return this.in.available();
        }

        public void close() throws IOException {
            this.in.close();
        }

        public int read() throws IOException {
            return this.in.read();
        }

        public int read(byte[] data, int offset, int len) throws IOException {
            return this.in.read(data, offset, len);
        }

        public long skip(long offset) throws IOException {
            return this.in.skip(offset);
        }

        public void resetState() throws IOException {
            ((ResetableGZIPInputStream)this.in).resetState();
        }

        private static class ResetableGZIPInputStream
        extends GZIPInputStream {
            public ResetableGZIPInputStream(InputStream in) throws IOException {
                super(in);
            }

            public void resetState() throws IOException {
                this.inf.reset();
            }
        }
    }

    protected static class GzipOutputStream
    extends CompressorStream {
        public GzipOutputStream(OutputStream out) throws IOException {
            super(new ResetableGZIPOutputStream(out));
        }

        protected GzipOutputStream(CompressorStream out) {
            super(out);
        }

        public void close() throws IOException {
            this.out.close();
        }

        public void flush() throws IOException {
            this.out.flush();
        }

        public void write(int b) throws IOException {
            this.out.write(b);
        }

        public void write(byte[] data, int offset, int length) throws IOException {
            this.out.write(data, offset, length);
        }

        public void finish() throws IOException {
            ((ResetableGZIPOutputStream)this.out).finish();
        }

        public void resetState() throws IOException {
            ((ResetableGZIPOutputStream)this.out).resetState();
        }

        private static class ResetableGZIPOutputStream
        extends GZIPOutputStream {
            public ResetableGZIPOutputStream(OutputStream out) throws IOException {
                super(out);
            }

            public void resetState() throws IOException {
                this.def.reset();
            }
        }
    }
}

