/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.io.compress;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.hadoop.io.compress.Compressor;
import org.apache.hadoop.io.compress.CompressorStream;

class BlockCompressorStream
extends CompressorStream {
    private final int MAX_INPUT_SIZE;

    public BlockCompressorStream(OutputStream out, Compressor compressor, int bufferSize, int compressionOverhead) {
        super(out, compressor, bufferSize);
        this.MAX_INPUT_SIZE = bufferSize - compressionOverhead;
    }

    public BlockCompressorStream(OutputStream out, Compressor compressor) {
        this(out, compressor, 512, 18);
    }

    public void write(byte[] b, int off, int len) throws IOException {
        if (this.compressor.finished()) {
            throw new IOException("write beyond end of stream");
        }
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || off > b.length || len < 0 || off + len > b.length) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return;
        }
        this.rawWriteInt(len);
        if (!this.compressor.finished()) {
            int bufLen;
            do {
                bufLen = Math.min(len, this.MAX_INPUT_SIZE);
                this.compressor.setInput(b, off, bufLen);
                while (!this.compressor.needsInput()) {
                    this.compress();
                }
                off += bufLen;
            } while ((len -= bufLen) > 0);
        }
    }

    void compress() throws IOException {
        int len = this.compressor.compress(this.buffer, 0, this.buffer.length);
        if (len > 0) {
            this.rawWriteInt(len);
            this.out.write(this.buffer, 0, len);
        }
    }

    private void rawWriteInt(int v) throws IOException {
        this.out.write(v >>> 24 & 0xFF);
        this.out.write(v >>> 16 & 0xFF);
        this.out.write(v >>> 8 & 0xFF);
        this.out.write(v >>> 0 & 0xFF);
    }
}

