/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;

public class Trash
extends Configured {
    private static final Log LOG = LogFactory.getLog((String)"org.apache.hadoop.fs.Trash");
    private static final String CURRENT = "Current";
    private static final DateFormat CHECKPOINT = new SimpleDateFormat("yyMMddHHmm");
    private static final int MSECS_PER_MINUTE = 60000;
    private FileSystem fs;
    private Path root;
    private Path current;
    private long interval;

    public Trash(Configuration conf) throws IOException {
        super(conf);
        Path root = new Path(conf.get("fs.trash.root", "/tmp/Trash"));
        this.fs = root.getFileSystem(conf);
        if (!root.isAbsolute()) {
            root = new Path(this.fs.getWorkingDirectory(), root);
        }
        this.root = root;
        this.current = new Path(root, CURRENT);
        this.interval = conf.getLong("fs.trash.interval", 60L) * 60000L;
    }

    public boolean moveToTrash(Path path) throws IOException {
        if (this.interval == 0L) {
            return false;
        }
        if (!path.isAbsolute()) {
            path = new Path(this.fs.getWorkingDirectory(), path);
        }
        if (!this.fs.exists(path)) {
            throw new FileNotFoundException(path.toString());
        }
        URI rootUri = this.root.toUri();
        String dirPath = path.toUri().getPath();
        if (dirPath.startsWith(rootUri.getPath())) {
            return false;
        }
        Path trashPath = new Path(rootUri.getScheme(), rootUri.getAuthority(), this.current.toUri().getPath() + dirPath);
        IOException cause = null;
        for (int i = 0; i < 2; ++i) {
            Path trashDir = trashPath.getParent();
            if (!this.fs.mkdirs(trashDir)) {
                throw new IOException("Failed to create trash directory: " + trashDir);
            }
            try {
                if (!this.fs.rename(path, trashPath)) continue;
                return true;
            }
            catch (IOException e) {
                cause = e;
            }
        }
        throw (IOException)new IOException("Failed to move to trash: " + path).initCause(cause);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkpoint() throws IOException {
        Path checkpoint;
        if (!this.fs.exists(this.current)) {
            return;
        }
        DateFormat dateFormat = CHECKPOINT;
        synchronized (dateFormat) {
            checkpoint = new Path(this.root, CHECKPOINT.format(new Date()));
        }
        if (!this.fs.rename(this.current, checkpoint)) {
            throw new IOException("Failed to checkpoint trash: " + checkpoint);
        }
        LOG.info((Object)("Created trash checkpoint: " + checkpoint));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void expunge() throws IOException {
        Path[] dirs = this.fs.listPaths(this.root);
        long now = System.currentTimeMillis();
        for (int i = 0; i < dirs.length; ++i) {
            long time;
            Path dir = dirs[i];
            String name = dir.getName();
            if (name.equals(CURRENT)) continue;
            try {
                DateFormat dateFormat = CHECKPOINT;
                synchronized (dateFormat) {
                    time = CHECKPOINT.parse(name).getTime();
                }
            }
            catch (ParseException e) {
                LOG.warn((Object)("Unexpected item in trash: " + dir + ". Ignoring."));
                continue;
            }
            if (now - this.interval <= time) continue;
            if (this.fs.delete(dir)) {
                LOG.info((Object)("Deleted trash checkpoint: " + dir));
                continue;
            }
            LOG.warn((Object)("Couldn't delete checkpoint: " + dir + " Ignoring."));
        }
    }

    public Runnable getEmptier() {
        return new Emptier();
    }

    public static void main(String[] args) throws Exception {
        new Trash(new Configuration()).getEmptier().run();
    }

    private class Emptier
    implements Runnable {
        private Emptier() {
        }

        public void run() {
            if (Trash.this.interval == 0L) {
                return;
            }
            long now = System.currentTimeMillis();
            long end = this.ceiling(now, Trash.this.interval);
            while (true) {
                try {
                    Thread.sleep(end - now);
                }
                catch (InterruptedException e) {
                    return;
                }
                now = System.currentTimeMillis();
                if (now < end) continue;
                try {
                    Trash.this.expunge();
                }
                catch (IOException e) {
                    LOG.warn((Object)("Trash expunge caught: " + e + ". Ignoring."));
                }
                try {
                    Trash.this.checkpoint();
                }
                catch (IOException e) {
                    LOG.warn((Object)("Trash checkpoint caught: " + e + ". Ignoring."));
                }
                end = this.ceiling(now, Trash.this.interval);
            }
        }

        private long ceiling(long time, long interval) {
            return this.floor(time, interval) + interval;
        }

        private long floor(long time, long interval) {
            return time / interval * interval;
        }
    }
}

