/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.DF;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.util.DiskChecker;
import org.apache.hadoop.util.StringUtils;

public class LocalDirAllocator {
    private static Map<String, AllocatorPerContext> contexts = new TreeMap<String, AllocatorPerContext>();
    private String contextCfgItemName;

    public LocalDirAllocator(String contextCfgItemName) {
        this.contextCfgItemName = contextCfgItemName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AllocatorPerContext obtainContext(String contextCfgItemName) {
        Map<String, AllocatorPerContext> map = contexts;
        synchronized (map) {
            AllocatorPerContext l = contexts.get(contextCfgItemName);
            if (l == null) {
                l = new AllocatorPerContext(contextCfgItemName);
                contexts.put(contextCfgItemName, l);
            }
            return l;
        }
    }

    public Path getLocalPathForWrite(String pathStr, Configuration conf) throws IOException {
        return this.getLocalPathForWrite(pathStr, -1L, conf);
    }

    public Path getLocalPathForWrite(String pathStr, long size, Configuration conf) throws IOException {
        AllocatorPerContext context = this.obtainContext(this.contextCfgItemName);
        return context.getLocalPathForWrite(pathStr, size, conf);
    }

    public Path getLocalPathToRead(String pathStr, Configuration conf) throws IOException {
        AllocatorPerContext context = this.obtainContext(this.contextCfgItemName);
        return context.getLocalPathToRead(pathStr, conf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isContextValid(String contextCfgItemName) {
        Map<String, AllocatorPerContext> map = contexts;
        synchronized (map) {
            return contexts.containsKey(contextCfgItemName);
        }
    }

    private class AllocatorPerContext {
        private final Log LOG = LogFactory.getLog((String)"org.apache.hadoop.fs.AllocatorPerContext");
        private int dirNumLastAccessed;
        private FileSystem localFS;
        private DF[] dirDF;
        private String contextCfgItemName;
        private String[] localDirs;
        private String savedLocalDirs = "";

        public AllocatorPerContext(String contextCfgItemName) {
            this.contextCfgItemName = contextCfgItemName;
        }

        private void confChanged(Configuration conf) throws IOException {
            String newLocalDirs = conf.get(this.contextCfgItemName);
            if (!newLocalDirs.equals(this.savedLocalDirs)) {
                this.localDirs = conf.getStrings(this.contextCfgItemName);
                this.localFS = FileSystem.getLocal(conf);
                int numDirs = this.localDirs.length;
                this.dirDF = new DF[numDirs];
                for (int i = 0; i < numDirs; ++i) {
                    try {
                        this.localFS.mkdirs(new Path(this.localDirs[i]));
                    }
                    catch (IOException ie) {
                        // empty catch block
                    }
                    this.dirDF[i] = new DF(new File(this.localDirs[i]), 30000L);
                }
                this.dirNumLastAccessed = 0;
                this.savedLocalDirs = newLocalDirs;
            }
        }

        private Path createPath(String path) throws IOException {
            Path file = new Path(new Path(this.localDirs[this.dirNumLastAccessed]), path);
            try {
                DiskChecker.checkDir(new File(file.getParent().toUri().getPath()));
                return file;
            }
            catch (DiskChecker.DiskErrorException d) {
                this.LOG.warn((Object)StringUtils.stringifyException(d));
                return null;
            }
        }

        public synchronized Path getLocalPathForWrite(String path, Configuration conf) throws IOException {
            return this.getLocalPathForWrite(path, -1L, conf);
        }

        public synchronized Path getLocalPathForWrite(String pathStr, long size, Configuration conf) throws IOException {
            this.confChanged(conf);
            int numDirs = this.localDirs.length;
            int numDirsSearched = 0;
            if (pathStr.startsWith("/")) {
                pathStr = pathStr.substring(1);
            }
            Path returnPath = null;
            while (numDirsSearched < numDirs && returnPath == null) {
                if (size >= 0L) {
                    long capacity = this.dirDF[this.dirNumLastAccessed].getAvailable();
                    if (capacity > size) {
                        returnPath = this.createPath(pathStr);
                    }
                } else {
                    returnPath = this.createPath(pathStr);
                }
                ++this.dirNumLastAccessed;
                this.dirNumLastAccessed %= numDirs;
                ++numDirsSearched;
            }
            if (returnPath != null) {
                return returnPath;
            }
            throw new DiskChecker.DiskErrorException("Could not find any valid local directory for " + pathStr);
        }

        public synchronized Path getLocalPathToRead(String pathStr, Configuration conf) throws IOException {
            this.confChanged(conf);
            int numDirs = this.localDirs.length;
            int numDirsSearched = 0;
            if (pathStr.startsWith("/")) {
                pathStr = pathStr.substring(1);
            }
            while (numDirsSearched < numDirs) {
                Path file = new Path(this.localDirs[numDirsSearched], pathStr);
                if (this.localFS.exists(file)) {
                    return file;
                }
                ++numDirsSearched;
            }
            throw new DiskChecker.DiskErrorException("Could not find " + pathStr + " in any of" + " the configured local directories");
        }
    }
}

