/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.dfs;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.hadoop.dfs.FSConstants;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class TransferFsImage
implements FSConstants {
    private HttpServletResponse response;
    private boolean isGetImage = false;
    private boolean isGetEdit = false;
    private boolean isPutImage = false;
    private int remoteport = 0;
    private String machineName = null;

    public TransferFsImage(Map<String, String[]> pmap, HttpServletRequest request, HttpServletResponse response) throws IOException {
        for (String key : pmap.keySet()) {
            if (key.equals("getimage")) {
                this.isGetImage = true;
                continue;
            }
            if (key.equals("getedit")) {
                this.isGetEdit = true;
                continue;
            }
            if (key.equals("putimage")) {
                this.isPutImage = true;
                continue;
            }
            if (key.equals("port")) {
                this.remoteport = new Integer(pmap.get("port")[0]);
                continue;
            }
            if (!key.equals("machine")) continue;
            this.machineName = pmap.get("machine")[0];
        }
        if (this.isGetImage && this.isGetEdit || !this.isGetImage && !this.isGetEdit && !this.isPutImage) {
            throw new IOException("No good parameters to TransferFsImage");
        }
    }

    boolean getEdit() {
        return this.isGetEdit;
    }

    boolean getImage() {
        return this.isGetImage;
    }

    boolean putImage() {
        return this.isPutImage;
    }

    String getInfoServer() throws IOException {
        if (this.machineName == null || this.remoteport == 0) {
            throw new IOException("MachineName and port undefined");
        }
        return this.machineName + ":" + this.remoteport;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void getFileServer(OutputStream outstream, File localfile) throws IOException {
        byte[] buf = new byte[BUFFER_SIZE];
        FileInputStream infile = null;
        try {
            infile = new FileInputStream(localfile);
            int num = 1;
            while (num > 0) {
                num = infile.read(buf);
                if (num <= 0) {
                    break;
                }
                outstream.write(buf, 0, num);
            }
        }
        finally {
            outstream.close();
            if (infile != null) {
                infile.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void getFileClient(String fsName, String id, File[] localPath) throws IOException {
        int i;
        byte[] buf = new byte[BUFFER_SIZE];
        StringBuffer str = new StringBuffer("http://" + fsName + "/getimage?");
        str.append(id);
        URL url = new URL(str.toString());
        URLConnection connection = url.openConnection();
        InputStream stream = connection.getInputStream();
        FileOutputStream[] output = null;
        if (localPath != null) {
            output = new FileOutputStream[localPath.length];
            for (i = 0; i < output.length; ++i) {
                output[i] = new FileOutputStream(localPath[i]);
            }
        }
        try {
            int num = 1;
            while (num > 0) {
                num = stream.read(buf);
                if (num <= 0 || localPath == null) continue;
                for (int i2 = 0; i2 < output.length; ++i2) {
                    output[i2].write(buf, 0, num);
                }
            }
        }
        finally {
            stream.close();
            if (localPath != null) {
                for (i = 0; i < output.length; ++i) {
                    output[i].close();
                }
            }
        }
    }

    static void getFileClient(String fsName, String id, File localPath) throws IOException {
        File[] filelist = new File[]{localPath};
        TransferFsImage.getFileClient(fsName, id, filelist);
    }
}

