/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.dfs;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileLock;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.dfs.FSConstants;
import org.apache.hadoop.dfs.InconsistentFSStateException;
import org.apache.hadoop.dfs.IncorrectVersionException;
import org.apache.hadoop.dfs.StorageInfo;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.io.UTF8;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.util.VersionInfo;

abstract class Storage
extends StorageInfo {
    public static final Log LOG = LogFactory.getLog((String)"org.apache.hadoop.dfs.Storage");
    protected static final int LAST_PRE_UPGRADE_LAYOUT_VERSION = -3;
    private static final String STORAGE_FILE_LOCK = "in_use.lock";
    protected static final String STORAGE_FILE_VERSION = "VERSION";
    private static final String STORAGE_DIR_CURRENT = "current";
    private static final String STORAGE_DIR_PREVIOUS = "previous";
    private static final String STORAGE_TMP_REMOVED = "removed.tmp";
    private static final String STORAGE_TMP_PREVIOUS = "previous.tmp";
    private static final String STORAGE_TMP_FINALIZED = "finalized.tmp";
    private FSConstants.NodeType storageType;
    protected List<StorageDirectory> storageDirs;

    Storage(FSConstants.NodeType type) {
        this.storageType = type;
    }

    Storage(FSConstants.NodeType type, int nsID, long cT) {
        super(-4, nsID, cT);
        this.storageType = type;
    }

    Storage(FSConstants.NodeType type, StorageInfo storageInfo) {
        super(storageInfo);
        this.storageType = type;
    }

    int getNumStorageDirs() {
        return this.storageDirs.size();
    }

    StorageDirectory getStorageDir(int idx) {
        return this.storageDirs.get(idx);
    }

    protected void addStorageDir(StorageDirectory sd) {
        this.storageDirs.add(sd);
    }

    abstract boolean isConversionNeeded(StorageDirectory var1) throws IOException;

    protected void getFields(Properties props, StorageDirectory sd) throws IOException {
        String sv = props.getProperty("layoutVersion");
        String st = props.getProperty("storageType");
        String sid = props.getProperty("namespaceID");
        String sct = props.getProperty("cTime");
        if (sv == null || st == null || sid == null || sct == null) {
            throw new InconsistentFSStateException(sd.root, "file VERSION is invalid.");
        }
        int rv = Integer.parseInt(sv);
        FSConstants.NodeType rt = FSConstants.NodeType.valueOf(st);
        int rid = Integer.parseInt(sid);
        long rct = Long.parseLong(sct);
        if (!this.storageType.equals((Object)rt) || this.namespaceID != 0 && rid != 0 && this.namespaceID != rid) {
            throw new InconsistentFSStateException(sd.root, "is incompatible with others.");
        }
        if (rv < -4) {
            throw new IncorrectVersionException(rv, "storage directory " + sd.root.getCanonicalPath());
        }
        this.layoutVersion = rv;
        this.storageType = rt;
        this.namespaceID = rid;
        this.cTime = rct;
    }

    protected void setFields(Properties props, StorageDirectory sd) throws IOException {
        props.setProperty("layoutVersion", String.valueOf(this.layoutVersion));
        props.setProperty("storageType", this.storageType.toString());
        props.setProperty("namespaceID", String.valueOf(this.namespaceID));
        props.setProperty("cTime", String.valueOf(this.cTime));
    }

    static void rename(File from, File to) throws IOException {
        if (!from.renameTo(to)) {
            throw new IOException("Failed to rename " + from.getCanonicalPath() + " to " + to.getCanonicalPath());
        }
    }

    static void deleteDir(File dir) throws IOException {
        if (!FileUtil.fullyDelete(dir)) {
            throw new IOException("Failed to delete " + dir.getCanonicalPath());
        }
    }

    public void writeAll() throws IOException {
        this.layoutVersion = -4;
        Iterator<StorageDirectory> it = this.storageDirs.iterator();
        while (it.hasNext()) {
            it.next().write();
        }
    }

    public void unlockAll() throws IOException {
        Iterator<StorageDirectory> it = this.storageDirs.iterator();
        while (it.hasNext()) {
            it.next().unlock();
        }
    }

    public static String getBuildVersion() {
        return VersionInfo.getRevision();
    }

    static String getRegistrationID(StorageInfo storage) {
        return "NS-" + Integer.toString(storage.getNamespaceID()) + "-" + Integer.toString(storage.getLayoutVersion()) + "-" + Long.toString(storage.getCTime());
    }

    protected abstract void corruptPreUpgradeStorage(File var1) throws IOException;

    protected void writeCorruptedData(RandomAccessFile file) throws IOException {
        String messageForPreUpgradeVersion = "\nThis file is INTENTIONALLY CORRUPTED so that versions\nof Hadoop prior to 0.13 (which are incompatible\nwith this directory layout) will fail to start.\n";
        file.seek(0L);
        file.writeInt(-4);
        UTF8.writeString(file, "");
        file.writeBytes("\nThis file is INTENTIONALLY CORRUPTED so that versions\nof Hadoop prior to 0.13 (which are incompatible\nwith this directory layout) will fail to start.\n");
        file.getFD().sync();
    }

    class StorageDirectory {
        File root;
        FileLock lock;

        StorageDirectory(File dir) {
            this.root = dir;
            this.lock = null;
        }

        void read() throws IOException {
            this.read(this.getVersionFile());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void read(File from) throws IOException {
            RandomAccessFile file = new RandomAccessFile(from, "rws");
            try {
                FileInputStream in = new FileInputStream(file.getFD());
                file.seek(0L);
                Properties props = new Properties();
                props.load(in);
                Storage.this.getFields(props, this);
            }
            finally {
                file.close();
            }
        }

        void write() throws IOException {
            Storage.this.corruptPreUpgradeStorage(this.root);
            this.write(this.getVersionFile());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void write(File to) throws IOException {
            Properties props = new Properties();
            Storage.this.setFields(props, this);
            RandomAccessFile file = new RandomAccessFile(to, "rws");
            try {
                file.seek(0L);
                FileOutputStream out = new FileOutputStream(file.getFD());
                props.store(out, null);
            }
            finally {
                file.close();
            }
        }

        void clearDirectory() throws IOException {
            File curDir = this.getCurrentDir();
            if (curDir.exists() && !FileUtil.fullyDelete(curDir)) {
                throw new IOException("Cannot remove current directory: " + curDir);
            }
            if (!curDir.mkdirs()) {
                throw new IOException("Cannot create directory " + curDir);
            }
        }

        File getCurrentDir() {
            return new File(this.root, Storage.STORAGE_DIR_CURRENT);
        }

        File getVersionFile() {
            return new File(new File(this.root, Storage.STORAGE_DIR_CURRENT), Storage.STORAGE_FILE_VERSION);
        }

        File getPreviousVersionFile() {
            return new File(new File(this.root, Storage.STORAGE_DIR_PREVIOUS), Storage.STORAGE_FILE_VERSION);
        }

        File getPreviousDir() {
            return new File(this.root, Storage.STORAGE_DIR_PREVIOUS);
        }

        File getPreviousTmp() {
            return new File(this.root, Storage.STORAGE_TMP_PREVIOUS);
        }

        File getRemovedTmp() {
            return new File(this.root, Storage.STORAGE_TMP_REMOVED);
        }

        File getFinalizedTmp() {
            return new File(this.root, Storage.STORAGE_TMP_FINALIZED);
        }

        StorageState analyzeStorage(FSConstants.StartupOption startOpt) throws IOException {
            assert (this.root != null) : "root is null";
            String rootPath = this.root.getCanonicalPath();
            try {
                if (!this.root.exists()) {
                    if (startOpt != FSConstants.StartupOption.FORMAT) {
                        LOG.info((Object)("Storage directory " + rootPath + " does not exist."));
                        return StorageState.NON_EXISTENT;
                    }
                    LOG.info((Object)(rootPath + " does not exist. Creating ..."));
                    if (!this.root.mkdirs()) {
                        throw new IOException("Cannot create directory " + rootPath);
                    }
                }
                if (!this.root.isDirectory()) {
                    LOG.info((Object)(rootPath + "is not a directory."));
                    return StorageState.NON_EXISTENT;
                }
                if (!this.root.canWrite()) {
                    LOG.info((Object)("Cannot access storage directory " + rootPath));
                    return StorageState.NON_EXISTENT;
                }
            }
            catch (SecurityException ex) {
                LOG.info((Object)("Cannot access storage directory " + rootPath), (Throwable)ex);
                return StorageState.NON_EXISTENT;
            }
            this.lock();
            if (startOpt == FSConstants.StartupOption.FORMAT) {
                return StorageState.NOT_FORMATTED;
            }
            if (Storage.this.isConversionNeeded(this)) {
                return StorageState.CONVERT;
            }
            File versionFile = this.getVersionFile();
            boolean hasCurrent = versionFile.exists();
            boolean hasPrevious = this.getPreviousDir().exists();
            boolean hasPreviousTmp = this.getPreviousTmp().exists();
            boolean hasRemovedTmp = this.getRemovedTmp().exists();
            boolean hasFinalizedTmp = this.getFinalizedTmp().exists();
            if (!(hasPreviousTmp || hasRemovedTmp || hasFinalizedTmp)) {
                if (hasCurrent) {
                    return StorageState.NORMAL;
                }
                if (hasPrevious) {
                    throw new InconsistentFSStateException(this.root, "version file in current directory it is missing.");
                }
                return StorageState.NOT_FORMATTED;
            }
            if ((hasPreviousTmp ? 1 : 0) + (hasRemovedTmp ? 1 : 0) + (hasFinalizedTmp ? 1 : 0) > 1) {
                throw new InconsistentFSStateException(this.root, "too many temporary directories.");
            }
            if (hasFinalizedTmp) {
                if (hasPrevious) {
                    throw new InconsistentFSStateException(this.root, "previous and finalized.tmpcannot exist together.");
                }
                return StorageState.COMPLETE_FINALIZE;
            }
            if (hasPreviousTmp) {
                if (hasPrevious) {
                    throw new InconsistentFSStateException(this.root, "previous and previous.tmp cannot exist together.");
                }
                if (hasCurrent) {
                    return StorageState.COMPLETE_UPGRADE;
                }
                return StorageState.RECOVER_UPGRADE;
            }
            assert (hasRemovedTmp) : "hasRemovedTmp must be true";
            if (!(hasCurrent ^ hasPrevious)) {
                throw new InconsistentFSStateException(this.root, "one and only one directory current or previous must be present when removed.tmp exists.");
            }
            if (hasCurrent) {
                return StorageState.COMPLETE_ROLLBACK;
            }
            return StorageState.RECOVER_ROLLBACK;
        }

        void doRecover(StorageState curState) throws IOException {
            File curDir = this.getCurrentDir();
            String rootPath = this.root.getCanonicalPath();
            switch (curState) {
                case COMPLETE_UPGRADE: {
                    LOG.info((Object)("Completing previous upgrade for storage directory " + rootPath + "."));
                    Storage.rename(this.getPreviousTmp(), this.getPreviousDir());
                    return;
                }
                case RECOVER_UPGRADE: {
                    LOG.info((Object)("Recovering storage directory " + rootPath + " from previous upgrade."));
                    if (curDir.exists()) {
                        Storage.deleteDir(curDir);
                    }
                    Storage.rename(this.getPreviousTmp(), curDir);
                    return;
                }
                case COMPLETE_ROLLBACK: {
                    LOG.info((Object)("Completing previous rollback for storage directory " + rootPath + "."));
                    Storage.deleteDir(this.getRemovedTmp());
                    return;
                }
                case RECOVER_ROLLBACK: {
                    LOG.info((Object)("Recovering storage directory " + rootPath + " from previous rollback."));
                    Storage.rename(this.getRemovedTmp(), curDir);
                    return;
                }
                case COMPLETE_FINALIZE: {
                    LOG.info((Object)("Completing previous finalize for storage directory " + rootPath + "."));
                    Storage.deleteDir(this.getFinalizedTmp());
                    return;
                }
            }
            throw new IOException("Unexpected FS state: " + (Object)((Object)curState));
        }

        void lock() throws IOException {
            File lockF = new File(this.root, Storage.STORAGE_FILE_LOCK);
            lockF.deleteOnExit();
            RandomAccessFile file = new RandomAccessFile(lockF, "rws");
            try {
                this.lock = file.getChannel().tryLock();
            }
            catch (IOException e) {
                LOG.info((Object)StringUtils.stringifyException(e));
                file.close();
                throw e;
            }
            if (this.lock == null) {
                String msg = "Cannot lock storage " + this.root + ". The directory is already locked.";
                LOG.info((Object)msg);
                file.close();
                throw new IOException(msg);
            }
        }

        void unlock() throws IOException {
            if (this.lock == null) {
                return;
            }
            this.lock.release();
            this.lock.channel().close();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum StorageState {
        NON_EXISTENT,
        NOT_FORMATTED,
        CONVERT,
        COMPLETE_UPGRADE,
        RECOVER_UPGRADE,
        COMPLETE_FINALIZE,
        COMPLETE_ROLLBACK,
        RECOVER_ROLLBACK,
        NORMAL;

    }
}

