/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.dfs;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Map;
import java.util.Random;
import java.util.TreeSet;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.dfs.Block;
import org.apache.hadoop.dfs.DFSClient;
import org.apache.hadoop.dfs.DFSFileInfo;
import org.apache.hadoop.dfs.DataNode;
import org.apache.hadoop.dfs.DatanodeInfo;
import org.apache.hadoop.dfs.LocatedBlock;
import org.apache.hadoop.dfs.NameNode;
import org.apache.hadoop.io.UTF8;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NamenodeFsck {
    public static final Log LOG = LogFactory.getLog((String)"org.apache.hadoop.dfs.NameNode");
    public static final int FIXING_NONE = 0;
    public static final int FIXING_MOVE = 1;
    public static final int FIXING_DELETE = 2;
    private NameNode nn;
    private UTF8 lostFound = null;
    private boolean lfInited = false;
    private boolean lfInitedOk = false;
    private boolean showFiles = false;
    private boolean showBlocks = false;
    private boolean showLocations = false;
    private int fixing = 0;
    private String path = "/";
    private Configuration conf;
    private PrintWriter out;
    Random r = new Random();

    public NamenodeFsck(Configuration conf, NameNode nn, Map<String, String[]> pmap, HttpServletResponse response) throws IOException {
        this.conf = conf;
        this.nn = nn;
        this.out = response.getWriter();
        for (String key : pmap.keySet()) {
            if (key.equals("path")) {
                this.path = pmap.get("path")[0];
                continue;
            }
            if (key.equals("move")) {
                this.fixing = 1;
                continue;
            }
            if (key.equals("delete")) {
                this.fixing = 2;
                continue;
            }
            if (key.equals("files")) {
                this.showFiles = true;
                continue;
            }
            if (key.equals("blocks")) {
                this.showBlocks = true;
                continue;
            }
            if (!key.equals("locations")) continue;
            this.showLocations = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fsck() throws IOException {
        try {
            DFSFileInfo[] files = this.nn.getListing(this.path);
            FsckResult res = new FsckResult();
            res.setReplication((short)this.conf.getInt("dfs.replication", 3));
            if (files != null) {
                for (int i = 0; i < files.length; ++i) {
                    this.check(files[i], res);
                }
                this.out.println(res);
                if (res.isHealthy()) {
                    this.out.println("\n\nThe filesystem under path '" + this.path + "' is HEALTHY");
                } else {
                    this.out.println("\n\nThe filesystem under path '" + this.path + "' is CORRUPT");
                }
            } else {
                this.out.println("\n\nPath '" + this.path + "' does not exist.");
            }
        }
        finally {
            this.out.close();
        }
    }

    private void check(DFSFileInfo file, FsckResult res) throws IOException {
        if (file.isDir()) {
            if (this.showFiles) {
                this.out.println(file.getPath() + " <dir>");
            }
            res.totalDirs++;
            DFSFileInfo[] files = this.nn.getListing(file.getPath());
            for (int i = 0; i < files.length; ++i) {
                this.check(files[i], res);
            }
            return;
        }
        res.totalFiles++;
        res.totalSize += file.getLen();
        LocatedBlock[] blocks = this.nn.open(file.getPath());
        res.totalBlocks += blocks.length;
        if (this.showFiles) {
            this.out.print(file.getPath() + " " + file.getLen() + ", " + blocks.length + " block(s): ");
        } else {
            this.out.print('.');
            this.out.flush();
            if (res.totalFiles % 100L == 0L) {
                this.out.println();
            }
        }
        int missing = 0;
        long missize = 0L;
        int under = 0;
        StringBuffer report = new StringBuffer();
        for (int i = 0; i < blocks.length; ++i) {
            short targetFileReplication;
            Block block = blocks[i].getBlock();
            long id = block.getBlockId();
            DatanodeInfo[] locs = blocks[i].getLocations();
            if (locs.length > (targetFileReplication = file.getReplication())) {
                res.overReplicatedBlocks += locs.length - targetFileReplication;
                res.numOverReplicatedBlocks += 1L;
            }
            if (locs.length < targetFileReplication && locs.length > 0) {
                res.underReplicatedBlocks += targetFileReplication - locs.length;
                res.numUnderReplicatedBlocks += 1L;
                ++under;
                if (!this.showFiles) {
                    this.out.print("\n" + file.getPath() + ": ");
                }
                this.out.println(" Under replicated " + block.getBlockName() + ". Target Replicas is " + targetFileReplication + " but found " + locs.length + " replica(s).");
            }
            report.append(i + ". " + id + " len=" + block.getNumBytes());
            if (locs == null || locs.length == 0) {
                report.append(" MISSING!");
                res.addMissing(block.getBlockName(), block.getNumBytes());
                ++missing;
                missize += block.getNumBytes();
            } else {
                report.append(" repl=" + locs.length);
                if (this.showLocations) {
                    StringBuffer sb = new StringBuffer("[");
                    for (int j = 0; j < locs.length; ++j) {
                        if (j > 0) {
                            sb.append(", ");
                        }
                        sb.append(locs[j]);
                    }
                    sb.append(']');
                    report.append(" " + sb.toString());
                }
            }
            report.append('\n');
        }
        if (missing > 0) {
            if (!this.showFiles) {
                this.out.println("\n" + file.getPath() + ": " + "MISSING " + missing + " blocks of total size " + missize + " B.");
            }
            res.corruptFiles++;
            switch (this.fixing) {
                case 0: {
                    break;
                }
                case 1: {
                    this.lostFoundMove(file, blocks);
                    break;
                }
                case 2: {
                    this.nn.delete(file.getPath());
                }
            }
        }
        if (this.showFiles) {
            if (missing > 0) {
                this.out.println(" MISSING " + missing + " blocks of total size " + missize + " B");
            } else if (under == 0) {
                this.out.println(" OK");
            }
            if (this.showBlocks) {
                this.out.println(report.toString());
            }
        }
    }

    private void lostFoundMove(DFSFileInfo file, LocatedBlock[] blocks) throws IOException {
        DFSClient dfs = new DFSClient(DataNode.createSocketAddr(this.conf.get("fs.default.name", "local")), this.conf);
        if (!this.lfInited) {
            this.lostFoundInit(dfs);
        }
        if (!this.lfInitedOk) {
            return;
        }
        String target = this.lostFound.toString() + file.getPath();
        String errmsg = "Failed to move " + file.getPath() + " to /lost+found";
        try {
            if (!this.nn.mkdirs(target)) {
                LOG.warn((Object)errmsg);
                return;
            }
            int chain = 0;
            OutputStream fos = null;
            for (int i = 0; i < blocks.length; ++i) {
                LocatedBlock lblock = blocks[i];
                DatanodeInfo[] locs = lblock.getLocations();
                if (locs == null || locs.length == 0) {
                    if (fos == null) continue;
                    fos.flush();
                    fos.close();
                    fos = null;
                    continue;
                }
                if (fos == null && (fos = dfs.create(new UTF8(target.toString() + "/" + chain), true)) != null) {
                    ++chain;
                }
                if (fos == null) {
                    LOG.warn((Object)(errmsg + ": could not store chain " + chain));
                    continue;
                }
                try {
                    this.copyBlock(dfs, lblock, fos);
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    LOG.warn((Object)(" - could not copy block " + lblock.getBlock().getBlockName() + " to " + target));
                    fos.flush();
                    fos.close();
                    fos = null;
                }
            }
            if (fos != null) {
                fos.close();
            }
            LOG.warn((Object)("\n - moved corrupted file " + file.getPath() + " to /lost+found"));
            dfs.delete(new UTF8(file.getPath()));
        }
        catch (Exception e) {
            e.printStackTrace();
            LOG.warn((Object)(errmsg + ": " + e.getMessage()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyBlock(DFSClient dfs, LocatedBlock lblock, OutputStream fos) throws Exception {
        int failures = 0;
        InetSocketAddress targetAddr = null;
        TreeSet<DatanodeInfo> deadNodes = new TreeSet<DatanodeInfo>();
        Socket s = null;
        DataInputStream in = null;
        FilterOutputStream out = null;
        while (s == null) {
            DatanodeInfo chosenNode;
            try {
                chosenNode = this.bestNode(dfs, lblock.getLocations(), deadNodes);
                targetAddr = DataNode.createSocketAddr(chosenNode.getName());
            }
            catch (IOException ie) {
                if (failures >= DFSClient.MAX_BLOCK_ACQUIRE_FAILURES) {
                    throw new IOException("Could not obtain block " + lblock);
                }
                LOG.info((Object)("Could not obtain block from any node:  " + ie));
                try {
                    Thread.sleep(10000L);
                }
                catch (InterruptedException iex) {
                    // empty catch block
                }
                deadNodes.clear();
                ++failures;
                continue;
            }
            try {
                s = new Socket();
                s.connect(targetAddr, 60000);
                s.setSoTimeout(60000);
                out = new DataOutputStream(new BufferedOutputStream(s.getOutputStream()));
                ((DataOutputStream)out).write(82);
                lblock.getBlock().write((DataOutput)((Object)out));
                ((DataOutputStream)out).writeLong(0L);
                ((DataOutputStream)out).flush();
                in = new DataInputStream(new BufferedInputStream(s.getInputStream()));
                long curBlockSize = in.readLong();
                long amtSkipped = in.readLong();
                if (curBlockSize != lblock.getBlock().len) {
                    throw new IOException("Recorded block size is " + lblock.getBlock().len + ", but datanode reports size of " + curBlockSize);
                }
                if (amtSkipped == 0L) continue;
                throw new IOException("Asked for offset of 0, but only received offset of " + amtSkipped);
            }
            catch (IOException ex) {
                LOG.info((Object)("Failed to connect to " + targetAddr + ":" + ex));
                deadNodes.add(chosenNode);
                if (s != null) {
                    try {
                        s.close();
                    }
                    catch (IOException iex) {
                        // empty catch block
                    }
                }
                s = null;
            }
        }
        if (in == null) {
            throw new Exception("Could not open data stream for " + lblock.getBlock().getBlockName());
        }
        byte[] buf = new byte[1024];
        int cnt = 0;
        boolean success = true;
        try {
            while ((cnt = in.read(buf)) > 0) {
                fos.write(buf, 0, cnt);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            success = false;
        }
        finally {
            try {
                in.close();
            }
            catch (Exception e1) {}
            try {
                out.close();
            }
            catch (Exception e1) {}
            try {
                s.close();
            }
            catch (Exception e1) {}
        }
        if (!success) {
            throw new Exception("Could not copy block data for " + lblock.getBlock().getBlockName());
        }
    }

    private DatanodeInfo bestNode(DFSClient dfs, DatanodeInfo[] nodes, TreeSet<DatanodeInfo> deadNodes) throws IOException {
        if (nodes == null || nodes.length - deadNodes.size() < 1) {
            throw new IOException("No live nodes contain current block");
        }
        DatanodeInfo chosenNode = null;
        for (int i = 0; i < nodes.length; ++i) {
            String nodename;
            int colon;
            if (deadNodes.contains(nodes[i]) || (colon = (nodename = nodes[i].getName()).indexOf(58)) < 0) continue;
            nodename = nodename.substring(0, colon);
        }
        if (chosenNode == null) {
            while (deadNodes.contains(chosenNode = nodes[Math.abs(this.r.nextInt()) % nodes.length])) {
            }
        }
        return chosenNode;
    }

    private void lostFoundInit(DFSClient dfs) {
        this.lfInited = true;
        try {
            UTF8 lfName = new UTF8("/lost+found");
            if (!dfs.exists(lfName)) {
                this.lfInitedOk = dfs.mkdirs(lfName);
                this.lostFound = lfName;
            } else if (!dfs.isDirectory(lfName)) {
                LOG.warn((Object)"Cannot use /lost+found : a regular file with this name exists.");
                this.lfInitedOk = false;
            } else {
                this.lostFound = lfName;
                this.lfInitedOk = true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.lfInitedOk = false;
        }
        if (this.lostFound == null) {
            LOG.warn((Object)"Cannot initialize /lost+found .");
            this.lfInitedOk = false;
        }
    }

    public int run(String[] args) throws Exception {
        return 0;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class FsckResult {
        private ArrayList<String> missingIds = new ArrayList();
        private long missingSize = 0L;
        private long corruptFiles = 0L;
        private long overReplicatedBlocks = 0L;
        private long underReplicatedBlocks = 0L;
        private long numOverReplicatedBlocks = 0L;
        private long numUnderReplicatedBlocks = 0L;
        private int replication = 0;
        private long totalBlocks = 0L;
        private long totalFiles = 0L;
        private long totalDirs = 0L;
        private long totalSize = 0L;

        public boolean isHealthy() {
            return this.missingIds.size() == 0;
        }

        public void addMissing(String id, long size) {
            this.missingIds.add(id);
            this.missingSize += size;
        }

        public ArrayList<String> getMissingIds() {
            return this.missingIds;
        }

        public long getMissingSize() {
            return this.missingSize;
        }

        public void setMissingSize(long missingSize) {
            this.missingSize = missingSize;
        }

        public long getOverReplicatedBlocks() {
            return this.overReplicatedBlocks;
        }

        public void setOverReplicatedBlocks(long overReplicatedBlocks) {
            this.overReplicatedBlocks = overReplicatedBlocks;
        }

        public float getReplicationFactor() {
            if (this.totalBlocks != 0L) {
                return (float)(this.totalBlocks * (long)this.replication + this.overReplicatedBlocks - this.underReplicatedBlocks) / (float)this.totalBlocks;
            }
            return 0.0f;
        }

        public long getUnderReplicatedBlocks() {
            return this.underReplicatedBlocks;
        }

        public void setUnderReplicatedBlocks(long underReplicatedBlocks) {
            this.underReplicatedBlocks = underReplicatedBlocks;
        }

        public long getTotalDirs() {
            return this.totalDirs;
        }

        public void setTotalDirs(long totalDirs) {
            this.totalDirs = totalDirs;
        }

        public long getTotalFiles() {
            return this.totalFiles;
        }

        public void setTotalFiles(long totalFiles) {
            this.totalFiles = totalFiles;
        }

        public long getTotalSize() {
            return this.totalSize;
        }

        public void setTotalSize(long totalSize) {
            this.totalSize = totalSize;
        }

        public int getReplication() {
            return this.replication;
        }

        public void setReplication(int replication) {
            this.replication = replication;
        }

        public long getTotalBlocks() {
            return this.totalBlocks;
        }

        public void setTotalBlocks(long totalBlocks) {
            this.totalBlocks = totalBlocks;
        }

        public String toString() {
            StringBuffer res = new StringBuffer();
            res.append("Status: " + (this.isHealthy() ? "HEALTHY" : "CORRUPT"));
            res.append("\n Total size:\t" + this.totalSize + " B");
            res.append("\n Total blocks:\t" + this.totalBlocks);
            if (this.totalBlocks > 0L) {
                res.append(" (avg. block size " + this.totalSize / this.totalBlocks + " B)");
            }
            res.append("\n Total dirs:\t" + this.totalDirs);
            res.append("\n Total files:\t" + this.totalFiles);
            if (this.missingSize > 0L) {
                res.append("\n  ********************************");
                res.append("\n  CORRUPT FILES:\t" + this.corruptFiles);
                res.append("\n  MISSING BLOCKS:\t" + this.missingIds.size());
                res.append("\n  MISSING SIZE:\t\t" + this.missingSize + " B");
                res.append("\n  ********************************");
            }
            res.append("\n Over-replicated blocks:\t" + this.numOverReplicatedBlocks);
            if (this.totalBlocks > 0L) {
                res.append(" (" + (float)(this.overReplicatedBlocks * 100L) / (float)this.totalBlocks + " %)");
            }
            res.append("\n Under-replicated blocks:\t" + this.numUnderReplicatedBlocks);
            if (this.totalBlocks > 0L) {
                res.append(" (" + (float)(this.numUnderReplicatedBlocks * 100L) / (float)this.totalBlocks + " %)");
            }
            res.append("\n Target replication factor:\t" + this.replication);
            res.append("\n Real replication factor:\t" + this.getReplicationFactor());
            return res.toString();
        }

        public long getCorruptFiles() {
            return this.corruptFiles;
        }

        public void setCorruptFiles(long corruptFiles) {
            this.corruptFiles = corruptFiles;
        }
    }
}

