/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.dfs;

import java.io.File;
import java.io.IOException;
import org.apache.hadoop.util.StringUtils;

class InconsistentFSStateException
extends IOException {
    public InconsistentFSStateException(File dir, String descr) {
        super("Directory " + InconsistentFSStateException.getFilePath(dir) + " is in an inconsistent state: " + descr);
    }

    public InconsistentFSStateException(File dir, String descr, Throwable ex) {
        this(dir, descr + "\n" + StringUtils.stringifyException(ex));
    }

    private static String getFilePath(File dir) {
        try {
            return dir.getCanonicalPath();
        }
        catch (IOException iOException) {
            return dir.getPath();
        }
    }
}

