/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.dfs;

import java.util.HashMap;
import java.util.Random;
import org.apache.hadoop.dfs.DatanodeDescriptor;

class Host2NodesMap {
    private HashMap<String, DatanodeDescriptor[]> map = new HashMap();
    private Random r = new Random();

    Host2NodesMap() {
    }

    synchronized boolean contains(DatanodeDescriptor node) {
        if (node == null) {
            return false;
        }
        String host = node.getHost();
        DatanodeDescriptor[] nodes = this.map.get(host);
        if (nodes != null) {
            for (DatanodeDescriptor containedNode : nodes) {
                if (node != containedNode) continue;
                return true;
            }
        }
        return false;
    }

    synchronized boolean add(DatanodeDescriptor node) {
        DatanodeDescriptor[] newNodes;
        if (node == null || this.contains(node)) {
            return false;
        }
        String host = node.getHost();
        DatanodeDescriptor[] nodes = this.map.get(host);
        if (nodes == null) {
            newNodes = new DatanodeDescriptor[]{node};
        } else {
            newNodes = new DatanodeDescriptor[nodes.length + 1];
            System.arraycopy(nodes, 0, newNodes, 0, nodes.length);
            newNodes[nodes.length] = node;
        }
        this.map.put(host, newNodes);
        return true;
    }

    synchronized boolean remove(DatanodeDescriptor node) {
        int i;
        if (node == null) {
            return false;
        }
        String host = node.getHost();
        DatanodeDescriptor[] nodes = this.map.get(host);
        if (nodes == null) {
            return false;
        }
        if (nodes.length == 1) {
            if (nodes[0] == node) {
                this.map.remove(host);
                return true;
            }
            return false;
        }
        for (i = 0; i < nodes.length && nodes[i] != node; ++i) {
        }
        if (i == nodes.length) {
            return false;
        }
        DatanodeDescriptor[] newNodes = new DatanodeDescriptor[nodes.length - 1];
        System.arraycopy(nodes, 0, newNodes, 0, i);
        System.arraycopy(nodes, i + 1, newNodes, i, nodes.length - i - 1);
        this.map.put(host, newNodes);
        return true;
    }

    synchronized DatanodeDescriptor getDatanodeByHost(String host) {
        if (host == null) {
            return null;
        }
        DatanodeDescriptor[] nodes = this.map.get(host);
        if (nodes == null) {
            return null;
        }
        if (nodes.length == 1) {
            return nodes[0];
        }
        return nodes[this.r.nextInt(nodes.length)];
    }

    public DatanodeDescriptor getDatanodeByName(String name) {
        if (name == null) {
            return null;
        }
        int colon = name.indexOf(":");
        String host = colon < 0 ? name : name.substring(0, colon);
        DatanodeDescriptor[] nodes = this.map.get(host);
        if (nodes == null) {
            return null;
        }
        for (DatanodeDescriptor containedNode : nodes) {
            if (!name.equals(containedNode.getName())) continue;
            return containedNode;
        }
        return null;
    }
}

