/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.dfs;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import org.apache.hadoop.dfs.Block;
import org.apache.hadoop.dfs.DatanodeDescriptor;
import org.apache.hadoop.dfs.DatanodeID;
import org.apache.hadoop.dfs.FSConstants;
import org.apache.hadoop.dfs.FSDirectory;
import org.apache.hadoop.dfs.FSEditLog;
import org.apache.hadoop.dfs.FSNamesystem;
import org.apache.hadoop.dfs.InconsistentFSStateException;
import org.apache.hadoop.dfs.Storage;
import org.apache.hadoop.dfs.StorageInfo;
import org.apache.hadoop.io.UTF8;
import org.apache.hadoop.io.WritableComparable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class FSImage
extends Storage {
    private long checkpointTime = -1L;
    private FSEditLog editLog = null;
    private boolean isUpgradeFinalized = false;

    FSImage() {
        super(FSConstants.NodeType.NAME_NODE);
        this.editLog = new FSEditLog(this);
    }

    FSImage(Collection<File> fsDirs) throws IOException {
        this();
        this.setStorageDirectories(fsDirs);
    }

    FSImage(StorageInfo storageInfo) {
        super(FSConstants.NodeType.NAME_NODE, storageInfo);
    }

    FSImage(File imageDir) throws IOException {
        this();
        ArrayList<File> dirs = new ArrayList<File>(1);
        dirs.add(imageDir);
        this.setStorageDirectories(dirs);
    }

    void setStorageDirectories(Collection<File> fsDirs) throws IOException {
        this.storageDirs = new ArrayList(fsDirs.size());
        Iterator<File> it = fsDirs.iterator();
        while (it.hasNext()) {
            this.addStorageDir(new Storage.StorageDirectory(this, it.next()));
        }
    }

    File getImageFile(int imageDirIdx, NameNodeFile type) {
        return FSImage.getImageFile(this.getStorageDir(imageDirIdx), type);
    }

    static File getImageFile(Storage.StorageDirectory sd, NameNodeFile type) {
        return new File(sd.getCurrentDir(), type.getName());
    }

    File getEditFile(int idx) {
        return this.getImageFile(idx, NameNodeFile.EDITS);
    }

    File getEditNewFile(int idx) {
        return this.getImageFile(idx, NameNodeFile.EDITS_NEW);
    }

    void recoverTransitionRead(Collection<File> dataDirs, FSConstants.StartupOption startOpt) throws IOException {
        assert (startOpt != FSConstants.StartupOption.FORMAT) : "NameNode formatting should be performed before reading the image";
        this.storageDirs = new ArrayList(dataDirs.size());
        ArrayList<Storage.StorageState> dataDirStates = new ArrayList<Storage.StorageState>(dataDirs.size());
        boolean isFormatted = false;
        for (File dataDir : dataDirs) {
            Storage.StorageState curState;
            Storage.StorageDirectory sd = new Storage.StorageDirectory(this, dataDir);
            try {
                curState = sd.analyzeStorage(startOpt);
                switch (curState) {
                    case NON_EXISTENT: {
                        throw new InconsistentFSStateException(sd.root, "storage directory does not exist or is not accessible.");
                    }
                    case NOT_FORMATTED: {
                        break;
                    }
                    case CONVERT: {
                        if (!this.convertLayout(sd)) break;
                        curState = Storage.StorageState.NOT_FORMATTED;
                        break;
                    }
                    case NORMAL: {
                        break;
                    }
                    default: {
                        sd.doRecover(curState);
                    }
                }
                if (curState != Storage.StorageState.NOT_FORMATTED && startOpt != FSConstants.StartupOption.ROLLBACK) {
                    sd.read();
                    isFormatted = true;
                }
            }
            catch (IOException ioe) {
                sd.unlock();
                throw ioe;
            }
            this.addStorageDir(sd);
            ((AbstractList)dataDirStates).add(curState);
        }
        if (dataDirs.size() == 0) {
            throw new IOException("All specified directories are not accessible or do not exist.");
        }
        if (!isFormatted && startOpt != FSConstants.StartupOption.ROLLBACK) {
            throw new IOException("NameNode is not formatted.");
        }
        if (startOpt != FSConstants.StartupOption.UPGRADE && this.layoutVersion < -3 && this.layoutVersion != -4) {
            throw new IOException("\nFile system image contains an old layout version " + this.layoutVersion + ".\nAn upgrade to version " + -4 + " is required.\nPlease restart NameNode with -upgrade option.");
        }
        this.checkpointTime = 0L;
        block18: for (int idx = 0; idx < this.getNumStorageDirs(); ++idx) {
            Storage.StorageDirectory sd = this.getStorageDir(idx);
            Storage.StorageState curState = (Storage.StorageState)((Object)((AbstractList)dataDirStates).get(idx));
            switch (curState) {
                case NON_EXISTENT: {
                    assert (false) : (Object)((Object)Storage.StorageState.NON_EXISTENT) + " state cannot be here";
                }
                case NOT_FORMATTED: {
                    LOG.info((Object)("Storage directory " + sd.root + " is not formatted."));
                    LOG.info((Object)"Formatting ...");
                    sd.clearDirectory();
                    continue block18;
                }
            }
        }
        switch (startOpt) {
            case UPGRADE: {
                this.doUpgrade();
                break;
            }
            case ROLLBACK: {
                this.doRollback();
            }
            case REGULAR: {
                if (this.loadFSImage()) {
                    this.saveFSImage();
                    break;
                }
                this.editLog.open();
            }
        }
        assert (this.editLog != null) : "editLog must be initialized";
        assert (this.editLog.getNumEditStreams() > 0) : "editLog should be opened";
    }

    private void doUpgrade() throws IOException {
        for (int idx = 0; idx < this.getNumStorageDirs(); ++idx) {
            Storage.StorageDirectory sd = this.getStorageDir(idx);
            if (!sd.getPreviousDir().exists()) continue;
            throw new InconsistentFSStateException(sd.root, "previous fs state should not exist during upgrade. Finalize or rollback first.");
        }
        this.loadFSImage();
        long oldCTime = this.getCTime();
        this.cTime = FSNamesystem.now();
        int oldLV = this.getLayoutVersion();
        this.layoutVersion = -4;
        this.checkpointTime = FSNamesystem.now();
        for (int idx = 0; idx < this.getNumStorageDirs(); ++idx) {
            Storage.StorageDirectory sd = this.getStorageDir(idx);
            LOG.info((Object)("Upgrading image directory " + sd.root + ".\n   old LV = " + oldLV + "; old CTime = " + oldCTime + ".\n   new LV = " + this.getLayoutVersion() + "; new CTime = " + this.getCTime()));
            File curDir = sd.getCurrentDir();
            File prevDir = sd.getPreviousDir();
            File tmpDir = sd.getPreviousTmp();
            assert (curDir.exists()) : "Current directory must exist.";
            assert (!prevDir.exists()) : "prvious directory must not exist.";
            assert (!tmpDir.exists()) : "prvious.tmp directory must not exist.";
            FSImage.rename(curDir, tmpDir);
            if (!curDir.mkdir()) {
                throw new IOException("Cannot create directory " + curDir);
            }
            this.saveFSImage(FSImage.getImageFile(sd, NameNodeFile.IMAGE));
            this.editLog.createEditLogFile(FSImage.getImageFile(sd, NameNodeFile.EDITS));
            sd.write();
            FSImage.rename(tmpDir, prevDir);
            this.isUpgradeFinalized = false;
            LOG.info((Object)("Upgrade of " + sd.root + " is complete."));
        }
        this.editLog.open();
    }

    private void doRollback() throws IOException {
        File prevDir;
        Storage.StorageDirectory sd;
        int idx;
        boolean canRollback = false;
        FSImage prevState = new FSImage();
        prevState.layoutVersion = -4;
        for (idx = 0; idx < this.getNumStorageDirs(); ++idx) {
            sd = this.getStorageDir(idx);
            prevDir = sd.getPreviousDir();
            if (!prevDir.exists()) {
                LOG.info((Object)("Storage directory " + sd.root + " does not contain previous fs state."));
                sd.read();
                continue;
            }
            FSImage fSImage = prevState;
            fSImage.getClass();
            Storage.StorageDirectory sdPrev = new Storage.StorageDirectory(fSImage, sd.root);
            sdPrev.read(sdPrev.getPreviousVersionFile());
            canRollback = true;
        }
        if (!canRollback) {
            throw new IOException("Cannot rollback. None of the storage directories contain previous fs state.");
        }
        for (idx = 0; idx < this.getNumStorageDirs(); ++idx) {
            sd = this.getStorageDir(idx);
            prevDir = sd.getPreviousDir();
            if (!prevDir.exists()) continue;
            LOG.info((Object)("Rolling back storage directory " + sd.root + ".\n   new LV = " + prevState.getLayoutVersion() + "; new CTime = " + prevState.getCTime()));
            File tmpDir = sd.getRemovedTmp();
            assert (!tmpDir.exists()) : "removed.tmp directory must not exist.";
            File curDir = sd.getCurrentDir();
            assert (curDir.exists()) : "Current directory must exist.";
            FSImage.rename(curDir, tmpDir);
            FSImage.rename(prevDir, curDir);
            FSImage.deleteDir(tmpDir);
            LOG.info((Object)("Rollback of " + sd.root + " is complete."));
        }
        this.isUpgradeFinalized = true;
    }

    private void doFinalize(Storage.StorageDirectory sd) throws IOException {
        File prevDir = sd.getPreviousDir();
        if (!prevDir.exists()) {
            return;
        }
        LOG.info((Object)("Finalizing upgrade for storage directory " + sd.root + ".\n   cur LV = " + this.getLayoutVersion() + "; cur CTime = " + this.getCTime()));
        assert (sd.getCurrentDir().exists()) : "Current directory must exist.";
        File tmpDir = sd.getFinalizedTmp();
        FSImage.rename(prevDir, tmpDir);
        FSImage.deleteDir(tmpDir);
        this.isUpgradeFinalized = true;
        LOG.info((Object)("Finalize upgrade for " + sd.root + " is complete."));
    }

    void finalizeUpgrade() throws IOException {
        for (int idx = 0; idx < this.getNumStorageDirs(); ++idx) {
            this.doFinalize(this.getStorageDir(idx));
        }
    }

    boolean isUpgradeFinalized() {
        return this.isUpgradeFinalized;
    }

    @Override
    protected void getFields(Properties props, Storage.StorageDirectory sd) throws IOException {
        super.getFields(props, sd);
        if (this.layoutVersion == 0) {
            throw new IOException("NameNode directory " + sd.root + " is not formatted.");
        }
        this.checkpointTime = this.readCheckpointTime(sd);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long readCheckpointTime(Storage.StorageDirectory sd) throws IOException {
        File timeFile = FSImage.getImageFile(sd, NameNodeFile.TIME);
        long timeStamp = 0L;
        if (timeFile.exists() && timeFile.canRead()) {
            DataInputStream in = new DataInputStream(new FileInputStream(timeFile));
            try {
                timeStamp = in.readLong();
            }
            finally {
                in.close();
            }
        }
        return timeStamp;
    }

    @Override
    protected void setFields(Properties props, Storage.StorageDirectory sd) throws IOException {
        super.setFields(props, sd);
        this.writeCheckpointTime(sd);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void writeCheckpointTime(Storage.StorageDirectory sd) throws IOException {
        if (this.checkpointTime < 0L) {
            return;
        }
        File timeFile = FSImage.getImageFile(sd, NameNodeFile.TIME);
        if (timeFile.exists()) {
            timeFile.delete();
        }
        DataOutputStream out = new DataOutputStream(new FileOutputStream(timeFile));
        try {
            out.writeLong(this.checkpointTime);
        }
        finally {
            out.close();
        }
    }

    void processIOError(int index) throws IOException {
        int nrDirs = this.getNumStorageDirs();
        assert (index >= 0 && index < nrDirs);
        if (nrDirs == 1) {
            throw new IOException("Checkpoint directories inaccessible.");
        }
        this.storageDirs.remove(index);
    }

    FSEditLog getEditLog() {
        return this.editLog;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    boolean isConversionNeeded(Storage.StorageDirectory sd) throws IOException {
        File oldImageDir = new File(sd.root, "image");
        if (!oldImageDir.exists()) {
            throw new InconsistentFSStateException(sd.root, oldImageDir + " does not exist.");
        }
        File oldF = new File(oldImageDir, "fsimage");
        RandomAccessFile oldFile = new RandomAccessFile(oldF, "rws");
        if (oldFile == null) {
            throw new IOException("Cannot read file: " + oldF);
        }
        try {
            oldFile.seek(0L);
            int odlVersion = oldFile.readInt();
            if (odlVersion < -3) {
                boolean bl = false;
                return bl;
            }
        }
        finally {
            oldFile.close();
        }
        if (!oldImageDir.isDirectory()) {
            throw new InconsistentFSStateException(sd.root, oldImageDir + " is not a directory.");
        }
        if (!oldImageDir.canWrite()) {
            throw new InconsistentFSStateException(sd.root, oldImageDir + " is not writable.");
        }
        return true;
    }

    private boolean convertLayout(Storage.StorageDirectory sd) throws IOException {
        File oldEdits2;
        File oldImageDir = new File(sd.root, "image");
        assert (oldImageDir.exists()) : "Old image directory is missing";
        File oldImage = new File(oldImageDir, "fsimage");
        LOG.info((Object)("Old layout version directory " + oldImageDir + " is found. New layout version is " + -4));
        LOG.info((Object)"Trying to convert ...");
        File newImageDir = sd.getCurrentDir();
        File versionF = sd.getVersionFile();
        if (versionF.exists()) {
            throw new IOException("Version file already exists: " + versionF);
        }
        if (newImageDir.exists()) {
            FSImage.deleteDir(newImageDir);
        }
        FSImage.rename(oldImageDir, newImageDir);
        File oldEdits1 = new File(sd.root, "edits");
        if (oldEdits1.exists()) {
            FSImage.rename(oldEdits1, FSImage.getImageFile(sd, NameNodeFile.EDITS));
        }
        if ((oldEdits2 = new File(sd.root, "edits.new")).exists()) {
            FSImage.rename(oldEdits2, FSImage.getImageFile(sd, NameNodeFile.EDITS_NEW));
        }
        this.layoutVersion = -3;
        File newImageFile = FSImage.getImageFile(sd, NameNodeFile.IMAGE);
        boolean needReformat = false;
        if (!newImageFile.exists()) {
            LOG.info((Object)("Old image file " + oldImage + " does not exist. "));
            needReformat = true;
        } else {
            sd.write();
        }
        LOG.info((Object)("Conversion of " + oldImage + " is complete."));
        return needReformat;
    }

    void recoverInterruptedCheckpoint(Storage.StorageDirectory sd) throws IOException {
        File curFile = FSImage.getImageFile(sd, NameNodeFile.IMAGE);
        File ckptFile = FSImage.getImageFile(sd, NameNodeFile.IMAGE_NEW);
        if (ckptFile.exists()) {
            if (FSImage.getImageFile(sd, NameNodeFile.EDITS_NEW).exists()) {
                if (!ckptFile.delete()) {
                    throw new IOException("Unable to delete " + ckptFile);
                }
            } else if (!ckptFile.renameTo(curFile)) {
                curFile.delete();
                if (!ckptFile.renameTo(curFile)) {
                    throw new IOException("Unable to rename " + ckptFile + " to " + curFile);
                }
            }
        }
    }

    boolean loadFSImage() throws IOException {
        long latestCheckpointTime = Long.MIN_VALUE;
        Storage.StorageDirectory latestSD = null;
        boolean needToSave = false;
        this.isUpgradeFinalized = true;
        for (int idx = 0; idx < this.getNumStorageDirs(); ++idx) {
            Storage.StorageDirectory sd = this.getStorageDir(idx);
            this.recoverInterruptedCheckpoint(sd);
            if (!sd.getVersionFile().exists()) {
                needToSave |= true;
                continue;
            }
            assert (FSImage.getImageFile(sd, NameNodeFile.IMAGE).exists()) : "Image file must exist.";
            this.checkpointTime = this.readCheckpointTime(sd);
            if (latestCheckpointTime < this.checkpointTime) {
                latestCheckpointTime = this.checkpointTime;
                latestSD = sd;
            }
            if (this.checkpointTime <= 0L) {
                needToSave |= true;
            }
            this.isUpgradeFinalized &= !sd.getPreviousDir().exists();
        }
        assert (latestSD != null) : "Latest storage directory was not determined.";
        latestSD.read();
        needToSave |= this.loadFSImage(FSImage.getImageFile(latestSD, NameNodeFile.IMAGE));
        return needToSave |= this.loadFSEdits(latestSD) > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean loadFSImage(File curFile) throws IOException {
        assert (this.getLayoutVersion() < 0) : "Negative layout version is expected.";
        assert (curFile != null) : "curFile is null";
        FSDirectory fsDir = FSNamesystem.getFSNamesystem().dir;
        boolean needToSave = true;
        int imgVersion = this.getLayoutVersion();
        DataInputStream in = new DataInputStream(new BufferedInputStream(new FileInputStream(curFile)));
        try {
            imgVersion = in.readInt();
            if (imgVersion <= -2) {
                this.namespaceID = in.readInt();
            }
            int numFiles = 0;
            if (imgVersion >= 0) {
                numFiles = imgVersion;
                imgVersion = 0;
            } else {
                numFiles = in.readInt();
            }
            this.layoutVersion = imgVersion;
            needToSave = imgVersion != -4;
            short replication = FSNamesystem.getFSNamesystem().getDefaultReplication();
            for (int i = 0; i < numFiles; ++i) {
                UTF8 name = new UTF8();
                name.readFields(in);
                if (imgVersion < 0) {
                    replication = in.readShort();
                    replication = FSEditLog.adjustReplication(replication);
                }
                int numBlocks = in.readInt();
                Block[] blocks = null;
                if (numBlocks > 0) {
                    blocks = new Block[numBlocks];
                    for (int j = 0; j < numBlocks; ++j) {
                        blocks[j] = new Block();
                        blocks[j].readFields(in);
                    }
                }
                fsDir.unprotectedAddFile(name, blocks, replication);
            }
            this.loadDatanodes(imgVersion, in);
        }
        finally {
            in.close();
        }
        return needToSave;
    }

    int loadFSEdits(Storage.StorageDirectory sd) throws IOException {
        int numEdits = 0;
        numEdits = this.editLog.loadFSEdits(FSImage.getImageFile(sd, NameNodeFile.EDITS));
        File editsNew = FSImage.getImageFile(sd, NameNodeFile.EDITS_NEW);
        if (editsNew.exists()) {
            numEdits += this.editLog.loadFSEdits(editsNew);
        }
        return numEdits;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void saveFSImage(File newFile) throws IOException {
        FSDirectory fsDir = FSNamesystem.getFSNamesystem().dir;
        DataOutputStream out = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(newFile)));
        try {
            out.writeInt(-4);
            out.writeInt(this.namespaceID);
            out.writeInt(fsDir.rootDir.numItemsInTree() - 1);
            FSImage.saveImage("", fsDir.rootDir, out);
            this.saveDatanodes(out);
        }
        finally {
            out.close();
        }
    }

    void saveFSImage() throws IOException {
        this.editLog.createNewIfMissing();
        for (int idx = 0; idx < this.getNumStorageDirs(); ++idx) {
            Storage.StorageDirectory sd = this.getStorageDir(idx);
            this.saveFSImage(FSImage.getImageFile(sd, NameNodeFile.IMAGE_NEW));
            this.editLog.createEditLogFile(FSImage.getImageFile(sd, NameNodeFile.EDITS));
        }
        this.rollFSImage();
    }

    private int newNamespaceID() {
        Random r = new Random();
        r.setSeed(FSNamesystem.now());
        int newID = 0;
        while (newID == 0) {
            newID = r.nextInt(Integer.MAX_VALUE);
        }
        return newID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void format(Storage.StorageDirectory sd) throws IOException {
        sd.clearDirectory();
        sd.lock();
        try {
            this.saveFSImage(FSImage.getImageFile(sd, NameNodeFile.IMAGE));
            this.editLog.createEditLogFile(FSImage.getImageFile(sd, NameNodeFile.EDITS));
            sd.write();
        }
        finally {
            sd.unlock();
        }
        LOG.info((Object)("Storage directory " + sd.root + " has been successfully formatted."));
    }

    public void format() throws IOException {
        this.layoutVersion = -4;
        this.namespaceID = this.newNamespaceID();
        this.cTime = 0L;
        this.checkpointTime = FSNamesystem.now();
        for (int idx = 0; idx < this.getNumStorageDirs(); ++idx) {
            Storage.StorageDirectory sd = this.getStorageDir(idx);
            this.format(sd);
        }
    }

    private static void saveImage(String parentPrefix, FSDirectory.INode root, DataOutputStream out) throws IOException {
        String fullName = "";
        if (root.getParent() != null) {
            fullName = parentPrefix + "/" + root.getLocalName();
            new UTF8(fullName).write(out);
            out.writeShort(root.getReplication());
            if (root.isDir()) {
                out.writeInt(0);
            } else {
                int nrBlocks = root.getBlocks().length;
                out.writeInt(nrBlocks);
                for (int i = 0; i < nrBlocks; ++i) {
                    root.getBlocks()[i].write(out);
                }
            }
        }
        Iterator<FSDirectory.INode> it = root.getChildIterator();
        while (it != null && it.hasNext()) {
            FSImage.saveImage(fullName, it.next(), out);
        }
    }

    void saveDatanodes(DataOutputStream out) throws IOException {
        Map<String, DatanodeDescriptor> datanodeMap = FSNamesystem.getFSNamesystem().datanodeMap;
        int size = datanodeMap.size();
        out.writeInt(size);
        Iterator<DatanodeDescriptor> it = datanodeMap.values().iterator();
        while (it.hasNext()) {
            DatanodeImage nodeImage = new DatanodeImage(it.next());
            nodeImage.write(out);
        }
    }

    void loadDatanodes(int version, DataInputStream in) throws IOException {
        if (version > -3) {
            return;
        }
        FSNamesystem fsNamesys = FSNamesystem.getFSNamesystem();
        int size = in.readInt();
        for (int i = 0; i < size; ++i) {
            DatanodeImage nodeImage = new DatanodeImage();
            nodeImage.readFields(in);
            fsNamesys.unprotectedAddDatanode(nodeImage.getDatanodeDescriptor());
        }
    }

    void rollFSImage() throws IOException {
        File ckpt;
        Storage.StorageDirectory sd;
        int idx;
        if (!this.editLog.existsNew()) {
            throw new IOException("New Edits file does not exist");
        }
        for (idx = 0; idx < this.getNumStorageDirs(); ++idx) {
            sd = this.getStorageDir(idx);
            ckpt = FSImage.getImageFile(sd, NameNodeFile.IMAGE_NEW);
            if (ckpt.exists()) continue;
            throw new IOException("Checkpoint file " + ckpt + " does not exist");
        }
        this.editLog.purgeEditLog();
        for (idx = 0; idx < this.getNumStorageDirs(); ++idx) {
            File curFile;
            sd = this.getStorageDir(idx);
            ckpt = FSImage.getImageFile(sd, NameNodeFile.IMAGE_NEW);
            if (ckpt.renameTo(curFile = FSImage.getImageFile(sd, NameNodeFile.IMAGE))) continue;
            curFile.delete();
            if (ckpt.renameTo(curFile)) continue;
            this.editLog.processIOError(idx);
            --idx;
        }
        this.layoutVersion = -4;
        this.checkpointTime = FSNamesystem.now();
        for (idx = 0; idx < this.getNumStorageDirs(); ++idx) {
            sd = this.getStorageDir(idx);
            try {
                sd.write();
                continue;
            }
            catch (IOException e) {
                LOG.error((Object)("Cannot write file " + sd.root), (Throwable)e);
                this.editLog.processIOError(idx);
                --idx;
            }
        }
    }

    void close() throws IOException {
        this.getEditLog().close();
        this.unlockAll();
    }

    File getFsImageName() {
        return this.getImageFile(0, NameNodeFile.IMAGE);
    }

    File[] getFsImageNameCheckpoint() {
        File[] list = new File[this.getNumStorageDirs()];
        for (int i = 0; i < this.getNumStorageDirs(); ++i) {
            list[i] = FSImage.getImageFile(this.getStorageDir(i), NameNodeFile.IMAGE_NEW);
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void corruptPreUpgradeStorage(File rootDir) throws IOException {
        File oldImageDir = new File(rootDir, "image");
        if (!oldImageDir.exists() && !oldImageDir.mkdir()) {
            throw new IOException("Cannot create directory " + oldImageDir);
        }
        File oldImage = new File(oldImageDir, "fsimage");
        if (!oldImage.exists() && !oldImage.createNewFile()) {
            throw new IOException("Cannot create file " + oldImage);
        }
        RandomAccessFile oldFile = new RandomAccessFile(oldImage, "rws");
        if (oldFile == null) {
            throw new IOException("Cannot read file: " + oldImage);
        }
        try {
            this.writeCorruptedData(oldFile);
        }
        finally {
            oldFile.close();
        }
    }

    static class DatanodeImage
    implements WritableComparable {
        DatanodeDescriptor node;

        DatanodeImage() {
            this.node = new DatanodeDescriptor();
        }

        DatanodeImage(DatanodeDescriptor from) {
            this.node = from;
        }

        DatanodeDescriptor getDatanodeDescriptor() {
            return this.node;
        }

        public int compareTo(Object o) {
            return this.node.compareTo(o);
        }

        public void write(DataOutput out) throws IOException {
            DatanodeID id = new DatanodeID(this.node.getName(), this.node.getStorageID(), this.node.getInfoPort());
            id.write(out);
            out.writeLong(this.node.getCapacity());
            out.writeLong(this.node.getRemaining());
            out.writeLong(this.node.getLastUpdate());
            out.writeInt(this.node.getXceiverCount());
        }

        public void readFields(DataInput in) throws IOException {
            DatanodeID id = new DatanodeID();
            id.readFields(in);
            long capacity = in.readLong();
            long remaining = in.readLong();
            long lastUpdate = in.readLong();
            int xceiverCount = in.readInt();
            this.node.updateRegInfo(id);
            this.node.setStorageID(id.getStorageID());
            this.node.setCapacity(capacity);
            this.node.setRemaining(remaining);
            this.node.setLastUpdate(lastUpdate);
            this.node.setXceiverCount(xceiverCount);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum NameNodeFile {
        IMAGE("fsimage"),
        TIME("fstime"),
        EDITS("edits"),
        IMAGE_NEW("fsimage.ckpt"),
        EDITS_NEW("edits.new");

        private String fileName = null;

        private NameNodeFile(String name) {
            this.fileName = name;
        }

        String getName() {
            return this.fileName;
        }
    }
}

