/*
 * Decompiled with CFR 0.152.
 */
package thredds.inventory.bdb;

import com.sleepycat.je.Cursor;
import com.sleepycat.je.Database;
import com.sleepycat.je.DatabaseConfig;
import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.DatabaseStats;
import com.sleepycat.je.Environment;
import com.sleepycat.je.EnvironmentConfig;
import com.sleepycat.je.EnvironmentLockedException;
import com.sleepycat.je.EnvironmentStats;
import com.sleepycat.je.LockMode;
import com.sleepycat.je.OperationStatus;
import com.sleepycat.je.SecondaryDatabase;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Formatter;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thredds.inventory.MFile;
import ucar.nc2.units.DateFormatter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MetadataManager {
    private static final Logger logger = LoggerFactory.getLogger(MetadataManager.class);
    private static final String UTF8 = "UTF-8";
    private static String root = null;
    private static Environment myEnv = null;
    private static List<Database> openDatabases = new ArrayList<Database>();
    private static boolean readOnly;
    private static boolean debug;
    private String collectionName;
    private Database database;
    private SecondaryDatabase secondary;
    private Calendar cal = new GregorianCalendar(TimeZone.getTimeZone("UTC"));
    private DateFormatter dateFormatter = new DateFormatter();
    private boolean showDelete = false;

    public static void setCacheDirectory(String dir) {
        root = dir;
        MetadataManager.setup(root, false);
    }

    private static void setup(String dirName, boolean _readOnly) throws DatabaseException {
        readOnly = _readOnly;
        EnvironmentConfig myEnvConfig = new EnvironmentConfig();
        myEnvConfig.setReadOnly(readOnly);
        myEnvConfig.setAllowCreate(!readOnly);
        myEnvConfig.setSharedCache(true);
        File dir = new File(dirName);
        dir.mkdirs();
        try {
            myEnv = new Environment(dir, myEnvConfig);
            logger.info("MetadataManager opened bdb in directory=" + dir);
        }
        catch (EnvironmentLockedException e) {
            readOnly = true;
            myEnvConfig.setReadOnly(true);
            myEnvConfig.setAllowCreate(false);
            myEnv = new Environment(dir, myEnvConfig);
        }
    }

    public static void closeAll() {
        if (debug) {
            System.out.println("close MetadataManager");
        }
        for (Database db : openDatabases) {
            if (debug) {
                System.out.println("  close database " + db.getDatabaseName());
            }
            db.close();
        }
        if (myEnv != null) {
            try {
                myEnv.close();
                myEnv = null;
            }
            catch (DatabaseException dbe) {
                logger.error("Error closing MyDbEnv: " + dbe.toString());
                System.exit(-1);
            }
        }
    }

    public static void showEnvStats(Formatter f) {
        if (myEnv == null) {
            MetadataManager.setup(root, false);
        }
        try {
            EnvironmentStats stats = myEnv.getStats(null);
            f.format("env stats= %s%n", stats);
            for (String dbName : myEnv.getDatabaseNames()) {
                f.format(" collection = %s%n", dbName);
            }
        }
        catch (DatabaseException e) {
            e.printStackTrace();
        }
    }

    public static String getCacheLocation() {
        return root;
    }

    public static List<String> getCollectionNames() {
        if (myEnv == null) {
            MetadataManager.setup(root, false);
        }
        return myEnv.getDatabaseNames();
    }

    public static boolean deleteCollection(String collectionName) {
        try {
            myEnv.removeDatabase(null, collectionName);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("BDB failed to delete Collection ", e);
            return false;
        }
    }

    public static void delete(String collectionName, String key) {
        try {
            MetadataManager mm = new MetadataManager(collectionName);
            mm.delete(key);
            mm.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public MetadataManager(String collectionName) throws DatabaseException, IOException {
        this.collectionName = collectionName;
        if (myEnv == null) {
            MetadataManager.setup(root, false);
        }
        DatabaseConfig dbConfig = new DatabaseConfig();
        dbConfig.setReadOnly(readOnly);
        dbConfig.setAllowCreate(!readOnly);
        if (!readOnly) {
            dbConfig.setDeferredWrite(true);
        }
        this.database = myEnv.openDatabase(null, collectionName, dbConfig);
        openDatabases.add(this.database);
    }

    public void put(String key, String value) {
        if (readOnly) {
            return;
        }
        try {
            this.database.put(null, new DatabaseEntry(key.getBytes(UTF8)), new DatabaseEntry(value.getBytes(UTF8)));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    public void put(byte[] key, byte[] value) {
        if (readOnly) {
            return;
        }
        this.database.put(null, new DatabaseEntry(key), new DatabaseEntry(value));
    }

    public void put(String key, byte[] value) {
        try {
            this.database.put(null, new DatabaseEntry(key.getBytes(UTF8)), new DatabaseEntry(value));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    public byte[] get(byte[] key) {
        DatabaseEntry value = new DatabaseEntry();
        this.database.get(null, new DatabaseEntry(key), value, LockMode.DEFAULT);
        return value.getData();
    }

    public byte[] getBytes(String key) {
        try {
            DatabaseEntry value = new DatabaseEntry();
            this.database.get(null, new DatabaseEntry(key.getBytes(UTF8)), value, LockMode.DEFAULT);
            return value.getData();
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public String get(String key) {
        try {
            DatabaseEntry value = new DatabaseEntry();
            OperationStatus status = this.database.get(null, new DatabaseEntry(key.getBytes(UTF8)), value, LockMode.DEFAULT);
            if (status == OperationStatus.SUCCESS) {
                return new String(value.getData(), UTF8);
            }
            return null;
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public void delete(String theKey) {
        try {
            DatabaseEntry entry = new DatabaseEntry(theKey.getBytes(UTF8));
            this.database.delete(null, entry);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(Map<String, MFile> current) {
        ArrayList<DatabaseEntry> result = new ArrayList<DatabaseEntry>();
        Cursor myCursor = null;
        try {
            myCursor = this.database.openCursor(null, null);
            DatabaseEntry foundKey = new DatabaseEntry();
            DatabaseEntry foundData = new DatabaseEntry();
            int count = 0;
            while (myCursor.getNext(foundKey, foundData, LockMode.DEFAULT) == OperationStatus.SUCCESS) {
                String filename;
                String key = new String(foundKey.getData(), UTF8);
                int pos = key.indexOf("#");
                if (pos <= 0 || null != current.get(filename = key.substring(0, pos))) continue;
                result.add(new DatabaseEntry(foundKey.getData()));
                ++count;
            }
            if (this.showDelete) {
                for (DatabaseEntry entry : result) {
                    OperationStatus status = this.database.delete(null, entry);
                    String key = new String(entry.getData(), UTF8);
                    System.out.printf("%s deleted %s%n", status, key);
                }
            }
        }
        catch (UnsupportedOperationException e) {
            logger.error("Trying to delete " + this.collectionName, e);
        }
        catch (UnsupportedEncodingException e) {
            logger.error("Trying to delete " + this.collectionName, e);
        }
        finally {
            if (null != myCursor) {
                myCursor.close();
            }
        }
    }

    public void close() {
        this.database.close();
        openDatabases.remove(this.database);
    }

    public void showStats(Formatter f) {
        try {
            DatabaseStats dstats = this.database.getStats(null);
            f.format("primary stats %n%s%n", dstats);
        }
        catch (DatabaseException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<KeyValue> getContent() throws DatabaseException, UnsupportedEncodingException {
        ArrayList<KeyValue> result = new ArrayList<KeyValue>();
        Cursor myCursor = null;
        try {
            myCursor = this.database.openCursor(null, null);
            DatabaseEntry foundKey = new DatabaseEntry();
            DatabaseEntry foundData = new DatabaseEntry();
            int count = 0;
            while (myCursor.getNext(foundKey, foundData, LockMode.DEFAULT) == OperationStatus.SUCCESS) {
                String key = new String(foundKey.getData(), UTF8);
                String data = new String(foundData.getData(), UTF8);
                result.add(new KeyValue(key, data));
                ++count;
            }
        }
        finally {
            if (null != myCursor) {
                myCursor.close();
            }
        }
        return result;
    }

    public static void main(String[] args) throws Exception {
        MetadataManager indexer = new MetadataManager("dummy");
        indexer.showStats(new Formatter(System.out));
        MetadataManager.closeAll();
    }

    static {
        debug = false;
        String home = System.getProperty("user.home");
        if (home == null) {
            home = System.getProperty("user.dir");
        }
        if (home == null) {
            home = ".";
        }
        root = home + "/.unidata/bdb/";
    }

    public class KeyValue {
        public String key;
        public String value;

        KeyValue(String key, String value) {
            this.key = key;
            this.value = value;
        }
    }
}

