/*
 * Decompiled with CFR 0.152.
 */
package opendap.dap.parser;

import java.io.InputStream;
import java.io.PrintStream;
import java.util.Arrays;
import opendap.dap.BaseTypeFactory;
import opendap.dap.parser.Daplex;
import opendap.dap.parser.Dapparse;
import opendap.dap.parser.ParseException;

public class DapParser
extends Dapparse {
    public static final String bisonVersion = "2.4.2";
    public static final String bisonSkeleton = "lalr1.java";
    public boolean errorVerbose = false;
    public static final int EOF = 0;
    public static final int SCAN_ALIAS = 258;
    public static final int SCAN_ARRAY = 259;
    public static final int SCAN_ATTR = 260;
    public static final int SCAN_BYTE = 261;
    public static final int SCAN_CODE = 262;
    public static final int SCAN_DATASET = 263;
    public static final int SCAN_DATA = 264;
    public static final int SCAN_ERROR = 265;
    public static final int SCAN_FLOAT32 = 266;
    public static final int SCAN_FLOAT64 = 267;
    public static final int SCAN_GRID = 268;
    public static final int SCAN_INT16 = 269;
    public static final int SCAN_INT32 = 270;
    public static final int SCAN_MAPS = 271;
    public static final int SCAN_MESSAGE = 272;
    public static final int SCAN_SEQUENCE = 273;
    public static final int SCAN_STRING = 274;
    public static final int SCAN_STRUCTURE = 275;
    public static final int SCAN_UINT16 = 276;
    public static final int SCAN_UINT32 = 277;
    public static final int SCAN_URL = 278;
    public static final int SCAN_WORD = 279;
    public static final int SCAN_PTYPE = 280;
    public static final int SCAN_PROG = 281;
    private Lexer yylexer;
    protected final InputStream stream;
    private PrintStream yyDebugStream = System.err;
    private int yydebug = 0;
    public static final int YYACCEPT = 0;
    public static final int YYABORT = 1;
    public static final int YYERROR = 2;
    public static final int YYFAIL = 3;
    private static final int YYNEWSTATE = 4;
    private static final int YYDEFAULT = 5;
    private static final int YYREDUCE = 6;
    private static final int YYERRLAB1 = 7;
    private static final int YYRETURN = 8;
    private int yyerrstatus_ = 0;
    private static final short yypact_ninf_ = -66;
    private static final short[] yypact_ = new short[]{3, -66, -66, -7, -1, 27, 5, -66, 19, 22, -66, -66, -66, -66, -66, 103, -66, 35, 55, 43, -66, -66, -66, -66, 9, -66, -66, 12, -66, 78, -66, -66, -66, 199, -66, 244, 77, 73, 82, -66, 244, -66, -66, 244, -66, -66, -66, -66, 244, 244, -66, 244, 244, -66, -66, -66, 244, -66, 244, 244, 244, -66, -66, -66, 81, 84, 108, -66, -66, -66, -66, -66, -66, -66, -66, -66, -66, -66, -66, -66, 99, -66, -66, -66, 100, 106, 101, 107, 244, 111, 112, 118, 119, 128, 129, 133, 134, 135, -66, -66, 120, 126, 150, -66, 6, -66, 131, 142, 143, 139, -66, -66, -24, -66, -20, -66, -17, -66, -13, -66, -11, -66, -10, -66, -66, 40, -66, 68, -66, 74, -66, 72, 223, 244, 244, -66, -66, 266, -66, -66, 146, 153, 151, -66, 157, -66, 158, -66, 159, -66, 165, -66, 166, -66, 129, -66, 174, -66, 175, -66, 135, -66, 181, 196, -66, 194, 195, -66, 198, -66, -66, -66, -66, -66, -66, -66, -66, -66, -66, 200, -66, 14, -66, 207, -66, -66, -66, 201, 173, -66, 244, 203, -66};
    private static final byte[] yydefact_ = new byte[]{0, 6, 32, 0, 0, 0, 0, 8, 2, 71, 5, 1, 34, 35, 4, 0, 3, 0, 73, 0, 14, 15, 20, 21, 0, 16, 18, 0, 23, 0, 17, 19, 22, 0, 9, 0, 0, 0, 75, 48, 80, 81, 82, 83, 99, 84, 85, 86, 87, 88, 89, 90, 91, 92, 100, 93, 94, 95, 96, 97, 98, 79, 33, 36, 0, 0, 0, 8, 8, 30, 80, 83, 87, 88, 90, 91, 94, 96, 97, 98, 0, 29, 31, 24, 0, 0, 0, 77, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 37, 35, 0, 0, 0, 7, 0, 72, 0, 0, 0, 0, 69, 49, 0, 59, 0, 61, 0, 51, 0, 55, 0, 68, 0, 63, 53, 0, 57, 0, 67, 0, 65, 0, 0, 0, 0, 28, 10, 0, 25, 74, 0, 0, 0, 38, 0, 43, 0, 44, 0, 39, 0, 41, 0, 45, 0, 40, 0, 42, 0, 46, 0, 47, 0, 0, 24, 79, 0, 76, 0, 70, 50, 60, 62, 52, 56, 64, 54, 58, 66, 0, 12, 0, 26, 0, 78, 8, 11, 0, 0, 27, 0, 0, 13};
    private static final short[] yypgoto_ = new short[]{-66, -66, -66, -65, 160, -66, 75, -66, -66, -35, -66, -66, 141, -66, -66, -66, -66, -66, -66, -66, -66, -66, -66, 136, 137, -66, -66, -66, -66, -66, -66, -18};
    private static final short[] yydefgoto_ = new short[]{-1, 5, 8, 15, 34, 35, 104, 138, 80, 81, 6, 14, 19, 63, 112, 118, 125, 120, 127, 114, 116, 122, 129, 130, 123, 64, 10, 18, 38, 87, 109, 82};
    private static final short yytable_ninf_ = -1;
    private static final short[] yytable_ = new short[]{83, 65, 101, 102, 1, 143, 12, 135, 2, 145, 144, 3, 147, 4, 146, 135, 149, 148, 151, 153, 7, 150, 88, 152, 154, 89, 9, 11, 16, 17, 90, 91, 13, 92, 93, 136, 66, 137, 94, 67, 95, 96, 97, 186, 39, 137, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 36, 155, 110, 62, 37, 39, 156, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 157, 163, 164, 161, 84, 158, 159, 20, 68, 85, 86, 160, 21, 98, 99, 100, 65, 22, 23, 24, 25, 26, 166, 188, 27, 28, 29, 30, 31, 32, 20, 103, 105, 106, 33, 21, 108, 107, 111, 113, 22, 23, 24, 25, 26, 115, 117, 27, 28, 29, 30, 31, 32, 132, 20, 119, 121, 133, 191, 21, 124, 126, 128, 139, 22, 23, 24, 25, 26, 140, 142, 27, 28, 29, 30, 31, 32, 20, 167, 141, 168, 134, 21, 169, 170, 171, 172, 22, 23, 24, 25, 26, 173, 174, 27, 28, 29, 30, 31, 32, 179, 176, 177, 69, 190, 70, 41, 42, 71, 44, 45, 46, 47, 72, 73, 50, 74, 75, 53, 54, 55, 76, 57, 77, 78, 79, 61, 20, 180, 182, 184, 183, 21, 185, 187, 192, 189, 22, 23, 24, 25, 26, 181, 131, 27, 28, 29, 30, 31, 32, 70, 41, 42, 71, 44, 45, 46, 47, 72, 73, 50, 74, 75, 53, 54, 55, 76, 57, 77, 78, 79, 61, 70, 41, 42, 71, 44, 45, 46, 47, 72, 73, 50, 74, 75, 53, 54, 55, 76, 57, 77, 78, 79, 165, 175, 162, 0, 0, 0, 178};
    private static final short[] yycheck_ = new short[]{35, 19, 67, 68, 1, 29, 1, 1, 5, 29, 34, 8, 29, 10, 34, 1, 29, 34, 29, 29, 27, 34, 40, 34, 34, 43, 27, 0, 9, 7, 48, 49, 27, 51, 52, 29, 27, 31, 56, 27, 58, 59, 60, 29, 1, 31, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 33, 29, 88, 28, 17, 1, 34, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 29, 133, 134, 28, 24, 34, 29, 1, 27, 33, 25, 34, 6, 29, 27, 4, 131, 11, 12, 13, 14, 15, 137, 185, 18, 19, 20, 21, 22, 23, 1, 29, 29, 24, 28, 6, 26, 33, 24, 24, 11, 12, 13, 14, 15, 24, 24, 18, 19, 20, 21, 22, 23, 30, 1, 24, 24, 28, 190, 6, 24, 24, 24, 29, 11, 12, 13, 14, 15, 24, 28, 18, 19, 20, 21, 22, 23, 1, 29, 33, 24, 28, 6, 29, 24, 24, 24, 11, 12, 13, 14, 15, 24, 24, 18, 19, 20, 21, 22, 23, 16, 24, 24, 1, 28, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 1, 29, 32, 29, 33, 6, 30, 24, 29, 32, 11, 12, 13, 14, 15, 164, 99, 18, 19, 20, 21, 22, 23, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 154, 132, -1, -1, -1, 160};
    private static final byte[] yystos_ = new byte[]{0, 1, 5, 8, 10, 36, 45, 27, 37, 27, 61, 0, 1, 27, 46, 38, 9, 7, 62, 47, 1, 6, 11, 12, 13, 14, 15, 18, 19, 20, 21, 22, 23, 28, 39, 40, 33, 17, 63, 1, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 28, 48, 60, 66, 27, 27, 27, 1, 3, 6, 11, 12, 14, 15, 19, 21, 22, 23, 43, 44, 66, 44, 24, 33, 25, 64, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 29, 27, 4, 38, 38, 29, 41, 29, 24, 33, 26, 65, 66, 24, 49, 24, 54, 24, 55, 24, 50, 24, 52, 24, 56, 59, 24, 51, 24, 53, 24, 57, 58, 47, 30, 28, 28, 1, 29, 31, 42, 29, 24, 33, 28, 29, 34, 29, 34, 29, 34, 29, 34, 29, 34, 29, 34, 29, 34, 29, 34, 29, 34, 28, 39, 44, 44, 24, 66, 29, 24, 29, 24, 24, 24, 24, 24, 59, 24, 24, 58, 16, 29, 41, 32, 33, 29, 30, 29, 24, 38, 32, 28, 44, 29};
    private static final short[] yytoken_number_ = new short[]{0, 256, 257, 258, 259, 260, 261, 262, 263, 264, 265, 266, 267, 268, 269, 270, 271, 272, 273, 274, 275, 276, 277, 278, 279, 280, 281, 123, 125, 59, 58, 91, 93, 61, 44};
    private static final byte[] yyr1_ = new byte[]{0, 35, 36, 36, 36, 36, 36, 37, 38, 38, 39, 39, 39, 39, 39, 40, 40, 40, 40, 40, 40, 40, 40, 40, 41, 41, 42, 42, 42, 43, 43, 44, 45, 46, 46, 47, 47, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 49, 49, 50, 50, 51, 51, 52, 52, 53, 53, 54, 54, 55, 55, 56, 56, 57, 57, 58, 59, 60, 61, 62, 62, 63, 63, 64, 64, 65, 65, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66};
    private static final byte[] yyr2_ = new byte[]{0, 2, 2, 3, 3, 2, 1, 5, 0, 2, 4, 7, 6, 11, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 2, 3, 5, 1, 1, 1, 1, 0, 3, 1, 0, 2, 2, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 1, 1, 3, 1, 3, 1, 3, 1, 3, 1, 3, 1, 3, 1, 3, 1, 3, 1, 3, 1, 1, 3, 7, 0, 4, 0, 4, 0, 4, 0, 4, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1};
    private static final String[] yytname_ = new String[]{"$end", "error", "$undefined", "SCAN_ALIAS", "SCAN_ARRAY", "SCAN_ATTR", "SCAN_BYTE", "SCAN_CODE", "SCAN_DATASET", "SCAN_DATA", "SCAN_ERROR", "SCAN_FLOAT32", "SCAN_FLOAT64", "SCAN_GRID", "SCAN_INT16", "SCAN_INT32", "SCAN_MAPS", "SCAN_MESSAGE", "SCAN_SEQUENCE", "SCAN_STRING", "SCAN_STRUCTURE", "SCAN_UINT16", "SCAN_UINT32", "SCAN_URL", "SCAN_WORD", "SCAN_PTYPE", "SCAN_PROG", "'{'", "'}'", "';'", "':'", "'['", "']'", "'='", "','", "$accept", "start", "datasetbody", "declarations", "declaration", "base_type", "array_decls", "array_decl", "datasetname", "var_name", "dassetup", "attributebody", "attr_list", "attribute", "bytes", "int16", "uint16", "int32", "uint32", "float32", "float64", "strs", "urls", "url", "str_or_id", "alias", "errorbody", "errorcode", "errormsg", "errorptype", "errorprog", "name", null};
    private static final byte[] yyrhs_ = new byte[]{36, 0, -1, 8, 37, -1, 8, 37, 9, -1, 5, 45, 46, -1, 10, 61, -1, 1, -1, 27, 38, 28, 43, 29, -1, -1, 38, 39, -1, 40, 44, 41, 29, -1, 20, 27, 38, 28, 44, 41, 29, -1, 18, 27, 38, 28, 44, 29, -1, 13, 27, 4, 30, 39, 16, 30, 38, 28, 44, 29, -1, 1, -1, 6, -1, 14, -1, 21, -1, 15, -1, 22, -1, 11, -1, 12, -1, 23, -1, 19, -1, -1, 41, 42, -1, 31, 24, 32, -1, 31, 66, 33, 24, 32, -1, 1, -1, 44, -1, 1, -1, 66, -1, -1, 27, 47, 28, -1, 1, -1, -1, 47, 48, -1, 60, 29, -1, 6, 66, 49, 29, -1, 14, 66, 50, 29, -1, 21, 66, 51, 29, -1, 15, 66, 52, 29, -1, 22, 66, 53, 29, -1, 11, 66, 54, 29, -1, 12, 66, 55, 29, -1, 19, 66, 56, 29, -1, 23, 66, 57, 29, -1, 66, 27, 47, 28, -1, 1, -1, 24, -1, 49, 34, 24, -1, 24, -1, 50, 34, 24, -1, 24, -1, 51, 34, 24, -1, 24, -1, 52, 34, 24, -1, 24, -1, 53, 34, 24, -1, 24, -1, 54, 34, 24, -1, 24, -1, 55, 34, 24, -1, 59, -1, 56, 34, 59, -1, 58, -1, 57, 34, 58, -1, 24, -1, 24, -1, 3, 66, 66, -1, 27, 62, 63, 64, 65, 28, 29, -1, -1, 7, 33, 24, 29, -1, -1, 17, 33, 24, 29, -1, -1, 25, 33, 24, 29, -1, -1, 26, 33, 24, 29, -1, 24, -1, 3, -1, 4, -1, 5, -1, 6, -1, 8, -1, 9, -1, 10, -1, 11, -1, 12, -1, 13, -1, 14, -1, 15, -1, 16, -1, 18, -1, 19, -1, 20, -1, 21, -1, 22, -1, 23, -1, 7, -1, 17, -1};
    private static final short[] yyprhs_ = new short[]{0, 0, 3, 6, 10, 14, 17, 19, 25, 26, 29, 34, 42, 49, 61, 63, 65, 67, 69, 71, 73, 75, 77, 79, 81, 82, 85, 89, 95, 97, 99, 101, 103, 104, 108, 110, 111, 114, 117, 122, 127, 132, 137, 142, 147, 152, 157, 162, 167, 169, 171, 175, 177, 181, 183, 187, 189, 193, 195, 199, 201, 205, 207, 211, 213, 217, 219, 223, 225, 227, 231, 239, 240, 245, 246, 251, 252, 257, 258, 263, 265, 267, 269, 271, 273, 275, 277, 279, 281, 283, 285, 287, 289, 291, 293, 295, 297, 299, 301, 303, 305};
    private static final short[] yyrline_ = new short[]{0, 71, 71, 72, 73, 74, 75, 80, 86, 87, 93, 95, 97, 99, 102, 108, 109, 110, 111, 112, 113, 114, 115, 116, 120, 121, 125, 126, 127, 132, 133, 137, 139, 142, 143, 148, 149, 153, 154, 156, 158, 160, 162, 164, 166, 168, 170, 172, 173, 178, 179, 183, 184, 188, 189, 193, 194, 198, 199, 202, 203, 206, 207, 210, 211, 215, 216, 220, 224, 234, 238, 242, 242, 243, 243, 244, 244, 245, 245, 251, 252, 253, 254, 255, 256, 257, 258, 259, 260, 261, 262, 263, 264, 265, 266, 267, 268, 269, 270, 271, 272};
    private static final byte[] yytranslate_table_ = new byte[]{0, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 34, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 30, 29, 2, 33, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 31, 2, 32, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 27, 2, 28, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26};
    private static final int yylast_ = 296;
    private static final int yynnts_ = 32;
    private static final int yyempty_ = -2;
    private static final int yyfinal_ = 11;
    private static final int yyterror_ = 1;
    private static final int yyerrcode_ = 256;
    private static final int yyntokens_ = 35;
    private static final int yyuser_token_number_max_ = 281;
    private static final int yyundef_token_ = 2;

    public DapParser(Lexer yylexer, InputStream stream) {
        this.yylexer = yylexer;
        this.stream = stream;
    }

    public final PrintStream getDebugStream() {
        return this.yyDebugStream;
    }

    public final void setDebugStream(PrintStream s) {
        this.yyDebugStream = s;
    }

    public final int getDebugLevel() {
        return this.yydebug;
    }

    public final void setDebugLevel(int level) {
        this.yydebug = level;
    }

    private final int yylex() throws ParseException {
        return this.yylexer.yylex();
    }

    protected final void yyerror(String s) {
        this.yylexer.yyerror(s);
    }

    protected final void yycdebug(String s) {
        if (this.yydebug > 0) {
            this.yyDebugStream.println(s);
        }
    }

    public final boolean recovering() {
        return this.yyerrstatus_ == 0;
    }

    private int yyaction(int yyn, YYStack yystack, int yylen) throws ParseException {
        Object yyval = yylen > 0 ? yystack.valueAt(yylen - 1) : yystack.valueAt(0);
        this.yy_reduce_print(yyn, yystack);
        switch (yyn) {
            case 6: {
                if (yyn != 6) break;
                yyval = this.unrecognizedresponse(this.parsestate);
                break;
            }
            case 7: {
                if (yyn != 7) break;
                this.datasetbody(this.parsestate, yystack.valueAt(1), yystack.valueAt(3));
                break;
            }
            case 8: {
                if (yyn != 8) break;
                yyval = this.declarations(this.parsestate, null, null);
                break;
            }
            case 9: {
                if (yyn != 9) break;
                yyval = this.declarations(this.parsestate, yystack.valueAt(1), yystack.valueAt(0));
                break;
            }
            case 10: {
                if (yyn != 10) break;
                yyval = this.makebase(this.parsestate, yystack.valueAt(2), yystack.valueAt(3), yystack.valueAt(1));
                break;
            }
            case 11: {
                if (yyn != 11 || (yyval = this.makestructure(this.parsestate, yystack.valueAt(2), yystack.valueAt(1), yystack.valueAt(4))) != null) break;
                return 1;
            }
            case 12: {
                if (yyn != 12 || (yyval = this.makesequence(this.parsestate, yystack.valueAt(1), yystack.valueAt(3))) != null) break;
                return 1;
            }
            case 13: {
                if (yyn != 13 || (yyval = this.makegrid(this.parsestate, yystack.valueAt(1), yystack.valueAt(6), yystack.valueAt(3))) != null) break;
                return 1;
            }
            case 14: {
                if (yyn != 14) break;
                this.daperror(this.parsestate, "Unrecognized type");
                return 1;
            }
            case 15: {
                if (yyn != 15) break;
                yyval = 261;
                break;
            }
            case 16: {
                if (yyn != 16) break;
                yyval = 269;
                break;
            }
            case 17: {
                if (yyn != 17) break;
                yyval = 276;
                break;
            }
            case 18: {
                if (yyn != 18) break;
                yyval = 270;
                break;
            }
            case 19: {
                if (yyn != 19) break;
                yyval = 277;
                break;
            }
            case 20: {
                if (yyn != 20) break;
                yyval = 266;
                break;
            }
            case 21: {
                if (yyn != 21) break;
                yyval = 267;
                break;
            }
            case 22: {
                if (yyn != 22) break;
                yyval = 278;
                break;
            }
            case 23: {
                if (yyn != 23) break;
                yyval = 274;
                break;
            }
            case 24: {
                if (yyn != 24) break;
                yyval = this.arraydecls(this.parsestate, null, null);
                break;
            }
            case 25: {
                if (yyn != 25) break;
                yyval = this.arraydecls(this.parsestate, yystack.valueAt(1), yystack.valueAt(0));
                break;
            }
            case 26: {
                if (yyn != 26) break;
                yyval = this.arraydecl(this.parsestate, null, yystack.valueAt(1));
                break;
            }
            case 27: {
                if (yyn != 27) break;
                yyval = this.arraydecl(this.parsestate, yystack.valueAt(3), yystack.valueAt(1));
                break;
            }
            case 28: {
                if (yyn != 28) break;
                this.daperror(this.parsestate, "Illegal dimension declaration");
                return 1;
            }
            case 29: {
                if (yyn != 29) break;
                yyval = yystack.valueAt(0);
                break;
            }
            case 30: {
                if (yyn != 30) break;
                this.daperror(this.parsestate, "Illegal dataset declaration");
                return 1;
            }
            case 31: {
                if (yyn != 31) break;
                yyval = yystack.valueAt(0);
                break;
            }
            case 32: {
                if (yyn != 32) break;
                this.dassetup(this.parsestate);
                break;
            }
            case 33: {
                if (yyn != 33) break;
                this.attributebody(this.parsestate, yystack.valueAt(1));
                break;
            }
            case 34: {
                if (yyn != 34) break;
                this.daperror(this.parsestate, "Illegal DAS body");
                return 1;
            }
            case 35: {
                if (yyn != 35) break;
                yyval = this.attrlist(this.parsestate, null, null);
                break;
            }
            case 36: {
                if (yyn != 36) break;
                yyval = this.attrlist(this.parsestate, yystack.valueAt(1), yystack.valueAt(0));
                break;
            }
            case 37: {
                if (yyn != 37) break;
                yyval = null;
                break;
            }
            case 38: {
                if (yyn != 38) break;
                yyval = this.attribute(this.parsestate, yystack.valueAt(2), yystack.valueAt(1), 261);
                break;
            }
            case 39: {
                if (yyn != 39) break;
                yyval = this.attribute(this.parsestate, yystack.valueAt(2), yystack.valueAt(1), 269);
                break;
            }
            case 40: {
                if (yyn != 40) break;
                yyval = this.attribute(this.parsestate, yystack.valueAt(2), yystack.valueAt(1), 276);
                break;
            }
            case 41: {
                if (yyn != 41) break;
                yyval = this.attribute(this.parsestate, yystack.valueAt(2), yystack.valueAt(1), 270);
                break;
            }
            case 42: {
                if (yyn != 42) break;
                yyval = this.attribute(this.parsestate, yystack.valueAt(2), yystack.valueAt(1), 277);
                break;
            }
            case 43: {
                if (yyn != 43) break;
                yyval = this.attribute(this.parsestate, yystack.valueAt(2), yystack.valueAt(1), 266);
                break;
            }
            case 44: {
                if (yyn != 44) break;
                yyval = this.attribute(this.parsestate, yystack.valueAt(2), yystack.valueAt(1), 267);
                break;
            }
            case 45: {
                if (yyn != 45) break;
                yyval = this.attribute(this.parsestate, yystack.valueAt(2), yystack.valueAt(1), 274);
                break;
            }
            case 46: {
                if (yyn != 46) break;
                yyval = this.attribute(this.parsestate, yystack.valueAt(2), yystack.valueAt(1), 278);
                break;
            }
            case 47: {
                if (yyn != 47) break;
                yyval = this.attrset(this.parsestate, yystack.valueAt(3), yystack.valueAt(1));
                break;
            }
            case 48: {
                if (yyn != 48) break;
                this.daperror(this.parsestate, "Illegal attribute");
                return 1;
            }
            case 49: {
                if (yyn != 49) break;
                yyval = this.attrvalue(this.parsestate, null, yystack.valueAt(0), 261);
                break;
            }
            case 50: {
                if (yyn != 50) break;
                yyval = this.attrvalue(this.parsestate, yystack.valueAt(2), yystack.valueAt(0), 261);
                break;
            }
            case 51: {
                if (yyn != 51) break;
                yyval = this.attrvalue(this.parsestate, null, yystack.valueAt(0), 269);
                break;
            }
            case 52: {
                if (yyn != 52) break;
                yyval = this.attrvalue(this.parsestate, yystack.valueAt(2), yystack.valueAt(0), 269);
                break;
            }
            case 53: {
                if (yyn != 53) break;
                yyval = this.attrvalue(this.parsestate, null, yystack.valueAt(0), 276);
                break;
            }
            case 54: {
                if (yyn != 54) break;
                yyval = this.attrvalue(this.parsestate, yystack.valueAt(2), yystack.valueAt(0), 276);
                break;
            }
            case 55: {
                if (yyn != 55) break;
                yyval = this.attrvalue(this.parsestate, null, yystack.valueAt(0), 270);
                break;
            }
            case 56: {
                if (yyn != 56) break;
                yyval = this.attrvalue(this.parsestate, yystack.valueAt(2), yystack.valueAt(0), 270);
                break;
            }
            case 57: {
                if (yyn != 57) break;
                yyval = this.attrvalue(this.parsestate, null, yystack.valueAt(0), 277);
                break;
            }
            case 58: {
                if (yyn != 58) break;
                yyval = this.attrvalue(this.parsestate, yystack.valueAt(2), yystack.valueAt(0), 277);
                break;
            }
            case 59: {
                if (yyn != 59) break;
                yyval = this.attrvalue(this.parsestate, null, yystack.valueAt(0), 266);
                break;
            }
            case 60: {
                if (yyn != 60) break;
                yyval = this.attrvalue(this.parsestate, yystack.valueAt(2), yystack.valueAt(0), 266);
                break;
            }
            case 61: {
                if (yyn != 61) break;
                yyval = this.attrvalue(this.parsestate, null, yystack.valueAt(0), 267);
                break;
            }
            case 62: {
                if (yyn != 62) break;
                yyval = this.attrvalue(this.parsestate, yystack.valueAt(2), yystack.valueAt(0), 267);
                break;
            }
            case 63: {
                if (yyn != 63) break;
                yyval = this.attrvalue(this.parsestate, null, yystack.valueAt(0), 274);
                break;
            }
            case 64: {
                if (yyn != 64) break;
                yyval = this.attrvalue(this.parsestate, yystack.valueAt(2), yystack.valueAt(0), 274);
                break;
            }
            case 65: {
                if (yyn != 65) break;
                yyval = this.attrvalue(this.parsestate, null, yystack.valueAt(0), 278);
                break;
            }
            case 66: {
                if (yyn != 66) break;
                yyval = this.attrvalue(this.parsestate, yystack.valueAt(2), yystack.valueAt(0), 278);
                break;
            }
            case 67: {
                if (yyn != 67) break;
                yyval = yystack.valueAt(0);
                break;
            }
            case 68: {
                if (yyn != 68) break;
                yyval = yystack.valueAt(0);
                break;
            }
            case 69: {
                if (yyn != 69) break;
                yyval = yystack.valueAt(1);
                yyval = yystack.valueAt(0);
                yyval = null;
                break;
            }
            case 70: {
                if (yyn != 70) break;
                yyval = this.errorbody(this.parsestate, yystack.valueAt(5), yystack.valueAt(4), yystack.valueAt(3), yystack.valueAt(2));
                break;
            }
            case 71: {
                if (yyn != 71) break;
                yyval = null;
                break;
            }
            case 72: {
                if (yyn != 72) break;
                yyval = yystack.valueAt(1);
                break;
            }
            case 73: {
                if (yyn != 73) break;
                yyval = null;
                break;
            }
            case 74: {
                if (yyn != 74) break;
                yyval = yystack.valueAt(1);
                break;
            }
            case 75: {
                if (yyn != 75) break;
                yyval = null;
                break;
            }
            case 76: {
                if (yyn != 76) break;
                yyval = yystack.valueAt(1);
                break;
            }
            case 77: {
                if (yyn != 77) break;
                yyval = null;
                break;
            }
            case 78: {
                if (yyn != 78) break;
                yyval = yystack.valueAt(1);
                break;
            }
            case 79: {
                if (yyn != 79) break;
                yyval = yystack.valueAt(0);
                break;
            }
            case 80: {
                if (yyn != 80) break;
                yyval = this.strdup("alias");
                break;
            }
            case 81: {
                if (yyn != 81) break;
                yyval = this.strdup("array");
                break;
            }
            case 82: {
                if (yyn != 82) break;
                yyval = this.strdup("attributes");
                break;
            }
            case 83: {
                if (yyn != 83) break;
                yyval = this.strdup("byte");
                break;
            }
            case 84: {
                if (yyn != 84) break;
                yyval = this.strdup("dataset");
                break;
            }
            case 85: {
                if (yyn != 85) break;
                yyval = this.strdup("data");
                break;
            }
            case 86: {
                if (yyn != 86) break;
                yyval = this.strdup("error");
                break;
            }
            case 87: {
                if (yyn != 87) break;
                yyval = this.strdup("float32");
                break;
            }
            case 88: {
                if (yyn != 88) break;
                yyval = this.strdup("float64");
                break;
            }
            case 89: {
                if (yyn != 89) break;
                yyval = this.strdup("grid");
                break;
            }
            case 90: {
                if (yyn != 90) break;
                yyval = this.strdup("int16");
                break;
            }
            case 91: {
                if (yyn != 91) break;
                yyval = this.strdup("int32");
                break;
            }
            case 92: {
                if (yyn != 92) break;
                yyval = this.strdup("maps");
                break;
            }
            case 93: {
                if (yyn != 93) break;
                yyval = this.strdup("sequence");
                break;
            }
            case 94: {
                if (yyn != 94) break;
                yyval = this.strdup("string");
                break;
            }
            case 95: {
                if (yyn != 95) break;
                yyval = this.strdup("structure");
                break;
            }
            case 96: {
                if (yyn != 96) break;
                yyval = this.strdup("uint16");
                break;
            }
            case 97: {
                if (yyn != 97) break;
                yyval = this.strdup("uint32");
                break;
            }
            case 98: {
                if (yyn != 98) break;
                yyval = this.strdup("url");
                break;
            }
            case 99: {
                if (yyn != 99) break;
                yyval = this.strdup("code");
                break;
            }
            case 100: {
                if (yyn != 100) break;
                yyval = this.strdup("message");
                break;
            }
        }
        this.yy_symbol_print("-> $$ =", yyr1_[yyn], yyval);
        yystack.pop(yylen);
        yylen = 0;
        yyn = yyr1_[yyn];
        int yystate = yypgoto_[yyn - 35] + yystack.stateAt(0);
        yystate = 0 <= yystate && yystate <= 296 && yycheck_[yystate] == yystack.stateAt(0) ? yytable_[yystate] : yydefgoto_[yyn - 35];
        yystack.push(yystate, yyval);
        return 4;
    }

    private final String yytnamerr_(String yystr) {
        block10: {
            if (yystr.charAt(0) == '\"') {
                StringBuffer yyr = new StringBuffer();
                block5: for (int i = 1; i < yystr.length(); ++i) {
                    switch (yystr.charAt(i)) {
                        case '\'': 
                        case ',': {
                            break block10;
                        }
                        case '\\': {
                            if (yystr.charAt(++i) != '\\') break block10;
                        }
                        default: {
                            yyr.append(yystr.charAt(i));
                            continue block5;
                        }
                        case '\"': {
                            return yyr.toString();
                        }
                    }
                }
            } else if (yystr.equals("$end")) {
                return "end of input";
            }
        }
        return yystr;
    }

    private void yy_symbol_print(String s, int yytype, Object yyvaluep) {
        if (this.yydebug > 0) {
            this.yycdebug(s + (yytype < 35 ? " token " : " nterm ") + yytname_[yytype] + " (" + (yyvaluep == null ? "(null)" : yyvaluep.toString()) + ")");
        }
    }

    public boolean parse() throws ParseException, ParseException {
        int yychar = -2;
        int yytoken = 0;
        int yyn = 0;
        int yylen = 0;
        int yystate = 0;
        YYStack yystack = new YYStack();
        int yynerrs_ = 0;
        Object yylval = null;
        this.yycdebug("Starting parse\n");
        this.yyerrstatus_ = 0;
        yystack.push(yystate, yylval);
        int label = 4;
        while (true) {
            switch (label) {
                case 4: {
                    this.yycdebug("Entering state " + yystate + "\n");
                    if (this.yydebug > 0) {
                        yystack.print(this.yyDebugStream);
                    }
                    if (yystate == 11) {
                        return true;
                    }
                    yyn = yypact_[yystate];
                    if (yyn == -66) {
                        label = 5;
                        break;
                    }
                    if (yychar == -2) {
                        this.yycdebug("Reading a token: ");
                        yychar = this.yylex();
                        yylval = this.yylexer.getLVal();
                    }
                    if (yychar <= 0) {
                        yytoken = 0;
                        yychar = 0;
                        this.yycdebug("Now at end of input.\n");
                    } else {
                        yytoken = DapParser.yytranslate_(yychar);
                        this.yy_symbol_print("Next token is", yytoken, yylval);
                    }
                    if ((yyn += yytoken) < 0 || 296 < yyn || yycheck_[yyn] != yytoken) {
                        label = 5;
                        break;
                    }
                    if ((yyn = yytable_[yyn]) <= 0) {
                        if (yyn == 0 || yyn == -1) {
                            label = 3;
                            break;
                        }
                        yyn = -yyn;
                        label = 6;
                        break;
                    }
                    this.yy_symbol_print("Shifting", yytoken, yylval);
                    yychar = -2;
                    if (this.yyerrstatus_ > 0) {
                        --this.yyerrstatus_;
                    }
                    yystate = yyn;
                    yystack.push(yystate, yylval);
                    label = 4;
                    break;
                }
                case 5: {
                    yyn = yydefact_[yystate];
                    if (yyn == 0) {
                        label = 3;
                        break;
                    }
                    label = 6;
                    break;
                }
                case 6: {
                    yylen = yyr2_[yyn];
                    label = this.yyaction(yyn, yystack, yylen);
                    yystate = yystack.stateAt(0);
                    break;
                }
                case 3: {
                    if (this.yyerrstatus_ == 0) {
                        ++yynerrs_;
                        this.yyerror(this.yysyntax_error(yystate, yytoken));
                    }
                    if (this.yyerrstatus_ == 3) {
                        if (yychar <= 0) {
                            if (yychar == 0) {
                                return false;
                            }
                        } else {
                            yychar = -2;
                        }
                    }
                    label = 7;
                    break;
                }
                case 2: {
                    yystack.pop(yylen);
                    yylen = 0;
                    yystate = yystack.stateAt(0);
                    label = 7;
                    break;
                }
                case 7: {
                    this.yyerrstatus_ = 3;
                    while ((yyn = yypact_[yystate]) == -66 || 0 > ++yyn || yyn > 296 || yycheck_[yyn] != 1 || 0 >= (yyn = yytable_[yyn])) {
                        if (yystack.height == 1) {
                            return false;
                        }
                        yystack.pop();
                        yystate = yystack.stateAt(0);
                        if (this.yydebug <= 0) continue;
                        yystack.print(this.yyDebugStream);
                    }
                    this.yy_symbol_print("Shifting", yystos_[yyn], yylval);
                    yystate = yyn;
                    yystack.push(yyn, yylval);
                    label = 4;
                    break;
                }
                case 0: {
                    return true;
                }
                case 1: {
                    return false;
                }
            }
        }
    }

    private String yysyntax_error(int yystate, int tok) {
        int yyn;
        if (this.errorVerbose && -66 < (yyn = yypact_[yystate]) && yyn <= 296) {
            int x;
            int yyxbegin = yyn < 0 ? -yyn : 0;
            int yychecklim = 296 - yyn + 1;
            int yyxend = yychecklim < 35 ? yychecklim : 35;
            int count = 0;
            for (x = yyxbegin; x < yyxend; ++x) {
                if (yycheck_[x + yyn] != x || x == 1) continue;
                ++count;
            }
            StringBuffer res = new StringBuffer("syntax error, unexpected ");
            res.append(this.yytnamerr_(yytname_[tok]));
            if (count < 5) {
                count = 0;
                for (x = yyxbegin; x < yyxend; ++x) {
                    if (yycheck_[x + yyn] != x || x == 1) continue;
                    res.append(count++ == 0 ? ", expecting " : " or ");
                    res.append(this.yytnamerr_(yytname_[x]));
                }
            }
            return res.toString();
        }
        return "syntax error";
    }

    private void yy_reduce_print(int yyrule, YYStack yystack) {
        if (this.yydebug == 0) {
            return;
        }
        short yylno = yyrline_[yyrule];
        int yynrhs = yyr2_[yyrule];
        this.yycdebug("Reducing stack by rule " + (yyrule - 1) + " (line " + yylno + "), ");
        for (int yyi = 0; yyi < yynrhs; ++yyi) {
            this.yy_symbol_print("   $" + (yyi + 1) + " =", yyrhs_[yyprhs_[yyrule] + yyi], yystack.valueAt(yynrhs - (yyi + 1)));
        }
    }

    private static final byte yytranslate_(int t) {
        if (t >= 0 && t <= 281) {
            return yytranslate_table_[t];
        }
        return 2;
    }

    public DapParser(InputStream stream) {
        this(stream, (BaseTypeFactory)null);
    }

    public DapParser(InputStream stream, BaseTypeFactory factory) {
        super(factory);
        this.yylexer = new Daplex(stream, this);
        this.stream = stream;
        this.lexstate = (Daplex)this.yylexer;
    }

    private final class YYStack {
        private int[] stateStack = new int[16];
        private Object[] valueStack = new Object[16];
        public int size = 16;
        public int height = -1;

        private YYStack() {
        }

        public final void push(int state, Object value) {
            ++this.height;
            if (this.size == this.height) {
                int[] newStateStack = new int[this.size * 2];
                System.arraycopy(this.stateStack, 0, newStateStack, 0, this.height);
                this.stateStack = newStateStack;
                Object[] newValueStack = new Object[this.size * 2];
                System.arraycopy(this.valueStack, 0, newValueStack, 0, this.height);
                this.valueStack = newValueStack;
                this.size *= 2;
            }
            this.stateStack[this.height] = state;
            this.valueStack[this.height] = value;
        }

        public final void pop() {
            --this.height;
        }

        public final void pop(int num) {
            if (num > 0) {
                Arrays.fill(this.valueStack, this.height - num + 1, this.height, null);
            }
            this.height -= num;
        }

        public final int stateAt(int i) {
            return this.stateStack[this.height - i];
        }

        public final Object valueAt(int i) {
            return this.valueStack[this.height - i];
        }

        public void print(PrintStream out) {
            out.print("Stack now");
            for (int i = 0; i < this.height; ++i) {
                out.print(' ');
                out.print(this.stateStack[i]);
            }
            out.println();
        }
    }

    public static interface Lexer {
        public Object getLVal();

        public int yylex() throws ParseException;

        public void yyerror(String var1);
    }
}

