/*
 * Decompiled with CFR 0.152.
 */
package abbot.util;

import abbot.NoExitSecurityManager;
import java.security.Permission;
import java.util.Iterator;
import java.util.Map;
import java.util.WeakHashMap;

public abstract class ThreadTerminatingSecurityManager
extends NoExitSecurityManager {
    private Map terminatedGroups = new WeakHashMap();

    private boolean isTerminated(Thread t) {
        Iterator iter = this.terminatedGroups.keySet().iterator();
        while (iter.hasNext()) {
            ThreadGroup group = (ThreadGroup)iter.next();
            ThreadGroup thisGroup = t.getThreadGroup();
            if (thisGroup == null || !group.parentOf(thisGroup)) continue;
            return true;
        }
        return false;
    }

    public void terminateThreads(ThreadGroup group) {
        if (group == null) {
            throw new NullPointerException("Thread group must not be null");
        }
        this.terminatedGroups.put(group, Boolean.TRUE);
        if (group.activeCount() == 0) {
            try {
                group.destroy();
            }
            catch (IllegalThreadStateException illegalThreadStateException) {
                // empty catch block
            }
        }
    }

    public void checkPermission(Permission perm, Object context) {
        if (this.isTerminated(Thread.currentThread())) {
            throw new ThreadTerminatedException();
        }
        super.checkPermission(perm, context);
    }

    public void checkPermission(Permission perm) {
        if (this.isTerminated(Thread.currentThread())) {
            throw new ThreadTerminatedException();
        }
        super.checkPermission(perm);
    }

    public class ThreadTerminatedException
    extends SecurityException {
    }
}

