/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.record.compiler;

import org.apache.hadoop.record.compiler.CodeBuffer;
import org.apache.hadoop.record.compiler.JType;

public class JBoolean
extends JType {
    public JBoolean() {
        this.setJavaType(new JavaBoolean());
        this.setCppType(new JType.CppType(this, "bool"));
        this.setCType(new JType.CType(this));
    }

    String getSignature() {
        return "z";
    }

    class JavaBoolean
    extends JType.JavaType {
        JavaBoolean() {
            super(JBoolean.this, "boolean", "Bool", "Boolean");
        }

        void genCompareTo(CodeBuffer cb, String fname, String other) {
            cb.append("ret = (" + fname + " == " + other + ")? 0 : (" + fname + "?1:-1);\n");
        }

        void genHashCode(CodeBuffer cb, String fname) {
            cb.append("ret = (" + fname + ")?0:1;\n");
        }

        void genSlurpBytes(CodeBuffer cb, String b, String s, String l) {
            cb.append("{\n");
            cb.append("if (" + l + "<1) {\n");
            cb.append("throw new java.io.IOException(\"Boolean is exactly 1 byte. Provided buffer is smaller.\");\n");
            cb.append("}\n");
            cb.append(s + "++; " + l + "--;\n");
            cb.append("}\n");
        }

        void genCompareBytes(CodeBuffer cb) {
            cb.append("{\n");
            cb.append("if (l1<1 || l2<1) {\n");
            cb.append("throw new java.io.IOException(\"Boolean is exactly 1 byte. Provided buffer is smaller.\");\n");
            cb.append("}\n");
            cb.append("if (b1[s1] != b2[s2]) {\n");
            cb.append("return (b1[s1]<b2[s2])? -1 : 0;\n");
            cb.append("}\n");
            cb.append("s1++; s2++; l1--; l2--;\n");
            cb.append("}\n");
        }
    }
}

