/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.servlet.jsp.JspFactory;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.SkipPageException;
import org.apache.hadoop.mapred.JobHistory;
import org.apache.hadoop.util.StringUtils;
import org.apache.jasper.runtime.HttpJspBase;
import org.apache.jasper.runtime.JspRuntimeLibrary;
import org.apache.jasper.runtime.JspSourceDependent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class jobhistory_jsp
extends HttpJspBase
implements JspSourceDependent {
    private static SimpleDateFormat dateFormat = new SimpleDateFormat("d/MM HH:mm:ss");
    private static Vector _jspx_dependants;

    private void printJobs(String trackerid, Map<String, JobHistory.JobInfo> jobs, String status, JspWriter out) throws IOException {
        if (jobs.size() == 0) {
            out.print("<h3>No Jobs available</h3>");
            return;
        }
        out.print("<table border=2 cellpadding=\"5\" cellspacing=\"2\">");
        out.print("<tr>");
        out.print("<td align=\"center\">Job Id</td><td>Name</td><td>User</td><td>Submit Time</td><td>Finish Time</td><td>Total Maps</td><td>Total Reduces</td><td>Finished Maps</td><td>Finished Reduces</td>");
        out.print("</tr>");
        for (JobHistory.JobInfo job : jobs.values()) {
            if (null != status && status.equals(job.get(JobHistory.Keys.JOB_STATUS))) {
                this.printJob(trackerid, job, out);
                continue;
            }
            if (status != null || job.get(JobHistory.Keys.JOB_STATUS).length() != 0) continue;
            this.printJob(trackerid, job, out);
        }
        out.print("</table>");
    }

    private void printJob(String trackerid, JobHistory.JobInfo job, JspWriter out) throws IOException {
        out.print("<tr>");
        out.print("<td><a href=\"jobdetailshistory.jsp?jobid=" + job.get(JobHistory.Keys.JOBID) + "&jobTrackerId=" + trackerid + "\">" + job.get(JobHistory.Keys.JOBID) + "</a></td>");
        out.print("<td>" + job.get(JobHistory.Keys.JOBNAME) + "</td>");
        out.print("<td>" + job.get(JobHistory.Keys.USER) + "</td>");
        out.print("<td>" + StringUtils.getFormattedTimeWithDiff(dateFormat, job.getLong(JobHistory.Keys.SUBMIT_TIME), 0L) + "</td>");
        out.print("<td>" + StringUtils.getFormattedTimeWithDiff(dateFormat, job.getLong(JobHistory.Keys.FINISH_TIME), job.getLong(JobHistory.Keys.SUBMIT_TIME)) + "</td>");
        out.print("<td>" + job.get(JobHistory.Keys.TOTAL_MAPS) + "</td>");
        out.print("<td>" + job.get(JobHistory.Keys.TOTAL_REDUCES) + "</td>");
        out.print("<td>" + job.get(JobHistory.Keys.FINISHED_MAPS) + "</td>");
        out.print("<td>" + job.get(JobHistory.Keys.FINISHED_REDUCES) + "</td>");
        out.print("</tr>");
    }

    public List getDependants() {
        return _jspx_dependants;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void _jspService(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        Map jobTrackerToJobs;
        PageContext _jspx_page_context;
        JspWriter _jspx_out;
        JspWriter out;
        JspFactory _jspxFactory;
        block9: {
            _jspxFactory = null;
            PageContext pageContext = null;
            HttpSession session = null;
            ServletContext application = null;
            ServletConfig config = null;
            out = null;
            jobhistory_jsp page = this;
            _jspx_out = null;
            _jspx_page_context = null;
            _jspxFactory = JspFactory.getDefaultFactory();
            response.setContentType("text/html; charset=UTF-8");
            _jspx_page_context = pageContext = _jspxFactory.getPageContext((Servlet)this, (ServletRequest)request, (ServletResponse)response, null, true, 8192, true);
            application = pageContext.getServletContext();
            config = pageContext.getServletConfig();
            session = pageContext.getSession();
            _jspx_out = out = pageContext.getOut();
            out.write(10);
            JspRuntimeLibrary.include((ServletRequest)request, (ServletResponse)response, (String)("loadhistory.jsp" + ("loadhistory.jsp".indexOf(63) > 0 ? (char)'&' : '?') + JspRuntimeLibrary.URLEncode((String)"historyFile", (String)request.getCharacterEncoding()) + "=" + JspRuntimeLibrary.URLEncode((String)String.valueOf(request.getParameter("historyFile")), (String)request.getCharacterEncoding()) + "&" + JspRuntimeLibrary.URLEncode((String)"reload", (String)request.getCharacterEncoding()) + "=" + JspRuntimeLibrary.URLEncode((String)String.valueOf(request.getParameter("reload")), (String)request.getCharacterEncoding())), (JspWriter)out, (boolean)false);
            out.write(10);
            out.write("\n\n<html><body>\n");
            jobTrackerToJobs = (Map)request.getSession().getAttribute("jobHistory");
            if (null != jobTrackerToJobs) break block9;
            out.println("NULL !!!");
            if (_jspxFactory == null) return;
            _jspxFactory.releasePageContext(_jspx_page_context);
            return;
        }
        try {
            for (String trackerStartTime : jobTrackerToJobs.keySet()) {
                Map jobs = (Map)jobTrackerToJobs.get(trackerStartTime);
                out.write("\n<h2>JobTracker started at : ");
                out.print((Object)new Date(Long.parseLong(trackerStartTime)));
                out.write("</h2>\n<hr/>\n<h3>Completed Jobs </h3>\n<center>\n");
                this.printJobs(trackerStartTime, jobs, JobHistory.Values.SUCCESS.name(), out);
                out.write("\n</center> \n<h3>Failed Jobs </h3>\n<center>\n");
                this.printJobs(trackerStartTime, jobs, JobHistory.Values.FAILED.name(), out);
                out.write("\n</center>\n<h3>Incomplete Jobs </h3>\n<center>\n");
                this.printJobs(trackerStartTime, jobs, null, out);
                out.write("\n</center>\n<hr/><br/>\n");
            }
            out.write(10);
            out.write(32);
            out.write(10);
            out.write("  \n</body></html>");
            if (_jspxFactory == null) return;
        }
        catch (Throwable t) {
            try {
                if (t instanceof SkipPageException) return;
                out = _jspx_out;
                if (out != null && out.getBufferSize() != 0) {
                    out.clearBuffer();
                }
                if (_jspx_page_context == null) return;
                _jspx_page_context.handlePageException(t);
                return;
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                if (_jspxFactory != null) {
                    _jspxFactory.releasePageContext(_jspx_page_context);
                }
            }
        }
        _jspxFactory.releasePageContext(_jspx_page_context);
        return;
    }
}

