/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableUtils;
import org.apache.hadoop.mapred.Counters;

public class TaskReport
implements Writable {
    private String taskid;
    private float progress;
    private String state;
    private String[] diagnostics;
    private long startTime;
    private long finishTime;
    private Counters counters;

    public TaskReport() {
    }

    TaskReport(String taskid, float progress, String state, String[] diagnostics, long startTime, long finishTime, Counters counters) {
        this.taskid = taskid;
        this.progress = progress;
        this.state = state;
        this.diagnostics = diagnostics;
        this.startTime = startTime;
        this.finishTime = finishTime;
        this.counters = counters;
    }

    public String getTaskId() {
        return this.taskid;
    }

    public float getProgress() {
        return this.progress;
    }

    public String getState() {
        return this.state;
    }

    public String[] getDiagnostics() {
        return this.diagnostics;
    }

    public Counters getCounters() {
        return this.counters;
    }

    public long getFinishTime() {
        return this.finishTime;
    }

    void setFinishTime(long finishTime) {
        this.finishTime = finishTime;
    }

    public long getStartTime() {
        return this.startTime;
    }

    void setStartTime(long startTime) {
        this.startTime = startTime;
    }

    public void write(DataOutput out) throws IOException {
        Text.writeString(out, this.taskid);
        out.writeFloat(this.progress);
        Text.writeString(out, this.state);
        out.writeLong(this.startTime);
        out.writeLong(this.finishTime);
        WritableUtils.writeStringArray(out, this.diagnostics);
        this.counters.write(out);
    }

    public void readFields(DataInput in) throws IOException {
        this.taskid = Text.readString(in);
        this.progress = in.readFloat();
        this.state = Text.readString(in);
        this.startTime = in.readLong();
        this.finishTime = in.readLong();
        this.diagnostics = WritableUtils.readStringArray(in);
        this.counters = new Counters();
        this.counters.readFields(in);
    }
}

