/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.IOException;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.mapred.Counters;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.JobInProgress;
import org.apache.hadoop.mapred.JobTracker;
import org.apache.hadoop.mapred.MapTask;
import org.apache.hadoop.mapred.ReduceTask;
import org.apache.hadoop.mapred.Task;
import org.apache.hadoop.mapred.TaskReport;
import org.apache.hadoop.mapred.TaskStatus;
import org.apache.hadoop.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class TaskInProgress {
    static final int MAX_TASK_EXECS = 1;
    int maxTaskAttempts = 4;
    static final double SPECULATIVE_GAP = 0.2;
    static final long SPECULATIVE_LAG = 60000L;
    private static NumberFormat idFormat = NumberFormat.getInstance();
    public static final Log LOG;
    private String jobFile = null;
    private String splitClass = null;
    private BytesWritable split = null;
    private int numMaps;
    private int partition;
    private JobTracker jobtracker;
    private String id;
    private JobInProgress job;
    private int successEventNumber = -1;
    private int numTaskFailures = 0;
    private int numKilledTasks = 0;
    private double progress = 0.0;
    private String state = "";
    private long startTime = 0L;
    private long execStartTime = 0L;
    private long execFinishTime = 0L;
    private int completes = 0;
    private boolean failed = false;
    private boolean killed = false;
    String taskIdPrefix;
    int nextTaskId = 0;
    private TreeMap<String, String> activeTasks = new TreeMap();
    private JobConf conf;
    private boolean runSpeculative;
    private Map<String, List<String>> taskDiagnosticData = new TreeMap<String, List<String>>();
    private TreeMap<String, TaskStatus> taskStatuses = new TreeMap();
    private Map<String, Task> tasks = new TreeMap<String, Task>();
    boolean savedTaskOutput = false;
    private TreeSet<String> machinesWhereFailed = new TreeSet();
    private TreeSet<String> tasksReportedClosed = new TreeSet();
    private Counters counters = new Counters();

    public TaskInProgress(String uniqueString, String jobFile, String splitClass, BytesWritable split, JobTracker jobtracker, JobConf conf, JobInProgress job, int partition) {
        this.jobFile = jobFile;
        this.splitClass = splitClass;
        this.split = split;
        this.jobtracker = jobtracker;
        this.job = job;
        this.conf = conf;
        this.partition = partition;
        this.setMaxTaskAttempts();
        this.init(uniqueString);
    }

    public TaskInProgress(String uniqueString, String jobFile, int numMaps, int partition, JobTracker jobtracker, JobConf conf, JobInProgress job) {
        this.jobFile = jobFile;
        this.numMaps = numMaps;
        this.partition = partition;
        this.jobtracker = jobtracker;
        this.job = job;
        this.conf = conf;
        this.setMaxTaskAttempts();
        this.init(uniqueString);
    }

    private void setMaxTaskAttempts() {
        this.maxTaskAttempts = this.isMapTask() ? this.conf.getMaxMapAttempts() : this.conf.getMaxReduceAttempts();
    }

    private String makeUniqueString(String uniqueBase) {
        StringBuffer result = new StringBuffer();
        result.append(uniqueBase);
        if (this.isMapTask()) {
            result.append("_m_");
        } else {
            result.append("_r_");
        }
        result.append(idFormat.format(this.partition));
        return result.toString();
    }

    public int idWithinJob() {
        return this.partition;
    }

    void init(String jobUniqueString) {
        this.startTime = System.currentTimeMillis();
        this.runSpeculative = this.conf.getSpeculativeExecution();
        this.taskIdPrefix = this.makeUniqueString(jobUniqueString);
        this.id = "tip_" + this.taskIdPrefix;
    }

    public JobInProgress getJob() {
        return this.job;
    }

    public String getTIPId() {
        return this.id;
    }

    public boolean isMapTask() {
        return this.split != null;
    }

    public boolean isRunning() {
        return !this.activeTasks.isEmpty();
    }

    public boolean isComplete() {
        return this.completes > 0;
    }

    public boolean isComplete(String taskid) {
        TaskStatus status = this.taskStatuses.get(taskid);
        if (status == null) {
            return false;
        }
        return this.completes > 0 && status.getRunState() == TaskStatus.State.SUCCEEDED;
    }

    public boolean isFailed() {
        return this.failed;
    }

    public int numTaskFailures() {
        return this.numTaskFailures;
    }

    public int numKilledTasks() {
        return this.numKilledTasks;
    }

    public double getProgress() {
        return this.progress;
    }

    public Counters getCounters() {
        return this.counters;
    }

    public boolean shouldCloseForClosedJob(String taskid) {
        TaskStatus ts = this.taskStatuses.get(taskid);
        if (ts != null && !this.tasksReportedClosed.contains(taskid) && this.job.getStatus().getRunState() != 1) {
            this.tasksReportedClosed.add(taskid);
            return true;
        }
        if (!this.isMapTask() && this.isComplete() && !this.tasksReportedClosed.contains(taskid)) {
            this.tasksReportedClosed.add(taskid);
            return true;
        }
        return false;
    }

    synchronized TaskReport generateSingleReport() {
        ArrayList<String> diagnostics = new ArrayList<String>();
        for (List<String> l : this.taskDiagnosticData.values()) {
            diagnostics.addAll(l);
        }
        TaskReport report = new TaskReport(this.getTIPId(), (float)this.progress, this.state, diagnostics.toArray(new String[diagnostics.size()]), this.execStartTime, this.execFinishTime, this.counters);
        return report;
    }

    synchronized List<String> getDiagnosticInfo(String taskId) {
        return this.taskDiagnosticData.get(taskId);
    }

    synchronized boolean updateStatus(TaskStatus status) {
        String taskid = status.getTaskId();
        String diagInfo = status.getDiagnosticInfo();
        TaskStatus oldStatus = this.taskStatuses.get(taskid);
        boolean changed = true;
        if (diagInfo != null && diagInfo.length() > 0) {
            LOG.info((Object)("Error from " + taskid + ": " + diagInfo));
            List<String> diagHistory = this.taskDiagnosticData.get(taskid);
            if (diagHistory == null) {
                diagHistory = new ArrayList<String>();
                this.taskDiagnosticData.put(taskid, diagHistory);
            }
            diagHistory.add(diagInfo);
        }
        if (oldStatus != null) {
            TaskStatus.State oldState = oldStatus.getRunState();
            TaskStatus.State newState = status.getRunState();
            if (newState != TaskStatus.State.RUNNING && oldState == newState) {
                LOG.warn((Object)("Recieved duplicate status update of '" + (Object)((Object)newState) + "' for '" + taskid + "' of TIP '" + this.getTIPId() + "'"));
                return false;
            }
            if (newState == TaskStatus.State.RUNNING && (oldState == TaskStatus.State.FAILED || oldState == TaskStatus.State.KILLED || oldState == TaskStatus.State.SUCCEEDED)) {
                return false;
            }
            changed = oldState != newState;
        }
        this.taskStatuses.put(taskid, status);
        this.recomputeProgress();
        return changed;
    }

    public void incompleteSubTask(String taskid, String trackerName) {
        LOG.info((Object)("Task '" + taskid + "' has been lost."));
        TaskStatus status = this.taskStatuses.get(taskid);
        TaskStatus.State taskState = TaskStatus.State.FAILED;
        if (status != null) {
            taskState = status.getRunState();
            if (taskState != TaskStatus.State.FAILED && taskState != TaskStatus.State.KILLED) {
                LOG.info((Object)("Task '" + taskid + "' running on '" + trackerName + "' in state: '" + (Object)((Object)taskState) + "' being failed!"));
                status.setRunState(TaskStatus.State.FAILED);
                taskState = TaskStatus.State.FAILED;
            }
            if (0L == status.getFinishTime()) {
                status.setFinishTime(System.currentTimeMillis());
            }
        }
        this.activeTasks.remove(taskid);
        if (this.completes > 0 && this.isMapTask()) {
            --this.completes;
        }
        Task t = this.tasks.get(taskid);
        try {
            t.discardTaskOutput();
        }
        catch (IOException ioe) {
            LOG.info((Object)("Failed to discard output of task '" + taskid + "' with " + StringUtils.stringifyException(ioe)));
        }
        if (taskState == TaskStatus.State.FAILED) {
            ++this.numTaskFailures;
        } else {
            ++this.numKilledTasks;
        }
        if (this.numTaskFailures >= this.maxTaskAttempts) {
            LOG.info((Object)("TaskInProgress " + this.getTIPId() + " has failed " + this.numTaskFailures + " times."));
            this.kill();
        }
        this.machinesWhereFailed.add(trackerName);
    }

    void alreadyCompletedTask(String taskid) throws IOException {
        Task t = this.tasks.get(taskid);
        try {
            t.discardTaskOutput();
        }
        catch (IOException ioe) {
            LOG.info((Object)("Failed to discard output of task '" + taskid + "' with " + StringUtils.stringifyException(ioe)));
        }
        this.completedTask(taskid);
    }

    void completedTask(String taskid) {
        TaskStatus status = this.taskStatuses.get(taskid);
        status.setRunState(TaskStatus.State.SUCCEEDED);
        this.activeTasks.remove(taskid);
        LOG.info((Object)("Task '" + taskid + "' has completed."));
    }

    public void completed(String taskid) throws IOException {
        Task t = this.tasks.get(taskid);
        if (!this.savedTaskOutput) {
            t.saveTaskOutput();
            this.savedTaskOutput = true;
        } else {
            try {
                t.discardTaskOutput();
            }
            catch (IOException ioe) {
                LOG.info((Object)("Failed to discard 'already-saved' output of task: " + t.getTaskId() + " with: " + StringUtils.stringifyException(ioe)));
            }
        }
        this.completedTask(taskid);
        ++this.completes;
        this.recomputeProgress();
    }

    public TaskStatus[] getTaskStatuses() {
        return this.taskStatuses.values().toArray(new TaskStatus[this.taskStatuses.size()]);
    }

    public TaskStatus getTaskStatus(String taskid) {
        return this.taskStatuses.get(taskid);
    }

    public void kill() {
        if (this.isComplete() || this.failed) {
            return;
        }
        this.failed = true;
        this.killed = true;
        this.recomputeProgress();
    }

    public boolean wasKilled() {
        return this.killed;
    }

    void recomputeProgress() {
        if (this.isComplete()) {
            this.progress = 1.0;
            this.execFinishTime = System.currentTimeMillis();
        } else if (this.failed) {
            this.progress = 0.0;
            this.execFinishTime = System.currentTimeMillis();
        } else {
            double bestProgress = 0.0;
            String bestState = "";
            Counters bestCounters = new Counters();
            for (String taskid : this.taskStatuses.keySet()) {
                TaskStatus status = this.taskStatuses.get(taskid);
                if (status.getRunState() == TaskStatus.State.SUCCEEDED) {
                    bestProgress = 1.0;
                    bestState = status.getStateString();
                    bestCounters = status.getCounters();
                    break;
                }
                if (status.getRunState() != TaskStatus.State.RUNNING || !((double)status.getProgress() >= bestProgress)) continue;
                bestProgress = status.getProgress();
                bestState = status.getStateString();
                bestCounters = status.getCounters();
            }
            this.progress = bestProgress;
            this.state = bestState;
            this.counters = bestCounters;
        }
    }

    boolean isRunnable() {
        return !this.failed && this.completes == 0;
    }

    boolean hasSpeculativeTask(double averageProgress) {
        return this.activeTasks.size() <= 1 && this.runSpeculative && averageProgress - this.progress >= 0.2 && System.currentTimeMillis() - this.startTime >= 60000L && this.completes == 0;
    }

    public Task getTaskToRun(String taskTracker) throws IOException {
        Task t = null;
        if (0L == this.execStartTime) {
            this.execStartTime = System.currentTimeMillis();
        }
        String taskid = null;
        if (this.nextTaskId < 1 + this.maxTaskAttempts + this.numKilledTasks) {
            taskid = new String("task_" + this.taskIdPrefix + "_" + this.nextTaskId);
            ++this.nextTaskId;
        } else {
            LOG.warn((Object)("Exceeded limit of " + (1 + this.maxTaskAttempts) + " (plus " + this.numKilledTasks + " killed)" + " attempts for the tip '" + this.getTIPId() + "'"));
            return null;
        }
        String jobId = this.job.getProfile().getJobId();
        t = this.isMapTask() ? new MapTask(jobId, this.jobFile, this.id, taskid, this.partition, this.splitClass, this.split) : new ReduceTask(jobId, this.jobFile, this.id, taskid, this.partition, this.numMaps);
        t.setConf(this.conf);
        this.tasks.put(taskid, t);
        this.activeTasks.put(taskid, taskTracker);
        this.jobtracker.createTaskEntry(taskid, taskTracker, this);
        return t;
    }

    public boolean hasFailedOnMachine(String tracker) {
        return this.machinesWhereFailed.contains(tracker);
    }

    public boolean hasRunOnMachine(String tracker) {
        return this.activeTasks.values().contains(tracker) || this.hasFailedOnMachine(tracker);
    }

    public int getNumberOfFailedMachines() {
        return this.machinesWhereFailed.size();
    }

    public int getIdWithinJob() {
        return this.partition;
    }

    public void setSuccessEventNumber(int eventNumber) {
        this.successEventNumber = eventNumber;
    }

    public int getSuccessEventNumber() {
        return this.successEventNumber;
    }

    static {
        idFormat.setMinimumIntegerDigits(6);
        idFormat.setGroupingUsed(false);
        LOG = LogFactory.getLog((String)"org.apache.hadoop.mapred.TaskInProgress");
    }
}

