/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.BindException;
import java.net.URL;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.util.ReflectionUtils;
import org.mortbay.http.HttpContext;
import org.mortbay.http.HttpHandler;
import org.mortbay.http.HttpListener;
import org.mortbay.http.SocketListener;
import org.mortbay.http.handler.ResourceHandler;
import org.mortbay.jetty.Server;
import org.mortbay.jetty.servlet.WebApplicationContext;
import org.mortbay.util.MultiException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StatusHttpServer {
    private static final boolean isWindows = System.getProperty("os.name").startsWith("Windows");
    private Server webServer = new Server();
    private SocketListener listener;
    private boolean findPort;
    private WebApplicationContext webAppContext;
    private static final Log LOG = LogFactory.getLog((String)StatusHttpServer.class.getName());

    public StatusHttpServer(String name, String bindAddress, int port, boolean findPort) throws IOException {
        this.findPort = findPort;
        this.listener = new SocketListener();
        this.listener.setPort(port);
        this.listener.setHost(bindAddress);
        this.webServer.addListener((HttpListener)this.listener);
        String logDir = System.getProperty("hadoop.log.dir");
        if (logDir != null) {
            HttpContext logContext = new HttpContext();
            logContext.setContextPath("/logs/*");
            logContext.setResourceBase(logDir);
            logContext.addHandler((HttpHandler)new ResourceHandler());
            this.webServer.addContext(logContext);
        }
        String appDir = StatusHttpServer.getWebAppsPath();
        HttpContext staticContext = new HttpContext();
        staticContext.setContextPath("/static/*");
        staticContext.setResourceBase(appDir + "/static");
        staticContext.addHandler((HttpHandler)new ResourceHandler());
        this.webServer.addContext(staticContext);
        this.webAppContext = this.webServer.addWebApplication("/", appDir + File.separator + name);
        this.addServlet("stacks", "/stacks", StackServlet.class);
    }

    public void setAttribute(String name, Object value) {
        this.webAppContext.setAttribute(name, value);
    }

    public <T extends HttpServlet> void addServlet(String name, String pathSpec, Class<T> servletClass) {
        WebApplicationContext context = this.webAppContext;
        try {
            if (name == null) {
                context.addServlet(pathSpec, servletClass.getName());
            } else {
                context.addServlet(name, pathSpec, servletClass.getName());
            }
        }
        catch (ClassNotFoundException ex) {
            throw StatusHttpServer.makeRuntimeException("Problem instantiating class", ex);
        }
        catch (InstantiationException ex) {
            throw StatusHttpServer.makeRuntimeException("Problem instantiating class", ex);
        }
        catch (IllegalAccessException ex) {
            throw StatusHttpServer.makeRuntimeException("Problem instantiating class", ex);
        }
    }

    private static RuntimeException makeRuntimeException(String msg, Throwable cause) {
        RuntimeException result = new RuntimeException(msg);
        if (cause != null) {
            result.initCause(cause);
        }
        return result;
    }

    public Object getAttribute(String name) {
        return this.webAppContext.getAttribute(name);
    }

    private static String getWebAppsPath() throws IOException {
        URL url = StatusHttpServer.class.getClassLoader().getResource("webapps");
        if (url == null) {
            throw new IOException("webapps not found in CLASSPATH");
        }
        return url.toString();
    }

    public int getPort() {
        return this.listener.getPort();
    }

    public void setThreads(int min, int max) {
        this.listener.setMinThreads(min);
        this.listener.setMaxThreads(max);
    }

    public void start() throws IOException {
        try {
            while (true) {
                try {
                    this.webServer.start();
                }
                catch (MultiException ex) {
                    boolean needNewPort = false;
                    for (int i = 0; i < ex.size(); ++i) {
                        Exception sub = ex.getException(i);
                        if (!(sub instanceof BindException)) continue;
                        needNewPort = true;
                        break;
                    }
                    if (!this.findPort || !needNewPort) {
                        throw ex;
                    }
                    this.listener.setPort(this.listener.getPort() + 1);
                    continue;
                }
                break;
            }
        }
        catch (IOException ie) {
            throw ie;
        }
        catch (Exception e) {
            IOException ie = new IOException("Problem starting http server");
            ie.initCause(e);
            throw ie;
        }
    }

    public void stop() throws InterruptedException {
        this.webServer.stop();
    }

    public static class StackServlet
    extends HttpServlet {
        public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
            ServletOutputStream outStream = response.getOutputStream();
            ReflectionUtils.printThreadInfo(new PrintWriter((OutputStream)outStream), "");
            outStream.close();
            ReflectionUtils.logThreadInfo(LOG, "jsp requested", 1L);
        }
    }
}

