/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.IOException;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.FileSplit;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapred.SequenceFileRecordReader;

public class SequenceFileInputFormat
extends FileInputFormat {
    public SequenceFileInputFormat() {
        this.setMinSplitSize(2000L);
    }

    protected Path[] listPaths(JobConf job) throws IOException {
        Path[] files = super.listPaths(job);
        for (int i = 0; i < files.length; ++i) {
            Path file = files[i];
            if (!file.getFileSystem(job).isDirectory(file)) continue;
            files[i] = new Path(file, "data");
        }
        return files;
    }

    public RecordReader getRecordReader(InputSplit split, JobConf job, Reporter reporter) throws IOException {
        reporter.setStatus(split.toString());
        return new SequenceFileRecordReader(job, (FileSplit)split);
    }
}

