/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.IOException;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.MapRunnable;
import org.apache.hadoop.mapred.Mapper;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.util.ReflectionUtils;

public class MapRunner
implements MapRunnable {
    private JobConf job;
    private Mapper mapper;

    public void configure(JobConf job) {
        this.job = job;
        this.mapper = (Mapper)ReflectionUtils.newInstance(job.getMapperClass(), job);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(RecordReader input, OutputCollector output, Reporter reporter) throws IOException {
        try {
            WritableComparable key = input.createKey();
            Writable value = input.createValue();
            while (input.next(key, value)) {
                this.mapper.map(key, value, output, reporter);
            }
        }
        finally {
            this.mapper.close();
        }
    }
}

