/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.InMemoryFileSystem;
import org.apache.hadoop.fs.LocalDirAllocator;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.UTF8;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableFactories;
import org.apache.hadoop.io.WritableFactory;
import org.apache.hadoop.mapred.MRConstants;
import org.apache.hadoop.metrics.MetricsRecord;
import org.apache.hadoop.util.Progressable;

class MapOutputLocation
implements Writable,
MRConstants {
    private String mapTaskId;
    private int mapId;
    private String host;
    private int port;

    public MapOutputLocation() {
    }

    public MapOutputLocation(String mapTaskId, int mapId, String host, int port) {
        this.mapTaskId = mapTaskId;
        this.mapId = mapId;
        this.host = host;
        this.port = port;
    }

    public String getMapTaskId() {
        return this.mapTaskId;
    }

    public int getMapId() {
        return this.mapId;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public void write(DataOutput out) throws IOException {
        UTF8.writeString(out, this.mapTaskId);
        out.writeInt(this.mapId);
        UTF8.writeString(out, this.host);
        out.writeInt(this.port);
    }

    public void readFields(DataInput in) throws IOException {
        this.mapTaskId = UTF8.readString(in);
        this.mapId = in.readInt();
        this.host = UTF8.readString(in);
        this.port = in.readInt();
    }

    public String toString() {
        return "http://" + this.host + ":" + this.port + "/mapOutput?map=" + this.mapTaskId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public long getFile(FileSystem fileSys, Path localFilename, int reduce, Progressable pingee, int timeout) throws IOException, InterruptedException {
        boolean good = false;
        long totalBytes = 0L;
        Thread currentThread = Thread.currentThread();
        URL path = new URL(this.toString() + "&reduce=" + reduce);
        try {
            URLConnection connection = path.openConnection();
            if (timeout > 0) {
                connection.setConnectTimeout(timeout);
                connection.setReadTimeout(timeout);
            }
            InputStream input = connection.getInputStream();
            try {
                FSDataOutputStream output = fileSys.create(localFilename);
                try {
                    byte[] buffer = new byte[65536];
                    if (currentThread.isInterrupted()) {
                        throw new InterruptedException();
                    }
                    int len = input.read(buffer);
                    while (len > 0) {
                        totalBytes += (long)len;
                        ((OutputStream)output).write(buffer, 0, len);
                        if (pingee != null) {
                            pingee.progress();
                        }
                        if (currentThread.isInterrupted()) {
                            throw new InterruptedException();
                        }
                        len = input.read(buffer);
                    }
                }
                finally {
                    ((OutputStream)output).close();
                }
            }
            finally {
                input.close();
            }
            boolean bl = good = (int)totalBytes == connection.getContentLength();
            if (!good) {
                throw new IOException("Incomplete map output received for " + path + " (" + totalBytes + " instead of " + connection.getContentLength() + ")");
            }
        }
        finally {
            if (!good) {
                try {
                    fileSys.delete(localFilename);
                    totalBytes = 0L;
                }
                catch (Throwable th) {}
            }
        }
        return totalBytes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Path getFile(InMemoryFileSystem inMemFileSys, FileSystem localFileSys, MetricsRecord shuffleMetrics, Path localFilename, LocalDirAllocator lDirAlloc, Configuration conf, int reduce, int timeout) throws IOException, InterruptedException {
        boolean good = false;
        long totalBytes = 0L;
        FileSystem fileSys = localFileSys;
        Thread currentThread = Thread.currentThread();
        URL path = new URL(this.toString() + "&reduce=" + reduce);
        try {
            URLConnection connection = path.openConnection();
            if (timeout > 0) {
                connection.setConnectTimeout(timeout);
                connection.setReadTimeout(timeout);
            }
            InputStream input = connection.getInputStream();
            FSDataOutputStream output = null;
            long length = Long.parseLong(connection.getHeaderField("Map-Output-Length"));
            long inMemFSSize = inMemFileSys.getFSSize();
            long checksumLength = (int)inMemFileSys.getChecksumFileLength(localFilename, length);
            boolean createInMem = false;
            if (inMemFSSize > 0L) {
                boolean bl = createInMem = (float)(length + checksumLength) / (float)inMemFSSize <= 0.25f && inMemFileSys.reserveSpaceWithCheckSum(localFilename, length);
            }
            if (createInMem) {
                fileSys = inMemFileSys;
            } else {
                localFilename = lDirAlloc.getLocalPathForWrite(localFilename.toUri().getPath(), length + checksumLength, conf);
            }
            output = fileSys.create(localFilename);
            try {
                try {
                    byte[] buffer = new byte[65536];
                    if (currentThread.isInterrupted()) {
                        throw new InterruptedException();
                    }
                    int len = input.read(buffer);
                    while (len > 0) {
                        totalBytes += (long)len;
                        shuffleMetrics.incrMetric("shuffle_input_bytes", len);
                        shuffleMetrics.update();
                        ((OutputStream)output).write(buffer, 0, len);
                        if (currentThread.isInterrupted()) {
                            throw new InterruptedException();
                        }
                        len = input.read(buffer);
                    }
                }
                finally {
                    ((OutputStream)output).close();
                }
            }
            finally {
                input.close();
            }
            boolean bl = good = totalBytes == length;
            if (!good) {
                throw new IOException("Incomplete map output received for " + path + " (" + totalBytes + " instead of " + length + ")");
            }
        }
        finally {
            if (!good) {
                try {
                    fileSys.delete(localFilename);
                    totalBytes = 0L;
                }
                catch (Throwable th) {}
            }
        }
        return fileSys.makeQualified(localFilename);
    }

    static {
        WritableFactories.setFactory(MapOutputLocation.class, new WritableFactory(){

            public Writable newInstance() {
                return new MapOutputLocation();
            }
        });
    }
}

