/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.IOException;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Random;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.DataOutputBuffer;
import org.apache.hadoop.mapred.ClusterStatus;
import org.apache.hadoop.mapred.Counters;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.JobEndNotifier;
import org.apache.hadoop.mapred.JobProfile;
import org.apache.hadoop.mapred.JobStatus;
import org.apache.hadoop.mapred.JobSubmissionProtocol;
import org.apache.hadoop.mapred.JobTracker;
import org.apache.hadoop.mapred.MapOutputFile;
import org.apache.hadoop.mapred.MapTask;
import org.apache.hadoop.mapred.ReduceTask;
import org.apache.hadoop.mapred.Task;
import org.apache.hadoop.mapred.TaskCompletionEvent;
import org.apache.hadoop.mapred.TaskReport;
import org.apache.hadoop.mapred.TaskStatus;
import org.apache.hadoop.mapred.TaskUmbilicalProtocol;

class LocalJobRunner
implements JobSubmissionProtocol {
    public static final Log LOG = LogFactory.getLog((String)"org.apache.hadoop.mapred.LocalJobRunner");
    private FileSystem fs;
    private HashMap<String, Job> jobs = new HashMap();
    private Configuration conf;
    private int map_tasks = 0;
    private int reduce_tasks = 0;
    private JobTracker.JobTrackerMetrics myMetrics = null;
    private static NumberFormat idFormat = NumberFormat.getInstance();

    public long getProtocolVersion(String protocol, long clientVersion) {
        return 3L;
    }

    public LocalJobRunner(Configuration conf) throws IOException {
        this.fs = FileSystem.get(conf);
        this.conf = conf;
        this.myMetrics = new JobTracker.JobTrackerMetrics();
    }

    public JobStatus submitJob(String jobFile) throws IOException {
        return new Job(jobFile, this.conf).status;
    }

    public void killJob(String id) {
        this.jobs.get(id).stop();
    }

    public JobProfile getJobProfile(String id) {
        Job job = this.jobs.get(id);
        return job.getProfile();
    }

    public TaskReport[] getMapTaskReports(String id) {
        return new TaskReport[0];
    }

    public TaskReport[] getReduceTaskReports(String id) {
        return new TaskReport[0];
    }

    public JobStatus getJobStatus(String id) {
        Job job = this.jobs.get(id);
        return job.status;
    }

    public Counters getJobCounters(String id) {
        Job job = this.jobs.get(id);
        return job.currentCounters;
    }

    public String getFilesystemName() throws IOException {
        return this.fs.getName();
    }

    public ClusterStatus getClusterStatus() {
        return new ClusterStatus(1, this.map_tasks, this.reduce_tasks, 1);
    }

    public JobStatus[] jobsToComplete() {
        return null;
    }

    public TaskCompletionEvent[] getTaskCompletionEvents(String jobid, int fromEventId, int maxEvents) throws IOException {
        return TaskCompletionEvent.EMPTY_ARRAY;
    }

    static {
        idFormat.setMinimumIntegerDigits(4);
        idFormat.setGroupingUsed(false);
    }

    private class Job
    extends Thread
    implements TaskUmbilicalProtocol {
        private String file;
        private String id;
        private JobConf job;
        private Random random = new Random();
        private JobStatus status;
        private ArrayList<String> mapIds = new ArrayList();
        private MapOutputFile mapoutputFile;
        private JobProfile profile;
        private Path localFile;
        private FileSystem localFs;
        private Counters completedTaskCounters = new Counters();
        private Counters currentCounters = new Counters();

        public long getProtocolVersion(String protocol, long clientVersion) {
            return 2L;
        }

        public Job(String file, Configuration conf) throws IOException {
            this.file = file;
            this.id = "job_" + this.newId();
            this.mapoutputFile = new MapOutputFile();
            this.mapoutputFile.setConf(conf);
            this.localFile = new JobConf(conf).getLocalPath("localRunner/" + this.id + ".xml");
            this.localFs = FileSystem.getLocal(conf);
            LocalJobRunner.this.fs.copyToLocalFile(new Path(file), this.localFile);
            this.job = new JobConf(this.localFile);
            this.profile = new JobProfile(this.job.getUser(), this.id, file, "http://localhost:8080/", this.job.getJobName());
            this.status = new JobStatus(this.id, 0.0f, 0.0f, 1);
            LocalJobRunner.this.jobs.put(this.id, this);
            this.start();
        }

        JobProfile getProfile() {
            return this.profile;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                InputSplit[] splits = this.job.getInputFormat().getSplits(this.job, 1);
                String jobId = this.profile.getJobId();
                int numReduceTasks = this.job.getNumReduceTasks();
                if (numReduceTasks > 1 || numReduceTasks < 0) {
                    numReduceTasks = 1;
                    this.job.setNumReduceTasks(1);
                }
                DataOutputBuffer buffer = new DataOutputBuffer();
                for (int i = 0; i < splits.length; ++i) {
                    String mapId = "map_" + idFormat.format(i);
                    this.mapIds.add(mapId);
                    buffer.reset();
                    splits[i].write(buffer);
                    BytesWritable split = new BytesWritable();
                    split.set(buffer.getData(), 0, buffer.getLength());
                    MapTask map = new MapTask(jobId, this.file, "tip_m_" + mapId, mapId, i, splits[i].getClass().getName(), split);
                    JobConf localConf = new JobConf(this.job);
                    map.localizeConfiguration(localConf);
                    map.setConf(localConf);
                    LocalJobRunner.this.map_tasks += 1;
                    LocalJobRunner.this.myMetrics.launchMap();
                    map.run(localConf, this);
                    map.saveTaskOutput();
                    LocalJobRunner.this.myMetrics.completeMap();
                    LocalJobRunner.this.map_tasks -= 1;
                    this.updateCounters(map);
                }
                if (numReduceTasks > 0) {
                    String reduceId = "reduce_" + this.newId();
                    for (int i = 0; i < this.mapIds.size(); ++i) {
                        String mapId = this.mapIds.get(i);
                        Path mapOut = this.mapoutputFile.getOutputFile(mapId);
                        Path reduceIn = this.mapoutputFile.getInputFileForWrite(i, reduceId, this.localFs.getLength(mapOut));
                        if (!this.localFs.mkdirs(reduceIn.getParent())) {
                            throw new IOException("Mkdirs failed to create " + reduceIn.getParent().toString());
                        }
                        if (!this.localFs.rename(mapOut, reduceIn)) {
                            throw new IOException("Couldn't rename " + mapOut);
                        }
                        this.mapoutputFile.removeAll(mapId);
                    }
                    ReduceTask reduce = new ReduceTask(jobId, this.file, "tip_r_0001", reduceId, 0, this.mapIds.size());
                    JobConf localConf = new JobConf(this.job);
                    reduce.localizeConfiguration(localConf);
                    reduce.setConf(localConf);
                    LocalJobRunner.this.reduce_tasks += 1;
                    LocalJobRunner.this.myMetrics.launchReduce();
                    reduce.run(localConf, this);
                    reduce.saveTaskOutput();
                    LocalJobRunner.this.myMetrics.completeReduce();
                    LocalJobRunner.this.reduce_tasks -= 1;
                    this.updateCounters(reduce);
                    this.mapoutputFile.removeAll(reduceId);
                }
                this.status.setRunState(2);
                JobEndNotifier.localRunnerNotification(this.job, this.status);
            }
            catch (Throwable t) {
                this.status.setRunState(3);
                LOG.warn((Object)this.id, t);
                JobEndNotifier.localRunnerNotification(this.job, this.status);
            }
            finally {
                try {
                    LocalJobRunner.this.fs.delete(new Path(this.file).getParent());
                    this.localFs.delete(this.localFile);
                }
                catch (IOException e) {
                    LOG.warn((Object)("Error cleaning up " + this.id + ": " + e));
                }
            }
        }

        private String newId() {
            return Integer.toString(Math.abs(this.random.nextInt()), 36);
        }

        public Task getTask(String taskid) {
            return null;
        }

        public void progress(String taskId, float progress, String state, TaskStatus.Phase phase, Counters taskCounters) {
            LOG.info((Object)state);
            float taskIndex = this.mapIds.indexOf(taskId);
            if (taskIndex >= 0.0f) {
                float numTasks = this.mapIds.size();
                this.status.setMapProgress(taskIndex / numTasks + progress / numTasks);
            } else {
                this.status.setReduceProgress(progress);
            }
            this.currentCounters = Counters.sum(this.completedTaskCounters, taskCounters);
        }

        private void updateCounters(Task task) {
            this.completedTaskCounters.incrAllCounters(task.getCounters());
        }

        public void reportDiagnosticInfo(String taskid, String trace) {
        }

        public boolean ping(String taskid) throws IOException {
            return true;
        }

        public void done(String taskId) throws IOException {
            int taskIndex = this.mapIds.indexOf(taskId);
            if (taskIndex >= 0) {
                this.status.setMapProgress(1.0f);
            } else {
                this.status.setReduceProgress(1.0f);
            }
        }

        public synchronized void fsError(String taskId, String message) throws IOException {
            LOG.fatal((Object)("FSError: " + message + "from task: " + taskId));
        }

        public TaskCompletionEvent[] getMapCompletionEvents(String jobId, int fromEventId, int maxLocs) throws IOException {
            return TaskCompletionEvent.EMPTY_ARRAY;
        }
    }
}

