/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.Counters;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.JobEndNotifier;
import org.apache.hadoop.mapred.JobHistory;
import org.apache.hadoop.mapred.JobProfile;
import org.apache.hadoop.mapred.JobStatus;
import org.apache.hadoop.mapred.JobTracker;
import org.apache.hadoop.mapred.Task;
import org.apache.hadoop.mapred.TaskCompletionEvent;
import org.apache.hadoop.mapred.TaskInProgress;
import org.apache.hadoop.mapred.TaskStatus;
import org.apache.hadoop.mapred.TaskTrackerStatus;
import org.apache.hadoop.metrics.MetricsContext;
import org.apache.hadoop.metrics.MetricsRecord;
import org.apache.hadoop.metrics.MetricsUtil;
import org.apache.hadoop.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JobInProgress {
    private static final Log LOG = LogFactory.getLog((String)"org.apache.hadoop.mapred.JobInProgress");
    JobProfile profile;
    JobStatus status;
    Path localJobFile = null;
    Path localJarFile = null;
    TaskInProgress[] maps = new TaskInProgress[0];
    TaskInProgress[] reduces = new TaskInProgress[0];
    int numMapTasks = 0;
    int numReduceTasks = 0;
    int runningMapTasks = 0;
    int runningReduceTasks = 0;
    int finishedMapTasks = 0;
    int finishedReduceTasks = 0;
    int failedMapTasks = 0;
    int failedReduceTasks = 0;
    int mapFailuresPercent = 0;
    int reduceFailuresPercent = 0;
    int failedMapTIPs = 0;
    int failedReduceTIPs = 0;
    JobTracker jobtracker = null;
    Map<String, List<TaskInProgress>> hostToMaps = new HashMap<String, List<TaskInProgress>>();
    private int taskCompletionEventTracker = 0;
    List<TaskCompletionEvent> taskCompletionEvents;
    private static final double CLUSTER_BLACKLIST_PERCENT = 0.25;
    private volatile int clusterSize = 0;
    private volatile int flakyTaskTrackers = 0;
    private Map<String, Integer> trackerToFailuresMap = new TreeMap<String, Integer>();
    long startTime;
    long finishTime;
    private JobConf conf;
    boolean tasksInited = false;
    private LocalFileSystem localFs;
    private String uniqueString;
    private Counters jobCounters = new Counters();
    private Counters mapCounters = new Counters();
    private Counters reduceCounters = new Counters();
    private MetricsRecord jobMetrics;

    public JobInProgress(String jobFile, JobTracker jobtracker, Configuration default_conf) throws IOException {
        this.uniqueString = jobtracker.createUniqueId();
        String jobid = "job_" + this.uniqueString;
        String url = "http://" + jobtracker.getJobTrackerMachine() + ":" + jobtracker.getInfoPort() + "/jobdetails.jsp?jobid=" + jobid;
        this.jobtracker = jobtracker;
        this.status = new JobStatus(jobid, 0.0f, 0.0f, 4);
        this.startTime = System.currentTimeMillis();
        this.localFs = FileSystem.getLocal(default_conf);
        JobConf default_job_conf = new JobConf(default_conf);
        this.localJobFile = default_job_conf.getLocalPath("jobTracker/" + jobid + ".xml");
        this.localJarFile = default_job_conf.getLocalPath("jobTracker/" + jobid + ".jar");
        FileSystem fs = FileSystem.get(default_conf);
        fs.copyToLocalFile(new Path(jobFile), this.localJobFile);
        this.conf = new JobConf(this.localJobFile);
        this.profile = new JobProfile(this.conf.getUser(), jobid, jobFile, url, this.conf.getJobName());
        String jarFile = this.conf.getJar();
        if (jarFile != null) {
            fs.copyToLocalFile(new Path(jarFile), this.localJarFile);
            this.conf.setJar(this.localJarFile.toString());
        }
        this.numMapTasks = this.conf.getNumMapTasks();
        this.numReduceTasks = this.conf.getNumReduceTasks();
        this.taskCompletionEvents = new ArrayList<TaskCompletionEvent>(this.numMapTasks + this.numReduceTasks + 10);
        this.mapFailuresPercent = this.conf.getMaxMapTaskFailuresPercent();
        this.reduceFailuresPercent = this.conf.getMaxReduceTaskFailuresPercent();
        JobHistory.JobInfo.logSubmitted(jobid, this.conf.getJobName(), this.conf.getUser(), System.currentTimeMillis(), jobFile);
        MetricsContext metricsContext = MetricsUtil.getContext("mapred");
        this.jobMetrics = metricsContext.createRecord("job");
        this.jobMetrics.setTag("user", this.conf.getUser());
        this.jobMetrics.setTag("jobName", this.conf.getJobName());
    }

    public void updateMetrics() {
        Counters counters = this.getCounters();
        for (String groupName : counters.getGroupNames()) {
            Counters.Group group = counters.getGroup(groupName);
            this.jobMetrics.setTag("group", group.getDisplayName());
            for (String counter : group.getCounterNames()) {
                long value = group.getCounter(counter);
                this.jobMetrics.setTag("counter", group.getDisplayName(counter));
                this.jobMetrics.setMetric("value", value);
                this.jobMetrics.update();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void initTasks() throws IOException {
        int i;
        JobClient.RawSplit[] splits;
        if (this.tasksInited) {
            return;
        }
        String jobFile = this.profile.getJobFile();
        FileSystem fs = FileSystem.get(this.conf);
        FSDataInputStream splitFile = fs.open(new Path(this.conf.get("mapred.job.split.file")));
        try {
            splits = JobClient.readSplitFile(splitFile);
        }
        finally {
            splitFile.close();
        }
        this.numMapTasks = splits.length;
        this.maps = new TaskInProgress[this.numMapTasks];
        for (i = 0; i < this.numMapTasks; ++i) {
            this.maps[i] = new TaskInProgress(this.uniqueString, jobFile, splits[i].getClassName(), splits[i].getBytes(), this.jobtracker, this.conf, this, i);
            for (String host : splits[i].getLocations()) {
                List<TaskInProgress> hostMaps = this.hostToMaps.get(host);
                if (hostMaps == null) {
                    hostMaps = new ArrayList<TaskInProgress>();
                    this.hostToMaps.put(host, hostMaps);
                }
                hostMaps.add(this.maps[i]);
            }
        }
        if (this.numMapTasks == 0) {
            this.finishTime = System.currentTimeMillis();
            this.status.setMapProgress(1.0f);
            this.status.setReduceProgress(1.0f);
            this.status.setRunState(2);
            this.tasksInited = true;
            JobEndNotifier.registerNotification(this.getJobConf(), this.getStatus());
            return;
        }
        this.reduces = new TaskInProgress[this.numReduceTasks];
        for (i = 0; i < this.numReduceTasks; ++i) {
            this.reduces[i] = new TaskInProgress(this.uniqueString, jobFile, this.numMapTasks, i, this.jobtracker, this.conf, this);
        }
        this.status = new JobStatus(this.status.getJobId(), 0.0f, 0.0f, 1);
        this.tasksInited = true;
        JobHistory.JobInfo.logStarted(this.profile.getJobId(), System.currentTimeMillis(), this.numMapTasks, this.numReduceTasks);
    }

    public JobProfile getProfile() {
        return this.profile;
    }

    public JobStatus getStatus() {
        return this.status;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public long getFinishTime() {
        return this.finishTime;
    }

    public int desiredMaps() {
        return this.numMapTasks;
    }

    public synchronized int finishedMaps() {
        return this.finishedMapTasks;
    }

    public int desiredReduces() {
        return this.numReduceTasks;
    }

    public synchronized int runningMaps() {
        return this.runningMapTasks;
    }

    public synchronized int runningReduces() {
        return this.runningReduceTasks;
    }

    public synchronized int finishedReduces() {
        return this.finishedReduceTasks;
    }

    TaskInProgress[] getMapTasks() {
        return this.maps;
    }

    TaskInProgress[] getReduceTasks() {
        return this.reduces;
    }

    JobConf getJobConf() {
        return this.conf;
    }

    public Vector<TaskInProgress> reportTasksInProgress(boolean shouldBeMap, boolean shouldBeComplete) {
        Vector<TaskInProgress> results = new Vector<TaskInProgress>();
        TaskInProgress[] tips = null;
        tips = shouldBeMap ? this.maps : this.reduces;
        for (int i = 0; i < tips.length; ++i) {
            if (tips[i].isComplete() != shouldBeComplete) continue;
            results.add(tips[i]);
        }
        return results;
    }

    public synchronized void updateTaskStatus(TaskInProgress tip, TaskStatus status, JobTracker.JobTrackerMetrics metrics) {
        double oldProgress = tip.getProgress();
        boolean wasRunning = tip.isRunning();
        boolean wasComplete = tip.isComplete();
        boolean change = tip.updateStatus(status);
        if (change) {
            TaskStatus.State state = status.getRunState();
            TaskTrackerStatus ttStatus = this.jobtracker.getTaskTracker(status.getTaskTracker());
            String httpTaskLogLocation = null;
            if (null != ttStatus) {
                httpTaskLogLocation = "http://" + ttStatus.getHost() + ":" + ttStatus.getHttpPort() + "/tasklog.jsp?plaintext=true&taskid=" + status.getTaskId() + "&all=true";
            }
            TaskCompletionEvent taskEvent = null;
            if (state == TaskStatus.State.SUCCEEDED) {
                taskEvent = new TaskCompletionEvent(this.taskCompletionEventTracker, status.getTaskId(), tip.idWithinJob(), status.getIsMap(), TaskCompletionEvent.Status.SUCCEEDED, httpTaskLogLocation);
                try {
                    this.completedTask(tip, status, metrics);
                }
                catch (IOException ioe) {
                    this.failedTask(tip, status.getTaskId(), "Failed to copy reduce's output", tip.isMapTask() ? TaskStatus.Phase.MAP : TaskStatus.Phase.REDUCE, TaskStatus.State.FAILED, ttStatus.getHost(), status.getTaskTracker(), null);
                    LOG.info((Object)("Failed to copy the output of " + status.getTaskId() + " with: " + StringUtils.stringifyException(ioe)));
                    return;
                }
                tip.setSuccessEventNumber(this.taskCompletionEventTracker);
            } else if (state == TaskStatus.State.FAILED || state == TaskStatus.State.KILLED) {
                TaskCompletionEvent t;
                int eventNumber = tip.getSuccessEventNumber();
                if (eventNumber != -1 && (t = this.taskCompletionEvents.get(eventNumber)).getTaskId().equals(status.getTaskId())) {
                    t.setTaskStatus(TaskCompletionEvent.Status.OBSOLETE);
                }
                this.failedTask(tip, status.getTaskId(), status, status.getTaskTracker(), wasRunning, wasComplete, metrics);
                TaskCompletionEvent.Status taskCompletionStatus = TaskCompletionEvent.Status.FAILED;
                if (tip.isFailed()) {
                    taskCompletionStatus = TaskCompletionEvent.Status.TIPFAILED;
                }
                taskEvent = new TaskCompletionEvent(this.taskCompletionEventTracker, status.getTaskId(), tip.idWithinJob(), status.getIsMap(), taskCompletionStatus, httpTaskLogLocation);
            }
            if (taskEvent != null) {
                this.taskCompletionEvents.add(taskEvent);
                ++this.taskCompletionEventTracker;
            }
        }
        LOG.debug((Object)("Taking progress for " + tip.getTIPId() + " from " + oldProgress + " to " + tip.getProgress()));
        double progressDelta = tip.getProgress() - oldProgress;
        if (tip.isMapTask()) {
            if (this.maps.length == 0) {
                this.status.setMapProgress(1.0f);
            } else {
                this.status.setMapProgress((float)((double)this.status.mapProgress() + progressDelta / (double)this.maps.length));
            }
        } else if (this.reduces.length == 0) {
            this.status.setReduceProgress(1.0f);
        } else {
            this.status.setReduceProgress((float)((double)this.status.reduceProgress() + progressDelta / (double)this.reduces.length));
        }
    }

    public synchronized Counters getJobCounters() {
        return this.jobCounters;
    }

    public synchronized Counters getMapCounters() {
        return this.sumTaskCounters(this.maps);
    }

    public synchronized Counters getReduceCounters() {
        return this.sumTaskCounters(this.reduces);
    }

    public Counters getCounters() {
        return Counters.sum(this.getJobCounters(), Counters.sum(this.getMapCounters(), this.getReduceCounters()));
    }

    private Counters sumTaskCounters(TaskInProgress[] tips) {
        Counters counters = new Counters();
        for (TaskInProgress tip : tips) {
            counters.incrAllCounters(tip.getCounters());
        }
        return counters;
    }

    public synchronized Task obtainNewMapTask(TaskTrackerStatus tts, int clusterSize) throws IOException {
        if (!this.tasksInited) {
            LOG.info((Object)("Cannot create task split for " + this.profile.getJobId()));
            return null;
        }
        ArrayList mapCache = (ArrayList)this.hostToMaps.get(tts.getHost());
        int target = this.findNewTask(tts, clusterSize, this.status.mapProgress(), this.maps, mapCache);
        if (target == -1) {
            return null;
        }
        boolean wasRunning = this.maps[target].isRunning();
        Task result = this.maps[target].getTaskToRun(tts.getTrackerName());
        if (!wasRunning) {
            ++this.runningMapTasks;
            JobHistory.Task.logStarted(this.profile.getJobId(), this.maps[target].getTIPId(), JobHistory.Values.MAP.name(), System.currentTimeMillis());
        }
        return result;
    }

    public synchronized Task obtainNewReduceTask(TaskTrackerStatus tts, int clusterSize) throws IOException {
        if (!this.tasksInited) {
            LOG.info((Object)("Cannot create task split for " + this.profile.getJobId()));
            return null;
        }
        int target = this.findNewTask(tts, clusterSize, this.status.reduceProgress(), this.reduces, null);
        if (target == -1) {
            return null;
        }
        boolean wasRunning = this.reduces[target].isRunning();
        Task result = this.reduces[target].getTaskToRun(tts.getTrackerName());
        if (!wasRunning) {
            ++this.runningReduceTasks;
            JobHistory.Task.logStarted(this.profile.getJobId(), this.reduces[target].getTIPId(), JobHistory.Values.REDUCE.name(), System.currentTimeMillis());
        }
        return result;
    }

    private String convertTrackerNameToHostName(String trackerName) {
        int indexOfColon = trackerName.indexOf(":");
        String trackerHostName = indexOfColon == -1 ? trackerName : trackerName.substring(0, indexOfColon);
        return trackerHostName;
    }

    void addTrackerTaskFailure(String trackerName) {
        if ((double)this.flakyTaskTrackers < (double)this.clusterSize * 0.25) {
            String trackerHostName = this.convertTrackerNameToHostName(trackerName);
            Integer trackerFailures = this.trackerToFailuresMap.get(trackerHostName);
            if (trackerFailures == null) {
                trackerFailures = new Integer(0);
            }
            trackerFailures = trackerFailures + 1;
            this.trackerToFailuresMap.put(trackerHostName, trackerFailures);
            if (trackerFailures.intValue() == this.conf.getMaxTaskFailuresPerTracker()) {
                ++this.flakyTaskTrackers;
                LOG.info((Object)("TaskTracker at '" + trackerHostName + "' turned 'flaky'"));
            }
        }
    }

    private int getTrackerTaskFailures(String trackerName) {
        String trackerHostName = this.convertTrackerNameToHostName(trackerName);
        Integer failedTasks = this.trackerToFailuresMap.get(trackerHostName);
        return failedTasks != null ? failedTasks : 0;
    }

    int getNoOfBlackListedTrackers() {
        return this.flakyTaskTrackers;
    }

    synchronized Map<String, Integer> getTaskTrackerErrors() {
        TreeMap<String, Integer> trackerErrors = new TreeMap<String, Integer>(this.trackerToFailuresMap);
        return trackerErrors;
    }

    private int findNewTask(TaskTrackerStatus tts, int clusterSize, double avgProgress, TaskInProgress[] tasks, List cachedTasks) {
        String taskTracker = tts.getTrackerName();
        this.clusterSize = clusterSize;
        int taskTrackerFailedTasks = this.getTrackerTaskFailures(taskTracker);
        if ((double)this.flakyTaskTrackers < (double)clusterSize * 0.25 && taskTrackerFailedTasks >= this.conf.getMaxTaskFailuresPerTracker()) {
            if (LOG.isDebugEnabled()) {
                String flakyTracker = this.convertTrackerNameToHostName(taskTracker);
                LOG.debug((Object)("Ignoring the black-listed tasktracker: '" + flakyTracker + "' for assigning a new task"));
            }
            return -1;
        }
        if (cachedTasks != null) {
            Iterator i = cachedTasks.iterator();
            while (i.hasNext()) {
                TaskInProgress tip = (TaskInProgress)i.next();
                i.remove();
                if (!tip.isRunnable() || tip.isRunning() || tip.hasFailedOnMachine(taskTracker)) continue;
                LOG.info((Object)("Choosing cached task " + tip.getTIPId()));
                int cacheTarget = tip.getIdWithinJob();
                return cacheTarget;
            }
        }
        int failedTarget = -1;
        int specTarget = -1;
        for (int i = 0; i < tasks.length; ++i) {
            boolean hasFailed;
            TaskInProgress task = tasks[i];
            if (!task.isRunnable() || (hasFailed = task.hasFailedOnMachine(taskTracker)) && task.getNumberOfFailedMachines() < clusterSize) continue;
            boolean isRunning = task.isRunning();
            if (hasFailed) {
                if (isRunning || failedTarget != -1) continue;
                failedTarget = i;
                continue;
            }
            if (!isRunning) {
                LOG.info((Object)("Choosing normal task " + tasks[i].getTIPId()));
                return i;
            }
            if (specTarget != -1 || !task.hasSpeculativeTask(avgProgress) || task.hasRunOnMachine(taskTracker)) continue;
            specTarget = i;
        }
        if (specTarget != -1) {
            LOG.info((Object)("Choosing speculative task " + tasks[specTarget].getTIPId()));
        } else if (failedTarget != -1) {
            LOG.info((Object)("Choosing failed task " + tasks[failedTarget].getTIPId()));
        }
        return specTarget != -1 ? specTarget : failedTarget;
    }

    public synchronized void completedTask(TaskInProgress tip, TaskStatus status, JobTracker.JobTrackerMetrics metrics) throws IOException {
        String taskid = status.getTaskId();
        if (tip.isComplete()) {
            LOG.info((Object)("Already complete TIP " + tip.getTIPId() + " has completed task " + taskid));
            try {
                tip.alreadyCompletedTask(taskid);
            }
            catch (IOException ioe) {
                LOG.info((Object)("Failed to discard output of " + taskid + " : " + StringUtils.stringifyException(ioe)));
            }
            if (this.status.getRunState() != 1) {
                this.jobtracker.markCompletedTaskAttempt(status.getTaskTracker(), taskid);
            }
            return;
        }
        LOG.info((Object)("Task '" + taskid + "' has completed " + tip.getTIPId() + " successfully."));
        tip.completed(taskid);
        String taskTrackerName = status.getTaskTracker();
        if (status.getIsMap()) {
            JobHistory.MapAttempt.logStarted(this.profile.getJobId(), tip.getTIPId(), status.getTaskId(), status.getStartTime(), taskTrackerName);
            JobHistory.MapAttempt.logFinished(this.profile.getJobId(), tip.getTIPId(), status.getTaskId(), status.getFinishTime(), taskTrackerName);
            JobHistory.Task.logFinished(this.profile.getJobId(), tip.getTIPId(), JobHistory.Values.MAP.name(), status.getFinishTime());
        } else {
            JobHistory.ReduceAttempt.logStarted(this.profile.getJobId(), tip.getTIPId(), status.getTaskId(), status.getStartTime(), taskTrackerName);
            JobHistory.ReduceAttempt.logFinished(this.profile.getJobId(), tip.getTIPId(), status.getTaskId(), status.getShuffleFinishTime(), status.getSortFinishTime(), status.getFinishTime(), taskTrackerName);
            JobHistory.Task.logFinished(this.profile.getJobId(), tip.getTIPId(), JobHistory.Values.REDUCE.name(), status.getFinishTime());
        }
        if (tip.isMapTask()) {
            --this.runningMapTasks;
            ++this.finishedMapTasks;
            metrics.completeMap();
        } else {
            --this.runningReduceTasks;
            ++this.finishedReduceTasks;
            metrics.completeReduce();
        }
        this.isJobComplete(tip, metrics);
        if (this.status.getRunState() != 1) {
            this.jobtracker.markCompletedTaskAttempt(status.getTaskTracker(), taskid);
        }
    }

    private boolean isJobComplete(TaskInProgress tip, JobTracker.JobTrackerMetrics metrics) {
        int i;
        boolean allDone = true;
        for (i = 0; i < this.maps.length; ++i) {
            if (this.maps[i].isComplete() || this.maps[i].isFailed()) continue;
            allDone = false;
            break;
        }
        if (allDone) {
            if (tip.isMapTask()) {
                this.status.setMapProgress(1.0f);
            }
            for (i = 0; i < this.reduces.length; ++i) {
                if (this.reduces[i].isComplete() || this.reduces[i].isFailed()) continue;
                allDone = false;
                break;
            }
        }
        if (this.status.getRunState() == 1 && allDone) {
            this.status.setRunState(2);
            this.status.setReduceProgress(1.0f);
            this.finishTime = System.currentTimeMillis();
            this.garbageCollect();
            LOG.info((Object)("Job " + this.status.getJobId() + " has completed successfully."));
            JobHistory.JobInfo.logFinished(this.status.getJobId(), this.finishTime, this.finishedMapTasks, this.finishedReduceTasks, this.failedMapTasks, this.failedReduceTasks);
            metrics.completeJob();
            return true;
        }
        return false;
    }

    public synchronized void kill() {
        if (this.status.getRunState() != 3) {
            int i;
            LOG.info((Object)("Killing job '" + this.status.getJobId() + "'"));
            this.status = new JobStatus(this.status.getJobId(), 1.0f, 1.0f, 3);
            this.finishTime = System.currentTimeMillis();
            this.runningMapTasks = 0;
            this.runningReduceTasks = 0;
            for (i = 0; i < this.maps.length; ++i) {
                this.maps[i].kill();
            }
            for (i = 0; i < this.reduces.length; ++i) {
                this.reduces[i].kill();
            }
            JobHistory.JobInfo.logFailed(this.status.getJobId(), this.finishTime, this.finishedMapTasks, this.finishedReduceTasks);
            this.garbageCollect();
        }
    }

    private void failedTask(TaskInProgress tip, String taskid, TaskStatus status, String trackerName, boolean wasRunning, boolean wasComplete, JobTracker.JobTrackerMetrics metrics) {
        tip.incompleteSubTask(taskid, trackerName);
        boolean isRunning = tip.isRunning();
        boolean isComplete = tip.isComplete();
        if (wasRunning && !isRunning) {
            if (tip.isMapTask()) {
                --this.runningMapTasks;
            } else {
                --this.runningReduceTasks;
            }
        }
        if (wasComplete && !isComplete && tip.isMapTask()) {
            --this.finishedMapTasks;
        }
        String taskTrackerName = status.getTaskTracker();
        if (status.getIsMap()) {
            JobHistory.MapAttempt.logStarted(this.profile.getJobId(), tip.getTIPId(), status.getTaskId(), status.getStartTime(), taskTrackerName);
            JobHistory.MapAttempt.logFailed(this.profile.getJobId(), tip.getTIPId(), status.getTaskId(), System.currentTimeMillis(), taskTrackerName, status.getDiagnosticInfo());
        } else {
            JobHistory.ReduceAttempt.logStarted(this.profile.getJobId(), tip.getTIPId(), status.getTaskId(), status.getStartTime(), taskTrackerName);
            JobHistory.ReduceAttempt.logFailed(this.profile.getJobId(), tip.getTIPId(), status.getTaskId(), System.currentTimeMillis(), taskTrackerName, status.getDiagnosticInfo());
        }
        if (tip.isMapTask()) {
            ++this.failedMapTasks;
        } else {
            ++this.failedReduceTasks;
        }
        if (status.getRunState() == TaskStatus.State.FAILED) {
            this.addTrackerTaskFailure(trackerName);
        }
        this.jobtracker.markCompletedTaskAttempt(status.getTaskTracker(), taskid);
        if (tip.isFailed()) {
            boolean killJob;
            boolean bl = tip.isMapTask() ? ++this.failedMapTIPs * 100 > this.mapFailuresPercent * this.numMapTasks : (killJob = ++this.failedReduceTIPs * 100 > this.reduceFailuresPercent * this.numReduceTasks);
            if (killJob) {
                LOG.info((Object)("Aborting job " + this.profile.getJobId()));
                JobHistory.Task.logFailed(this.profile.getJobId(), tip.getTIPId(), tip.isMapTask() ? JobHistory.Values.MAP.name() : JobHistory.Values.REDUCE.name(), System.currentTimeMillis(), status.getDiagnosticInfo());
                JobHistory.JobInfo.logFailed(this.profile.getJobId(), System.currentTimeMillis(), this.finishedMapTasks, this.finishedReduceTasks);
                this.kill();
            } else {
                this.isJobComplete(tip, metrics);
            }
            if (tip.isMapTask()) {
                this.jobCounters.incrCounter(Counter.NUM_FAILED_MAPS, 1L);
            } else {
                this.jobCounters.incrCounter(Counter.NUM_FAILED_REDUCES, 1L);
            }
        }
    }

    public void failedTask(TaskInProgress tip, String taskid, String reason, TaskStatus.Phase phase, TaskStatus.State state, String hostname, String trackerName, JobTracker.JobTrackerMetrics metrics) {
        TaskStatus status = new TaskStatus(taskid, tip.isMapTask(), 0.0f, state, reason, reason, trackerName, phase, tip.getCounters());
        this.updateTaskStatus(tip, status, metrics);
        JobHistory.Task.logFailed(this.profile.getJobId(), tip.getTIPId(), tip.isMapTask() ? JobHistory.Values.MAP.name() : JobHistory.Values.REDUCE.name(), System.currentTimeMillis(), reason);
    }

    synchronized void garbageCollect() {
        this.jobtracker.finalizeJob(this);
        try {
            if (this.localJobFile != null) {
                this.localFs.delete(this.localJobFile);
                this.localJobFile = null;
            }
            if (this.localJarFile != null) {
                this.localFs.delete(this.localJarFile);
                this.localJarFile = null;
            }
            FileSystem fs = FileSystem.get(this.conf);
            fs.delete(new Path(this.profile.getJobFile()).getParent());
            String tempDir = this.conf.get("mapred.system.dir") + "/job_" + this.uniqueString;
            fs.delete(new Path(tempDir));
        }
        catch (IOException e) {
            LOG.warn((Object)("Error cleaning up " + this.profile.getJobId() + ": " + e));
        }
    }

    public TaskInProgress getTaskInProgress(String tipid) {
        int i;
        for (i = 0; i < this.maps.length; ++i) {
            if (!tipid.equals(this.maps[i].getTIPId())) continue;
            return this.maps[i];
        }
        for (i = 0; i < this.reduces.length; ++i) {
            if (!tipid.equals(this.reduces[i].getTIPId())) continue;
            return this.reduces[i];
        }
        return null;
    }

    public TaskStatus findFinishedMap(int mapId) {
        TaskInProgress tip = this.maps[mapId];
        if (tip.isComplete()) {
            TaskStatus[] statuses = tip.getTaskStatuses();
            for (int i = 0; i < statuses.length; ++i) {
                if (statuses[i].getRunState() != TaskStatus.State.SUCCEEDED) continue;
                return statuses[i];
            }
        }
        return null;
    }

    public synchronized TaskCompletionEvent[] getTaskCompletionEvents(int fromEventId, int maxEvents) {
        TaskCompletionEvent[] events = TaskCompletionEvent.EMPTY_ARRAY;
        if (this.taskCompletionEvents.size() > fromEventId) {
            int actualMax = Math.min(maxEvents, this.taskCompletionEvents.size() - fromEventId);
            events = this.taskCompletionEvents.subList(fromEventId, actualMax + fromEventId).toArray(events);
        }
        return events;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Counter {
        NUM_FAILED_MAPS,
        NUM_FAILED_REDUCES;

    }
}

