/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.mapred.DefaultJobHistoryParser;

public class JobHistory {
    public static final Log LOG = LogFactory.getLog((String)"org.apache.hadoop.mapred.JobHistory");
    private static final String DELIMITER = " ";
    private static final String KEY = "(\\w+)";
    private static final String VALUE = "[[^\"]?]+";
    private static final Pattern pattern = Pattern.compile("(\\w+)=\"[[^\"]?]+\"");
    public static final String JOBTRACKER_START_TIME = String.valueOf(System.currentTimeMillis());
    private static final String LOG_DIR = System.getProperty("hadoop.log.dir") + File.separator + "history";
    public static final String MASTER_INDEX_LOG_FILE = "JobHistory.log";
    private static PrintWriter masterIndex = null;
    private static Map<String, PrintWriter> openJobs = new HashMap<String, PrintWriter>();
    private static boolean disableHistory = false;
    private static Map<Keys, String> parseBuffer = new HashMap<Keys, String>();

    private static void init() {
        if (!disableHistory) {
            try {
                File logDir = new File(LOG_DIR);
                if (!logDir.exists() && !logDir.mkdirs()) {
                    throw new IOException("Mkdirs failed to create " + logDir.toString());
                }
                masterIndex = new PrintWriter(new FileOutputStream(new File(LOG_DIR + File.separator + MASTER_INDEX_LOG_FILE), true));
                JobHistory.log(masterIndex, RecordTypes.Jobtracker, Keys.START_TIME, JOBTRACKER_START_TIME);
            }
            catch (IOException e) {
                LOG.error((Object)"Failed to initialize JobHistory log file", (Throwable)e);
                disableHistory = true;
            }
        }
    }

    public static void parseHistory(File path, Listener l) throws IOException {
        BufferedReader reader = new BufferedReader(new FileReader(path));
        String line = null;
        StringBuffer buf = new StringBuffer();
        while ((line = reader.readLine()) != null) {
            buf.append(line);
            if (!line.trim().endsWith("\"")) continue;
            JobHistory.parseLine(buf.toString(), l);
            buf = new StringBuffer();
        }
    }

    private static void parseLine(String line, Listener l) throws IOException {
        int idx = line.indexOf(32);
        String recType = line.substring(0, idx);
        String data = line.substring(idx + 1, line.length());
        Matcher matcher = pattern.matcher(data);
        while (matcher.find()) {
            String tuple = matcher.group(0);
            String[] parts = tuple.split("=");
            parseBuffer.put(Keys.valueOf(parts[0]), parts[1].substring(1, parts[1].length() - 1));
        }
        l.handle(RecordTypes.valueOf(recType), parseBuffer);
        parseBuffer.clear();
    }

    static void log(PrintWriter out, RecordTypes recordType, Enum key, String value) {
        out.println(recordType.name() + DELIMITER + key + "=\"" + value + "\"");
        out.flush();
    }

    static void log(PrintWriter out, RecordTypes recordType, Enum[] keys, String[] values) {
        StringBuffer buf = new StringBuffer(recordType.name());
        buf.append(DELIMITER);
        for (int i = 0; i < keys.length; ++i) {
            buf.append(keys[i]);
            buf.append("=\"");
            buf.append(values[i]);
            buf.append("\"");
            buf.append(DELIMITER);
        }
        out.println(buf.toString());
        out.flush();
    }

    public static boolean isDisableHistory() {
        return disableHistory;
    }

    public static void setDisableHistory(boolean disableHistory) {
        JobHistory.disableHistory = disableHistory;
    }

    static {
        JobHistory.init();
    }

    public static class HistoryCleaner
    implements Runnable {
        static final long ONE_DAY_IN_MS = 86400000L;
        static final long THIRTY_DAYS_IN_MS = 2592000000L;
        private long now;
        private static boolean isRunning = false;
        private static long lastRan;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            if (isRunning) {
                return;
            }
            this.now = System.currentTimeMillis();
            if (lastRan == 0L || this.now - lastRan < 86400000L) {
                return;
            }
            lastRan = this.now;
            isRunning = true;
            try {
                File logFile = new File(LOG_DIR + File.separator + JobHistory.MASTER_INDEX_LOG_FILE);
                String string = JobHistory.MASTER_INDEX_LOG_FILE;
                synchronized (JobHistory.MASTER_INDEX_LOG_FILE) {
                    Map<String, JobInfo> jobs;
                    Map<String, Map<String, JobInfo>> jobTrackersToJobs = DefaultJobHistoryParser.parseMasterIndex(logFile);
                    for (String jobTrackerId : jobTrackersToJobs.keySet()) {
                        jobs = jobTrackersToJobs.get(jobTrackerId);
                        Iterator<String> iter = jobs.keySet().iterator();
                        while (iter.hasNext()) {
                            JobInfo job = jobs.get(iter.next());
                            if (this.now - job.getLong(Keys.SUBMIT_TIME) > 2592000000L) {
                                iter.remove();
                            }
                            if (jobs.size() == 0) {
                                iter.remove();
                            }
                            iter.next();
                        }
                    }
                    masterIndex.close();
                    masterIndex = new PrintWriter(logFile);
                    for (String jobTrackerId : jobTrackersToJobs.keySet()) {
                        jobs = jobTrackersToJobs.get(jobTrackerId);
                        JobHistory.log(masterIndex, RecordTypes.Jobtracker, Keys.START_TIME, jobTrackerId);
                        for (String jobId : jobs.keySet()) {
                            JobInfo job = jobs.get(jobId);
                            Map<Keys, String> values = job.getValues();
                            JobHistory.log(masterIndex, RecordTypes.Job, values.keySet().toArray(new Keys[0]), values.values().toArray(new String[0]));
                        }
                        masterIndex.flush();
                    }
                    // ** MonitorExit[var2_3] (shouldn't be in output)
                }
            }
            catch (IOException e) {
                LOG.error((Object)"Failed loading history log for cleanup", (Throwable)e);
            }
            {
                File[] oldFiles;
                for (File f : oldFiles = new File(LOG_DIR).listFiles(new FileFilter(){

                    public boolean accept(File file) {
                        return HistoryCleaner.this.now - file.lastModified() > 2592000000L;
                    }
                })) {
                    f.delete();
                    LOG.info((Object)("Deleting old history file : " + f.getName()));
                }
                isRunning = false;
                return;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Listener {
        public void handle(RecordTypes var1, Map<Keys, String> var2) throws IOException;
    }

    public static class ReduceAttempt
    extends TaskAttempt {
        public static void logStarted(String jobId, String taskId, String taskAttemptId, long startTime, String hostName) {
            PrintWriter writer;
            if (!disableHistory && null != (writer = (PrintWriter)openJobs.get(JOBTRACKER_START_TIME + "_" + jobId))) {
                JobHistory.log(writer, RecordTypes.ReduceAttempt, new Enum[]{Keys.TASK_TYPE, Keys.TASKID, Keys.TASK_ATTEMPT_ID, Keys.START_TIME, Keys.HOSTNAME}, new String[]{Values.REDUCE.name(), taskId, taskAttemptId, String.valueOf(startTime), hostName});
            }
        }

        public static void logFinished(String jobId, String taskId, String taskAttemptId, long shuffleFinished, long sortFinished, long finishTime, String hostName) {
            PrintWriter writer;
            if (!disableHistory && null != (writer = (PrintWriter)openJobs.get(JOBTRACKER_START_TIME + "_" + jobId))) {
                JobHistory.log(writer, RecordTypes.ReduceAttempt, new Enum[]{Keys.TASK_TYPE, Keys.TASKID, Keys.TASK_ATTEMPT_ID, Keys.TASK_STATUS, Keys.SHUFFLE_FINISHED, Keys.SORT_FINISHED, Keys.FINISH_TIME, Keys.HOSTNAME}, new String[]{Values.REDUCE.name(), taskId, taskAttemptId, Values.SUCCESS.name(), String.valueOf(shuffleFinished), String.valueOf(sortFinished), String.valueOf(finishTime), hostName});
            }
        }

        public static void logFailed(String jobId, String taskId, String taskAttemptId, long timestamp, String hostName, String error) {
            PrintWriter writer;
            if (!disableHistory && null != (writer = (PrintWriter)openJobs.get(JOBTRACKER_START_TIME + "_" + jobId))) {
                JobHistory.log(writer, RecordTypes.ReduceAttempt, new Enum[]{Keys.TASK_TYPE, Keys.TASKID, Keys.TASK_ATTEMPT_ID, Keys.TASK_STATUS, Keys.FINISH_TIME, Keys.HOSTNAME, Keys.ERROR}, new String[]{Values.REDUCE.name(), taskId, taskAttemptId, Values.FAILED.name(), String.valueOf(timestamp), hostName, error});
            }
        }
    }

    public static class MapAttempt
    extends TaskAttempt {
        public static void logStarted(String jobId, String taskId, String taskAttemptId, long startTime, String hostName) {
            PrintWriter writer;
            if (!disableHistory && null != (writer = (PrintWriter)openJobs.get(JOBTRACKER_START_TIME + "_" + jobId))) {
                JobHistory.log(writer, RecordTypes.MapAttempt, new Enum[]{Keys.TASK_TYPE, Keys.TASKID, Keys.TASK_ATTEMPT_ID, Keys.START_TIME, Keys.HOSTNAME}, new String[]{Values.MAP.name(), taskId, taskAttemptId, String.valueOf(startTime), hostName});
            }
        }

        public static void logFinished(String jobId, String taskId, String taskAttemptId, long finishTime, String hostName) {
            PrintWriter writer;
            if (!disableHistory && null != (writer = (PrintWriter)openJobs.get(JOBTRACKER_START_TIME + "_" + jobId))) {
                JobHistory.log(writer, RecordTypes.MapAttempt, new Enum[]{Keys.TASK_TYPE, Keys.TASKID, Keys.TASK_ATTEMPT_ID, Keys.TASK_STATUS, Keys.FINISH_TIME, Keys.HOSTNAME}, new String[]{Values.MAP.name(), taskId, taskAttemptId, Values.SUCCESS.name(), String.valueOf(finishTime), hostName});
            }
        }

        public static void logFailed(String jobId, String taskId, String taskAttemptId, long timestamp, String hostName, String error) {
            PrintWriter writer;
            if (!disableHistory && null != (writer = (PrintWriter)openJobs.get(JOBTRACKER_START_TIME + "_" + jobId))) {
                JobHistory.log(writer, RecordTypes.MapAttempt, new Enum[]{Keys.TASK_TYPE, Keys.TASKID, Keys.TASK_ATTEMPT_ID, Keys.TASK_STATUS, Keys.FINISH_TIME, Keys.HOSTNAME, Keys.ERROR}, new String[]{Values.MAP.name(), taskId, taskAttemptId, Values.FAILED.name(), String.valueOf(timestamp), hostName, error});
            }
        }
    }

    public static class TaskAttempt
    extends Task {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Task
    extends KeyValuePair {
        private Map<String, TaskAttempt> taskAttempts = new TreeMap<String, TaskAttempt>();

        public static void logStarted(String jobId, String taskId, String taskType, long startTime) {
            PrintWriter writer;
            if (!disableHistory && null != (writer = (PrintWriter)openJobs.get(JOBTRACKER_START_TIME + "_" + jobId))) {
                JobHistory.log(writer, RecordTypes.Task, new Enum[]{Keys.TASKID, Keys.TASK_TYPE, Keys.START_TIME}, new String[]{taskId, taskType, String.valueOf(startTime)});
            }
        }

        public static void logFinished(String jobId, String taskId, String taskType, long finishTime) {
            PrintWriter writer;
            if (!disableHistory && null != (writer = (PrintWriter)openJobs.get(JOBTRACKER_START_TIME + "_" + jobId))) {
                JobHistory.log(writer, RecordTypes.Task, new Enum[]{Keys.TASKID, Keys.TASK_TYPE, Keys.TASK_STATUS, Keys.FINISH_TIME}, new String[]{taskId, taskType, Values.SUCCESS.name(), String.valueOf(finishTime)});
            }
        }

        public static void logFailed(String jobId, String taskId, String taskType, long time, String error) {
            PrintWriter writer;
            if (!disableHistory && null != (writer = (PrintWriter)openJobs.get(JOBTRACKER_START_TIME + "_" + jobId))) {
                JobHistory.log(writer, RecordTypes.Task, new Enum[]{Keys.TASKID, Keys.TASK_TYPE, Keys.TASK_STATUS, Keys.FINISH_TIME, Keys.ERROR}, new String[]{taskId, taskType, Values.FAILED.name(), String.valueOf(time), error});
            }
        }

        public Map<String, TaskAttempt> getTaskAttempts() {
            return this.taskAttempts;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class JobInfo
    extends KeyValuePair {
        private Map<String, Task> allTasks = new TreeMap<String, Task>();

        public JobInfo(String jobId) {
            this.set(Keys.JOBID, jobId);
        }

        public Map<String, Task> getAllTasks() {
            return this.allTasks;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public static void logSubmitted(String jobId, String jobName, String user, long submitTime, String jobConf) {
            if (disableHistory) return;
            String string = JobHistory.MASTER_INDEX_LOG_FILE;
            synchronized (JobHistory.MASTER_INDEX_LOG_FILE) {
                JobHistory.log(masterIndex, RecordTypes.Job, new Enum[]{Keys.JOBID, Keys.JOBNAME, Keys.USER, Keys.SUBMIT_TIME, Keys.JOBCONF}, new String[]{jobId, jobName, user, String.valueOf(submitTime), jobConf});
                // ** MonitorExit[var6_5] (shouldn't be in output)
                String logFileName = JOBTRACKER_START_TIME + "_" + jobId;
                File logFile = new File(LOG_DIR + File.separator + logFileName);
                try {
                    PrintWriter writer = new PrintWriter(logFile);
                    openJobs.put(logFileName, writer);
                    JobHistory.log(writer, RecordTypes.Job, new Enum[]{Keys.JOBID, Keys.JOBNAME, Keys.USER, Keys.SUBMIT_TIME, Keys.JOBCONF}, new String[]{jobId, jobName, user, String.valueOf(submitTime), jobConf});
                    return;
                }
                catch (IOException e) {
                    LOG.error((Object)"Failed creating job history log file, disabling history", (Throwable)e);
                    disableHistory = true;
                }
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public static void logStarted(String jobId, long startTime, int totalMaps, int totalReduces) {
            if (disableHistory) return;
            String string = JobHistory.MASTER_INDEX_LOG_FILE;
            synchronized (JobHistory.MASTER_INDEX_LOG_FILE) {
                JobHistory.log(masterIndex, RecordTypes.Job, new Enum[]{Keys.JOBID, Keys.LAUNCH_TIME, Keys.TOTAL_MAPS, Keys.TOTAL_REDUCES}, new String[]{jobId, String.valueOf(startTime), String.valueOf(totalMaps), String.valueOf(totalReduces)});
                // ** MonitorExit[var5_4] (shouldn't be in output)
                String logFileName = JOBTRACKER_START_TIME + "_" + jobId;
                PrintWriter writer = (PrintWriter)openJobs.get(logFileName);
                if (null == writer) return;
                JobHistory.log(writer, RecordTypes.Job, new Enum[]{Keys.JOBID, Keys.LAUNCH_TIME, Keys.TOTAL_MAPS, Keys.TOTAL_REDUCES}, new String[]{jobId, String.valueOf(startTime), String.valueOf(totalMaps), String.valueOf(totalReduces)});
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public static void logFinished(String jobId, long finishTime, int finishedMaps, int finishedReduces, int failedMaps, int failedReduces) {
            if (disableHistory) return;
            String string = JobHistory.MASTER_INDEX_LOG_FILE;
            synchronized (JobHistory.MASTER_INDEX_LOG_FILE) {
                JobHistory.log(masterIndex, RecordTypes.Job, new Enum[]{Keys.JOBID, Keys.FINISH_TIME, Keys.JOB_STATUS, Keys.FINISHED_MAPS, Keys.FINISHED_REDUCES}, new String[]{jobId, "" + finishTime, Values.SUCCESS.name(), String.valueOf(finishedMaps), String.valueOf(finishedReduces)});
                // ** MonitorExit[var7_6] (shouldn't be in output)
                String logFileName = JOBTRACKER_START_TIME + "_" + jobId;
                PrintWriter writer = (PrintWriter)openJobs.get(logFileName);
                if (null != writer) {
                    JobHistory.log(writer, RecordTypes.Job, new Enum[]{Keys.JOBID, Keys.FINISH_TIME, Keys.JOB_STATUS, Keys.FINISHED_MAPS, Keys.FINISHED_REDUCES, Keys.FAILED_MAPS, Keys.FAILED_REDUCES}, new String[]{jobId, "" + finishTime, Values.SUCCESS.name(), String.valueOf(finishedMaps), String.valueOf(finishedReduces), String.valueOf(failedMaps), String.valueOf(failedReduces)});
                    writer.close();
                    openJobs.remove(logFileName);
                }
                Thread historyCleaner = new Thread(new HistoryCleaner());
                historyCleaner.start();
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public static void logFailed(String jobid, long timestamp, int finishedMaps, int finishedReduces) {
            if (disableHistory) return;
            String string = JobHistory.MASTER_INDEX_LOG_FILE;
            synchronized (JobHistory.MASTER_INDEX_LOG_FILE) {
                JobHistory.log(masterIndex, RecordTypes.Job, new Enum[]{Keys.JOBID, Keys.FINISH_TIME, Keys.JOB_STATUS, Keys.FINISHED_MAPS, Keys.FINISHED_REDUCES}, new String[]{jobid, String.valueOf(timestamp), Values.FAILED.name(), String.valueOf(finishedMaps), String.valueOf(finishedReduces)});
                // ** MonitorExit[var5_4] (shouldn't be in output)
                String logFileName = JOBTRACKER_START_TIME + "_" + jobid;
                PrintWriter writer = (PrintWriter)openJobs.get(logFileName);
                if (null == writer) return;
                JobHistory.log(writer, RecordTypes.Job, new Enum[]{Keys.JOBID, Keys.FINISH_TIME, Keys.JOB_STATUS, Keys.FINISHED_MAPS, Keys.FINISHED_REDUCES}, new String[]{jobid, String.valueOf(timestamp), Values.FAILED.name(), String.valueOf(finishedMaps), String.valueOf(finishedReduces)});
                writer.close();
                openJobs.remove(logFileName);
                return;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class KeyValuePair {
        private Map<Keys, String> values = new HashMap<Keys, String>();

        KeyValuePair() {
        }

        public String get(Keys k) {
            String s = this.values.get((Object)k);
            return s == null ? "" : s;
        }

        public int getInt(Keys k) {
            String s = this.values.get((Object)k);
            if (null != s) {
                return Integer.parseInt(s);
            }
            return 0;
        }

        public long getLong(Keys k) {
            String s = this.values.get((Object)k);
            if (null != s) {
                return Long.parseLong(s);
            }
            return 0L;
        }

        public void set(Keys k, String s) {
            this.values.put(k, s);
        }

        public void set(Map<Keys, String> m) {
            this.values.putAll(m);
        }

        public synchronized void handle(Map<Keys, String> values) {
            this.set(values);
        }

        public Map<Keys, String> getValues() {
            return this.values;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Values {
        SUCCESS,
        FAILED,
        KILLED,
        MAP,
        REDUCE;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Keys {
        JOBTRACKERID,
        START_TIME,
        FINISH_TIME,
        JOBID,
        JOBNAME,
        USER,
        JOBCONF,
        SUBMIT_TIME,
        LAUNCH_TIME,
        TOTAL_MAPS,
        TOTAL_REDUCES,
        FAILED_MAPS,
        FAILED_REDUCES,
        FINISHED_MAPS,
        FINISHED_REDUCES,
        JOB_STATUS,
        TASKID,
        HOSTNAME,
        TASK_TYPE,
        ERROR,
        TASK_ATTEMPT_ID,
        TASK_STATUS,
        COPY_PHASE,
        SORT_PHASE,
        REDUCE_PHASE,
        SHUFFLE_FINISHED,
        SORT_FINISHED;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum RecordTypes {
        Jobtracker,
        Job,
        Task,
        MapAttempt,
        ReduceAttempt;

    }
}

